/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptmc.business.anobj.AnObjTemplateLibService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.TempAnObjFieldBo;

public class AnObjTemplateLibF7Plugin
extends HRDataBaseEdit
implements AnalyseObjectConstants,
TreeNodeClickListener,
SearchEnterListener {
    private static final String AN_OBJ_DESC_TIPS = "anobjdesc";
    private static final String FIELD_ENTRY = "fieldentry";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_NUMBER = "fieldnumber";
    private static final String VALUE_TYPE = "valuetype";
    private static final String TREE_VIEW = "treeviewap";
    private static final String SEARCH_AP = "searchap";
    private static final String OP_OK = "ok";
    private static final String KEY_AN_OBJ_MSG = "anObjMsg";
    private static final String BTN_VIEW_AN_OBJ = "viewanobj";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{BTN_VIEW_AN_OBJ});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection allTemplateAnObjCol = AnObjTemplateLibService.getInstance().getAllTemplateAnObjCol();
        ArrayList anObjMsgList = Lists.newArrayListWithExpectedSize((int)allTemplateAnObjCol.size());
        for (DynamicObject templateAnObjDy : allTemplateAnObjCol) {
            HashMap anObjMsg = Maps.newHashMapWithExpectedSize((int)2);
            anObjMsg.put("id", templateAnObjDy.getString("id"));
            anObjMsg.put("name", templateAnObjDy.getString("name"));
            anObjMsg.put("number", templateAnObjDy.getString("number"));
            anObjMsg.put("description", templateAnObjDy.getString("description"));
            anObjMsgList.add(anObjMsg);
        }
        this.buildTree(anObjMsgList);
        this.getPageCache().put(KEY_AN_OBJ_MSG, SerializationUtils.toJsonString((Object)anObjMsgList));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_OK)) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
            String anObjIdStr = treeView.getTreeState().getFocusNodeId();
            if (HRStringUtils.isEmpty((String)anObjIdStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u5bf9\u8c61\u6a21\u677f\u3002", (String)"AnObjTemplateLibF7Plugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().returnDataToParent((Object)anObjIdStr);
        }
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText();
        String anObjMsgStr = this.getPageCache().get(KEY_AN_OBJ_MSG);
        List anObjMsgList = SerializationUtils.fromJsonStringToList((String)anObjMsgStr, Map.class);
        List matchedDataList = HRStringUtils.isEmpty((String)text) ? anObjMsgList : anObjMsgList.stream().filter(anObjMsg -> ((String)anObjMsg.get("name")).contains(text) || ((String)anObjMsg.get("number")).contains(text)).collect(Collectors.toList());
        this.buildTree(matchedDataList);
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String nodeId = (String)treeNodeEvent.getNodeId();
        String anObjMsgStr = this.getPageCache().get(KEY_AN_OBJ_MSG);
        List anObjMsgList = SerializationUtils.fromJsonStringToList((String)anObjMsgStr, Map.class);
        anObjMsgList.stream().filter(msg -> HRStringUtils.equals((String)((String)msg.get("id")), (String)nodeId)).findAny().ifPresent(msg -> {
            Label anObjDesc = (Label)this.getView().getControl(AN_OBJ_DESC_TIPS);
            anObjDesc.setText((String)msg.get("description"));
            this.getView().updateView(AN_OBJ_DESC_TIPS);
        });
        long anObjId = Long.parseLong(nodeId);
        List allTemplateAnObjFieldCol = AnObjTemplateLibService.getInstance().getAllTemplateAnObjFieldCol(anObjId);
        this.getModel().getEntryEntity(FIELD_ENTRY).clear();
        this.getModel().deleteEntryData(FIELD_ENTRY);
        this.getModel().batchCreateNewEntryRow(FIELD_ENTRY, allTemplateAnObjFieldCol.size());
        int index = 0;
        for (TempAnObjFieldBo tempAnObjFieldBo : allTemplateAnObjFieldCol) {
            this.getModel().setValue(FIELD_NAME, (Object)tempAnObjFieldBo.getName(), index);
            this.getModel().setValue(FIELD_NUMBER, (Object)tempAnObjFieldBo.getNumber(), index);
            this.getModel().setValue(VALUE_TYPE, (Object)tempAnObjFieldBo.getType(), index);
            ++index;
        }
        this.getView().updateView(FIELD_ENTRY);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Label && HRStringUtils.equals((String)(key = ((Label)evt.getSource()).getKey()), (String)BTN_VIEW_AN_OBJ)) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            if (HRStringUtils.isEmpty((String)focusNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u5bf9\u8c61\u3002", (String)"AnObjTemplateLibF7Plugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("hrptmc_analyseobject");
            showParameter.setPkId((Object)Long.parseLong(focusNodeId));
            showParameter.setBillStatus(BillOperationStatus.AUDIT);
            showParameter.setStatus(OperationStatus.VIEW);
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            showParameter.setOpenStyle(openStyle);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void buildTree(List<Map<String, String>> anObjMsgList) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        TreeNode root = new TreeNode(null, "0", "", true);
        root.setIsOpened(true);
        treeView.deleteAllNodes();
        ArrayList nodes = Lists.newArrayListWithCapacity((int)10);
        for (Map<String, String> anObjMsg : anObjMsgList) {
            String name = anObjMsg.get("name");
            String number = anObjMsg.get("number");
            String text = name + " | " + number;
            TreeNode currNode = new TreeNode(root.getId(), anObjMsg.get("id"), text, false);
            currNode.setLeaf(true);
            nodes.add(currNode);
        }
        root.setChildren((List)nodes);
        treeView.addNode(root);
        this.getView().updateView(TREE_VIEW);
    }
}

