/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjPermRuleService;
import kd.hr.hrptmc.business.anobj.virtualentity.VirtualEntityService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.AnObjPivotBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;

public class AnObjCommonProcessor
implements AnalyseObjectConstants {
    public static final String CUSTOM_CONTROL = "customcontrolap";
    private AnalyseObjectCommonEdit plugin;

    public AnObjCommonProcessor(AnalyseObjectCommonEdit plugin) {
        this.plugin = plugin;
    }

    public List<AnObjGroupField> getCacheGroupFields() {
        ArrayList groupFields = Lists.newArrayListWithExpectedSize((int)10);
        String groupFieldStr = this.getView().getPageCache().get("cache_group_fields");
        if (HRStringUtils.isEmpty((String)groupFieldStr)) {
            return groupFields;
        }
        return JSON.parseArray((String)groupFieldStr, AnObjGroupField.class);
    }

    public List<QueryFieldBo> getCacheQueryFields(boolean removeIdFields) {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        List queryFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
            if (removeIdFields) {
                queryFields.removeIf(field -> field.getFieldPath().endsWith(".id"));
            }
        }
        return queryFields;
    }

    public List<QueryFieldBo> getOriginalQueryFields() {
        List queryFields = Lists.newArrayListWithCapacity((int)10);
        String queryFieldStr = this.getView().getPageCache().get("originQueryFields");
        if (HRStringUtils.isNotEmpty((String)queryFieldStr)) {
            queryFields = JSON.parseArray((String)queryFieldStr, QueryFieldBo.class);
        }
        return queryFields;
    }

    public List<CalculateFieldBo> getCacheCalculateFields(boolean removeUnSelected) {
        String calculateFieldsStr = this.getView().getPageCache().get("calculateFields");
        List calculateFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)calculateFieldsStr)) {
            calculateFields = JSON.parseArray((String)calculateFieldsStr, CalculateFieldBo.class);
            if (removeUnSelected) {
                calculateFields.removeIf(field -> field.getSelected() == false);
            }
        }
        return calculateFields;
    }

    public List<AnObjPivotBo> getCachePivotConfig() {
        String anObjPivotConfigStr = this.getView().getPageCache().get("anObjPivotConfig");
        List anObjPivotConfigs = Lists.newArrayListWithCapacity((int)16);
        if (HRStringUtils.isNotEmpty((String)anObjPivotConfigStr)) {
            anObjPivotConfigs = JSON.parseArray((String)anObjPivotConfigStr, AnObjPivotBo.class);
        }
        return anObjPivotConfigs;
    }

    public List<JoinEntityBo> getAllJoinEntity() {
        List joinEntityBos = Collections.emptyList();
        String entityStr = this.getView().getPageCache().get("joinEntities");
        if (HRStringUtils.isNotEmpty((String)entityStr)) {
            joinEntityBos = JSON.parseArray((String)entityStr, JoinEntityBo.class);
        }
        return joinEntityBos;
    }

    public List<QueryFieldBo> getSelectedQueryFields(Object entityNodes, boolean isVirtualEntity) {
        if (entityNodes == null) {
            return Collections.emptyList();
        }
        String queryFieldsStr = this.getView().getPageCache().get("originQueryFields");
        Map<Object, Object> queryFieldMap = Collections.emptyMap();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            List queryFieldBos = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
            queryFieldMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        }
        ArrayList selectedQueryFields = Lists.newArrayListWithCapacity((int)10);
        List fieldTreeNodes = JSON.parseArray((String)SerializationUtils.toJsonString((Object)entityNodes), FieldTreeNode.class);
        for (FieldTreeNode fieldTreeNode : fieldTreeNodes) {
            if (!fieldTreeNode.getSelected().booleanValue() || !fieldTreeNode.getField().booleanValue()) continue;
            QueryFieldBo queryFieldBo = (QueryFieldBo)queryFieldMap.get(fieldTreeNode.getFieldAlias());
            if (queryFieldBo == null) {
                queryFieldBo = new QueryFieldBo();
            }
            queryFieldBo.setFieldName(fieldTreeNode.getName());
            queryFieldBo.setFieldNumber(fieldTreeNode.getFieldAlias());
            queryFieldBo.setEntityNumber(fieldTreeNode.getEntityNumber());
            queryFieldBo.setEntityName(fieldTreeNode.getEntityName());
            queryFieldBo.setFieldAlias(fieldTreeNode.getFieldAlias());
            queryFieldBo.setFieldPath(fieldTreeNode.getFieldPath());
            queryFieldBo.setValueType(fieldTreeNode.getValueType());
            queryFieldBo.setComplexType(fieldTreeNode.getComplexType());
            queryFieldBo.setBaseDataNum(fieldTreeNode.getBaseDataNum());
            queryFieldBo.setBaseDataIdType(fieldTreeNode.getBaseDataIdType());
            queryFieldBo.setVirtualEntityField(isVirtualEntity);
            if (isVirtualEntity) {
                queryFieldBo.setControlType(fieldTreeNode.getControlType());
            }
            selectedQueryFields.add(queryFieldBo);
        }
        return selectedQueryFields;
    }

    public List<Map<String, Object>> getAllFieldsForCalFieldPage(Object fieldNodes) {
        String allTreeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (allTreeNodeStr == null) {
            return Collections.emptyList();
        }
        List selectedNodeAlias = Collections.emptyList();
        if (fieldNodes != null) {
            List selectedNodes = JSON.parseArray((String)SerializationUtils.toJsonString((Object)fieldNodes), FieldTreeNode.class);
            selectedNodeAlias = selectedNodes.stream().map(FieldTreeNode::getFieldAlias).collect(Collectors.toList());
        }
        ArrayList fields = Lists.newArrayListWithCapacity((int)10);
        List fieldTreeNodes = JSON.parseArray((String)allTreeNodeStr, FieldTreeNode.class);
        for (FieldTreeNode fieldTreeNode : fieldTreeNodes) {
            if (!fieldTreeNode.getField().booleanValue() || fieldTreeNode.getFieldPath().endsWith(".id")) continue;
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)6);
            fieldMap.put("fieldName", fieldTreeNode.getName());
            fieldMap.put("fieldNumber", fieldTreeNode.getFieldAlias());
            fieldMap.put("valueType", fieldTreeNode.getValueType());
            if (HRStringUtils.isNotEmpty((String)fieldTreeNode.getBaseDataNum())) {
                fieldMap.put("baseDataNum", fieldTreeNode.getBaseDataNum());
            }
            if (HRStringUtils.isNotEmpty((String)fieldTreeNode.getEnumEntityNum())) {
                fieldMap.put("enumEntityNum", fieldTreeNode.getEnumEntityNum());
            }
            fieldMap.put("isSelected", selectedNodeAlias.contains(fieldTreeNode.getFieldAlias()));
            fields.add(fieldMap);
        }
        return fields;
    }

    public List<CalculateFieldBo> getAllCalculateFields(Object calFields) {
        if (calFields == null) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)SerializationUtils.toJsonString((Object)calFields), CalculateFieldBo.class);
    }

    public List<Map<String, Object>> getReportCalFields() {
        String anObjRefByReport = this.getView().getPageCache().get("anObjRefByReport");
        if (HRStringUtils.equals((String)anObjRefByReport, (String)"true")) {
            DynamicObject[] calFieldDys;
            ArrayList reportCalFields = Lists.newArrayListWithCapacity((int)10);
            for (DynamicObject calFieldDy : calFieldDys = CalculateFieldService.getInstance().queryReportCalFieldNameNumsForAnObj((Long)this.getModel().getValue("id"))) {
                HashMap calFieldMap = Maps.newHashMapWithExpectedSize((int)2);
                calFieldMap.put("fieldName", calFieldDy.getLocaleString("name"));
                calFieldMap.put("fieldNumber", calFieldDy.getString("number"));
                reportCalFields.add(calFieldMap);
            }
            return reportCalFields;
        }
        return Collections.emptyList();
    }

    public List<String> getAllRefFieldAliasByCalField(List<CalculateFieldBo> calFields) {
        ArrayList refFieldAliasList = Lists.newArrayListWithCapacity((int)10);
        calFields.forEach(field -> {
            refFieldAliasList.addAll(field.getRefEntityFields().stream().filter(fieldAlias -> !fieldAlias.endsWith(".id")).collect(Collectors.toSet()));
            for (CalculateFieldBo refCalculateField : field.getRefCalculateFields()) {
                refFieldAliasList.add(refCalculateField.getFieldNumber());
            }
        });
        return refFieldAliasList;
    }

    public List<String> getDataFilterRefFieldAlias() {
        String dataFilter = (String)this.getModel().getValue("datafilter");
        if (HRStringUtils.isEmpty((String)dataFilter)) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
        List paramList = conditionInfo.getConditionList().stream().map(ConditionInfo::getParam).collect(Collectors.toList());
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFieldsStr)) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        List queryFieldBoList = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
        return queryFieldBoList.stream().filter(queryFieldBo -> paramList.contains(queryFieldBo.getHRFilterParam())).map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toList());
    }

    public List<String> getPivotRefFieldAlias() {
        String pivotIsCompleted;
        ArrayList refAlias = Lists.newArrayListWithCapacity((int)10);
        String dimFieldAlias = (String)this.getModel().getValue("pivotdim");
        if (HRStringUtils.isNotEmpty((String)dimFieldAlias)) {
            refAlias.add(dimFieldAlias);
        }
        if (HRStringUtils.equals((String)(pivotIsCompleted = this.getView().getPageCache().get("pivotIsCompleted")), (String)"true")) {
            String allIndexAliasStr = this.getView().getPageCache().get("allIndexAlias");
            List selectedIndexAliasList = Lists.newArrayListWithCapacity((int)10);
            if (HRStringUtils.isNotEmpty((String)allIndexAliasStr)) {
                selectedIndexAliasList = (List)SerializationUtils.fromJsonString((String)allIndexAliasStr, List.class);
            }
            refAlias.addAll(selectedIndexAliasList.stream().map(index -> (String)index.get("id")).collect(Collectors.toList()));
        } else {
            String pivotIndex = (String)this.getModel().getValue("pivotindex");
            if (HRStringUtils.isNotEmpty((String)pivotIndex)) {
                String[] split = pivotIndex.split(",");
                refAlias.addAll(Arrays.asList(split));
            }
        }
        return refAlias;
    }

    public List<String> getGroupFieldRefFieldAlias() {
        ArrayList refAlias = Lists.newArrayListWithCapacity((int)10);
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        if (cacheGroupFields.isEmpty()) {
            return refAlias;
        }
        cacheGroupFields.forEach(field -> {
            if (field.getAnObjField() != null) {
                refAlias.add(field.getAnObjField().getFieldAlias());
            } else if (field.getAnObjCalField() != null) {
                refAlias.add(field.getAnObjCalField().getFieldNumber());
            }
        });
        return refAlias;
    }

    public List<String> getPreIndexRefFieldAlias() {
        ArrayList fieldAliasList = Lists.newArrayListWithCapacity((int)10);
        HRBaseServiceHelper preIndexHelper = new HRBaseServiceHelper("hrptmc_preindex");
        DynamicObjectCollection preIndexDys = preIndexHelper.queryOriginalCollection("target", new QFilter[]{new QFilter("anobj", "=", this.getModel().getValue("id"))});
        for (DynamicObject preIndexDy : preIndexDys) {
            String index = preIndexDy.getString("target");
            fieldAliasList.add(index);
        }
        return fieldAliasList;
    }

    public Set<String> getPermRuleRefFieldAlias() {
        Long anObjId = (Long)this.getModel().getValue("id");
        if (anObjId == null || anObjId == 0L) {
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        return AnObjPermRuleService.getInstance().getPermRuleRefAnObjFieldAliasList(anObjId.longValue()).keySet();
    }

    public void setAllFieldsToCache(List<FieldTreeNode> entityAllFields) {
        String allFieldTreeNodesStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isNotEmpty((String)allFieldTreeNodesStr)) {
            List fieldTreeNodes = JSON.parseArray((String)allFieldTreeNodesStr, FieldTreeNode.class);
            entityAllFields.forEach(field -> this.addFieldTreeNode((FieldTreeNode)field, fieldTreeNodes));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)fieldTreeNodes));
        } else {
            ArrayList allFieldTreeNodes = Lists.newArrayListWithCapacity((int)10);
            entityAllFields.forEach(field -> this.addFieldTreeNode((FieldTreeNode)field, allFieldTreeNodes));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)allFieldTreeNodes));
        }
    }

    public void setVirtualEntityConfigForContext(HRComplexObjContext context, List<JoinEntityBo> joinEntities, List<QueryFieldBo> queryFields, List<QFilter> qFilters) {
        if (context != null && joinEntities.size() == 1 && joinEntities.get(0).getVirtualEntity()) {
            context.setVirtualEntity(Boolean.TRUE);
            StringBuilder servicePath = new StringBuilder();
            VirtualEntityInfo virtualEntityInfo = VirtualEntityService.getInstance().queryAndAssembleVirtualEntity(joinEntities.get(0).getEntityNumber(), servicePath);
            List queryFieldAliasList = queryFields.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toList());
            virtualEntityInfo.getFieldInfoList().removeIf(field -> !queryFieldAliasList.contains(field.getNumber()));
            VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = new VirtualEntityQueryParamInfo();
            virtualEntityQueryParamInfo.setVirtualEntityInfo(virtualEntityInfo);
            virtualEntityQueryParamInfo.setSummaryQueryParamInfo(new SummaryQueryParamInfo(virtualEntityInfo.isSummaryQueryByBatch(), -1, false));
            virtualEntityQueryParamInfo.setSelectedFieldInfoList(virtualEntityInfo.getFieldInfoList());
            virtualEntityQueryParamInfo.setStart(0);
            virtualEntityQueryParamInfo.setLimit(500);
            virtualEntityQueryParamInfo.setReportFilterList(qFilters);
            context.setVirtualEntityQueryParamInfo(virtualEntityQueryParamInfo);
            context.setVirtualEntityQueryService(servicePath.toString());
        }
    }

    private void addFieldTreeNode(FieldTreeNode node, List<FieldTreeNode> allFieldTreeNodes) {
        if (node.getField().booleanValue()) {
            allFieldTreeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.addFieldTreeNode(child, allFieldTreeNodes);
            }
        }
    }

    public IFormView getView() {
        return this.plugin.getView();
    }

    public IDataModel getModel() {
        return this.plugin.getView().getModel();
    }

    public AnalyseObjectCommonEdit getPlugin() {
        return this.plugin;
    }

    public void setPlugin(AnalyseObjectCommonEdit plugin) {
        this.plugin = plugin;
    }
}

