/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.virtualentity.VirtualEntityService;
import kd.hr.hrptmc.common.model.anobj.AnObjSideBar;
import kd.hr.hrptmc.common.model.anobj.EntityRelationBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.util.ReportComplexObjTransferUtil;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCommonProcessor;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjGroupFieldProcessor;

public class AnObjDataProcessor
extends AnObjCommonProcessor {
    private static final String DATA_SOURCE = "changeDataSourceConfirm_dataSource";
    private final AnObjGroupFieldProcessor groupFieldProcessor;

    public AnObjDataProcessor(AnalyseObjectCommonEdit plugin) {
        super(plugin);
        this.groupFieldProcessor = new AnObjGroupFieldProcessor(plugin);
    }

    public void getAllData(CustomEventArgs args) {
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)args.getEventArgs(), Map.class);
        Object entityNodes = dataMap.get("entityNodes");
        String joinEntitiesStr = SerializationUtils.toJsonString(entityNodes);
        boolean isVirtualEntity = false;
        this.getView().getPageCache().put("joinEntities", joinEntitiesStr);
        List entityRelationBos = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            List queryEntityBos = JSON.parseArray((String)joinEntitiesStr, JoinEntityBo.class);
            if (queryEntityBos.size() == 1 && ((JoinEntityBo)queryEntityBos.get(0)).getVirtualEntity()) {
                isVirtualEntity = true;
            }
            List entityRelationCommonBos = queryEntityBos.stream().map(JoinEntityCommonBo::getEntityRelation).filter(Objects::nonNull).collect(Collectors.toList());
            entityRelationBos = ReportComplexObjTransferUtil.reverseEntityRelationBos(entityRelationCommonBos);
        }
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelationBos));
        Object queryFields = dataMap.get("queryFields");
        List<QueryFieldBo> queryFieldBos = this.getSelectedQueryFields(queryFields, isVirtualEntity);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
        Object calFields = dataMap.get("calFields");
        List calculateFieldBos = Lists.newArrayListWithCapacity((int)10);
        String calFieldsStr = SerializationUtils.toJsonString(calFields);
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            calculateFieldBos = JSON.parseArray((String)calFieldsStr, CalculateFieldBo.class);
        }
        this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFieldBos));
        String operate = (String)dataMap.get("operate");
        if (HRStringUtils.equals((String)operate, (String)"dataPreview")) {
            this.getView().invokeOperation("previewdata");
        } else if (HRStringUtils.equals((String)operate, (String)"nextStep")) {
            this.getView().invokeOperation("nextstep");
        } else if (HRStringUtils.equals((String)operate, (String)"save")) {
            this.getView().invokeOperation("save");
        }
    }

    public boolean validateNumber() {
        String number = (String)this.getModel().getValue("number");
        boolean matches = Pattern.matches("^[a-zA-Z0-9_]*$", number);
        if (!matches) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\u3002", (String)"AnObjDataProcessor_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        return matches;
    }

    public boolean validateDuplicateName() {
        boolean exists = false;
        Long id = (Long)this.getModel().getValue("id");
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        if (id == null || id == 0L) {
            exists = this.isDuplicateName(name);
        } else {
            String originName = this.getView().getPageCache().get("originName");
            if (!HRStringUtils.equals((String)originName, (String)name.getLocaleValue())) {
                exists = this.isDuplicateName(name);
            }
        }
        return !exists;
    }

    private boolean isDuplicateName(ILocaleString name) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_analyseobject");
        String entityNum = this.getModel().getDataEntityType().getName();
        QFilter qFilter = HRStringUtils.equals((String)entityNum, (String)"hrptmc_anobjtemplib") ? new QFilter("name", "=", (Object)name.getLocaleValue()).and(new QFilter("objecttype", "=", (Object)"template")) : new QFilter("name", "=", (Object)name.getLocaleValue()).and(new QFilter("objecttype", "!=", (Object)"template"));
        boolean exists = helper.isExists(qFilter);
        if (exists) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u5bf9\u8c61\u540d\u79f0\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"AnObjDataProcessor_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[]{name.getLocaleValue()}), new Object[0]));
        }
        return exists;
    }

    public boolean validatePivotData() {
        List anObjSideBars = JSON.parseArray((String)this.getView().getPageCache().get("sideBar"), AnObjSideBar.class);
        if (anObjSideBars.stream().noneMatch(sideBar -> HRStringUtils.equals((String)sideBar.getType(), (String)"pivot"))) {
            return true;
        }
        String dimValStr = (String)this.getModel().getValue("pivotdimval");
        String pivotIndexStr = (String)this.getModel().getValue("pivotindex");
        if (HRStringUtils.isEmpty((String)dimValStr) || HRStringUtils.isEmpty((String)pivotIndexStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u884c\u5217\u8f6c\u7f6e\u914d\u7f6e\u4e0d\u5b8c\u6574\u3002", (String)"AnObjDataProcessor_11", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean validateFieldDefineData(String op) {
        List joinEntities = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, JoinEntityBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, EntityRelationBo.class);
        }
        if (HRStringUtils.isEmpty((String)joinEntitiesStr) || joinEntities.isEmpty()) {
            String dataSource = this.getView().getPageCache().get(DATA_SOURCE);
            if (HRStringUtils.equals((String)dataSource, (String)"virtual")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u865a\u62df\u5bf9\u8c61\u201d\uff0c\u7136\u540e\u91cd\u8bd5\u3002", (String)"AnObjDataProcessor_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\uff0c\u7136\u540e\u91cd\u8bd5\u3002", (String)"AnObjDataProcessor_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (!this.validateEntityRelation(joinEntities, entityRelations)) {
            return false;
        }
        if (!this.validateFields()) {
            return false;
        }
        if (HRStringUtils.equals((String)op, (String)"save")) {
            return this.groupFieldProcessor.validateAllGroupField() && this.validatePivotData();
        }
        return true;
    }

    private boolean validateFields() {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        String calculateFieldsStr = this.getView().getPageCache().get("calculateFields");
        List queryFields = Collections.emptyList();
        List calculateFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)calculateFieldsStr)) {
            calculateFields = JSON.parseArray((String)calculateFieldsStr, CalculateFieldBo.class);
        }
        if (queryFields.isEmpty() && calculateFields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)"AnObjDataProcessor_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (queryFields.isEmpty()) {
            boolean hasSelected = false;
            for (CalculateFieldBo calculateField : calculateFields) {
                if (!calculateField.getSelected().booleanValue()) continue;
                hasSelected = true;
                break;
            }
            if (!hasSelected) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)"AnObjDataProcessor_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean validateEntityRelation(List<JoinEntityBo> joinEntities, List<EntityRelationBo> entityRelations) {
        for (JoinEntityBo joinEntity : joinEntities) {
            if (HRStringUtils.equals((String)joinEntity.getType(), (String)"main")) continue;
            Optional<EntityRelationBo> relationOptional = entityRelations.stream().filter(relation -> relation != null && HRStringUtils.isNotEmpty((String)relation.getEntityAlias()) && HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny();
            boolean noSet = false;
            if (relationOptional.isPresent()) {
                EntityRelationCommonBo entityRelation;
                List conditions;
                if (HRStringUtils.equals((String)relationOptional.get().getJoinType(), (String)"none")) {
                    noSet = true;
                }
                if ((conditions = (entityRelation = (EntityRelationCommonBo)relationOptional.get()).getConditions()) == null || conditions.isEmpty() || HRStringUtils.isEmpty((String)entityRelation.getJoinType())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\u6761\u4ef6\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"AnObjDataProcessor_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                noSet = true;
            }
            if (!noSet) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"AnObjDataProcessor_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void changeDataSource(CustomEventArgs args) {
        String anObjRefByReportStr = this.getView().getPageCache().get("anObjRefByReport");
        boolean anObjRefByReport = Boolean.parseBoolean(anObjRefByReportStr);
        if (anObjRefByReport) {
            this.showChangeDataSourceErrorMsg();
            return;
        }
        List<String> dataFilterRefFieldAlias = this.getDataFilterRefFieldAlias();
        if (!dataFilterRefFieldAlias.isEmpty()) {
            this.showChangeDataSourceErrorMsg();
            return;
        }
        List<String> pivotRefFieldAlias = this.getPivotRefFieldAlias();
        if (!pivotRefFieldAlias.isEmpty()) {
            this.showChangeDataSourceErrorMsg();
            return;
        }
        this.getView().getPageCache().put(DATA_SOURCE, args.getEventArgs());
        String allFieldTreeNodesStr = this.getView().getPageCache().get("allFieldTreeNodes");
        String calFieldsStr = this.getView().getPageCache().get("calculateFields");
        if (HRStringUtils.isEmpty((String)allFieldTreeNodesStr) && HRStringUtils.isEmpty((String)calFieldsStr)) {
            String dataSource = this.getView().getPageCache().get(DATA_SOURCE);
            this.changeDataSource(dataSource);
        } else {
            ConfirmCallBackListener changeDataSourceConfirmListener = new ConfirmCallBackListener("changeDataSourceConfirm", (IFormPlugin)this.getPlugin());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6570\u636e\u6e90\u540e\uff0c\u5206\u6790\u5bf9\u8c61\u7684\u6240\u6709\u914d\u7f6e\u5c06\u88ab\u6e05\u7a7a\u3002\u786e\u5b9a\u8981\u5207\u6362\u5417\uff1f", (String)"AnObjDataProcessor_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, changeDataSourceConfirmListener);
        }
    }

    private void showChangeDataSourceErrorMsg() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5bf9\u8c61\u4e0b\u6709\u5b57\u6bb5\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5207\u6362\u6570\u636e\u6e90\u3002", (String)"AnObjDataProcessor_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
    }

    public void confirmChangeDataSource(int result) {
        String dataSource = this.getView().getPageCache().get(DATA_SOURCE);
        if (result == MessageBoxResult.Yes.getValue()) {
            this.changeDataSource(dataSource);
        } else if (HRStringUtils.equals((String)dataSource, (String)"virtual")) {
            this.getView().getPageCache().put(DATA_SOURCE, "business");
        } else {
            this.getView().getPageCache().put(DATA_SOURCE, "virtual");
        }
    }

    private void changeDataSource(String dataSource) {
        FieldDefineService fieldDefineService = new FieldDefineService();
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "changeDataSource");
        if (HRStringUtils.equals((String)dataSource, (String)"virtual")) {
            List virtualEntitiesDataSource = VirtualEntityService.getInstance().getVirtualEntitiesDataSource();
            dataMap.put("dataSource", virtualEntitiesDataSource);
            dataMap.put("entities", fieldDefineService.getAllEntitiesForVirtual(virtualEntitiesDataSource));
        } else {
            List dataSourceCloudBos = fieldDefineService.getDataSourceTree();
            dataMap.put("dataSource", dataSourceCloudBos);
            dataMap.put("entities", fieldDefineService.getAllEntities(dataSourceCloudBos));
        }
        dataMap.put("time", new Date());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)dataMap);
        this.clearEntityAndFields();
    }

    private void clearEntityAndFields() {
        this.getView().getPageCache().remove("allFieldTreeNodes");
        this.getView().getPageCache().remove("joinEntities");
        this.getView().getPageCache().remove("entityRelations");
        this.getView().getPageCache().remove("queryFields");
        this.getView().getPageCache().remove("calculateFields");
        this.getView().getPageCache().remove("transPositionInfo");
        this.getView().getPageCache().remove("transNameAlias");
        this.getView().getPageCache().remove("transPositionNames");
        this.getView().getPageCache().remove("transFieldAliasList");
    }
}

