/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.ModifyFieldNameBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCommonProcessor;

public class AnObjFieldProcessor
extends AnObjCommonProcessor {
    public AnObjFieldProcessor(AnalyseObjectCommonEdit plugin) {
        super(plugin);
    }

    public void openModifyFieldPage(CustomEventArgs args) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbp_modifyfieldname");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("modifyFieldNameParams", (Object)args.getEventArgs());
        String allCalFieldStr = this.getView().getPageCache().get("calculateFields");
        if (HRStringUtils.isNotEmpty((String)allCalFieldStr)) {
            List calculateFieldBos = JSON.parseArray((String)allCalFieldStr, CalculateFieldBo.class);
            List calFieldNames = calculateFieldBos.stream().map(CalculateFieldBo::getFieldName).collect(Collectors.toList());
            parameter.setCustomParam("calFieldNames", (Object)SerializationUtils.toJsonString(calFieldNames));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getPlugin(), "hbp_modifyfieldname"));
        this.getView().showForm(parameter);
    }

    public void setFieldNewName(Object returnData) {
        String queryFieldStr;
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "modifyFieldName");
        dataMap.put("data", returnData);
        customcontrol.setData((Object)dataMap);
        ModifyFieldNameBo bo = (ModifyFieldNameBo)returnData;
        String treeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isNotEmpty((String)treeNodeStr)) {
            List fieldTreeNodes = JSON.parseArray((String)treeNodeStr, FieldTreeNode.class);
            fieldTreeNodes.stream().filter(node -> HRStringUtils.equals((String)bo.getFieldAlias(), (String)node.getFieldAlias())).findAny().ifPresent(node -> node.setName(bo.getName()));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)fieldTreeNodes));
        }
        if (HRStringUtils.isNotEmpty((String)(queryFieldStr = this.getView().getPageCache().get("queryFields")))) {
            List queryFieldBoList = JSON.parseArray((String)queryFieldStr, QueryFieldBo.class);
            queryFieldBoList.stream().filter(fieldBo -> HRStringUtils.equals((String)bo.getFieldAlias(), (String)fieldBo.getFieldAlias())).findAny().ifPresent(fieldBo -> fieldBo.setFieldName(bo.getName()));
            this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFieldBoList));
        }
    }

    public void setFieldComplexType() {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFieldsStr)) {
            return;
        }
        List queryFieldBoList = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
        for (QueryFieldBo queryField : queryFieldBoList) {
            if (queryField.getComplexType() == null) {
                String baseDataNum = queryField.getBaseDataNum();
                if (HRStringUtils.isEmpty((String)baseDataNum)) {
                    queryField.setComplexType(FieldComplexType.NORMAL.getValue());
                } else {
                    String baseDataType = AnalyseObjectUtil.getBaseDataType((String)baseDataNum);
                    queryField.setComplexType(baseDataType);
                }
            }
            if (!queryField.getFieldAlias().endsWith(".id") || !HRStringUtils.equals((String)queryField.getComplexType(), (String)FieldComplexType.NORMAL.getValue()) || !HRStringUtils.isNotEmpty((String)queryField.getBaseDataNum())) continue;
            String baseDataType = AnalyseObjectUtil.getBaseDataType((String)queryField.getBaseDataNum());
            queryField.setComplexType(baseDataType);
        }
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFieldBoList));
    }

    public void setFieldControlType() {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFieldsStr)) {
            return;
        }
        List queryFieldCommonBoList = JSON.parseArray((String)queryFieldsStr, QueryFieldCommonBo.class);
        AnalyseObjectUtil.setFieldControlType((List)queryFieldCommonBoList);
        List queryFieldBoList = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
        for (QueryFieldBo queryFieldBo : queryFieldBoList) {
            if (HRStringUtils.isNotEmpty((String)queryFieldBo.getControlType())) continue;
            queryFieldCommonBoList.stream().filter(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)queryFieldBo.getFieldAlias())).findAny().ifPresent(field -> queryFieldBo.setControlType(field.getControlType()));
        }
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFieldBoList));
    }

    public void setBaseDataIdFields(boolean virtualEntity) {
        List<QueryFieldBo> queryFieldBos = this.getCacheQueryFields(false);
        List<QueryFieldBo> originalQueryFields = this.getOriginalQueryFields();
        Map originalFieldMap = originalQueryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        String fieldTreeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isEmpty((String)fieldTreeNodeStr)) {
            return;
        }
        List fieldTreeNodes = JSON.parseArray((String)fieldTreeNodeStr, FieldTreeNode.class);
        Map<String, QueryFieldBo> queryFieldBoMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        Map<String, FieldTreeNode> treeNodeMap = fieldTreeNodes.stream().collect(Collectors.toMap(FieldTreeNode::getFieldAlias, treeNode -> treeNode));
        ArrayList newQueryFieldBoList = Lists.newArrayListWithCapacity((int)10);
        HashSet addAlias = Sets.newHashSetWithExpectedSize((int)16);
        for (QueryFieldBo queryFieldBo : queryFieldBos) {
            QueryFieldBo newQueryFieldBo;
            if (!AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType())) continue;
            String fieldAlias = queryFieldBo.getFieldAlias();
            fieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(".")) + ".id";
            QueryFieldBo originQueryField = (QueryFieldBo)originalFieldMap.get(fieldAlias);
            if (queryFieldBoMap.containsKey(fieldAlias) || !addAlias.add(fieldAlias)) continue;
            if (originQueryField != null) {
                newQueryFieldBoList.add(originQueryField);
                continue;
            }
            FieldTreeNode fieldTreeNode = treeNodeMap.get(fieldAlias);
            if (virtualEntity) {
                newQueryFieldBo = new QueryFieldBo();
                if (fieldTreeNode != null) {
                    newQueryFieldBo.setFieldName(fieldTreeNode.getName());
                } else {
                    newQueryFieldBo.setFieldName(new LocaleString(fieldAlias));
                }
                newQueryFieldBo.setFieldNumber(fieldAlias);
                newQueryFieldBo.setEntityNumber(queryFieldBo.getEntityNumber());
                newQueryFieldBo.setEntityName(queryFieldBo.getEntityName());
                newQueryFieldBo.setFieldAlias(fieldAlias);
                newQueryFieldBo.setFieldPath(queryFieldBo.getFieldPath().substring(0, queryFieldBo.getFieldPath().lastIndexOf(".")) + ".id");
                newQueryFieldBo.setBaseDataNum(queryFieldBo.getBaseDataNum());
                newQueryFieldBo.setBaseDataIdType(queryFieldBo.getBaseDataIdType());
                newQueryFieldBo.setVirtualEntityField(true);
                newQueryFieldBo.setComplexType(queryFieldBo.getComplexType());
                newQueryFieldBoList.add(newQueryFieldBo);
                continue;
            }
            newQueryFieldBo = new QueryFieldBo();
            newQueryFieldBo.setFieldName(fieldTreeNode.getName());
            newQueryFieldBo.setFieldNumber(fieldTreeNode.getFieldAlias());
            newQueryFieldBo.setEntityNumber(fieldTreeNode.getEntityNumber());
            newQueryFieldBo.setEntityName(fieldTreeNode.getEntityName());
            newQueryFieldBo.setFieldAlias(fieldTreeNode.getFieldAlias());
            newQueryFieldBo.setFieldPath(fieldTreeNode.getFieldPath());
            newQueryFieldBo.setValueType(fieldTreeNode.getValueType());
            newQueryFieldBo.setBaseDataNum(fieldTreeNode.getBaseDataNum());
            newQueryFieldBo.setBaseDataIdType(fieldTreeNode.getBaseDataIdType());
            newQueryFieldBo.setComplexType(queryFieldBo.getComplexType());
            newQueryFieldBo.setVirtualEntityField(false);
            newQueryFieldBoList.add(newQueryFieldBo);
        }
        if (newQueryFieldBoList.isEmpty()) {
            return;
        }
        queryFieldBos.addAll(newQueryFieldBoList);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
    }

    public void setZoneInfoIntoQueryField() {
        List<QueryFieldBo> queryFieldBos = this.getCacheQueryFields(false);
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        DateTimeFieldTimeZoneUtil.buildTimeZoneInfoIntoQueryField(queryFieldBos, (MainEntityTypeUtil)entityTypeUtil);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
    }

    public void addDateTimeRelateOrgFields() {
        List<QueryFieldBo> queryFieldBos = this.getCacheQueryFields(false);
        List<QueryFieldBo> originalQueryFields = this.getOriginalQueryFields();
        Map originalFieldMap = originalQueryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        String fieldTreeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isEmpty((String)fieldTreeNodeStr)) {
            return;
        }
        List fieldTreeNodes = JSON.parseArray((String)fieldTreeNodeStr, FieldTreeNode.class);
        Map<String, QueryFieldBo> queryFieldBoMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        ArrayList newQueryFieldBoList = Lists.newArrayListWithCapacity((int)10);
        HashSet addAlias = Sets.newHashSetWithExpectedSize((int)16);
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        for (QueryFieldBo queryField : queryFieldBos) {
            if (!HRStringUtils.equals((String)queryField.getControlType(), (String)FieldControlType.DATE_TIME.getValue())) {
                return;
            }
            DateTimeProp dateTimeProp = (DateTimeProp)AnalyseObjectUtil.parseFieldAliasGetProperty((String)queryField.getEntityNumber(), (String)queryField.getFieldAlias(), (MainEntityTypeUtil)entityTypeUtil);
            if (dateTimeProp.getTimeZoneTransType() != 2) continue;
            String relateOrg = dateTimeProp.getRelateOrg();
            boolean isSubEntityField = queryField.getFieldAlias().startsWith(queryField.getEntityNumber());
            String fieldPrefix = isSubEntityField ? queryField.getFieldAlias().substring(0, queryField.getFieldAlias().indexOf(".")) : "";
            Optional<FieldTreeNode> orgFieldTreeNode = fieldTreeNodes.stream().filter(field -> {
                boolean isRelateOrgField;
                boolean bl = isRelateOrgField = HRStringUtils.equals((String)field.getEntityNumber(), (String)queryField.getEntityNumber()) && field.getFieldAlias().endsWith("." + relateOrg);
                if (isSubEntityField) {
                    return isRelateOrgField && field.getFieldAlias().startsWith(fieldPrefix);
                }
                return isRelateOrgField;
            }).findAny();
            if (!orgFieldTreeNode.isPresent()) continue;
            String orgFieldAlias = orgFieldTreeNode.get().getFieldAlias();
            QueryFieldBo originQueryField = (QueryFieldBo)originalFieldMap.get(orgFieldAlias);
            if (queryFieldBoMap.containsKey(orgFieldAlias) || !addAlias.add(orgFieldAlias)) continue;
            if (originQueryField != null) {
                newQueryFieldBoList.add(originQueryField);
                continue;
            }
            QueryFieldBo newQueryFieldBo = new QueryFieldBo();
            newQueryFieldBo.setFieldName(orgFieldTreeNode.get().getName());
            newQueryFieldBo.setFieldNumber(orgFieldTreeNode.get().getFieldAlias());
            newQueryFieldBo.setEntityNumber(orgFieldTreeNode.get().getEntityNumber());
            newQueryFieldBo.setEntityName(orgFieldTreeNode.get().getEntityName());
            newQueryFieldBo.setFieldAlias(orgFieldTreeNode.get().getFieldAlias());
            newQueryFieldBo.setFieldPath(orgFieldTreeNode.get().getFieldPath());
            newQueryFieldBo.setValueType(orgFieldTreeNode.get().getValueType());
            newQueryFieldBo.setBaseDataNum(orgFieldTreeNode.get().getBaseDataNum());
            newQueryFieldBo.setBaseDataIdType(orgFieldTreeNode.get().getBaseDataIdType());
            newQueryFieldBo.setVirtualEntityField(false);
            newQueryFieldBoList.add(newQueryFieldBo);
        }
        if (newQueryFieldBoList.isEmpty()) {
            return;
        }
        queryFieldBos.addAll(newQueryFieldBoList);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
    }
}

