/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.model.anobj.AnObjSideBar;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCommonProcessor;

public class AnObjFormProcessor
extends AnObjCommonProcessor {
    private static final Log LOGGER = LogFactory.getLog(AnObjFormProcessor.class);

    public AnObjFormProcessor(AnalyseObjectCommonEdit plugin) {
        super(plugin);
    }

    public void sendFlagForGetAllData(String operationKey, String nextTab) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "getAllData");
        dataMap.put("operate", "nextStep");
        dataMap.put("time", new Date());
        if (HRStringUtils.equals((String)operationKey, (String)"previewdata")) {
            dataMap.put("operate", "dataPreview");
            dataMap.put("time", System.currentTimeMillis());
        } else if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            dataMap.put("operate", "save");
        } else if (HRStringUtils.equals((String)nextTab, (String)"filterdata")) {
            dataMap.put("operate", "nextStep");
            dataMap.put("time", System.currentTimeMillis());
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            LOGGER.error((Throwable)ex);
        }
        customcontrol.setData((Object)dataMap);
    }

    public void sendFlagForToStep2() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "toStep2");
        dataMap.put("uuid", UUID.randomUUID());
        customcontrol.setData((Object)dataMap);
    }

    public String getNextTab(Tab tab) {
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        String nextTab = null;
        boolean foundCurrent = false;
        for (Control item : items) {
            if (foundCurrent) {
                nextTab = item.getKey();
                break;
            }
            if (!HRStringUtils.equals((String)currentTab, (String)item.getKey())) continue;
            foundCurrent = true;
        }
        return nextTab;
    }

    public String getLastTab(Tab tab) {
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        String lastTab = ((Control)items.get(0)).getKey();
        if (HRStringUtils.equals((String)lastTab, (String)currentTab)) {
            return null;
        }
        for (int i = 1; i < items.size(); ++i) {
            if (HRStringUtils.equals((String)currentTab, (String)((Control)items.get(i)).getKey())) {
                return lastTab;
            }
            lastTab = ((Control)items.get(i)).getKey();
        }
        return lastTab;
    }

    public void setVisibleForBtn(String tab, IFormView view) {
        if (HRStringUtils.equals((String)tab, (String)"defineobj")) {
            view.setVisible(Boolean.TRUE, new String[]{"nextstepbtn"});
            view.setVisible(Boolean.FALSE, new String[]{"laststepbtn", "previewbtn", "bar_save"});
        } else if (HRStringUtils.equals((String)tab, (String)"definefield")) {
            view.setVisible(Boolean.TRUE, new String[]{"laststepbtn", "nextstepbtn", "previewbtn", "bar_save"});
        } else if (HRStringUtils.equals((String)tab, (String)"filterdata")) {
            view.setVisible(Boolean.TRUE, new String[]{"laststepbtn", "bar_save"});
            view.setVisible(Boolean.FALSE, new String[]{"previewbtn", "nextstepbtn"});
        }
    }

    public List<AnObjSideBar> getFrontSideBar(IFormView view) {
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        String currentIndexStr = this.getView().getPageCache().get("currentBarIndex");
        int index = Integer.parseInt(currentIndexStr);
        --index;
        String sideBarStr = view.getPageCache().get("sideBar");
        List anObjSideBars = SerializationUtils.fromJsonStringToList((String)sideBarStr, AnObjSideBar.class);
        int sideBarIndex = 0;
        for (AnObjSideBar side : anObjSideBars) {
            result.add(side);
            if (index == sideBarIndex) break;
            ++sideBarIndex;
        }
        return result;
    }

    public void clearDataFilterTable() {
        CustomControl dataFilterControl = (CustomControl)this.getView().getControl("anobjdatafiltercontrol");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("eventKey", "confirmDeleteDataFilter");
        dataMap.put("date", System.currentTimeMillis());
        dataFilterControl.setData((Object)dataMap);
    }

    public void clearGroupFieldTable() {
        CustomControl dataFilterControl = (CustomControl)this.getView().getControl("groupfieldcontrol");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("eventKey", "confirmDeleteGroupField");
        dataMap.put("date", System.currentTimeMillis());
        dataFilterControl.setData((Object)dataMap);
    }
}

