/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnObjSideBarService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.common.constant.anobj.AnObjGroupFieldConstants;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.AnObjSideBar;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.util.ReportCommonUtils;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCommonProcessor;

public class AnObjGroupFieldProcessor
extends AnObjCommonProcessor
implements AnalyseObjectConstants,
AnObjGroupFieldConstants {
    public AnObjGroupFieldProcessor(AnalyseObjectCommonEdit plugin) {
        super(plugin);
    }

    public void initGroupFieldControl() {
        List<AnObjGroupField> groupFields = this.getCacheGroupFields();
        if (!groupFields.isEmpty()) {
            AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(this.getModel().getDataEntity(), new MainEntityTypeUtil());
            for (AnObjGroupField groupField : groupFields) {
                if (!HRStringUtils.equals((String)groupField.getType(), (String)"enum")) continue;
                this.setEnumItemToGroupField(groupField.getAnObjField(), groupField, enumFieldHandler);
            }
            this.putGroupFieldsToCache(groupFields);
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("groupfieldcontrol");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "init");
        dataMap.put("status", "edit");
        customcontrol.setData((Object)dataMap);
    }

    public void requestCurrentGroupField() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("groupfieldcontrol");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "getCurrentGroupField");
        dataMap.put("time", System.currentTimeMillis());
        customcontrol.setData((Object)dataMap);
    }

    public boolean validateAllGroupField() {
        boolean result = true;
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        List<QueryFieldBo> cacheQueryFields = this.getCacheQueryFields(false);
        List<CalculateFieldBo> cacheCalculateFields = this.getCacheCalculateFields(false);
        StringBuilder errorMsg = new StringBuilder();
        for (AnObjGroupField cacheGroupField : cacheGroupFields) {
            result = result && this.validateGroupField(cacheGroupField, cacheGroupFields, cacheQueryFields, cacheCalculateFields, false, errorMsg);
        }
        if (errorMsg.length() > 0) {
            this.getView().showTipNotification(errorMsg.toString());
        }
        return result;
    }

    public boolean validateGroupField(AnObjGroupField groupField, List<AnObjGroupField> cacheGroupFields, List<QueryFieldBo> cacheQueryFields, List<CalculateFieldBo> cacheCalculateFields, boolean showTip, StringBuilder errorMsg) {
        String msg;
        String msg2;
        cacheGroupFields.set(groupField.getIndex(), groupField);
        if (HRStringUtils.isEmpty((String)groupField.getNumber())) {
            msg2 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u7f16\u7801\u3002", (String)"AnObjGroupFieldProcessor_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            errorMsg.append(msg2);
            if (showTip) {
                this.getView().showTipNotification(msg2);
            }
        } else if (!ReportCommonUtils.validateNumber((String)groupField.getNumber())) {
            msg2 = ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u7f16\u7801\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199\u3002", (String)"AnObjGroupFieldProcessor_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            errorMsg.append(msg2);
            if (showTip) {
                this.getView().showTipNotification(msg2);
            }
        }
        if (groupField.getName() == null || HRStringUtils.isEmpty((String)groupField.getName().getLocaleValue())) {
            msg2 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u540d\u79f0\u3002", (String)"AnObjGroupFieldProcessor_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            errorMsg.append(msg2);
            if (showTip) {
                this.getView().showTipNotification(msg2);
            }
        }
        if (groupField.getAnObjField() == null && groupField.getAnObjCalField() == null) {
            msg2 = ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u7684\u5206\u7ec4\u8d4b\u503c\u4f9d\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnObjGroupFieldProcessor_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            errorMsg.append(msg2);
            if (showTip) {
                this.getView().showTipNotification(msg2);
            }
        }
        if (errorMsg.length() > 0) {
            return false;
        }
        long sameNumCount = cacheGroupFields.stream().filter(cacheField -> HRStringUtils.equals((String)cacheField.getNumber(), (String)groupField.getNumber())).count();
        long otherSameNumCount = cacheQueryFields.stream().filter(fieldBo -> HRStringUtils.equals((String)fieldBo.getFieldAlias(), (String)groupField.getNumber())).count();
        long sameNameCount = cacheGroupFields.stream().filter(cacheField -> cacheField.getName() != null && HRStringUtils.equals((String)cacheField.getName().getLocaleValue(), (String)groupField.getName().getLocaleValue())).count();
        long otherSameNameCount = cacheQueryFields.stream().filter(fieldBo -> HRStringUtils.equals((String)fieldBo.getFieldName().getLocaleValue(), (String)groupField.getName().getLocaleValue())).count();
        otherSameNameCount += cacheCalculateFields.stream().filter(calculateFieldBo -> HRStringUtils.equals((String)calculateFieldBo.getFieldName().getLocaleValue(), (String)groupField.getName().getLocaleValue())).count();
        if (sameNumCount > 1L || (otherSameNumCount += cacheCalculateFields.stream().filter(calculateFieldBo -> HRStringUtils.equals((String)calculateFieldBo.getFieldNumber(), (String)groupField.getNumber())).count()) > 0L) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u7f16\u7801\u201c%s\u201d\u4e0e\u5176\u4ed6\u5b57\u6bb5\u91cd\u590d\u3002", (String)"AnObjGroupFieldProcessor_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), groupField.getNumber());
            errorMsg.append(msg);
            if (showTip) {
                this.getView().showTipNotification(msg);
            }
        }
        if (sameNameCount > 1L || otherSameNameCount > 0L) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u540d\u79f0\u201c%s\u201d\u4e0e\u5176\u4ed6\u5b57\u6bb5\u91cd\u590d\u3002", (String)"AnObjGroupFieldProcessor_11", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), groupField.getName());
            errorMsg.append(msg);
            if (showTip) {
                this.getView().showTipNotification(msg);
            }
        }
        if (errorMsg.length() > 0) {
            return false;
        }
        String msgStart = ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u201c%1$s\u201d: %2$s\u8bf7\u4fee\u6539\u3002", (String)"AnObjGroupFieldProcessor_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        StringBuilder tips = new StringBuilder();
        if (!this.validateGroupItems(tips, groupField)) {
            if (tips.length() > 0) {
                errorMsg.append(String.format(msgStart, groupField.getName().getLocaleValue(), tips));
            }
            if (showTip && errorMsg.length() > 0) {
                this.getView().showTipNotification(errorMsg.toString());
            }
            return false;
        }
        return true;
    }

    private boolean validateGroupItems(StringBuilder tips, AnObjGroupField groupField) {
        boolean result = true;
        List group = groupField.getGroup();
        int index = 1;
        for (AnObjGroupField.GroupItem groupItem : group) {
            boolean isUnGroupItem;
            boolean bl = isUnGroupItem = groupItem.getUnGroupItem() != null && groupItem.getUnGroupItem() != false;
            if (groupItem.getItemName() == null || HRStringUtils.isEmpty((String)groupItem.getItemName().getLocaleValue())) {
                String tip = isUnGroupItem ? ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u672a\u5206\u7ec4\u7684\u540d\u79f0\u3002", (String)"AnObjGroupFieldProcessor_12", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u6761\u5206\u7ec4\u8bbe\u7f6e\u7684\u5206\u7ec4\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AnObjGroupFieldProcessor_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), index);
                tips.append(tip);
                tips.append(",");
                result = false;
            }
            if (groupItem.getUnGroupItem() == null || !groupItem.getUnGroupItem().booleanValue()) {
                Map itemMap;
                List values;
                String itemCondition = groupItem.getItemCondition();
                if (HRStringUtils.isEmpty((String)itemCondition)) {
                    String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u6761\u5206\u7ec4\u8bbe\u7f6e\u7684\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AnObjGroupFieldProcessor_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), index);
                    tips.append(tip);
                    tips.append(",");
                    result = false;
                    ++index;
                    continue;
                }
                if ("number".equals(groupField.getType()) && ((values = (List)(itemMap = (Map)SerializationUtils.fromJsonString((String)itemCondition, Map.class)).get("value")).size() != 2 || HRStringUtils.isEmpty((String)((String)values.get(0))) || HRStringUtils.isEmpty((String)((String)values.get(1))))) {
                    String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u6761\u5206\u7ec4\u8bbe\u7f6e\u7684\u6570\u5b57\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AnObjGroupFieldProcessor_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), index);
                    tips.append(tip);
                    tips.append(",");
                    result = false;
                }
            }
            ++index;
        }
        return result;
    }

    public List<CalculateFieldBo> transferCalculateFields(List<Integer> groupFieldIndexList) {
        if (groupFieldIndexList.isEmpty()) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        List<QueryFieldBo> cacheQueryFields = this.getCacheQueryFields(false);
        List<CalculateFieldBo> cacheCalculateFields = this.getCacheCalculateFields(true);
        return cacheGroupFields.stream().filter(field -> groupFieldIndexList.contains(field.getIndex())).filter(field -> this.validateGroupField((AnObjGroupField)field, cacheGroupFields, cacheQueryFields, cacheCalculateFields, false, new StringBuilder())).map(field -> AnObjGroupFieldService.getInstance().transferGroupField(cacheCalculateFields, cacheQueryFields, field)).collect(Collectors.toList());
    }

    public void updateGroupFieldsCache(String currentGroupFieldStr) {
        if (HRStringUtils.isEmpty((String)currentGroupFieldStr)) {
            return;
        }
        AnObjGroupField anObjGroupField = (AnObjGroupField)SerializationUtils.fromJsonString((String)currentGroupFieldStr, AnObjGroupField.class);
        this.updateGroupFieldCache(anObjGroupField);
    }

    private void updateGroupFieldCache(AnObjGroupField anObjGroupField) {
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        cacheGroupFields.set(anObjGroupField.getIndex(), anObjGroupField);
        this.putGroupFieldsToCache(cacheGroupFields);
        if (HRStringUtils.equals((String)"save", (String)this.getView().getPageCache().get("fromOp"))) {
            this.getView().getPageCache().remove("fromOp");
            this.getView().invokeOperation("save");
        }
    }

    public List<String> getAllGroupFieldsDependFieldsNumberList() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        cacheGroupFields.forEach(field -> {
            if (HRStringUtils.equals((String)field.getFieldType(), (String)"field") && field.getAnObjField() != null) {
                result.add(field.getAnObjField().getFieldAlias());
            } else if (HRStringUtils.equals((String)field.getFieldType(), (String)"calField") && field.getAnObjCalField() != null) {
                result.add(field.getAnObjCalField().getFieldNumber());
            }
        });
        return result;
    }

    public void putGroupFieldsToCache(List<AnObjGroupField> anObjGroupFields) {
        this.getView().getPageCache().put("cache_group_fields", JSON.toJSONString(anObjGroupFields));
    }

    public void openBaseDataF7(String args) {
        String itemCondition;
        JSONObject param = JSON.parseObject((String)args);
        String groupFieldStr = JSON.toJSONString(param.get("anObjGroupField"));
        AnObjGroupField groupField = (AnObjGroupField)JSON.parseObject((String)groupFieldStr, AnObjGroupField.class);
        int itemIndex = (Integer)param.get("index");
        this.getView().getPageCache().put("openBaseDataF7_ItemIndex", String.valueOf(itemIndex));
        String baseDataNum = groupField.getAnObjField().getBaseDataNum();
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)baseDataNum, (boolean)true);
        if (groupField.getGroup() != null && itemIndex < groupField.getGroup().size() && groupField.getGroup().get(itemIndex) != null && HRStringUtils.isNotEmpty((String)(itemCondition = ((AnObjGroupField.GroupItem)groupField.getGroup().get(itemIndex)).getItemCondition()))) {
            List selectedItems = (List)SerializationUtils.fromJsonString((String)itemCondition, List.class);
            String baseDataIdType = groupField.getAnObjField().getBaseDataIdType();
            if (HRStringUtils.equals((String)baseDataIdType, (String)"string")) {
                listShowParameter.setSelectedRows(selectedItems.stream().map(item -> (String)item.get("id")).toArray());
            } else {
                listShowParameter.setSelectedRows(selectedItems.stream().map(item -> Long.parseLong((String)item.get("id"))).toArray());
            }
        }
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getPlugin(), "baseDataF7Back"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void backF7Data(ListSelectedRowCollection rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)rows.size());
        for (ListSelectedRow row : rows) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("id", row.getPrimaryKeyValue().toString());
            map.put("name", row.getName());
            dataList.add(map);
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("groupfieldcontrol");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        String itemIndexStr = this.getView().getPageCache().get("openBaseDataF7_ItemIndex");
        dataMap.put("method", "backF7Data");
        dataMap.put("data", dataList);
        dataMap.put("index", Integer.parseInt(itemIndexStr));
        customcontrol.setData((Object)dataMap);
    }

    public void selectAnObjField(String groupFieldStr) {
        AnObjGroupField groupField = (AnObjGroupField)JSON.parseObject((String)groupFieldStr, AnObjGroupField.class);
        Optional<Map> selectedOp = groupField.getSelectedFields().stream().filter(field -> field.get("selected") != null && (Boolean)field.get("selected") != false).findAny();
        if (selectedOp.isPresent()) {
            String fieldAlias = (String)selectedOp.get().get("number");
            groupField.setGroup(null);
            List<QueryFieldBo> queryFields = this.getCacheQueryFields(true);
            List<CalculateFieldBo> calculateFields = this.getCacheCalculateFields(true);
            Optional<QueryFieldBo> queryFieldOp = queryFields.stream().filter(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)fieldAlias)).findAny();
            AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(this.getModel().getDataEntity(), new MainEntityTypeUtil());
            queryFieldOp.ifPresent(queryFieldBo -> {
                groupField.setFieldType("field");
                groupField.setType(this.getQueryFieldType((QueryFieldBo)queryFieldBo));
                groupField.setAnObjField(queryFieldBo);
                if (HRStringUtils.equals((String)groupField.getType(), (String)"enum")) {
                    this.setEnumItemToGroupField((QueryFieldBo)queryFieldBo, groupField, enumFieldHandler);
                }
            });
            Optional<CalculateFieldBo> calFieldOp = calculateFields.stream().filter(field -> HRStringUtils.equals((String)field.getFieldNumber(), (String)fieldAlias)).findAny();
            calFieldOp.ifPresent(calField -> {
                groupField.setFieldType("calField");
                groupField.setType(this.getCalFieldType((CalculateFieldBo)calField));
                groupField.setAnObjCalField(calField);
            });
        } else {
            groupField.setAnObjField(null);
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("groupfieldcontrol");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "backSelectAnObjField");
        dataMap.put("anObjGroupField", groupField);
        customcontrol.setData((Object)dataMap);
        this.updateGroupFieldCache(groupField);
    }

    private void setEnumItemToGroupField(QueryFieldBo queryFieldBo, AnObjGroupField groupField, AnObjEnumFieldHandler enumFieldHandler) {
        if (AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType()) && queryFieldBo.getBaseDataNum() == null) {
            String enumBaseData = AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)queryFieldBo.getEntityNumber(), (String)queryFieldBo.getFieldAlias(), (MainEntityTypeUtil)new MainEntityTypeUtil());
            queryFieldBo.setBaseDataNum(enumBaseData);
        }
        ArrayList enumItemList = Lists.newArrayListWithCapacity((int)10);
        List enumItems = enumFieldHandler.getEnumItems((QueryFieldCommonBo)queryFieldBo);
        for (AnObjEnumFieldHandler.AnObjEnumItem enumItem : enumItems) {
            HashMap item = Maps.newHashMapWithExpectedSize((int)2);
            item.put("name", enumItem.getName());
            item.put("id", enumItem.getValue());
            enumItemList.add(item);
        }
        groupField.setEnumItems((List)enumItemList);
    }

    private String getQueryFieldType(QueryFieldBo queryFieldBo) {
        boolean isEnum = AnalyseObjectUtil.isEnumType((String)queryFieldBo.getControlType());
        boolean isBaseData = AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType()) && (queryFieldBo.getFieldAlias().endsWith(".name") || queryFieldBo.getFieldAlias().endsWith(".number"));
        boolean isDate = HRStringUtils.equals((String)queryFieldBo.getValueType(), (String)DataTypeEnum.DATETIME.getDataTypeKey());
        if (isEnum) {
            return "enum";
        }
        if (isBaseData) {
            return "baseData";
        }
        if (isDate) {
            return "datetime";
        }
        return "number";
    }

    private String getCalFieldType(CalculateFieldBo calculateFieldBo) {
        if (HRStringUtils.equals((String)calculateFieldBo.getValueType(), (String)DataTypeEnum.DATETIME.getDataTypeKey())) {
            return "datetime";
        }
        return "number";
    }

    public boolean removeGroupField(int sideBarIndex, int groupFieldIndex) {
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        AnObjGroupField remove = cacheGroupFields.remove(groupFieldIndex);
        Set refByReportFieldAliasCollection = AnalyseObjectService.getInstance().getRefByReportFieldAliasCollection((Long)this.getModel().getValue("id"));
        if (refByReportFieldAliasCollection.contains(remove.getNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u8d4b\u503c\u5b57\u6bb5\u5df2\u88ab\u62a5\u8868\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AnObjGroupFieldProcessor_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        AnObjSideBarService.getInstance().removeSideBarFromCache(sideBarIndex, this.getView().getPageCache());
        this.getView().getPageCache().put("currentBarFlag", "table");
        int index = 0;
        for (AnObjGroupField cacheGroupField : cacheGroupFields) {
            cacheGroupField.setIndex(Integer.valueOf(index++));
        }
        this.putGroupFieldsToCache(cacheGroupFields);
        List anObjSideBars = JSON.parseArray((String)this.getView().getPageCache().get("sideBar"), AnObjSideBar.class);
        index = 0;
        for (AnObjSideBar anObjSideBar : anObjSideBars) {
            if (!HRStringUtils.equals((String)anObjSideBar.getType(), (String)"groupField")) continue;
            anObjSideBar.setGroupFieldIndex(Integer.valueOf(index++));
        }
        this.getView().getPageCache().put("sideBar", JSON.toJSONString((Object)anObjSideBars));
        return true;
    }

    public void showGroupField(int index, List<AnObjSideBar> anObjSideBars, boolean requestGroupField) {
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        if (--index >= anObjSideBars.size()) {
            AnObjSideBar newAnObjSideBar = new AnObjSideBar();
            newAnObjSideBar.setIndex(Integer.valueOf(index));
            newAnObjSideBar.setType("groupField");
            newAnObjSideBar.setGroupFieldIndex(Integer.valueOf(cacheGroupFields.size()));
            anObjSideBars.add(newAnObjSideBar);
            AnObjGroupField anObjGroupField = new AnObjGroupField();
            anObjGroupField.setNumberLock(Boolean.valueOf(false));
            anObjGroupField.setIndex(Integer.valueOf(cacheGroupFields.size()));
            anObjGroupField.setSelectedFields(this.getCurrentSelectedFields(null));
            CustomControl customcontrol = (CustomControl)this.getView().getControl("groupfieldcontrol");
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put("method", "addGroupField");
            dataMap.put("enableLang", InteServiceHelper.getEnabledLang());
            dataMap.put("anObjGroupField", anObjGroupField);
            if (requestGroupField) {
                dataMap.put("getCurrentGroupField", true);
            }
            customcontrol.setData((Object)dataMap);
            cacheGroupFields.add(anObjGroupField);
            this.putGroupFieldsToCache(cacheGroupFields);
        } else {
            AnObjSideBar anObjSideBar = anObjSideBars.get(index);
            AnObjGroupField groupField = cacheGroupFields.get(anObjSideBar.getGroupFieldIndex());
            if (HRStringUtils.equals((String)groupField.getFieldType(), (String)"field") && groupField.getAnObjField() != null) {
                String fieldAlias = groupField.getAnObjField().getFieldAlias();
                groupField.setSelectedFields(this.getCurrentSelectedFields(fieldAlias));
            } else if (HRStringUtils.equals((String)groupField.getFieldType(), (String)"calField") && groupField.getAnObjCalField() != null) {
                String fieldNumber = groupField.getAnObjCalField().getFieldNumber();
                groupField.setSelectedFields(this.getCurrentSelectedFields(fieldNumber));
            } else {
                groupField.setSelectedFields(this.getCurrentSelectedFields(null));
            }
            CustomControl customcontrol = (CustomControl)this.getView().getControl("groupfieldcontrol");
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put("method", "editGroupField");
            dataMap.put("enableLang", InteServiceHelper.getEnabledLang());
            dataMap.put("anObjGroupField", groupField);
            if (requestGroupField) {
                dataMap.put("getCurrentGroupField", true);
            }
            customcontrol.setData((Object)dataMap);
        }
    }

    public boolean validateAddPivotRefIndex() {
        List<AnObjGroupField> cacheGroupFields = this.getCacheGroupFields();
        if (cacheGroupFields == null) {
            return true;
        }
        return cacheGroupFields.stream().noneMatch(field -> field.getAnObjField() != null && AnalyseObjectService.getInstance().isIndexField(field.getAnObjField().getValueType()));
    }

    private List<Map<String, Object>> getCurrentSelectedFields(String selectedFieldAlias) {
        List<QueryFieldBo> queryFields = this.getCacheQueryFields(true);
        String allIndexAliasStr = this.getView().getPageCache().get("allIndexAlias");
        HashSet pivotRefFields = Sets.newHashSetWithExpectedSize((int)16);
        String pivotDim = (String)this.getModel().getValue("pivotdim");
        if (HRStringUtils.isNotEmpty((String)pivotDim)) {
            pivotRefFields.add(pivotDim);
        }
        if (allIndexAliasStr == null) {
            String value = (String)this.getModel().getValue("pivotindex");
            if (HRStringUtils.isNotEmpty((String)value)) {
                pivotRefFields.addAll(Arrays.asList(value.split(",")));
            }
        } else {
            List indexFields = (List)SerializationUtils.fromJsonString((String)allIndexAliasStr, List.class);
            for (Map indexField : indexFields) {
                if (indexField.get("selected") == null || !((Boolean)indexField.get("selected")).booleanValue()) continue;
                pivotRefFields.add((String)indexField.get("id"));
            }
        }
        String sideBarStr = this.getView().getPageCache().get("sideBar");
        List anObjSideBars = JSON.parseArray((String)sideBarStr, AnObjSideBar.class);
        if (anObjSideBars.stream().anyMatch(field -> HRStringUtils.equals((String)field.getType(), (String)"pivot"))) {
            queryFields.removeIf(field -> AnalyseObjectService.getInstance().isIndexField(field.getValueType()));
        }
        ArrayList selectedFields = Lists.newArrayListWithCapacity((int)10);
        Set typeSet = Stream.of(DataTypeEnum.DATETIME.getDataTypeKey(), DataTypeEnum.INTEGER.getDataTypeKey(), DataTypeEnum.LONG.getDataTypeKey(), DataTypeEnum.BIGDECIMAL.getDataTypeKey()).collect(Collectors.toSet());
        queryFields.stream().filter(field -> AnalyseObjectUtil.isEnumType((String)field.getControlType()) || AnalyseObjectUtil.isBaseDataType((String)field.getComplexType()) && (field.getFieldAlias().endsWith(".name") || field.getFieldAlias().endsWith(".number")) || typeSet.contains(field.getValueType())).forEach(field -> {
            if (pivotRefFields.contains(field.getFieldNumber())) {
                return;
            }
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)3);
            fieldMap.put("name", field.getFieldName().getLocaleValue());
            fieldMap.put("number", field.getFieldAlias());
            if (selectedFieldAlias != null && HRStringUtils.equals((String)field.getFieldAlias(), (String)selectedFieldAlias)) {
                fieldMap.put("selected", true);
            }
            selectedFields.add(fieldMap);
        });
        return selectedFields;
    }
}

