/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.anobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.hr.hbp.business.service.labelandreport.AnobjFilterUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceAppBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceCloudBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnObjSideBarService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.anobj.virtualentity.VirtualEntityService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.common.model.anobj.AnObjPivotBo;
import kd.hr.hrptmc.common.model.anobj.AnObjSideBar;
import kd.hr.hrptmc.common.model.anobj.EntityRelationBo;
import kd.hr.hrptmc.common.model.anobj.JoinEntityBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.util.ReportComplexObjTransferUtil;
import kd.hr.hrptmc.formplugin.web.anobj.AnalyseObjectCommonEdit;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCommonProcessor;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjCopyProcessor;
import kd.hr.hrptmc.formplugin.web.anobj.processor.AnObjEntityProcessor;

public class AnObjInitProcessor
extends AnObjCommonProcessor {
    private final AnObjCopyProcessor anObjCopyProcessor;
    private final AnObjEntityProcessor anObjEntityProcessor;

    public AnObjInitProcessor(AnalyseObjectCommonEdit plugin) {
        super(plugin);
        this.anObjCopyProcessor = new AnObjCopyProcessor(plugin);
        this.anObjEntityProcessor = new AnObjEntityProcessor(plugin);
    }

    public void initData(boolean isCopy) {
        Long id;
        AnalyseObjectService anObjService = AnalyseObjectService.getInstance();
        if (isCopy) {
            Object copyIdObj = this.getView().getFormShowParameter().getCustomParam("copyId");
            if (copyIdObj == null) {
                return;
            }
            id = Long.parseLong(copyIdObj.toString());
        } else {
            id = (Long)this.getModel().getValue("id");
        }
        List joinEntities = anObjService.queryAndAssembleJoinEntities(id);
        this.anObjEntityProcessor.resetEntityLongNumberForInit(joinEntities);
        List queryFields = anObjService.queryAndAssembleQueryFields(id);
        List entityRelations = anObjService.queryAndAssembleEntityRelations(id);
        for (EntityRelationBo entityRelation : entityRelations) {
            joinEntities.stream().filter(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityRelation.getJoinEntityAlias())).findAny().ifPresent(entityBo -> entityBo.setEntityRelation((EntityRelationCommonBo)entityRelation));
        }
        for (EntityRelationBo entityRelation : entityRelations) {
            if (!HRStringUtils.equals((String)entityRelation.getJoinType(), (String)"RightJoin")) continue;
            entityRelation.setJoinType(null);
        }
        CalculateFieldService calFieldService = CalculateFieldService.getInstance();
        List calculateFields = calFieldService.loadCalFieldsByAnObjIdForBo(id, false);
        AnObjSideBarService sideBarService = AnObjSideBarService.getInstance();
        List sideBars = sideBarService.getSideBars(id);
        String oldSideBar = (String)this.getModel().getValue("sidebar");
        sideBarService.compatibleOldSideBar(id.longValue(), oldSideBar, sideBars);
        this.getModel().setValue("sidebar", null);
        List groupFields = AnObjGroupFieldService.getInstance().getGroupFields(id, this.getCacheQueryFields(false));
        int index = 0;
        for (AnObjSideBar sideBar : sideBars) {
            String type = sideBar.getType();
            if (!HRStringUtils.equals((String)type, (String)"groupField")) continue;
            sideBar.setGroupFieldIndex(Integer.valueOf(index++));
        }
        List anObjPivotConfigs = AnalyseObjectService.getInstance().getAnObjPivotConfigMsg(id.longValue());
        if (!anObjPivotConfigs.isEmpty()) {
            String pivotDim = ((AnObjPivotBo)anObjPivotConfigs.get(0)).getPivotDim();
            this.getModel().setValue("pivotdim", (Object)pivotDim);
            String dimValueStr = anObjPivotConfigs.stream().map(AnObjPivotBo::getPivotDimVal).distinct().collect(Collectors.joining(","));
            this.getModel().setValue("pivotdimval", (Object)dimValueStr);
            String selectIndexStr = anObjPivotConfigs.stream().map(AnObjPivotBo::getPivotIndex).distinct().collect(Collectors.joining(","));
            this.getModel().setValue("pivotindex", (Object)selectIndexStr);
        }
        if (isCopy) {
            this.anObjCopyProcessor.clearDataId(joinEntities, queryFields, entityRelations, calculateFields, sideBars, anObjPivotConfigs, groupFields);
        }
        this.getView().getPageCache().put("sideBar", SerializationUtils.toJsonString((Object)sideBars));
        this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString((Object)joinEntities));
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFields));
        this.getView().getPageCache().put("originQueryFields", SerializationUtils.toJsonString((Object)queryFields));
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelations));
        this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFields));
        this.getView().getPageCache().put("cache_group_fields", JSON.toJSONString((Object)groupFields));
        this.getView().getPageCache().put("anObjPivotConfig", SerializationUtils.toJsonString((Object)anObjPivotConfigs));
        String sideBarStr = SerializationUtils.toJsonString((Object)sideBars);
        this.getView().getPageCache().put("sideBar", sideBarStr);
        this.getView().getPageCache().put("originSideBar", sideBarStr);
        this.getView().getPageCache().put("anObjRefByReport", String.valueOf(anObjService.isAnObjRefByReport(id)));
        this.getView().getPageCache().put("originName", ((ILocaleString)this.getModel().getValue("name")).getLocaleValue());
        this.getModel().setDataChanged(false);
    }

    public void initDataFilter() {
        String queryFields = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFields)) {
            return;
        }
        List queryFieldBos = JSON.parseArray((String)queryFields, QueryFieldCommonBo.class);
        List inputMap = AnobjFilterUtil.getParamList((List)queryFieldBos);
        if (inputMap.isEmpty()) {
            return;
        }
        String value = (String)this.getModel().getValue("datafilter");
        HashMap data = Maps.newHashMapWithExpectedSize((int)4);
        data.put("param", inputMap);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            value = RuleUtil.getNewestConditionValue((String)value);
            data.put("value", value);
            this.getPlugin().getHRFilter().setValue(value);
            data.put("onlyUpdateWeb", "true");
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && ((Boolean)this.getModel().getValue("issyspreset")).booleanValue()) {
            data.put("pageState", OperationStatus.VIEW.toString());
        } else {
            data.put("pageState", this.getView().getFormShowParameter().getStatus().toString());
        }
        this.getPlugin().getHRFilter().updateControlData((Map)data);
    }

    public void initCustomControl() {
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List calculateFields = Collections.emptyList();
        List entityAllFields = Lists.newArrayListWithCapacity((int)10);
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        String calFieldsStr = this.getView().getPageCache().get("calculateFields");
        ArrayList selectedFieldKeys = Lists.newArrayListWithCapacity((int)10);
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase() || this.anObjCopyProcessor.isCopyAnObj()) {
            Set refByReportFieldAliasList = AnalyseObjectService.getInstance().getRefByReportFieldAliasCollection((Long)this.getModel().getValue("id"));
            if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
                joinEntities = JSON.parseArray((String)joinEntitiesStr, JoinEntityBo.class);
            }
            if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
                queryFields = JSON.parseArray((String)queryFieldsStr, QueryFieldBo.class);
                queryFields.stream().filter(queryField -> queryField.isVirtualEntityField() || !queryField.getFieldAlias().endsWith(".id")).forEach(queryField -> selectedFieldKeys.add(queryField.getFieldAlias()));
            }
            if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
                entityRelations = JSON.parseArray((String)entityRelationsStr, EntityRelationBo.class);
            }
            if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
                calculateFields = JSON.parseArray((String)calFieldsStr, CalculateFieldBo.class);
                calculateFields.stream().filter(CalculateFieldBo::getSelected).forEach(field -> {
                    if (refByReportFieldAliasList.contains(field.getFieldNumber())) {
                        field.setDisabled(Boolean.TRUE);
                    }
                    selectedFieldKeys.add(field.getFieldNumber());
                });
            }
            String objType = (String)this.getModel().getValue("objecttype");
            if (AnalyseObjectService.getInstance().isVirtualEntityAnObj(objType)) {
                FieldTreeNode entityAllField = VirtualEntityService.getInstance().buildVirtualEntityFields((JoinEntityBo)joinEntities.get(0), queryFields, refByReportFieldAliasList);
                entityAllFields.add(entityAllField);
            } else {
                FieldDefineService service = new FieldDefineService();
                service.setSetComplexType(false);
                List queryFieldCommonBos = ReportComplexObjTransferUtil.transferQueryFieldBos((List)queryFields);
                queryFieldCommonBos = queryFieldCommonBos.stream().filter(queryField -> !queryField.getFieldPath().endsWith(".id")).collect(Collectors.toList());
                entityAllFields = service.getEntityAllFields(ReportComplexObjTransferUtil.transferJoinEntityBos((List)joinEntities), queryFieldCommonBos, refByReportFieldAliasList);
            }
            this.setAllFieldsToCache(entityAllFields);
        }
        FieldDefineService fieldDefineService = new FieldDefineService();
        List dataSourceCloudBos = null;
        List virtualEntitiesDataSource = null;
        if (joinEntities.size() == 1 && ((JoinEntityBo)joinEntities.get(0)).getVirtualEntity()) {
            virtualEntitiesDataSource = VirtualEntityService.getInstance().getVirtualEntitiesDataSource();
        } else {
            dataSourceCloudBos = fieldDefineService.getDataSourceTree();
        }
        Map<String, Object> dataMap = this.assembleData(dataSourceCloudBos, virtualEntitiesDataSource, joinEntities, entityRelations, entityAllFields, calculateFields, selectedFieldKeys);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(dataMap);
        this.getView().getPageCache().put("initCompleted", "1");
    }

    private Map<String, Object> assembleData(List<DataSourceCloudBo> clouds, List<DataSourceAppBo> virtualEntitiesDataSource, List<JoinEntityBo> joinEntities, List<EntityRelationBo> entityRelations, List<FieldTreeNode> entityAllFields, List<CalculateFieldBo> calculateFields, List<String> selectedFieldKeys) {
        for (JoinEntityBo joinEntity : joinEntities) {
            if (!HRStringUtils.equals((String)joinEntity.getType(), (String)"sub")) continue;
            entityRelations.stream().filter(relation -> HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny().ifPresent(arg_0 -> ((JoinEntityBo)joinEntity).setEntityRelation(arg_0));
        }
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String statusParam = status.toString();
        if (status == OperationStatus.EDIT && ((Boolean)this.getModel().getValue("issyspreset")).booleanValue()) {
            statusParam = OperationStatus.VIEW.toString();
        }
        this.getView().getPageCache().put("pageStatus", statusParam);
        dataMap.put("status", statusParam);
        dataMap.put("entityNodes", joinEntities);
        if (virtualEntitiesDataSource == null) {
            dataMap.put("clouds", clouds);
        } else {
            dataMap.put("clouds", virtualEntitiesDataSource);
        }
        if (HRStringUtils.equals((String)statusParam, (String)OperationStatus.VIEW.toString())) {
            entityAllFields.forEach(this::disableFieldTreeNode);
            calculateFields.forEach(field -> field.setDisabled(Boolean.TRUE));
        }
        dataMap.put("fieldTreeNode", entityAllFields);
        dataMap.put("calFields", calculateFields);
        List<String> refFieldAliasList = this.getAllRefFieldAliasByCalField(calculateFields);
        dataMap.put("refFieldAliasList", refFieldAliasList);
        List<String> dataFilterRefFieldAlias = this.getDataFilterRefFieldAlias();
        List<String> pivotRefFieldAlias = this.getPivotRefFieldAlias();
        List<String> groupFieldRefFieldAlias = this.getGroupFieldRefFieldAlias();
        List<String> preIndexRefFieldAlias = this.getPreIndexRefFieldAlias();
        Set<String> permRuleRefFieldAlias = this.getPermRuleRefFieldAlias();
        dataFilterRefFieldAlias.addAll(pivotRefFieldAlias);
        dataFilterRefFieldAlias.addAll(groupFieldRefFieldAlias);
        dataMap.put("filterFieldAliasList", dataFilterRefFieldAlias);
        dataMap.put("preIndexRefFieldAlias", preIndexRefFieldAlias);
        dataMap.put("permRuleRefFieldAlias", permRuleRefFieldAlias);
        dataMap.put("selectedFieldKeys", selectedFieldKeys);
        dataMap.put("method", "init");
        dataMap.put("isReport", Boolean.TRUE);
        boolean isVirtual = joinEntities.size() == 1 && joinEntities.get(0).getVirtualEntity();
        FieldDefineService fieldDefineService = new FieldDefineService();
        if (isVirtual) {
            dataMap.put("entities", fieldDefineService.getAllEntitiesForVirtual(virtualEntitiesDataSource));
        } else {
            dataMap.put("entities", fieldDefineService.getAllEntities(clouds));
        }
        String dataSource = "business";
        if (isVirtual) {
            dataSource = "virtual";
        }
        dataMap.put("dataSource", dataSource);
        return dataMap;
    }

    private void disableFieldTreeNode(FieldTreeNode node) {
        node.setDisabled(Boolean.TRUE);
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.disableFieldTreeNode(child);
            }
        }
    }
}

