/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.calfield;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.function.ReportFunctionSubPagePlugin;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.calfield.CollectCalculateFunctionService;
import kd.hr.hrptmc.common.constant.calfield.CalculateFieldConstants;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.calfield.PreIndexBo;
import kd.hr.hrptmc.common.util.ReportCommonUtils;

public class CalculateFieldPlugin
extends ReportFunctionSubPagePlugin
implements CalculateFieldConstants {
    private final Random rand = new SecureRandom();
    private static final Pattern NUMBER_START_PATTERN = Pattern.compile("^[0-9]");
    private static final String FUNCTION_FLEX = "functionflex";
    private static final Log LOGGER = LogFactory.getLog(CalculateFieldPlugin.class);

    public void afterCreateNewData(EventObject eventObject) {
        String currentCalFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("currentCalField");
        String allCalFieldsStr = (String)this.getView().getFormShowParameter().getCustomParam("calculateFields");
        String expr = "";
        if (HRStringUtils.isNotEmpty((String)currentCalFieldStr)) {
            CalculateFieldBo currentCalField = (CalculateFieldBo)SerializationUtils.fromJsonString((String)currentCalFieldStr, CalculateFieldBo.class);
            this.getModel().setValue("name", (Object)currentCalField.getFieldName());
            this.getModel().setValue("number", (Object)currentCalField.getFieldNumber());
            this.getModel().setValue("type", (Object)currentCalField.getValueType());
            expr = currentCalField.getViewExpr();
            if (HRStringUtils.isEmpty((String)expr)) {
                expr = currentCalField.getExpr();
            }
            this.getModel().setValue("expr", (Object)expr);
            if (HRStringUtils.isNotEmpty((String)allCalFieldsStr)) {
                List allCalFields = JSON.parseArray((String)allCalFieldsStr, CalculateFieldBo.class);
                allCalFields.removeIf(field -> HRStringUtils.equals((String)currentCalField.getFieldNumber(), (String)field.getFieldNumber()));
                allCalFieldsStr = SerializationUtils.toJsonString((Object)allCalFields);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        this.getPageCache().put("calculateFields", allCalFieldsStr);
        List<Map<String, Object>> fields = this.getAllSelectedFields(false);
        this.queryEnumsItemsToCache();
        this.initFuncPageView(FUNCTION_FLEX, fields, ReportFunctionExecuteService.class.getName(), expr);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        HashMap map = new HashMap(1);
        HashMap<String, String> item = new HashMap<String, String>(1);
        map.put("item", item);
        if (ReportCommonUtils.validateNumberByISVIsKD()) {
            item.put("emptytip", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5f00\u5934\uff0c\u652f\u6301\u82f1\u6587\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"CalculateFieldPlugin_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "kdhr_"));
        } else {
            item.put("emptytip", ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u82f1\u6587\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"CalculateFieldPlugin_12", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        this.getView().updateControlMetadata("number", map);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        if (this.isReport()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"type"});
        }
        this.getModel().setDataChanged(false);
    }

    private void queryEnumsItemsToCache() {
        String anObjId = (String)this.getView().getFormShowParameter().getCustomParam("anobj");
        if (HRStringUtils.isEmpty((String)anObjId)) {
            return;
        }
        List<Map<String, Object>> queryFields = this.getQueryFields(false);
        DynamicObject anObjDy = AnalyseObjectService.getInstance().getAnObjDy(Long.valueOf(anObjId));
        if (HRStringUtils.equals((String)"filesource", (String)anObjDy.getString("objecttype"))) {
            AnObjEnumFieldHandler anObjEnumFieldHandler = new AnObjEnumFieldHandler(anObjDy, new MainEntityTypeUtil());
            HashMap enumItemMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map<String, Object> field : queryFields) {
                String fieldAlias = (String)field.get("fieldNumber");
                List enumItems = anObjEnumFieldHandler.getEnumItemsForFileSource(fieldAlias);
                if (enumItems == null) continue;
                enumItemMap.put(fieldAlias, enumItems.stream().map(AnObjEnumFieldHandler.AnObjEnumItem::getValue).collect(Collectors.toList()));
            }
            this.getPageCache().put("enumItemMap", SerializationUtils.toJsonString((Object)enumItemMap));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"ok") && this.validateNumberAndName(args)) {
            boolean isReport = this.isReport();
            StringBuilder errorMsg = new StringBuilder();
            Map exprMap = this.parseFunctionExpr(errorMsg);
            if (exprMap == null) {
                this.getView().showTipNotification(errorMsg.toString());
                args.setCancel(true);
            } else {
                ArrayList<String> refFieldNums;
                Map<String, Object> defaultValMap;
                Object executeResult;
                String expr = (String)exprMap.get("expr");
                if (HRStringUtils.isEmpty((String)expr) || HRStringUtils.isBlank((CharSequence)expr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalculateFieldPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                CollectCalculateFunctionService collectCalculateFunctionService = new CollectCalculateFunctionService((String)this.getModel().getValue("number"), isReport);
                ArrayList newGenCalculateFields = Lists.newArrayListWithCapacity((int)10);
                errorMsg = new StringBuilder();
                CalculateFieldBo currentCalField = this.getCurrentCalField();
                String calculateStr = this.getPageCache().get("calculateFields");
                List<Object> calculateFieldBos = Lists.newArrayListWithCapacity((int)10);
                if (HRStringUtils.isNotEmpty((String)calculateStr)) {
                    calculateFieldBos = JSON.parseArray((String)calculateStr, CalculateFieldBo.class);
                }
                if (currentCalField != null) {
                    collectCalculateFunctionService.clearCollectCalculateFunc(currentCalField, (List)calculateFieldBos);
                }
                if (!collectCalculateFunctionService.handleCollectCalculateFunc(exprMap, (List)newGenCalculateFields, errorMsg)) {
                    this.getView().showTipNotification(errorMsg.toString());
                    args.setCancel(true);
                    return;
                }
                Map aggregationMap = collectCalculateFunctionService.getAggregationMap();
                calculateFieldBos.addAll(newGenCalculateFields);
                String execExpr = (String)exprMap.get("runExpr");
                if (!newGenCalculateFields.isEmpty()) {
                    execExpr = (String)exprMap.get("viewExpr");
                }
                if ((executeResult = this.preExecuteExpr(execExpr, defaultValMap = this.getDefaultValMap(refFieldNums = new ArrayList<String>((Set)exprMap.get("refFieldNums"))), errorMsg)) == null && errorMsg.length() > 0) {
                    this.getView().showTipNotification(errorMsg.toString());
                    args.setCancel(true);
                    return;
                }
                if (!this.validateExpr(args, executeResult)) {
                    return;
                }
                currentCalField = this.setCurrentCalculateField(currentCalField, calculateFieldBos, newGenCalculateFields, exprMap);
                this.handleCalculateRefFieldAndOrder(args, currentCalField, calculateFieldBos, newGenCalculateFields, refFieldNums);
                currentCalField.setAggregationMap(aggregationMap);
                if (currentCalField.getRefCalculateFields().stream().anyMatch(refCalField -> HRStringUtils.equals((String)refCalField.getCalMethod(), (String)"summary"))) {
                    currentCalField.setCalMethod("summary");
                } else if (newGenCalculateFields.isEmpty()) {
                    currentCalField.setCalMethod("normal");
                }
                if (isReport) {
                    calculateFieldBos.removeIf(field -> HRStringUtils.equals((String)field.getSource(), (String)"anobj"));
                }
                calculateFieldBos = calculateFieldBos.stream().sorted(Comparator.comparingInt(CalculateFieldBo::getIndex)).collect(Collectors.toList());
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)calculateFieldBos));
                this.closeConfirmStatus = true;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleCalculateRefFieldAndOrder(BeforeDoOperationEventArgs args, CalculateFieldBo currentCalField, List<CalculateFieldBo> calculateFieldBos, List<CalculateFieldBo> newGenCalculateFields, List<String> refFieldNums) {
        String preIndexStr = (String)this.getView().getFormShowParameter().getCustomParam("preIndexes");
        List preIndexBos = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)preIndexStr)) {
            preIndexBos = JSON.parseArray((String)preIndexStr, PreIndexBo.class);
        }
        for (CalculateFieldBo newGenCalculateField : newGenCalculateFields) {
            this.parseCalFieldRef(newGenCalculateField.getExpr(), newGenCalculateField, calculateFieldBos, preIndexBos, refFieldNums);
        }
        this.parseCalFieldRef(currentCalField.getExpr(), currentCalField, calculateFieldBos, preIndexBos, refFieldNums);
        ArrayList refLinks = Lists.newArrayListWithCapacity((int)10);
        refLinks.add(currentCalField.getFieldName().getLocaleValue());
        ArrayList rings = Lists.newArrayListWithCapacity((int)10);
        calculateFieldBos.add(currentCalField);
        this.addCalFieldOrder(refLinks, currentCalField, calculateFieldBos, rings);
        this.handleRefPreIndexOrder(calculateFieldBos);
        if (rings.size() > 0) {
            StringBuilder ringSb = new StringBuilder();
            for (List ring : rings) {
                ringSb.append(ring).append(",");
            }
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5b58\u5728\u5faa\u73af\u8ba1\u7b97\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CalculateFieldPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), ringSb.substring(0, ringSb.length() - 1));
            this.getView().showTipNotification(msg);
            args.setCancel(true);
            return;
        }
        Optional<Integer> minOrder = calculateFieldBos.stream().map(CalculateFieldBo::getOrder).min(Comparator.naturalOrder());
        if (minOrder.isPresent() && minOrder.get() > 0) {
            calculateFieldBos.forEach(field -> field.setOrder(Integer.valueOf(field.getOrder() - (Integer)minOrder.get())));
        }
    }

    private CalculateFieldBo setCurrentCalculateField(CalculateFieldBo currentCalField, List<CalculateFieldBo> calculateFieldBos, List<CalculateFieldBo> newGenCalculateFields, Map<String, Object> exprMap) {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        String valueType = (String)this.getModel().getValue("type");
        if (currentCalField == null) {
            currentCalField = new CalculateFieldBo(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name), number);
            currentCalField.setSelected(Boolean.valueOf(true));
            Optional<Integer> maxIndex = calculateFieldBos.stream().map(CalculateFieldBo::getIndex).max(Comparator.naturalOrder());
            if (maxIndex.isPresent()) {
                currentCalField.setIndex(Integer.valueOf(maxIndex.get() + 1));
            } else {
                currentCalField.setIndex(Integer.valueOf(0));
            }
            if (this.isReport()) {
                currentCalField.setSource("report");
            } else {
                currentCalField.setSource("anobj");
            }
        } else {
            this.modifyRefNumbers(currentCalField.getFieldNumber(), calculateFieldBos);
            currentCalField.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name));
            currentCalField.setFieldNumber(number);
            currentCalField.setTitle(currentCalField.getFieldName().getLocaleValue() + " | " + currentCalField.getFieldNumber());
        }
        if (newGenCalculateFields.size() > 0) {
            currentCalField.setCalMethod("summary");
        }
        String runExpr = (String)exprMap.get("runExpr");
        String viewExpr = (String)exprMap.get("viewExpr");
        boolean isUseFunc = (Boolean)exprMap.get("isUseFunc");
        currentCalField.setValueType(valueType);
        currentCalField.setExpr(runExpr);
        currentCalField.setViewExpr(viewExpr);
        if (isUseFunc) {
            currentCalField.setType("complex");
        } else {
            currentCalField.setType("simple");
        }
        String controlType = CalculateFieldService.getInstance().getControlTypeByValueType(valueType);
        currentCalField.setControlType(controlType);
        return currentCalField;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateExpr(BeforeDoOperationEventArgs args, Object executeResult) {
        if (!(!this.isReport() || executeResult instanceof Integer || executeResult instanceof Long || executeResult instanceof Float || executeResult instanceof Double || executeResult instanceof BigDecimal)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u521b\u5efa\u6307\u6807\u7c7b\u578b\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CalculateFieldPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (!this.isReport()) {
            boolean sameNumberType;
            String type = (String)this.getModel().getValue("type");
            String executeResultType = this.getExecuteResultType(executeResult);
            boolean bl = sameNumberType = this.isNumberType(type) && this.isNumberType(executeResultType);
            if (!HRStringUtils.equals((String)type, (String)executeResultType) && !sameNumberType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u7ed3\u679c\u7c7b\u578b\u4e0e\u5df2\u9009\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CalculateFieldPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
        } else {
            String executeResultType = this.getExecuteResultType(executeResult);
            this.getModel().setValue("type", (Object)executeResultType);
        }
        return true;
    }

    private boolean isNumberType(String type) {
        return HRStringUtils.equals((String)type, (String)DataTypeEnum.INTEGER.getDataTypeKey()) || HRStringUtils.equals((String)type, (String)DataTypeEnum.LONG.getDataTypeKey()) || HRStringUtils.equals((String)type, (String)DataTypeEnum.BIGDECIMAL.getDataTypeKey());
    }

    @ExcludeFromJacocoGeneratedReport
    private String getExecuteResultType(Object executeResult) {
        String type = null;
        if (executeResult instanceof Integer) {
            type = DataTypeEnum.INTEGER.getDataTypeKey();
        } else if (executeResult instanceof Long) {
            type = DataTypeEnum.LONG.getDataTypeKey();
        } else if (executeResult instanceof Double || executeResult instanceof Float || executeResult instanceof BigDecimal) {
            type = DataTypeEnum.BIGDECIMAL.getDataTypeKey();
        } else if (executeResult instanceof CharSequence) {
            type = DataTypeEnum.STRING.getDataTypeKey();
        } else if (executeResult instanceof Boolean) {
            type = DataTypeEnum.BOOLEAN.getDataTypeKey();
        } else if (executeResult instanceof Date) {
            type = DataTypeEnum.DATETIME.getDataTypeKey();
        }
        return type;
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateNumberAndName(BeforeDoOperationEventArgs args) {
        String name = ((ILocaleString)this.getModel().getValue("name")).getLocaleValue();
        String number = (String)this.getModel().getValue("number");
        List<Map<String, Object>> fields = this.getAllSelectedFields(true);
        if (ReportCommonUtils.validateNumberByISVIsKD()) {
            if (!number.startsWith("kdhr_") || !ReportCommonUtils.validateNumber((String)number)) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199\u3002", (String)"CalculateFieldPlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "kdhr_"));
                args.setCancel(true);
                return false;
            }
        } else if (number.startsWith("kdhr_") || !ReportCommonUtils.validateNumber((String)number)) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u7981\u6b62\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199\u3002", (String)"CalculateFieldPlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), "kdhr_"));
            args.setCancel(true);
            return false;
        }
        for (Map<String, Object> field : fields) {
            boolean numberRepeat;
            String fieldName = this.getFieldNameStr(field.get("fieldName"));
            String fieldNumber = (String)field.get("fieldNumber");
            boolean nameRepeat = fieldName != null && HRStringUtils.equals((String)name, (String)fieldName);
            boolean bl = numberRepeat = fieldNumber != null && HRStringUtils.equals((String)number.toLowerCase(), (String)fieldNumber.toLowerCase());
            if (nameRepeat && numberRepeat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CalculateFieldPlugin_14", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            if (nameRepeat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CalculateFieldPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            if (!numberRepeat) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CalculateFieldPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (NUMBER_START_PATTERN.matcher(number).find()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7f16\u7801\uff0c\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u3002", (String)"CalculateFieldPlugin_16", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> getQueryFields(boolean forValidateNumberAndName) {
        String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam("fields");
        List<Object> fields = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)fieldStr)) {
            fields = (List)SerializationUtils.fromJsonString((String)fieldStr, List.class);
            if (!this.isReport() && !forValidateNumberAndName) {
                fields = fields.stream().filter(field -> field.get("isSelected") != null && (Boolean)field.get("isSelected") != false).collect(Collectors.toList());
            }
        }
        return fields;
    }

    private List<Map<String, Object>> getCalculateFields() {
        String calculateStr = this.getPageCache().get("calculateFields");
        List<Object> calculateFields = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)calculateStr)) {
            calculateFields = (List)SerializationUtils.fromJsonString((String)calculateStr, List.class);
            calculateFields = this.isReport() ? calculateFields.stream().filter(calField -> {
                List refPreIndexes = (List)calField.get("refPreIndexes");
                return refPreIndexes == null || refPreIndexes.isEmpty();
            }).collect(Collectors.toList()) : calculateFields.stream().filter(calField -> (Boolean)calField.get("selected")).collect(Collectors.toList());
        }
        return calculateFields;
    }

    private List<Map<String, Object>> getPresetIndexes() {
        String preIndexStr;
        List preIndexes = Lists.newArrayListWithCapacity((int)10);
        if (this.isReport() && HRStringUtils.isNotEmpty((String)(preIndexStr = (String)this.getView().getFormShowParameter().getCustomParam("preIndexes")))) {
            preIndexes = (List)SerializationUtils.fromJsonString((String)preIndexStr, List.class);
        }
        return preIndexes;
    }

    private List<Map<String, Object>> getAllSelectedFields(boolean forValidateNumberAndName) {
        List hideFields;
        String reportCalFieldStr;
        List<Map<String, Object>> fields = this.getQueryFields(forValidateNumberAndName);
        fields.addAll(this.getCalculateFields());
        fields.addAll(this.getPresetIndexes());
        if (forValidateNumberAndName && HRStringUtils.isNotEmpty((String)(reportCalFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("reportCalFields")))) {
            List reportCalFields = (List)SerializationUtils.fromJsonString((String)reportCalFieldStr, List.class);
            fields.addAll(reportCalFields);
        }
        if ((hideFields = (List)this.getView().getFormShowParameter().getCustomParam("hideFields")) != null) {
            for (Map<String, Object> field : fields) {
                String fieldNum = (String)field.get("fieldNumber");
                if (!hideFields.contains(fieldNum)) continue;
                field.put("hide", "true");
            }
        }
        return fields;
    }

    private String getFieldNameStr(Object fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (fieldName instanceof JSONObject) {
            String language = RequestContext.get().getLang().name();
            return ((JSONObject)fieldName).getString(language);
        }
        if (fieldName instanceof Map) {
            String language = RequestContext.get().getLang().name();
            return (String)((Map)fieldName).get(language);
        }
        return (String)fieldName;
    }

    @ExcludeFromJacocoGeneratedReport
    private void modifyRefNumbers(String oldNumber, List<CalculateFieldBo> calculateFieldBos) {
        String newNumber = (String)this.getModel().getValue("number");
        if (HRStringUtils.equals((String)oldNumber, (String)newNumber)) {
            return;
        }
        for (CalculateFieldBo calculateFieldBo : calculateFieldBos) {
            List refCalculateFields = calculateFieldBo.getRefCalculateFields();
            for (CalculateFieldBo refCalculateField : refCalculateFields) {
                if (!HRStringUtils.equals((String)refCalculateField.getFieldNumber(), (String)oldNumber)) continue;
                refCalculateField.setFieldNumber(newNumber);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Object> getDefaultValMap(List<String> refFieldNums) {
        if (refFieldNums == null || refFieldNums.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap defaultValMap = Maps.newHashMapWithExpectedSize((int)16);
        String fieldMapStr = this.getPageCache().get("fieldMapKey");
        Map fieldMap = (Map)SerializationUtils.fromJsonString((String)fieldMapStr, Map.class);
        for (String refFieldNum : refFieldNums) {
            boolean isBaseData;
            if (refFieldNum.endsWith(".id")) continue;
            Map field = (Map)fieldMap.get(refFieldNum);
            String type = (String)field.get("valueType");
            String baseDataNum = (String)field.get("baseDataNum");
            DataTypeEnum typeEnum = DataTypeEnum.of((String)type);
            boolean bl = isBaseData = HRStringUtils.isNotEmpty((String)baseDataNum) && (refFieldNum.endsWith(".name") || refFieldNum.endsWith(".number"));
            if (isBaseData) {
                String idType = this.getBaseDataIdType(baseDataNum);
                DataTypeEnum idTypeEnum = DataTypeEnum.of((String)idType);
                String idNum = refFieldNum.substring(0, refFieldNum.lastIndexOf(".") + 1) + "id";
                if (idTypeEnum == DataTypeEnum.STRING) {
                    defaultValMap.put(idNum, "testID");
                } else {
                    defaultValMap.put(idNum, this.rand.nextLong());
                }
            }
            switch (typeEnum) {
                case STRING: 
                case LOCALESTRING: {
                    defaultValMap.put(refFieldNum, "2023-02-03");
                    break;
                }
                case DATETIME: {
                    defaultValMap.put(refFieldNum, new Date());
                    break;
                }
                case INTEGER: {
                    defaultValMap.put(refFieldNum, this.rand.nextInt());
                    break;
                }
                case LONG: {
                    defaultValMap.put(refFieldNum, this.rand.nextLong());
                    break;
                }
                case BIGDECIMAL: {
                    defaultValMap.put(refFieldNum, this.rand.nextDouble());
                    break;
                }
                case BOOLEAN: {
                    defaultValMap.put(refFieldNum, "1");
                    break;
                }
            }
        }
        return defaultValMap;
    }

    private String getBaseDataIdType(String baseDataNum) {
        Class propertyType = EntityMetadataCache.getDataEntityType((String)baseDataNum).getPrimaryKey().getPropertyType();
        if (propertyType == Long.TYPE || propertyType == Long.class) {
            return "long";
        }
        return "string";
    }

    @ExcludeFromJacocoGeneratedReport
    private void parseCalFieldRef(String parsedExpr, CalculateFieldBo currentCalField, List<CalculateFieldBo> calculateFieldBos, List<PreIndexBo> preIndexBos, List<String> refFieldNums) {
        if (calculateFieldBos.isEmpty() && preIndexBos.isEmpty() && refFieldNums.isEmpty()) {
            return;
        }
        Map<String, CalculateFieldBo> calFieldMap = calculateFieldBos.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, field -> field));
        Map<String, PreIndexBo> preIndexMap = preIndexBos.stream().collect(Collectors.toMap(PreIndexBo::getFieldNumber, field -> field));
        int currentOrder = 0;
        ArrayList refCalFields = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList refPreIndexes = Lists.newArrayListWithExpectedSize((int)16);
        char[] exprArr = parsedExpr.toCharArray();
        StringBuilder fieldSb = new StringBuilder();
        boolean isQuotation = false;
        boolean isReport = this.isReport();
        for (char chr : exprArr) {
            if (this.specialChar.contains(Character.valueOf(chr))) {
                if (chr == '\"') {
                    boolean bl = isQuotation = !isQuotation;
                }
                if (fieldSb.length() <= 0) continue;
                if (chr == '(' || isQuotation || numberPattern.matcher(fieldSb.toString()).matches()) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                if (!fieldSb.toString().startsWith("$") || !fieldSb.toString().endsWith("$")) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, preIndexMap, refCalFields, refPreIndexes, refFieldNums, isReport);
                fieldSb = new StringBuilder();
                continue;
            }
            fieldSb.append(chr);
        }
        if (fieldSb.length() > 0 && !numberPattern.matcher(fieldSb.toString()).matches() && fieldSb.toString().startsWith("$") && fieldSb.toString().endsWith("$")) {
            currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, preIndexMap, refCalFields, refPreIndexes, refFieldNums, isReport);
        }
        currentCalField.setRefEntityFields(refFieldNums);
        currentCalField.setRefCalculateFields((List)refCalFields);
        currentCalField.setRefPreIndexes((List)refPreIndexes);
        currentCalField.setOrder(Integer.valueOf(++currentOrder));
    }

    private void handleRefPreIndexOrder(List<CalculateFieldBo> calculateFieldBos) {
        if (!this.isReport()) {
            return;
        }
        List refPreIndexCalFields = calculateFieldBos.stream().filter(calField -> calField.getRefCalculateFields() != null && !calField.getRefCalculateFields().isEmpty()).collect(Collectors.toList());
        if (refPreIndexCalFields.isEmpty()) {
            return;
        }
        Integer minOrder = refPreIndexCalFields.stream().map(CalculateFieldBo::getOrder).min(Integer::compareTo).get();
        calculateFieldBos.stream().filter(calField -> calField.getRefCalculateFields() == null || calField.getRefCalculateFields().isEmpty()).max(Comparator.comparing(CalculateFieldBo::getOrder)).ifPresent(maxOrderCalFiled -> {
            Integer maxOrder = maxOrderCalFiled.getOrder();
            int offset = 1;
            if (maxOrder >= minOrder) {
                offset = maxOrder.equals(minOrder) ? 1 : maxOrder - minOrder;
                for (CalculateFieldBo refPreIndexCalField : refPreIndexCalFields) {
                    refPreIndexCalField.setOrder(Integer.valueOf(refPreIndexCalField.getOrder() + offset));
                }
            }
        });
    }

    @ExcludeFromJacocoGeneratedReport
    private int handleRefField(StringBuilder fieldSb, int currentOrder, Map<String, CalculateFieldBo> calFieldMap, Map<String, PreIndexBo> preIndexMap, List<CalculateFieldBo> refCalFields, List<PreIndexBo> refPreIndexes, List<String> refFieldNums, boolean isReport) {
        PreIndexBo preIndexBo;
        String newFieldNum = fieldSb.substring(1, fieldSb.length() - 1);
        CalculateFieldBo calField = calFieldMap.get(newFieldNum);
        if (calField != null) {
            refCalFields.add(calField);
            currentOrder = calField.getOrder() > currentOrder ? calField.getOrder() : currentOrder;
            refFieldNums.remove(newFieldNum);
        }
        if (isReport && (preIndexBo = preIndexMap.get(newFieldNum)) != null) {
            refPreIndexes.add(preIndexBo);
            refFieldNums.remove(newFieldNum);
        }
        return currentOrder;
    }

    @ExcludeFromJacocoGeneratedReport
    private void addCalFieldOrder(List<String> refLinks, CalculateFieldBo currentField, List<CalculateFieldBo> calculateFields, List<List<String>> rings) {
        for (CalculateFieldBo calField : calculateFields) {
            Optional<CalculateFieldBo> refFieldOp;
            List refCalculateFields = calField.getRefCalculateFields();
            if (refCalculateFields == null || refCalculateFields.isEmpty() || HRStringUtils.equals((String)currentField.getFieldNumber(), (String)calField.getFieldNumber()) || !(refFieldOp = refCalculateFields.stream().filter(field -> HRStringUtils.equals((String)field.getFieldNumber(), (String)currentField.getFieldNumber())).findAny()).isPresent()) continue;
            int order = calField.getOrder();
            if (order <= currentField.getOrder()) {
                calField.setOrder(Integer.valueOf(currentField.getOrder() + 1));
            }
            if (refLinks.stream().distinct().count() != (long)refLinks.size()) continue;
            refLinks.add(calField.getFieldName().getLocaleValue());
            if (refLinks.stream().distinct().count() != (long)refLinks.size()) {
                rings.add(refLinks);
                continue;
            }
            this.addCalFieldOrder(refLinks, calField, calculateFields, rings);
        }
    }

    private CalculateFieldBo getCurrentCalField() {
        String currentCalFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("currentCalField");
        if (HRStringUtils.isEmpty((String)currentCalFieldStr)) {
            return null;
        }
        return (CalculateFieldBo)SerializationUtils.fromJsonString((String)currentCalFieldStr, CalculateFieldBo.class);
    }

    private boolean isReport() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParams().get("isReport");
    }
}

