/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.export;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class HRExportProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CUSTPARAM_CONTEXT = "requestcontext";
    private static final String CUSTPARAM_ENTITYNAME = "entityname";
    private static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    private static final String CACHEKEY_HR_JOBFORMINFO = "export_jobforminfo";
    private static final String CACHEKEY_HR_TASKID = "export_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_EXPORT_ISFINISHED = "export_isfinished";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_BILLNAME = "listname";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETE = "complete";
    private static final String KEY_INITTIPS = "inittips";
    private static final String KEY_PROGRESSDATAS = "progressdatas";
    private static Log LOGGER = LogFactory.getLog(HRExportProgressFormPlugin.class);
    private boolean canClose = false;

    private boolean checkCustParams() {
        if (StringUtils.isBlank((CharSequence)this.getEntityNumber())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s\u3002", (String)"HRExportProgressFormPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), CUSTPARAM_ENTITYNUMBER));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s\u3002", (String)"HRExportProgressFormPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), CUSTPARAM_ENTITYNAME));
            return false;
        }
        return true;
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNUMBER);
    }

    private String getEntityName() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNAME);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_HR_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_HR_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_HR_TASKID);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_HR_TASKID, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_EXPORT_ISFINISHED);
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_EXPORT_ISFINISHED, String.valueOf(finished));
    }

    private JobFormInfo buildJobFormInfo() {
        if (!this.checkCustParams()) {
            return null;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa - %s", (String)"HRExportProgressFormPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), this.getEntityName()));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setTaskClassname((String)this.getView().getFormShowParameter().getCustomParam("taskClassName"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CUSTPARAM_CONTEXT, RequestContext.get());
        params.put(CUSTPARAM_ENTITYNUMBER, this.getEntityNumber());
        params.put(CUSTPARAM_ENTITYNAME, this.getEntityName());
        jobInfo.setParams(params);
        jobInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(false);
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        if (this.getView().getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", "background_actionid");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.hr.hrptmc.formplugin.web.export.ReportExportTaskClick");
        return jobFormInfo;
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_HR_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_HR_JOBFORMINFO, str);
        }
    }

    public void registerListener(EventObject eventObject) {
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Label title = (Label)this.getControl(KEY_BILLNAME);
        String text = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa%s\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"HRExportProgressFormPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), this.getEntityName());
        title.setText(text);
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.setPercent(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void onProgress(ProgressEvent evt) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, evt);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            evt.setProgress(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (this.isStart() && !this.isSuspending()) {
            if (!this.canClose && !this.isFinished() && StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"HRExportProgressFormPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("MULTISHEET_CLOSE_CONFIRMED", (IFormPlugin)this));
                this.stopBar();
                event.setCancel(true);
            }
        } else {
            event.setCancel(true);
        }
    }

    private boolean isSuspending() {
        String suspending = this.getPageCache().get(this.getCurrentAppCacheKey());
        return !StringUtils.isBlank((CharSequence)suspending) && Boolean.parseBoolean(suspending);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            bar.start();
        }
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                JobFormInfo jobFormInfo = this.getJobFormInfo();
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
            }
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_HR_JOBFORMINFO) ? (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_HR_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_HR_JOBFORMINFO);
        return StringUtils.isBlank((CharSequence)str) ? null : (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void showExportDetails(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        String totalCount = data.containsKey(KEY_TOTAL) ? String.valueOf(data.get(KEY_TOTAL)) : ResManager.loadKDString((String)"\u672a\u77e5", (String)"HRExportProgressFormPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        String completeCount = data.containsKey(KEY_COMPLETE) ? String.valueOf(data.get(KEY_COMPLETE)) : ResManager.loadKDString((String)"\u672a\u77e5", (String)"HRExportProgressFormPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(totalCount);
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText(completeCount);
        if (data.containsKey(KEY_TOTAL)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_INITTIPS});
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(KEY_PROGRESSDATAS, notHidden);
        }
    }

    private Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
        result.put("taskinfo", taskInfoStr);
        result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        return result;
    }

    private void complete(TaskInfo taskInfo, ProgressEvent progressEvent) {
        String url;
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        Map<String, Object> taskData = this.getTaskCustData(taskInfo);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            String errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"HRExportProgressFormPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            this.stopBar();
            return;
        }
        if (taskData.containsKey("fail")) {
            boolean fail = (Boolean)taskData.get("fail");
            String failmessage = (String)taskData.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                this.getView().showErrorNotification(failmessage);
                this.stopBar();
                return;
            }
        }
        if (!isFinished) {
            progressEvent.setProgress(99);
            this.showExportDetails(taskInfo);
            return;
        }
        this.getView().returnDataToParent(this.packageReturnResult(taskInfo));
        if (taskData.containsKey("downloadurl") && StringUtils.isNotBlank((CharSequence)(url = (String)taskData.get("downloadurl")))) {
            this.getView().download(url);
        }
        progressEvent.setProgress(100);
        this.stopBar();
        this.closeForm();
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
    }

    private Map<String, Object> getTaskCustData(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(controlKey)) {
            this.getCurrentAppCache().put(this.getCurrentAppCacheKey(), (Object)this.getCurrentAppCacheKey());
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HRExportProgressFormPlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.setStart(true);
            this.closeForm();
        } else if ("btnok".equals(controlKey)) {
            this.toBackground();
        }
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber()).getAppId());
    }

    private String getCurrentAppCacheKey() {
        String taskId = StringUtils.isNotBlank((CharSequence)this.getTaskId()) ? "_" + this.getTaskId() : "";
        return "EXPT_SUSPEND_" + this.getEntityNumber() + taskId;
    }
}

