/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.export;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleInfo;
import kd.hr.hrptmc.formplugin.web.export.ColumnCellMergeIndex;
import kd.hr.hrptmc.formplugin.web.export.HRMergeExcelCell;
import kd.hr.hrptmc.formplugin.web.export.IHRExporter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class HRGridExcelExporter
implements IHRExporter {
    private static final Log log = LogFactory.getLog(HRGridExcelExporter.class);
    private static final String CELLSTYLE_ALIGN_DEFAULT = "default";
    private static final Pattern digestPat = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
    private static final int MAX_ROW_INDEX = 0x100000;
    private static final String NEED_MERGE_SAME_CELL = "needmergesamecell";
    private String seqHeadName = ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"HRGridExcelExporter_21", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
    private final String levelTree = ResManager.loadKDString((String)"\u7ea7", (String)"HRGridExcelExporter_01", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
    private SXSSFWorkbook wb;
    private int loopTimes;
    private int size;
    private Integer summaryLevel;
    private boolean isTreeShow;
    private boolean showSeq;
    private ReportManageConfigInfo reportManageConfigInfo;
    private Map<String, String> allIndexField;
    private Map<String, Integer> digestLengthMap = Maps.newHashMapWithExpectedSize((int)16);
    private boolean isTotal;
    private int dataSeq = 1;
    private int headColIndex;
    private int cellIndex;
    private int colIndex;
    private int rowIndex;
    private List<SXSSFRow> headRows;
    private Map<String, String> keyCaptionMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, XSSFCellStyle> textStyles = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, ReportStyleInfo> cellStyleMap = Maps.newHashMapWithExpectedSize((int)16);
    private boolean mergeSameCell;
    private final List<ColumnCellMergeIndex> mergeCellIndexList = Lists.newArrayListWithExpectedSize((int)10);
    private boolean lastRowSubTotalMark = false;
    private SXSSFRow lastRow = null;

    public HRGridExcelExporter(SXSSFWorkbook wb) {
        this.wb = wb;
    }

    @Override
    public void initIndex(String sheetName) {
        this.colIndex = 0;
        this.rowIndex = 0;
        this.cellIndex = 0;
        this.headColIndex = 0;
        this.headRows = new ArrayList<SXSSFRow>();
        this.wb.createSheet(sheetName);
        this.mergeCellIndexList.clear();
        this.lastRowSubTotalMark = false;
        this.lastRow = null;
    }

    @Override
    public String export(ReportHeadInfo reportHeadInfo, List<ReportBodyRowInfo> data, String sheetName) throws IOException {
        if (data == null) {
            return null;
        }
        if (reportHeadInfo == null || CollectionUtils.isEmpty((Collection)reportHeadInfo.getHf())) {
            return null;
        }
        SXSSFSheet sheet = this.wb.getSheet(sheetName);
        if (this.getLoopTimes() == 0) {
            this.createTreeHeadColumn(this.wb, sheet, reportHeadInfo, 0);
        }
        this.rowIndex = this.headRows.size() + this.getSize();
        if (this.isTreeShow) {
            HashMap treeData = Maps.newHashMapWithExpectedSize((int)16);
            this.createTreeBodyColumn(this.wb, sheet, reportHeadInfo.getHf(), data, 0, treeData);
        } else {
            this.createBodyColumn(this.wb, sheet, reportHeadInfo.getHf(), data);
        }
        if (this.getLoopTimes() == 0) {
            this.adjustTreeColumnWidth(sheet, reportHeadInfo.getHf());
            this.mergeTableHead(sheet);
            this.renameTableHeadCells(sheet);
        }
        sheet.flushRows();
        return null;
    }

    private void createTreeHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, ReportHeadInfo reportHeadInfo, int rowIndex) {
        List hf = reportHeadInfo.getHf();
        if (CollectionUtils.isEmpty((Collection)hf)) {
            return;
        }
        this.cellStyleMap = reportHeadInfo._getStyleMap();
        this.createTreeHeadColumn(wb, sheet, hf, reportHeadInfo.getHs(), rowIndex);
    }

    private void createTreeHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<ReportHeadRowInfo> columns, ReportStyleInfo hs, int rowIndex) {
        for (ReportHeadRowInfo col : columns) {
            SXSSFCell cell;
            SXSSFRow row;
            if (rowIndex >= this.headRows.size()) {
                row = this.getRow(sheet, rowIndex);
                this.headRows.add(row);
            } else {
                row = this.headRows.get(rowIndex);
            }
            if (this.showSeq && this.colIndex == 0) {
                cell = row.createCell(this.colIndex);
                this.keyCaptionMap.put(this.seqHeadName, this.seqHeadName);
                cell.setCellValue((RichTextString)new XSSFRichTextString(this.seqHeadName));
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(this.getHeadColumnStyle(wb, hs, col.getAlign()));
                ++this.colIndex;
            }
            String fieldKey = col.getCodeAlias() + col.getName();
            if (col.getHasChildren()) {
                fieldKey = fieldKey + this.colIndex;
            }
            if (!this.isTreeShow || this.summaryLevel == null || this.summaryLevel <= 0 || this.summaryLevel <= this.colIndex) {
                this.setTempCell(sheet, rowIndex);
                cell = row.createCell(this.colIndex);
                this.keyCaptionMap.put(fieldKey, col.getName() == null ? "" : col.getName());
                cell.setCellValue((RichTextString)new XSSFRichTextString(fieldKey));
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(this.getHeadColumnStyle(wb, hs, col.getAlign()));
                if (this.isHasChildren(col)) {
                    List children = col.getChildren();
                    this.createTreeHeadColumn(wb, sheet, children, hs, rowIndex + 1);
                    continue;
                }
                int r = rowIndex;
                while (r < this.headRows.size() - 1) {
                    row = this.headRows.get(++r);
                    this.copyCell(sheet.getRow(r - 1).getCell(this.colIndex), row.createCell(this.colIndex));
                }
                ++this.colIndex;
                continue;
            }
            while (this.summaryLevel > this.colIndex) {
                fieldKey = this.colIndex + fieldKey;
                this.setTempCell(sheet, rowIndex);
                cell = row.createCell(this.colIndex);
                this.keyCaptionMap.put(fieldKey, col.getName() == null ? "" : this.colIndex + 1 + this.levelTree + col.getName());
                cell.setCellValue((RichTextString)new XSSFRichTextString(fieldKey));
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(this.getHeadColumnStyle(wb, hs, col.getAlign()));
                if (this.isHasChildren(col)) {
                    List children = col.getChildren();
                    this.createTreeHeadColumn(wb, sheet, children, hs, rowIndex + 1);
                    continue;
                }
                int r = rowIndex;
                while (r < this.headRows.size() - 1) {
                    row = this.headRows.get(++r);
                    this.copyCell(sheet.getRow(r - 1).getCell(this.colIndex), row.createCell(this.colIndex));
                }
                ++this.colIndex;
            }
        }
    }

    private boolean isHasChildren(ReportHeadRowInfo col) {
        return col.getHasChildren() && col.getChildren() != null && col.getChildren().size() > 0;
    }

    protected int createTreeBodyColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<ReportHeadRowInfo> cols, List<ReportBodyRowInfo> data, int cellIndexStart, Map<Integer, ReportBodyCellInfo> treeData) {
        SXSSFRow row = null;
        for (ReportBodyRowInfo rowData : data) {
            if (CollectionUtils.isEmpty((Collection)rowData.getR())) continue;
            row = this.getRow(sheet, this.rowIndex++);
            this.cellIndex = 0;
            Map<String, ReportBodyCellInfo> cellMap = this.getCellMap(rowData);
            this.setTreeRowData(wb, sheet, row, cellMap, cols, cellIndexStart, treeData);
        }
        return this.rowIndex;
    }

    protected void setTreeRowData(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow row, Map<String, ReportBodyCellInfo> cellMap, List<ReportHeadRowInfo> columns, int cellIndexStart, Map<Integer, ReportBodyCellInfo> treeData) {
        int n = this.cellIndex = this.summaryLevel != null ? this.summaryLevel + this.cellIndex : this.cellIndex;
        if (cellMap == null || cellMap.isEmpty()) {
            return;
        }
        ReportBodyCellInfo reportBodyCellInfo = cellMap.get("kingdeeSubtotalMark".toLowerCase(Locale.ROOT));
        ReportBodyCellInfo bodyCellInfo = reportBodyCellInfo == null ? new ReportBodyCellInfo() : reportBodyCellInfo;
        Boolean subTotalMark = Boolean.parseBoolean(bodyCellInfo.getV() != null ? bodyCellInfo.getV().toString() : "false") || this.isTotal;
        if (this.summaryLevel != null) {
            int j = 0;
            for (int i = 0; i <= this.summaryLevel; ++i) {
                SXSSFCell cell;
                if (this.showSeq && i == 0) {
                    cell = row.createCell(i);
                    this.setSeqCellValueAndStyle(wb, cell, subTotalMark);
                    ++this.cellIndex;
                    j = 1;
                }
                cell = row.createCell(i + j);
                ReportBodyCellInfo info = treeData.get(i);
                cell.setCellValue(info != null && StringUtils.isNotBlank((Object)info.getV()) ? info.getV().toString() : null);
                this.setCellStyle(cell, info, CELLSTYLE_ALIGN_DEFAULT, subTotalMark, null);
            }
        }
        this.setRowDataCol(wb, row, cellMap, columns, subTotalMark, cellIndexStart);
        ReportBodyCellInfo childrenBodyCellInfo = cellMap.get("children");
        ReportBodyCellInfo children = childrenBodyCellInfo == null ? new ReportBodyCellInfo() : childrenBodyCellInfo;
        Object childrenList = children.getV();
        if (childrenList instanceof List) {
            List childrenData = (List)childrenList;
            HashMap childrenTreeData = Maps.newHashMapWithExpectedSize((int)16);
            childrenTreeData.putAll(treeData);
            ReportBodyCellInfo parBodyCellInfo = cellMap.get(columns.get(0).getCodeAlias().toLowerCase(Locale.ROOT));
            ReportBodyCellInfo parentCellInfo = parBodyCellInfo == null ? new ReportBodyCellInfo() : parBodyCellInfo;
            childrenTreeData.put(cellIndexStart, parentCellInfo);
            this.createTreeBodyColumn(wb, sheet, columns, childrenData, ++cellIndexStart, childrenTreeData);
        }
    }

    protected void setRowDataCol(SXSSFWorkbook wb, SXSSFRow row, Map<String, ReportBodyCellInfo> cellMap, List<ReportHeadRowInfo> columns, Boolean subTotalMark, int cellIndexStart) {
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            SXSSFCell cell;
            ReportHeadRowInfo col = columns.get(i);
            if (this.isHasChildren(col)) {
                this.setRowData(wb, row, cellMap, col.getChildren(), subTotalMark);
                continue;
            }
            if (i == 0) {
                cell = row.getCell(cellIndexStart);
            } else {
                cell = row.createCell(this.cellIndex);
                ++this.cellIndex;
            }
            this.setCellValueAndStyle(wb, cell, col, cellMap, subTotalMark);
        }
    }

    protected int createBodyColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<ReportHeadRowInfo> cols, List<ReportBodyRowInfo> data) {
        boolean needMergeSameCell = this.needMergeSameCell();
        for (ReportBodyRowInfo rowData : data) {
            SXSSFRow row = this.getRow(sheet, this.rowIndex++);
            Map<String, ReportBodyCellInfo> cellMap = this.getCellMap(rowData);
            ReportBodyCellInfo reportBodyCellInfo = cellMap.get("kingdeeSubtotalMark".toLowerCase(Locale.ROOT));
            ReportBodyCellInfo bodyCellInfo = reportBodyCellInfo == null ? new ReportBodyCellInfo() : reportBodyCellInfo;
            Boolean subTotalMark = Boolean.parseBoolean(bodyCellInfo.getV() != null ? bodyCellInfo.getV().toString() : "false") || this.isTotal;
            this.cellIndex = 0;
            this.setRowData(wb, row, cellMap, cols, subTotalMark);
            if (needMergeSameCell && !this.isTotal) {
                this.mergeSameCell(sheet, row, this.lastRow, this.lastRowSubTotalMark);
            }
            this.lastRow = row;
            this.lastRowSubTotalMark = subTotalMark;
        }
        return this.rowIndex;
    }

    private void mergeSameCell(SXSSFSheet sheet, SXSSFRow row, SXSSFRow lastRow, boolean lastRowSubTotalMark) {
        int currentRowNum = row.getRowNum();
        if (lastRow != null) {
            int lastRowNum = lastRow.getRowNum();
            short lastRowEndCellNum = lastRow.getLastCellNum();
            short endCellNum = row.getLastCellNum();
            int endIndex = Math.min(endCellNum, lastRowEndCellNum);
            for (int columnIndex = 0; columnIndex < endIndex; ++columnIndex) {
                SXSSFCell lastRowCell = lastRow.getCell(columnIndex);
                SXSSFCell currentRowCell = row.getCell(columnIndex);
                CellType lastRowCellType = lastRowCell.getCellType();
                CellType currentRowCellType = currentRowCell.getCellType();
                if (columnIndex == this.mergeCellIndexList.size()) {
                    if (columnIndex == 0 && this.showSeq) {
                        this.mergeCellIndexList.add(new ColumnCellMergeIndex(lastRowNum, lastRowNum, columnIndex, true));
                    } else {
                        this.mergeCellIndexList.add(new ColumnCellMergeIndex(lastRowNum, lastRowNum, columnIndex, false));
                    }
                }
                ColumnCellMergeIndex columnCellMergeIndex = this.mergeCellIndexList.get(columnIndex);
                if (lastRowCellType != CellType.BLANK && lastRowCellType != CellType.STRING || currentRowCellType != CellType.BLANK && currentRowCellType != CellType.STRING) continue;
                if (columnIndex != 0) {
                    ColumnCellMergeIndex lastColumnIndex = this.mergeCellIndexList.get(columnIndex - 1);
                    if (lastColumnIndex.isSeqColumn() || lastColumnIndex.getStartMergeRowIndex() < currentRowNum) {
                        String lastRowCellValue = lastRowCell.getStringCellValue();
                        String rowCellValue = currentRowCell.getStringCellValue();
                        if (rowCellValue != null && rowCellValue.equals(lastRowCellValue)) {
                            columnCellMergeIndex.setEndMergeRowIndex(currentRowNum);
                            continue;
                        }
                        this.mergeCell(sheet, lastRowSubTotalMark, columnCellMergeIndex);
                        columnCellMergeIndex.setStartMergeRowIndex(currentRowNum);
                        columnCellMergeIndex.setEndMergeRowIndex(currentRowNum);
                        continue;
                    }
                    this.mergeCell(sheet, lastRowSubTotalMark, columnCellMergeIndex);
                    columnCellMergeIndex.setStartMergeRowIndex(currentRowNum);
                    columnCellMergeIndex.setEndMergeRowIndex(currentRowNum);
                    continue;
                }
                if (this.showSeq) continue;
                String lastRowCellValue = lastRowCell.getStringCellValue();
                String rowCellValue = currentRowCell.getStringCellValue();
                if (rowCellValue != null && rowCellValue.equals(lastRowCellValue)) {
                    columnCellMergeIndex.setEndMergeRowIndex(currentRowNum);
                    continue;
                }
                this.mergeCell(sheet, lastRowSubTotalMark, columnCellMergeIndex);
                columnCellMergeIndex.setStartMergeRowIndex(currentRowNum);
                columnCellMergeIndex.setEndMergeRowIndex(currentRowNum);
            }
        }
    }

    private void mergeCell(SXSSFSheet sheet, boolean lastRowSubTotalMark, ColumnCellMergeIndex columnCellMergeIndex) {
        if (!columnCellMergeIndex.isMergeOneCell()) {
            if (lastRowSubTotalMark) {
                columnCellMergeIndex.setEndMergeRowIndex(columnCellMergeIndex.getEndMergeRowIndex() - 1);
            }
            if (!columnCellMergeIndex.isMergeOneCell()) {
                SXSSFCell firstCell;
                CellStyle cellStyle;
                sheet.addMergedRegion(new CellRangeAddress(columnCellMergeIndex.getStartMergeRowIndex(), columnCellMergeIndex.getEndMergeRowIndex(), columnCellMergeIndex.getMergeColumnIndex(), columnCellMergeIndex.getMergeColumnIndex()));
                SXSSFRow mergeRow = sheet.getRow(columnCellMergeIndex.getStartMergeRowIndex());
                if (mergeRow != null && (cellStyle = (firstCell = mergeRow.getCell(columnCellMergeIndex.getMergeColumnIndex())).getCellStyle()) != null) {
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                }
            }
        }
    }

    protected void setRowData(SXSSFWorkbook wb, SXSSFRow row, Map<String, ReportBodyCellInfo> cellMap, List<ReportHeadRowInfo> columns, Boolean subTotalMark) {
        for (ReportHeadRowInfo column : columns) {
            SXSSFCell cell;
            ReportHeadRowInfo col = column;
            if (this.isHasChildren(col)) {
                this.setRowData(wb, row, cellMap, col.getChildren(), subTotalMark);
                continue;
            }
            if (this.showSeq && this.cellIndex == 0) {
                cell = row.createCell(this.cellIndex);
                this.setSeqCellValueAndStyle(wb, cell, subTotalMark);
                ++this.cellIndex;
            }
            cell = row.createCell(this.cellIndex);
            this.setCellValueAndStyle(wb, cell, col, cellMap, subTotalMark);
            ++this.cellIndex;
        }
    }

    protected void setSeqCellValueAndStyle(SXSSFWorkbook wb, SXSSFCell cell, Boolean subTotalMark) {
        if (cell == null) {
            return;
        }
        if (!subTotalMark.booleanValue()) {
            cell.setCellValue((double)this.dataSeq);
            ++this.dataSeq;
        }
        cell.setCellStyle(subTotalMark != false ? this.getSubTotalStyle(wb, CELLSTYLE_ALIGN_DEFAULT, null) : this.getTextStyle(wb, CELLSTYLE_ALIGN_DEFAULT, null));
    }

    protected void setCellValueAndStyle(SXSSFWorkbook wb, SXSSFCell cell, ReportHeadRowInfo col, Map<String, ReportBodyCellInfo> cellMap, Boolean subTotalMark) {
        ReportBodyCellInfo reportBodyCellInfo = cellMap.get(col.getCodeAlias().toLowerCase(Locale.ROOT));
        ReportBodyCellInfo bodyCellInfo = reportBodyCellInfo == null ? new ReportBodyCellInfo() : reportBodyCellInfo;
        Object value = bodyCellInfo.getV();
        if (cell == null) {
            return;
        }
        Integer digestLength = this.buildDataFormat(col, value);
        this.setCellStyle(cell, bodyCellInfo, col.getAlign(), subTotalMark, digestLength);
        if (null == digestLength) {
            cell.setCellValue(StringUtils.isBlank((Object)value) ? null : value.toString());
        } else {
            cell.getCellStyle().setDataFormat(wb.createDataFormat().getFormat(this.allIndexField.get(col.getCode())));
            double cellValue = Double.parseDouble(value.toString());
            cell.setCellValue(cellValue);
        }
    }

    @Override
    public void drawPic(String sheetName, String base64Image, int col, int width, int colEnd, int widthEnd) throws IOException {
        if (HRStringUtils.isEmpty((String)base64Image)) {
            return;
        }
        SXSSFSheet sheet = this.wb.getSheet(sheetName);
        this.drawPic(this.wb, sheet, base64Image, col, width, colEnd, widthEnd);
        sheet.flushRows();
    }

    private void drawPic(SXSSFWorkbook wb, SXSSFSheet sheet, String base64Image, int col, int width, int colEnd, int widthEnd) {
        SXSSFDrawing drawing = sheet.createDrawingPatriarch();
        byte[] imageBytes = Base64.getDecoder().decode(base64Image);
        ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, col, width, colEnd, widthEnd);
        drawing.createPicture(anchor, wb.addPicture(imageBytes, 5));
    }

    private Integer buildDataFormat(ReportHeadRowInfo col, Object value) {
        Integer digestLength = null;
        if (StringUtils.isBlank((Object)value) || "--".equalsIgnoreCase(value.toString().trim())) {
            return digestLength;
        }
        if (this.allIndexField.containsKey(col.getCode()) || this.allIndexField.containsKey(col.getCodeAlias())) {
            if (this.digestLengthMap.containsKey(col.getCode())) {
                return this.digestLengthMap.get(col.getCode());
            }
            if (!digestPat.matcher(value.toString()).find()) {
                this.digestLengthMap.put(col.getCode(), digestLength);
                return digestLength;
            }
            StringBuilder dateFormat = new StringBuilder("0");
            String[] num = value.toString().split("\\.");
            if (num.length == 2) {
                dateFormat.append(".");
                for (int i = 0; i < num[1].length(); ++i) {
                    dateFormat.append("0");
                }
                digestLength = num[1].length();
            } else {
                digestLength = 0;
            }
            dateFormat.append("_ ");
            this.allIndexField.put(col.getCode(), dateFormat.toString());
            this.digestLengthMap.put(col.getCode(), digestLength);
        }
        return digestLength;
    }

    private void setCellStyle(SXSSFCell cell, ReportBodyCellInfo bodyCellInfo, String align, Boolean subTotalMark, Integer digestLength) {
        if (bodyCellInfo != null && StringUtils.isNotBlank((CharSequence)bodyCellInfo.getS()) && this.cellStyleMap.containsKey(bodyCellInfo.getK() + "_" + bodyCellInfo.getS())) {
            cell.setCellStyle(subTotalMark != false ? this.getSubTotalStyle(this.wb, align, digestLength) : this.getCustomTextStyle(this.wb, this.cellStyleMap.get(bodyCellInfo.getK() + "_" + bodyCellInfo.getS()), align, digestLength));
        } else {
            cell.setCellStyle(subTotalMark != false ? this.getSubTotalStyle(this.wb, align, digestLength) : this.getTextStyle(this.wb, align, digestLength));
        }
    }

    private static void setCommonStyle(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }

    private CellStyle getCustomTextStyle(SXSSFWorkbook wb, ReportStyleInfo styleInfo, String align, Integer digestLength) {
        XSSFCellStyle cs;
        StringBuilder style = new StringBuilder("TEXT_");
        style.append(align);
        style.append(digestLength);
        if (styleInfo != null) {
            if (StringUtils.isNotBlank((CharSequence)styleInfo.getBg())) {
                style.append(styleInfo.getBg());
            }
            if (StringUtils.isNotBlank((CharSequence)styleInfo.getC())) {
                style.append(styleInfo.getC());
            }
            if (StringUtils.isNotBlank((CharSequence)styleInfo.getFs())) {
                style.append(styleInfo.getFs());
            }
            if (StringUtils.isNotBlank((CharSequence)styleInfo.getFw())) {
                style.append(styleInfo.getFw());
            }
        }
        if ((cs = this.textStyles.get(style.toString())) == null) {
            cs = (XSSFCellStyle)wb.createCellStyle();
            HRGridExcelExporter.setCommonStyle((CellStyle)cs);
            if (null == digestLength) {
                cs.setDataFormat(wb.createDataFormat().getFormat("@"));
            }
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setAlignment(this.getAlignment(align));
            this.setCustomStyle(styleInfo, cs);
            this.textStyles.put(style.toString(), cs);
        }
        return cs;
    }

    private CellStyle getSubTotalStyle(SXSSFWorkbook wb, String align, Integer digestLength) {
        String style;
        XSSFCellStyle cs;
        if (StringUtils.isBlank((CharSequence)align)) {
            align = CELLSTYLE_ALIGN_DEFAULT;
        }
        if ((cs = this.textStyles.get(style = "SUBTOTAL_" + align + digestLength)) == null) {
            cs = (XSSFCellStyle)wb.createCellStyle();
            HRGridExcelExporter.setCommonStyle((CellStyle)cs);
            cs.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (null == digestLength) {
                cs.setDataFormat(wb.createDataFormat().getFormat("@"));
            }
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    private CellStyle getTextStyle(SXSSFWorkbook wb, String align, Integer digestLength) {
        String style;
        XSSFCellStyle cs;
        if (StringUtils.isBlank((CharSequence)align)) {
            align = CELLSTYLE_ALIGN_DEFAULT;
        }
        if ((cs = this.textStyles.get(style = "TEXT_" + align + digestLength)) == null) {
            cs = (XSSFCellStyle)wb.createCellStyle();
            HRGridExcelExporter.setCommonStyle((CellStyle)cs);
            if (null == digestLength) {
                cs.setDataFormat(wb.createDataFormat().getFormat("@"));
            }
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment(String align) {
        if (StringUtils.isBlank((CharSequence)align)) {
            return HorizontalAlignment.LEFT;
        }
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private void setTempCell(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex);
        this.setTempCell(sheet, row, rowIndex, this.colIndex - 1);
        for (int i = 0; i < rowIndex; ++i) {
            SXSSFRow r = this.headRows.get(i);
            SXSSFCell cell = r.getCell(this.colIndex);
            if (cell != null) continue;
            this.copyCell(r.getCell(this.colIndex - 1), r.createCell(this.colIndex));
        }
    }

    private void setTempCell(SXSSFSheet sheet, SXSSFRow row, int rowIndex, int colIndex) {
        if (rowIndex == 0 || colIndex < 0) {
            return;
        }
        SXSSFCell cell = row.getCell(colIndex);
        if (cell == null && colIndex >= 0) {
            this.copyCell(sheet.getRow(rowIndex - 1).getCell(colIndex), row.createCell(colIndex));
            if (colIndex > 0) {
                this.setTempCell(sheet, row, rowIndex, colIndex - 1);
            }
        }
    }

    private void copyCell(SXSSFCell cell, SXSSFCell newCell) {
        newCell.setCellValue(cell.getStringCellValue());
        newCell.setCellType(cell.getCellType());
        newCell.setCellStyle(cell.getCellStyle());
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb, ReportStyleInfo hs, String align) {
        XSSFCellStyle headColumnStyle;
        StringBuilder style = new StringBuilder("HEAD_TEXT_");
        style.append(align);
        if (hs != null) {
            if (StringUtils.isNotBlank((CharSequence)hs.getBg())) {
                style.append(hs.getBg());
            }
            if (StringUtils.isNotBlank((CharSequence)hs.getC())) {
                style.append(hs.getC());
            }
            if (StringUtils.isNotBlank((CharSequence)hs.getFs())) {
                style.append(hs.getFs());
            }
            if (StringUtils.isNotBlank((CharSequence)hs.getFw())) {
                style.append(hs.getFw());
            }
        }
        if ((headColumnStyle = this.textStyles.get(style.toString())) == null) {
            headColumnStyle = (XSSFCellStyle)wb.createCellStyle();
            HRGridExcelExporter.setCommonStyle((CellStyle)headColumnStyle);
            headColumnStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
            headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headColumnStyle.setAlignment(this.getAlignment(align));
            headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headColumnStyle.setHidden(false);
            this.setCustomStyle(hs, headColumnStyle);
            this.textStyles.put(style.toString(), headColumnStyle);
        }
        return headColumnStyle;
    }

    private void setCustomStyle(ReportStyleInfo hs, XSSFCellStyle cs) {
        if (hs != null && cs != null) {
            if (StringUtils.isNotEmpty((CharSequence)hs.getBg())) {
                cs.setFillForegroundColor(this.transferColumnColor(hs.getBg()));
            } else {
                cs.setFillForegroundColor(IndexedColors.WHITE1.getIndex());
            }
            XSSFFont font = (XSSFFont)this.wb.createFont();
            if (StringUtils.isNotEmpty((CharSequence)hs.getC())) {
                font.setColor(this.transferColumnColor(hs.getC()));
            }
            if (StringUtils.isNotEmpty((CharSequence)hs.getFs()) && "italic".equalsIgnoreCase(hs.getFs())) {
                font.setItalic(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)hs.getFw()) && "bold".equalsIgnoreCase(hs.getFw())) {
                font.setBold(true);
            }
            font.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"HRGridExcelExporter_23", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            cs.setFont((Font)font);
        }
    }

    private XSSFColor transferColumnColor(String color) {
        if (StringUtils.isBlank((CharSequence)color)) {
            return null;
        }
        String[] rgba = color.substring(color.indexOf("(") + 1, color.indexOf(")")).split(",");
        return new XSSFColor(new Color(Integer.parseInt(rgba[0].trim()), Integer.parseInt(rgba[1].trim()), Integer.parseInt(rgba[2].trim()), Math.round(Float.parseFloat(rgba[3].trim()))), (IndexedColorMap)new DefaultIndexedColorMap());
    }

    private void adjustTreeColumnWidth(SXSSFSheet sheet, List<ReportHeadRowInfo> cols) {
        for (int i = 0; i < cols.size(); ++i) {
            ReportHeadRowInfo col = cols.get(i);
            if (i == 0 && this.showSeq) {
                this.setColumnWidth(sheet, this.headColIndex, this.seqHeadName);
                ++this.headColIndex;
            }
            if (i == 0 && this.summaryLevel != null && this.summaryLevel > 0) {
                for (int j = 0; j <= this.summaryLevel; ++j) {
                    this.setColumnWidth(sheet, this.headColIndex, this.keyCaptionMap.get(j + col.getCodeAlias()));
                    ++this.headColIndex;
                }
            }
            this.setColumnWith(sheet, col);
        }
    }

    private void setColumnWith(SXSSFSheet sheet, ReportHeadRowInfo col) {
        if (this.isHasChildren(col)) {
            this.adjustColumnWidth(sheet, col.getChildren());
        } else {
            this.setColumnWidth(sheet, this.headColIndex, col.getName());
            ++this.headColIndex;
        }
    }

    private void adjustColumnWidth(SXSSFSheet sheet, List<ReportHeadRowInfo> cols) {
        for (ReportHeadRowInfo col : cols) {
            this.setColumnWith(sheet, col);
        }
    }

    private void setColumnWidth(SXSSFSheet sheet, int index, String colHeadName) {
        if (colHeadName == null) {
            return;
        }
        int w = colHeadName.getBytes().length;
        if (w * 2 * 160 > 65280) {
            sheet.setColumnWidth(index, 6000);
        } else if (w < 12) {
            sheet.setColumnWidth(index, 3840);
        } else {
            sheet.setColumnWidth(index, w * 2 * 160);
        }
    }

    private void mergeTableHead(SXSSFSheet sheet) {
        HRMergeExcelCell[][] cells = this.getTableHeadCells(sheet);
        int rowCount = cells.length;
        if (rowCount == 0) {
            throw new KDException(BosErrorCode.reportHeadEmpty, new Object[0]);
        }
        int colCount = cells[0].length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                HRMergeExcelCell rowCell;
                HRMergeExcelCell colCell;
                int col;
                int row = i + 1;
                HRMergeExcelCell firstCell = cells[i][j];
                firstCell.setMerged(true);
                boolean colMerge = false;
                for (col = j + 1; col < colCount && !(colCell = cells[i][col]).isMerged() && firstCell.getValue().equals(colCell.getValue()); ++col) {
                    if (i == 0) {
                        colCell.setMerged(true);
                        colMerge = true;
                    }
                    if (i <= 0 || !cells[i - 1][j].getValue().equals(cells[i - 1][col].getValue()) || !cells[i - 1][j].isMerged() || !cells[i - 1][col].isMerged()) continue;
                    colCell.setMerged(true);
                    colMerge = true;
                }
                boolean rowMerge = false;
                while (row < rowCount && !(rowCell = cells[row][j]).isMerged() && firstCell.getValue().equals(rowCell.getValue())) {
                    rowCell.setMerged(true);
                    rowMerge = true;
                    ++row;
                }
                if (!colMerge && !rowMerge) continue;
                CellRangeAddress rang = new CellRangeAddress(i, row - 1, j, col - 1);
                sheet.addMergedRegion(rang);
            }
        }
    }

    private HRMergeExcelCell[][] getTableHeadCells(SXSSFSheet sheet) {
        int headRowSize = this.headRows.size();
        HRMergeExcelCell[][] cells = new HRMergeExcelCell[headRowSize][this.colIndex];
        for (int i = 0; i < headRowSize; ++i) {
            SXSSFRow row = sheet.getRow(i);
            for (int j = 0; j < this.colIndex; ++j) {
                cells[i][j] = new HRMergeExcelCell(row.getCell(j).getStringCellValue());
            }
        }
        return cells;
    }

    private void renameTableHeadCells(SXSSFSheet sheet) {
        int headRowSize = this.headRows.size();
        for (int i = 0; i < headRowSize; ++i) {
            SXSSFRow row = sheet.getRow(i);
            for (int j = 0; j < this.colIndex; ++j) {
                row.getCell(j).setCellValue(this.keyCaptionMap.get(row.getCell(j).getStringCellValue()));
            }
        }
    }

    private SXSSFRow getRow(SXSSFSheet sheet, int r) {
        if (r >= 0x100000) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u6570%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"HRGridExcelExporter_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), 0x100000));
        }
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    @Override
    public SXSSFWorkbook getWb() {
        return this.wb;
    }

    @Override
    public void setWb(SXSSFWorkbook wb) {
        this.wb = wb;
    }

    public int getLoopTimes() {
        return this.loopTimes;
    }

    @Override
    public void setLoopTimes(int loopTimes) {
        this.loopTimes = loopTimes;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void setSummaryLevel(Integer summaryLevel) {
        this.summaryLevel = summaryLevel;
    }

    @Override
    public void isTreeShow(boolean isTreeShow) {
        this.isTreeShow = isTreeShow;
    }

    @Override
    public void setShowSeq(boolean showSeq) {
        this.showSeq = showSeq;
    }

    @Override
    public void setReportManageConfigInfo(ReportManageConfigInfo reportManageConfigInfo) {
        this.reportManageConfigInfo = reportManageConfigInfo;
    }

    @Override
    public void setTotal(boolean total) {
        this.isTotal = total;
    }

    @Override
    public void setDataSeq(int dataSeq) {
        this.dataSeq = dataSeq;
    }

    @Override
    public void setAllIndexField(Map<String, String> allIndexField) {
        this.allIndexField = allIndexField;
        this.digestLengthMap.clear();
    }

    @Override
    public void isMergeSameCell(boolean isMergeSameCell) {
        this.mergeSameCell = isMergeSameCell;
    }

    @Override
    public void mergeInTheEnd(String sheetName) {
        SXSSFSheet sheet;
        if (this.needMergeSameCell() && !this.isTotal && !this.isTreeShow && !this.mergeCellIndexList.isEmpty() && (sheet = this.wb.getSheet(sheetName)) != null) {
            for (ColumnCellMergeIndex columnCellMergeIndex : this.mergeCellIndexList) {
                this.mergeCell(sheet, this.lastRowSubTotalMark, columnCellMergeIndex);
            }
        }
    }

    private Map<String, ReportBodyCellInfo> getCellMap(ReportBodyRowInfo reportBodyRowInfo) {
        return reportBodyRowInfo.getR().stream().collect(Collectors.toMap(cell -> cell.getK().toLowerCase(Locale.ROOT), cell -> cell));
    }

    private boolean needMergeSameCell() {
        long orgId = RequestContext.get().getOrgId() == 0L ? OrgServiceUtil.getHRRootOrgId() : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("2VKJ94YEM7AU", Long.valueOf(orgId));
        Map parameter = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Boolean isNeedMergeSameCell = (Boolean)parameter.get(NEED_MERGE_SAME_CELL);
        if (isNeedMergeSameCell == null) {
            return false;
        }
        return isNeedMergeSameCell != false && this.mergeSameCell;
    }
}

