/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.export;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.cache.CacheFactory;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ListExporter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.time.CostTimeHelper;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.formplugin.web.export.HRExportProgressImpl;
import kd.hr.hrptmc.formplugin.web.export.HRGridExcelExporter;
import kd.hr.hrptmc.formplugin.web.export.IHRExporter;
import kd.hr.hrptmc.formplugin.web.repdesign.subtotal.ReportSubTotalHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportHeadUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportQueryUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.WorkRptUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class HRSheetExportDataTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HRSheetExportDataTask.class);
    private final CostTimeHelper costTimeHelper = CostTimeHelper.create(HRSheetExportDataTask.class);
    private ConcurrentHashMap<String, Object> params = new ConcurrentHashMap();
    private DynamicObject exportLogObj;
    private ExportProgress exportProgress;
    private IFormView parentView;
    private static final int MAX_LIMIT = 20000;
    private static final int MIN_LIMIT = 2000;
    private static final int sheetRowCount = 1000000;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDBizException {
        this.costTimeHelper.nestedStart(false);
        LOGGER.info("HRSheetExportDataTask execute start ---------");
        if (params != null) {
            try {
                this.params.putAll(params);
                Object requestContext = params.get("requestcontext");
                if (requestContext instanceof RequestContext) {
                    RequestContext.set((RequestContext)((RequestContext)requestContext));
                } else if (requestContext != null) {
                    RequestContext reqctx = (RequestContext)JSONObject.parseObject((String)requestContext.toString(), RequestContext.class);
                    RequestContext.set((RequestContext)reqctx);
                }
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getCause(), new ErrorCode("exportDataError", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", (String)"HRSheetExportDataTask_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])), new Object[0]);
            }
        }
        this.getParentView();
        try {
            this.exportLogObj = this.buildExportLogObj();
            this.exportBatch4MulWork(this.params);
        }
        catch (Throwable throwable) {
            String errMsg = null;
            if (throwable instanceof KDBizException) {
                errMsg = throwable.getMessage();
            } else if (SystemParamServiceHelper.isShowStackTrace()) {
                errMsg = ListExporter.formatException((Throwable)throwable);
            }
            if (StringUtils.isBlank((String)errMsg)) {
                errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"HRSheetExportDataTask_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            }
            LOGGER.error(throwable);
            this.exportLogObj.set("logs", (Object)errMsg);
            this.exportLogObj.set("complete", (Object)0);
            throw new KDBizException(throwable, new ErrorCode("exportdataerror", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", (String)"HRSheetExportDataTask_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            this.saveExportLog();
            Object pkValue = this.exportLogObj.getPkValue();
            this.getExportProgress().feedbackLogId(pkValue);
            this.getExportProgress().complete();
            LOGGER.info("HRSheetExportDataTask execute end TotalCostTime:{};---------", (Object)this.costTimeHelper.getTotalCostTime());
        }
    }

    private void exportBatch4MulWork(Map<String, Object> params) throws IOException {
        Object serializePreIdxQFilters;
        Object serializeOnQFilters;
        Object serializeWhereQFilters;
        LOGGER.info("HRSheetExportDataTask_exportBatch start ---------");
        Object object = params.get("reportQueryParamInfo");
        ReportQueryParamInfo reportQueryParamInfo = (ReportQueryParamInfo)SerializationUtils.fromJsonString((String)object.toString(), ReportQueryParamInfo.class);
        reportQueryParamInfo.setFromCache(false);
        reportQueryParamInfo.setRouteByBigData(true);
        reportQueryParamInfo.setAlgoXDetailOptimize(false);
        if (reportQueryParamInfo.getAdminOrgSummaryInfo() != null) {
            reportQueryParamInfo.getAdminOrgSummaryInfo().setShowAllSummaryLevel(true);
        }
        if (Objects.nonNull(serializeWhereQFilters = params.get("serializeWhereQFilters"))) {
            List whereQFilters = (List)HRJSONUtils.cast((String)serializeWhereQFilters.toString(), List.class, (Class[])new Class[]{String.class});
            List whereQFilterList = whereQFilters.stream().map(qFilter -> QFilter.fromSerializedString((String)qFilter)).collect(Collectors.toList());
            reportQueryParamInfo.setWhereQFilter(whereQFilterList);
        }
        if (Objects.nonNull(serializeOnQFilters = params.get("serializeOnQFilters"))) {
            List onQFilters = (List)HRJSONUtils.cast((String)serializeOnQFilters.toString(), List.class, (Class[])new Class[]{String.class});
            List onQFilterList = onQFilters.stream().map(qFilter -> QFilter.fromSerializedString((String)qFilter)).collect(Collectors.toList());
            reportQueryParamInfo.setOnQFilter(onQFilterList);
        }
        if (Objects.nonNull(serializePreIdxQFilters = params.get("serializePreIdxQFilters"))) {
            List preIdxQFilters = (List)HRJSONUtils.cast((String)serializePreIdxQFilters.toString(), List.class, (Class[])new Class[]{String.class});
            List preIdxQFilterList = preIdxQFilters.stream().map(qFilter -> QFilter.fromSerializedString((String)qFilter)).collect(Collectors.toList());
            reportQueryParamInfo.setPreIdxQFilter(preIdxQFilterList);
        }
        this.costTimeHelper.logCostKey("HRSheetExportDataTask", true, "getReportInfo_buildParams");
        AdminOrgSummaryInfo adminOrgSummaryInfo = reportQueryParamInfo.getAdminOrgSummaryInfo();
        try {
            List workRpt = reportQueryParamInfo.getReportManageConfigInfo().getWorkRpt();
            int total = workRpt.size();
            this.getExportProgress().feedbackProgress(total, 0);
            if (workRpt.size() == 1) {
                boolean isChar;
                String type = ((WorkRptInfo)workRpt.get(0)).getReportConfig().getType();
                boolean bl = isChar = type.equals("2") || type.equals("3") || type.equals("4");
                if (!isChar) {
                    reportQueryParamInfo.setStart(-1);
                    reportQueryParamInfo.setLimit(-1);
                    reportQueryParamInfo.setRouteByBigData(false);
                    total = (int)ReportQueryUtil.getReportTotal(reportQueryParamInfo);
                }
            }
            this.exportLogObj.set("total", (Object)total);
            this.costTimeHelper.logCostKey("HRSheetExportDataTask", true, "getReportTotal0");
            String picStr = (String)params.get("genPic");
            Map picMap = null;
            if (!HRStringUtils.isEmpty((String)picStr)) {
                picMap = (Map)SerializationUtils.fromJsonString((String)picStr, Map.class);
            }
            SXSSFWorkbook wb = new SXSSFWorkbook(-1);
            wb.setCompressTempFiles(true);
            for (int i = 0; i < workRpt.size(); ++i) {
                WorkRptInfo workRptInfo = (WorkRptInfo)workRpt.get(i);
                String workRptId = workRptInfo.getWorkRptId();
                WorkRptUtil.switchWorkRpt(reportQueryParamInfo.getReportManageConfigInfo(), workRptId);
                String type = workRptInfo.getReportConfig().getType();
                HRGridExcelExporter exporter = new HRGridExcelExporter(wb);
                exporter.setShowSeq(reportQueryParamInfo.getReportManageConfigInfo().getReportConfig().getShowSeq());
                exporter.setReportManageConfigInfo(reportQueryParamInfo.getReportManageConfigInfo());
                exporter.setAllIndexField(FieldInfoUtil.getAllRowIndexFieldMap(reportQueryParamInfo.getReportManageConfigInfo().getRows()));
                switch (type) {
                    case "2": 
                    case "3": 
                    case "4": {
                        if (picMap == null) break;
                        this.buildGridExcelByPic(workRptInfo, (String)picMap.get(workRptId), exporter);
                        break;
                    }
                    default: {
                        this.buildGridExcel(reportQueryParamInfo, adminOrgSummaryInfo, exporter, total);
                    }
                }
                if (workRpt.size() <= 1) continue;
                int completePercent = (i + 1) * 100 / total;
                this.getExportProgress().feedbackProgress(total, completePercent);
            }
            String url = this.writeFile(wb, reportQueryParamInfo.getReportManageConfigInfo().getAssignObj().getAnObj().getNumber());
            String domainContext = UrlService.getDomainContextUrl();
            if (!domainContext.endsWith("/")) {
                domainContext = domainContext + "/";
            }
            String fullUrl = domainContext + url;
            DisposableUrlParam urlParam = new DisposableUrlParam();
            urlParam.setEntityNum((String)params.get("entitynumber"));
            urlParam.setPath(fullUrl);
            urlParam.setPermItem("4730fc9f000004ae");
            urlParam.setPkId((Object)0L);
            fullUrl = AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)urlParam);
            this.getExportProgress().feedbackProgress(total, 100);
            this.getExportProgress().feedbackFileUrl(fullUrl);
            this.exportLogObj.set("downloadurl", (Object)fullUrl);
            this.exportLogObj.set("complete", (Object)total);
            this.costTimeHelper.logCostKey("writeFile", true, "writeFile");
        }
        catch (Exception exception) {
            LOGGER.error("exportBatch_exception_pageId:{}", (Object)reportQueryParamInfo.getPageId(), (Object)exception);
            throw new KDException((Throwable)exception, BosErrorCode.systemError, new Object[]{exception.getMessage()});
        }
    }

    private int buildSummaryLevel(List<ReportBodyRowInfo> data) {
        HashSet level = new HashSet();
        data.forEach(data2 -> {
            if (CollectionUtils.isEmpty((Collection)data2.getR())) {
                return;
            }
            HashSet levelSub = new HashSet();
            data2.getR().stream().forEach(data3 -> {
                if (!"children".equalsIgnoreCase(data3.getK())) {
                    return;
                }
                int i = 0;
                Object childrenList = data3.getV();
                if (childrenList instanceof List) {
                    ++i;
                    List childrenData = (List)childrenList;
                    i += this.buildSummaryLevel(childrenData);
                }
                levelSub.add(i);
            });
            if (levelSub.size() > 0) {
                level.add((Integer)Collections.max(levelSub));
            }
        });
        return level.size() > 0 ? (Integer)Collections.max(level) : 0;
    }

    private void buildGridExcel(ReportQueryParamInfo reportQueryParamInfo, AdminOrgSummaryInfo adminOrgSummaryInfo, IHRExporter exporter, int total) throws IOException {
        int i = 0;
        int batchSize = this.getBatchSize(reportQueryParamInfo);
        WorkRptInfo curWorkRpt = reportQueryParamInfo.getReportManageConfigInfo().getCurWorkRpt();
        int size = reportQueryParamInfo.getReportManageConfigInfo().getWorkRpt().size();
        String sheetNamePre = ResManager.loadKDString((String)"\u5de5\u4f5c\u8868%s", (String)"HRSheetExportDataTask_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[]{curWorkRpt.getKey()});
        int j = 1;
        String firstColumnCode = "";
        int workReportDataCount = 0;
        Map objSortValueMap = null;
        Map afterKeyMap = null;
        block0: while (true) {
            String sheetName = j > 1 ? sheetNamePre + "_" + j : sheetNamePre;
            exporter.initIndex(sheetName);
            int k = 0;
            int totalRow = 0;
            do {
                boolean hasNextPage;
                ReportInfo reportInfo;
                boolean isSubTotal = ReportSubTotalHandler.getIsSubTotal(reportQueryParamInfo.getReportManageConfigInfo());
                if (i == 0) {
                    ReportHeadInfo reportHeadInfo;
                    reportQueryParamInfo.setStart(0);
                    if (isSubTotal) {
                        reportQueryParamInfo.setLimit(batchSize);
                    } else {
                        reportQueryParamInfo.setLimit(batchSize + 1);
                        reportQueryParamInfo.setEsLimit(batchSize);
                    }
                    reportQueryParamInfo.setRouteByBigData(true);
                    reportQueryParamInfo.setObjSortValueMap(null);
                    reportQueryParamInfo.setAfterKeyMap(null);
                    reportInfo = ReportQueryUtil.getReportInfo(reportQueryParamInfo);
                    if ("0".equals(curWorkRpt.getReportConfig().getType())) {
                        if (adminOrgSummaryInfo != null) {
                            exporter.isTreeShow(adminOrgSummaryInfo.getTreeShow());
                            if (adminOrgSummaryInfo.getTreeShow() && adminOrgSummaryInfo.getSummaryLevel() == null) {
                                exporter.setSummaryLevel(this.buildSummaryLevel(reportInfo.getBody()) + 1);
                            } else {
                                exporter.setSummaryLevel(adminOrgSummaryInfo.getSummaryLevel());
                            }
                        }
                        exporter.isMergeSameCell(curWorkRpt.getReportConfig().getMergeCell());
                    }
                    firstColumnCode = this.getFirstColumnCode((reportHeadInfo = reportInfo.getHead()) != null && CollectionUtils.isNotEmpty((Collection)reportHeadInfo.getHf()) ? (ReportHeadRowInfo)reportHeadInfo.getHf().get(0) : null);
                } else {
                    reportQueryParamInfo.setStart(i * batchSize);
                    if (isSubTotal) {
                        reportQueryParamInfo.setLimit(batchSize);
                    } else {
                        reportQueryParamInfo.setLimit(batchSize + 1);
                        reportQueryParamInfo.setEsLimit(batchSize);
                    }
                    reportQueryParamInfo.setRouteByBigData(true);
                    reportQueryParamInfo.setObjSortValueMap(objSortValueMap);
                    reportQueryParamInfo.setAfterKeyMap(afterKeyMap);
                    reportInfo = ReportQueryUtil.getReportInfo(reportQueryParamInfo);
                }
                objSortValueMap = reportInfo.getObjSortValueMap();
                afterKeyMap = reportInfo.getAfterKeyMap();
                List body = reportInfo.getBody();
                boolean bl = isSubTotal ? reportInfo.getHasNextPage() : (hasNextPage = reportInfo.getSize() > batchSize);
                if (hasNextPage && !isSubTotal) {
                    body.remove(body.size() - 1);
                }
                this.costTimeHelper.logCostKey("HRSheetExportDataTask", true, "getReportInfo" + i + ",size:" + body.size());
                exporter.setSize(totalRow);
                exporter.setLoopTimes(k);
                exporter.export(reportInfo.getHead(), reportInfo.getBody(), sheetName);
                int curRowSize = body.size();
                if (curRowSize == 0) {
                    return;
                }
                totalRow += curRowSize;
                workReportDataCount += curRowSize;
                ++i;
                ++k;
                if (size == 1) {
                    int completePercent = workReportDataCount > total ? 100 : workReportDataCount * 100 / total;
                    this.getExportProgress().feedbackProgress(total, completePercent);
                }
                if (totalRow >= 1000000) {
                    SXSSFSheet sheet = exporter.getWb().getSheet(sheetName);
                    exporter.mergeInTheEnd(sheetName);
                    int sheetIndex = exporter.getWb().getSheetIndex((Sheet)sheet);
                    exporter.getWb().setSheetName(sheetIndex, sheetNamePre + "_" + j);
                    ++j;
                    continue block0;
                }
                if (hasNextPage) continue;
                exporter.mergeInTheEnd(sheetName);
                this.handleLastPage(reportInfo, reportQueryParamInfo, exporter, firstColumnCode, sheetName, totalRow, i, k, total);
                return;
            } while (adminOrgSummaryInfo == null || !adminOrgSummaryInfo.getTreeShow());
        }
    }

    private void handleLastPage(ReportInfo reportInfo, ReportQueryParamInfo reportQueryParamInfo, IHRExporter exporter, String firstColumnCode, String sheetName, int totalRow, int i, int k, int total) throws IOException {
        this.costTimeHelper.logCostKey("HRSheetExportDataTask", true, String.format("HRGridExcelExporter%1s(workRpt:%2s)", i, total));
        if (reportQueryParamInfo.getReportManageConfigInfo().getReportConfig().getTotal() && totalRow != 0) {
            reportQueryParamInfo.setStart(-1);
            reportQueryParamInfo.setLimit(-1);
            reportQueryParamInfo.setRouteByBigData(false);
            ReportInfo totalRowsReportInfo = ReportQueryUtil.getReportTotalRows(reportQueryParamInfo);
            exporter.setSize(totalRow);
            exporter.setLoopTimes(k);
            exporter.setTotal(true);
            if (totalRowsReportInfo == null) {
                return;
            }
            List reportBodyCellInfoList = ((ReportBodyRowInfo)totalRowsReportInfo.getTotalRow().get(0)).getR();
            for (ReportBodyCellInfo reportBodyCellInfo : reportBodyCellInfoList) {
                if (!StringUtils.isNotEmpty((String)firstColumnCode) || !reportBodyCellInfo.getK().equalsIgnoreCase(firstColumnCode) || !ObjectUtils.isEmpty((Object)reportBodyCellInfo.getV())) continue;
                reportBodyCellInfo.setV((Object)reportQueryParamInfo.getReportManageConfigInfo().getReportConfig().getTotalName());
                break;
            }
            exporter.export(reportInfo.getHead(), totalRowsReportInfo.getTotalRow(), sheetName);
        }
        exporter.setDataSeq(1);
        exporter.setTotal(false);
    }

    private void buildGridExcelByPic(WorkRptInfo workRptInfo, String base64, IHRExporter exporter) throws IOException {
        String sheetName = ResManager.loadKDString((String)"\u5de5\u4f5c\u8868%s", (String)"HRSheetExportDataTask_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[]{workRptInfo.getKey()});
        exporter.initIndex(sheetName);
        exporter.drawPic(sheetName, base64, 1, 1, 19, 28);
    }

    private String getFirstColumnCode(ReportHeadRowInfo headRowInfo) {
        if (headRowInfo == null) {
            return null;
        }
        if (headRowInfo.getHasChildren() && null != headRowInfo.getChildren() && headRowInfo.getChildren().size() > 0) {
            return this.getFirstColumnCode((ReportHeadRowInfo)headRowInfo.getChildren().get(0));
        }
        return headRowInfo.getCodeAlias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(this.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (wb != null) {
                wb.dispose();
                wb.close();
            }
        }
    }

    protected String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xlsx";
    }

    public IFormView getParentView() {
        if (this.parentView == null) {
            String parentPageId = (String)this.params.get("parentpageid");
            if (StringUtils.isBlank((String)parentPageId)) {
                return null;
            }
            this.parentView = SessionManager.getCurrent().getView(parentPageId);
        }
        return this.parentView;
    }

    private ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new HRExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    private DynamicObject buildExportLogObj() {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject obj = (DynamicObject)objType.createInstance();
        obj.set("bizobject", this.params.get("entityname"));
        obj.set("sourceobj", (Object)"hrptmc_reportmanage");
        obj.set("billstatus", (Object)"C");
        obj.set("exportstatus", (Object)"0");
        obj.set("createtime", (Object)TimeServiceHelper.now());
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_exportlog", obj, null);
        obj.set("billno", (Object)billno);
        obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        return obj;
    }

    private void saveExportLog() {
        this.exportLogObj.set("exportstatus", (Object)"1");
        this.exportLogObj.set("finishtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((IDataEntityType)this.exportLogObj.getDataEntityType(), (Object[])new DynamicObject[]{this.exportLogObj});
    }

    private int getBatchSize(ReportQueryParamInfo reportQueryParamInfo) {
        boolean esQuery;
        int rowSize = 1000000 / ReportHeadUtils.getHeadColumnSize(reportQueryParamInfo.getReportManageConfigInfo());
        if (HRCloudServiceHelper.isMultiTenants()) {
            return Math.min(rowSize, 2000);
        }
        int min = Math.min(rowSize, 20000);
        boolean bl = esQuery = "mySubscribe".equals(reportQueryParamInfo.getReportCenterOpenFrom()) || "share".equals(reportQueryParamInfo.getReportCenterOpenFrom());
        if (esQuery && 10000 < min) {
            return 9999;
        }
        return min;
    }
}

