/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hrptmc.business.datastore.physicaltable.PhysicalTableHandler;
import kd.hr.hrptmc.business.datastore.physicaltable.model.AnObjFileSourceDataStoreTableBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;
import kd.hr.hrptmc.business.filesource.CreateAnObjService;
import kd.hr.hrptmc.business.filesource.CreateVirtualEntityService;
import kd.hr.hrptmc.business.filesource.FileSourceTableMsgService;
import kd.hr.hrptmc.business.filesource.ReportFileSourceImportInfo;
import kd.hr.hrptmc.business.filesource.ReportFileSourceService;
import kd.hr.hrptmc.business.filesource.exception.RptFileSourceCreateAnObjException;
import kd.hr.hrptmc.business.filesource.exception.RptFileSourceCreateTableException;
import kd.hr.hrptmc.business.filesource.exception.RptFileSourceCreateVirtualObjException;
import kd.hr.hrptmc.business.filesource.exception.RptFileSourceInsertDataException;
import kd.hr.hrptmc.formplugin.web.filesource.csv.ReportFileSourceCsvHandler;
import kd.hr.hrptmc.formplugin.web.filesource.csv.ReportFileSourceCsvReader;
import kd.hr.hrptmc.formplugin.web.filesource.excel.ReportFileSourceReadListener;

public class ReportFileSourceImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(ReportFileSourceImportPlugin.class);
    private ImportLogger logger;
    private final ReportFileSourceImportInfo importInfo = new ReportFileSourceImportInfo();
    private static final String KEY_FILE_NAME = "fileName";
    private static final String KEY_CREATE_TABLE = "createTable";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        for (String url : this.ctx.getAllUrls()) {
            this.logger = this.ctx.getLogger(url);
            String fileName = (String)this.ctx.getOption().get(KEY_FILE_NAME);
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    if (fileName.endsWith(".csv")) {
                        ReportFileSourceCsvReader csvReader = new ReportFileSourceCsvReader();
                        csvReader.read(in, new ReportFileSourceCsvHandler(this.ctx, url, this.importInfo, this.logger));
                        continue;
                    }
                    EasyExcel.read((InputStream)in, (ReadListener)new ReportFileSourceReadListener(this.ctx, url, this.importInfo, this.logger)).extraRead(CellExtraTypeEnum.MERGE).sheet().doRead();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception ex) {
                if (ex instanceof KDBizException) {
                    this.logger.log(Integer.valueOf(0), ex.getMessage());
                } else {
                    this.logger.log(Integer.valueOf(0), ImportLogger.formatException((Throwable)ex));
                }
                LOGGER.error("FileSource resolveExcel error: ", (Throwable)ex);
            }
            finally {
                this.ctx.setResolveComplete(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importData() {
        try {
            for (String url : this.ctx.getAllUrls()) {
                LinkedBlockingQueue dataQ = this.ctx.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = this.ctx.getLogger(url);
                importLogger.setDelRows(delRows);
                this.fetchBatchQueenData(this.ctx, url, dataQ);
            }
        }
        catch (Exception e) {
            this.handleUnknownFailed();
            LOGGER.error("FileSource importData error: ", (Throwable)e);
        }
        finally {
            HashMap<String, Object> retdata = new HashMap<String, Object>(16);
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getLogCache().size();
                HashMap sheetResult = Maps.newHashMapWithExpectedSize((int)2);
                sheetResult.put("sheetTotal", logger.getTotal());
                sheetResult.put("sheetFailed", logger.getLogCache().size());
                retdata.put("sheetResult", sheetResult);
                IHRAppCache hrptmc = HRAppCache.get((String)"hrptmc");
                String pageId = (String)this.ctx.getOption().get("pageId");
                String cacheKey = "fileSource_" + pageId;
                HashMap msgMap = Maps.newHashMapWithExpectedSize((int)16);
                if (failed > 0) {
                    msgMap.put("success", "false");
                    msgMap.put("errorMsg", this.getErrorMsg());
                } else {
                    CreateAnObjService createAnObjService = this.importInfo.getCreateAnObjService();
                    if (createAnObjService != null && createAnObjService.getAnObjDy() != null) {
                        DynamicObject anObjDy = createAnObjService.getAnObjDy();
                        String anObjName = anObjDy.getLocaleString("name").getLocaleValue();
                        String anObjNum = anObjDy.getString("number");
                        String anObjId = anObjDy.getString("id");
                        msgMap.put("success", "true");
                        msgMap.put("tableName", this.importInfo.getTableName());
                        msgMap.put("anObjId", anObjId);
                        msgMap.put("anObjNum", anObjNum);
                        msgMap.put("anObjName", anObjName);
                    }
                }
                hrptmc.put(cacheKey, (Object)msgMap);
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            this.ctx.feedbackProgress(100, null, null);
            this.clearAttachmentFile();
        }
    }

    private void fetchBatchQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ) {
        int timeout = 0;
        int dataCount = 0;
        try {
            ArrayList<ImportBillData> rowDatas = new ArrayList<ImportBillData>(10);
            while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 5)) {
                int lastLeftCount = 0;
                int needCount = 500 - lastLeftCount;
                ImportBillData rowdata = dataQ.poll(10L, TimeUnit.SECONDS);
                if ((rowdata == null || rowdata.isEmpty()) && rowDatas.isEmpty()) {
                    ++timeout;
                    continue;
                }
                rowDatas.add(rowdata);
                dataQ.drainTo(rowDatas, needCount);
                rowDatas.removeIf(data -> data == null || data.isEmpty());
                timeout = 0;
                if (this.logger.getLogCache().size() > 0) break;
                boolean resolveComplete = this.ctx.isResolveComplete(url);
                if (rowDatas.size() <= 0 || !this.startCreateTableAndImportData(resolveComplete, rowDatas)) continue;
                this.createTable();
                if (this.importInfo.getTableName() == null) continue;
                this.importBatchData(rowDatas);
                rowDatas.clear();
                this.setProgress(dataCount += rowDatas.size());
            }
            if (this.importInfo.getTableName() != null) {
                Set<String> enumFields = this.saveEnums();
                this.importInfo.setEnumFields(enumFields);
                this.generateAnObjAndVirtualObj();
                this.saveTableAndFieldsMsg();
            }
        }
        catch (RptFileSourceCreateTableException ex) {
            this.handleFailed(ResManager.loadKDString((String)"\u521b\u5efa\u7269\u7406\u8868\u5f02\u5e38\u3002", (String)"ReportFileSourceImportPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            this.dropTableAndClearData();
        }
        catch (RptFileSourceInsertDataException ex) {
            this.handleFailed(ResManager.loadKDString((String)"\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38\u3002", (String)"ReportFileSourceImportPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            this.dropTableAndClearData();
        }
        catch (RptFileSourceCreateVirtualObjException ex) {
            this.handleFailed(ResManager.loadKDString((String)"\u521b\u5efa\u865a\u62df\u5bf9\u8c61\u5f02\u5e38\u3002", (String)"ReportFileSourceImportPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            this.dropTableAndClearData();
        }
        catch (RptFileSourceCreateAnObjException ex) {
            this.handleFailed(ResManager.loadKDString((String)"\u521b\u5efa\u5206\u6790\u5bf9\u8c61\u5f02\u5e38\u3002", (String)"ReportFileSourceImportPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            this.dropTableAndClearData();
        }
        catch (Exception ex) {
            this.dropTableAndClearData();
            this.handleUnknownFailed();
            LOGGER.error("FileSource importData error: ", (Throwable)ex);
        }
    }

    private boolean startCreateTableAndImportData(boolean resolveComplete, List<ImportBillData> rowDatas) {
        if (this.logger.getLogCache().size() > 0) {
            return false;
        }
        Boolean createTable = (Boolean)this.ctx.getOption().get(KEY_CREATE_TABLE);
        if (createTable != null && createTable.booleanValue()) {
            return true;
        }
        return rowDatas.size() >= 200 || resolveComplete;
    }

    private void saveTableAndFieldsMsg() {
        FileSourceTableMsgService.getInstance().saveTableMsg(this.importInfo);
    }

    private Set<String> saveEnums() {
        Set enumFields = this.getEnumFields();
        enumFields = ReportFileSourceService.getInstance().saveEnums(enumFields, this.importInfo);
        LOGGER.info("ReportFileSourceImport save enums success, enum fields: {}", (Object)enumFields);
        return enumFields;
    }

    private Set<String> getEnumFields() {
        HashSet enumFields = Sets.newHashSetWithExpectedSize((int)16);
        this.importInfo.getFieldLengthMap().forEach((index, maxLen) -> {
            ReportDataStoreFieldBo dataStoreFieldBo = (ReportDataStoreFieldBo)this.importInfo.getFields().get((int)index);
            if (dataStoreFieldBo.getType() == ReportDataStoreType.NVARCHAR && maxLen <= 100) {
                enumFields.add(dataStoreFieldBo.getFieldName());
            }
        });
        return enumFields;
    }

    private void generateAnObjAndVirtualObj() throws RptFileSourceCreateVirtualObjException, RptFileSourceCreateAnObjException {
        String fileName = (String)this.ctx.getOption().get(KEY_FILE_NAME);
        CreateVirtualEntityService createVirtualEntityService = new CreateVirtualEntityService(this.importInfo);
        try {
            this.importInfo.setCreateVirtualEntityService(createVirtualEntityService);
            createVirtualEntityService.createVirtualEntity(fileName);
        }
        catch (Exception ex) {
            this.dropTableAndClearData();
            throw new RptFileSourceCreateVirtualObjException(ex);
        }
        LOGGER.info("ReportFileSourceImport generate virtualObj success, virtualObj number: {}", (Object)createVirtualEntityService.getNumber());
        CreateAnObjService createAnObjService = new CreateAnObjService(this.importInfo, fileName);
        try {
            this.importInfo.setCreateAnObjService(createAnObjService);
            createAnObjService.createAnObj();
        }
        catch (Exception ex) {
            this.dropTableAndClearData();
            throw new RptFileSourceCreateAnObjException(ex);
        }
        LOGGER.info("ReportFileSourceImport generate anObj success, anObj number: {}", (Object)createAnObjService.getNumber());
    }

    private void createTable() throws RptFileSourceCreateTableException {
        AnObjFileSourceDataStoreTableBo dataStoreTableBo;
        Boolean createTable = (Boolean)this.ctx.getOption().get(KEY_CREATE_TABLE);
        if (createTable != null && createTable.booleanValue()) {
            return;
        }
        try {
            dataStoreTableBo = ReportFileSourceService.getInstance().createTable(this.importInfo);
            this.importInfo.setDataStoreTableBo(dataStoreTableBo);
            this.ctx.addOption(KEY_CREATE_TABLE, (Object)true);
        }
        catch (Exception ex) {
            throw new RptFileSourceCreateTableException(ex);
        }
        LOGGER.info("ReportFileSourceImport create table success, table name: {}", (Object)dataStoreTableBo.getTableName());
    }

    private void dropTableAndClearData() {
        CreateVirtualEntityService createVirtualEntityService;
        PhysicalTableHandler tableHandler = this.importInfo.getTableHandler();
        if (tableHandler != null) {
            tableHandler.deleteTable(new char[0]);
        }
        FileSourceTableMsgService.getInstance().deleteTableMsg(this.importInfo.getTableName());
        CreateAnObjService createAnObjService = this.importInfo.getCreateAnObjService();
        if (createAnObjService != null) {
            createAnObjService.deleteAnObj();
        }
        if ((createVirtualEntityService = this.importInfo.getCreateVirtualEntityService()) != null) {
            createVirtualEntityService.deleteVirtualEntity();
        }
        ReportFileSourceService.getInstance().deleteEnums(this.importInfo.getTableName());
    }

    private void importBatchData(List<ImportBillData> rowdatas) throws RptFileSourceInsertDataException {
        if (rowdatas.get(0).getData().containsKey((Object)"errCode")) {
            throw new RptFileSourceInsertDataException("no data!");
        }
        long[] ids = ID.genLongIds((int)rowdatas.size());
        int index = 0;
        ArrayList values = Lists.newArrayListWithCapacity((int)10);
        for (ImportBillData billData : rowdatas) {
            JSONObject rowJson = billData.getData();
            JSONObject rowData = rowJson.getJSONObject("data");
            long id = ids[index];
            Object[] value = ReportFileSourceService.getInstance().buildInsertData(rowData, id, this.importInfo);
            values.add(value);
            ++index;
        }
        try {
            ReportFileSourceService.getInstance().insertData(this.importInfo.getTableName(), (List)values, this.importInfo);
        }
        catch (Exception ex) {
            throw new RptFileSourceInsertDataException(ex);
        }
    }

    private void handleFailed(String msg) {
        this.logger.log(Integer.valueOf(0), msg);
    }

    private void handleUnknownFailed() {
        String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38", (String)"ReportFileSourceImportPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        this.handleFailed(msg);
    }

    private void clearAttachmentFile() {
        for (String url : this.ctx.getAllUrls()) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            service.delete(url);
        }
    }

    private void setProgress(int dataCount) {
        if (this.logger.getTotal() > 0) {
            int progress = (int)((double)dataCount * 1.0 / (double)this.logger.getTotal() * 100.0);
            this.ctx.feedbackProgress(progress, this.logger.getTotal(), this.logger.getLogCache().size());
        }
    }

    private String getErrorMsg() {
        StringBuilder error = new StringBuilder();
        this.logger.getLogCache().forEach((rowIndex, log) -> {
            for (ImportLogger.ImportLog importLog : log) {
                if (importLog == null) continue;
                error.append(importLog).append(System.lineSeparator());
                if (error.length() <= 100) continue;
                error.replace(97, 100, "...").setLength(100);
            }
        });
        return error.toString();
    }
}

