/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.filesource.ReportFileSourceService;
import kd.hr.hrptmc.common.util.ImportFileUtil;
import kd.hr.hrptmc.formplugin.web.util.AnObjTreeF7PageUtil;

public class ReportFileSourceImportStartPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(ReportFileSourceImportStartPlugin.class);
    private static final String ATTACHMENT_FILE_UPLOAD = "fileupload";
    private static final String KEY_TABLE_NAME = "tableName";
    private static final String KEY_LAST_TABLE_NAME = "lastTableName";
    private static final String KEY_CHOOSE_TABLE_NAME = "chooseTableName";
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile(".+_[0-9]+$");

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_FILE_UPLOAD);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getPageCache().put(KEY_LAST_TABLE_NAME, (String)this.getView().getFormShowParameter().getCustomParam(KEY_LAST_TABLE_NAME));
        this.getPageCache().put(KEY_CHOOSE_TABLE_NAME, (String)this.getView().getFormShowParameter().getCustomParam(KEY_LAST_TABLE_NAME));
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            return;
        }
        if (urls.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u6570\u91cf\u9650\u5236\u4e3a1\u3002", (String)"ReportFileSourceImportStartPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = null;
        String localPath = "";
        String filesize = "";
        String filename = "";
        if (urls[0] instanceof Map) {
            Map map = (Map)urls[0];
            url = (String)map.get("url");
            filesize = String.valueOf(map.get("size"));
            filename = (String)map.get("name");
            try {
                localPath = ImportFileUtil.downloadTempFileForSource((String)url);
                LOGGER.info(" upload localPath:{}", (Object)localPath);
            }
            catch (IOException ioException) {
                LOGGER.error(".upload() downloadTempFile IOException:", (Throwable)ioException);
                this.getView().showErrorNotification(ioException.getMessage());
                return;
            }
        }
        url = String.valueOf(urls[0]);
        if (url.lastIndexOf("/") != -1) {
            filename = url.substring(url.lastIndexOf("/") + 1);
        }
        try {
            localPath = ImportFileUtil.downloadTempFileForSource((String)url);
        }
        catch (IOException ex) {
            LOGGER.error((Throwable)ex);
        }
        File file = new File(ImportFileUtil.checkUrl((String)localPath));
        filesize = String.valueOf(file.length());
        if (Long.parseLong(filesize) > 0x3200000L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5927\u4e8e50M\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", (String)"ReportFileSourceImportStartPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return;
        }
        filename = this.handleFileName(filename);
        try {
            Map result = ImportFileUtil.uploadFile((String)filename, (String)localPath);
            this.getModel().setValue("filename", (Object)filename);
            this.getModel().setValue("filesize", (Object)filesize);
            this.getModel().setValue("serverUrl", result.get("serverUrl"));
            this.getModel().setValue("clienturl", result.get("clientUrl"));
            this.startImport();
        }
        catch (Throwable ex) {
            LOGGER.error("FileSourceImportStart Error: ", ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38", (String)"ReportFileSourceImportStartPlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
    }

    private String handleFileName(String fileName) {
        DynamicObjectCollection anObjDyCol;
        String fileNameNotSuffix;
        String prefix = fileNameNotSuffix = fileName.substring(0, fileName.lastIndexOf("."));
        if (FILE_NAME_PATTERN.matcher(fileNameNotSuffix).matches()) {
            int lineIndex = fileNameNotSuffix.lastIndexOf("_");
            prefix = fileNameNotSuffix.substring(0, lineIndex + 1);
        }
        if (!(anObjDyCol = AnalyseObjectService.getInstance().getAnObjDysStartWithName(prefix, "")).isEmpty()) {
            String finalFileName = fileName;
            if (anObjDyCol.stream().noneMatch(dy -> HRStringUtils.equals((String)finalFileName, (String)dy.getString("name")))) {
                return fileName;
            }
            String anObjName = ((DynamicObject)anObjDyCol.get(0)).getString("name");
            String anObjNameNotSuffix = anObjName.substring(0, anObjName.lastIndexOf("."));
            String anObjNameSuffix = anObjName.substring(anObjName.lastIndexOf("."));
            HashMap anObjNameIndexMap = Maps.newHashMapWithExpectedSize((int)anObjDyCol.size());
            anObjDyCol.forEach(anObjDy -> {
                String currentAnObjName = anObjDy.getString("name");
                String curAnObjNameNotSuffix = currentAnObjName.substring(0, currentAnObjName.lastIndexOf("."));
                if (FILE_NAME_PATTERN.matcher(curAnObjNameNotSuffix).matches()) {
                    int lineIndex = curAnObjNameNotSuffix.lastIndexOf("_");
                    String number = curAnObjNameNotSuffix.substring(lineIndex + 1);
                    try {
                        int newNumber = Integer.parseInt(number);
                        anObjNameIndexMap.put(currentAnObjName, newNumber);
                    }
                    catch (Exception ex) {
                        anObjNameIndexMap.put(currentAnObjName, 0);
                    }
                } else {
                    anObjNameIndexMap.put(currentAnObjName, 0);
                }
            });
            Optional maxNum = anObjNameIndexMap.values().stream().max(Integer::compare);
            if (maxNum.isPresent()) {
                int lineIndex = anObjNameNotSuffix.lastIndexOf("_");
                int newNumber = (Integer)maxNum.get() + 1;
                fileName = lineIndex > 0 ? anObjNameNotSuffix.substring(0, lineIndex + 1) + newNumber + anObjNameSuffix : anObjNameNotSuffix + "_" + newNumber + anObjNameSuffix;
            } else {
                fileName = anObjNameNotSuffix + "_" + 1 + anObjNameSuffix;
            }
        }
        return fileName;
    }

    private void startImport() {
        String fileName = (String)this.getModel().getValue("filename");
        String serverUrl = (String)this.getModel().getValue("serverUrl");
        String clientUrl = (String)this.getModel().getValue("clienturl");
        this.startImporting(serverUrl, clientUrl, fileName);
    }

    private void startImporting(String url, String clientUrl, String fileName) {
        IFormView view = this.getView();
        if (HRStringUtils.isEmpty((String)url)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u3002", (String)"ReportFileSourceImportStartPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_filesourcimporting");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("serverUrl", url);
        params.put("clienturl", clientUrl);
        params.put("filename", fileName);
        params.put("formId", view.getFormShowParameter().getCustomParam("formId"));
        showParameter.setCustomParams((Map)params);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importComplete"));
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)"importComplete", (String)evt.getActionId())) {
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map) {
                Map msgMap = (Map)returnData;
                if (msgMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ReportFileSourceImportStartPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return;
                }
                String success = (String)msgMap.get("success");
                if (HRStringUtils.equals((String)success, (String)"true")) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ReportFileSourceImportStartPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    this.addFileSourceAnObjNode(msgMap);
                    this.clearLastImportData(msgMap);
                } else {
                    this.getView().showTipNotification((String)msgMap.get("errorMsg"));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ReportFileSourceImportStartPlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void clearLastImportData(Map<String, String> msgMap) {
        String tableName = msgMap.get(KEY_TABLE_NAME);
        String lastTableName = this.getPageCache().get(KEY_LAST_TABLE_NAME);
        if (HRStringUtils.isNotEmpty((String)lastTableName)) {
            ReportFileSourceService.getInstance().dropTableAndClearData(lastTableName);
        }
        this.getPageCache().put(KEY_LAST_TABLE_NAME, tableName);
    }

    private void addFileSourceAnObjNode(Map<String, String> msgMap) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String rootNodeStr = this.getPageCache().get("rootNode");
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        String lastTableName = this.getPageCache().get(KEY_LAST_TABLE_NAME);
        if (HRStringUtils.isNotEmpty((String)lastTableName)) {
            rootNode.getChildren().remove(0);
        }
        String anObjId = msgMap.get("anObjId");
        TreeNode newNode = new TreeNode(rootNode.getId(), anObjId, msgMap.get("anObjName"), false);
        rootNode.addChild(0, newNode);
        treeView.updateNode(rootNode);
        treeView.focusNode(newNode);
        AnObjTreeF7PageUtil.buildEntries(anObjId, this.getModel(), this.getView());
        this.getView().updateView("treeview");
    }

    public void afterUpload(UploadEvent evt) {
        String fileUid = this.getView().getPageCache().get("fileUid");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_FILE_UPLOAD);
        if (attachmentPanel.getAttachmentData().size() > 0) {
            List mapList = attachmentPanel.getAttachmentData();
            for (Map map : mapList) {
                boolean canRemove = map.get("uid").toString().equals(fileUid);
                if (!canRemove) continue;
                attachmentPanel.remove(map);
            }
            this.getView().updateView(ATTACHMENT_FILE_UPLOAD);
        }
        this.getView().getPageCache().remove("fileUid");
    }

    public void pageRelease(EventObject evt) {
        String chooseTableName;
        super.pageRelease(evt);
        String option = this.getPageCache().get("option");
        String lastTableName = this.getPageCache().get(KEY_LAST_TABLE_NAME);
        if (!HRStringUtils.equals((String)option, (String)"ok") && HRStringUtils.isNotEmpty((String)lastTableName) && !HRStringUtils.equals((String)lastTableName, (String)(chooseTableName = this.getPageCache().get(KEY_CHOOSE_TABLE_NAME)))) {
            ReportFileSourceService.getInstance().dropTableAndClearData(lastTableName);
        }
    }
}

