/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource.csv;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;
import kd.hr.hrptmc.business.filesource.ReportFileSourceImportInfo;
import kd.hr.hrptmc.business.filesource.ReportFileSourceService;
import kd.hr.hrptmc.formplugin.web.filesource.ReportFileSourceValidateHandler;
import kd.hr.hrptmc.formplugin.web.filesource.csv.ICsvHandler;
import kd.hr.hrptmc.formplugin.web.filesource.util.ReportFileSourceDateUtils;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class ReportFileSourceCsvHandler
implements ICsvHandler {
    private final String url;
    private final ImportContext ctx;
    private final ReportFileSourceImportInfo importInfo;
    private final ImportLogger importLogger;
    private final LinkedBlockingQueue<ImportBillData> dataQueue;
    private final ReportFileSourceValidateHandler validateHandler;
    private int currentRowIndex = 0;
    private int effectiveRowCount = 0;
    private final List<String> heads = Lists.newArrayListWithCapacity((int)10);
    private static final String FIELD_NAME_PREFIX = "field";
    private final Map<Integer, ReportDataStoreType> lastFieldTypeMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");

    public ReportFileSourceCsvHandler(ImportContext ctx, String url, ReportFileSourceImportInfo importInfo, ImportLogger logger) {
        this.ctx = ctx;
        this.url = url;
        this.importInfo = importInfo;
        this.importLogger = logger;
        this.dataQueue = ctx.getDataQueue(url);
        this.validateHandler = new ReportFileSourceValidateHandler(logger);
    }

    @Override
    public void startDocument(CSVParser csvParser) {
        this.importLogger.setTotal((int)csvParser.getRecordNumber());
    }

    @Override
    public void handle(CSVRecord row) {
        if (row == null) {
            return;
        }
        this.currentRowIndex = (int)row.getRecordNumber();
        if (this.currentRowIndex == 1) {
            this.handleCsvHead(row);
            this.validateHandler.validateHeadIsEmpty(this.heads);
        } else {
            List<String> data = this.handleCsvData(row);
            if (this.currentRowIndex <= 201 && !this.hasErrorLine(this.currentRowIndex)) {
                this.parseRowDataGenerateFieldMsg(data);
                if (this.currentRowIndex == 201) {
                    this.handleNullCol();
                }
            }
            JSONObject rowEntity = new JSONObject();
            JSONObject rowObj = new JSONObject();
            this.parseRowData(row, rowEntity);
            rowObj.put("data", (Object)rowEntity);
            rowObj.put("rownum", (Object)this.currentRowIndex);
            this.addBillData(new ImportBillData(rowObj, this.currentRowIndex, this.currentRowIndex + 1, null));
        }
    }

    private void handleCsvHead(CSVRecord row) {
        int colIndex = 0;
        for (String head : row) {
            if (HRStringUtils.isEmpty((String)head)) continue;
            this.validateHandler.validateHeadName(head, this.heads, (int)row.getRecordNumber(), colIndex);
            ++colIndex;
            this.heads.add(head);
        }
        this.validateHandler.validateHeadCount(this.heads.size(), (int)row.getRecordNumber());
        this.buildFieldInfo();
    }

    private List<String> handleCsvData(CSVRecord csvRecord) {
        ArrayList data = Lists.newArrayListWithExpectedSize((int)this.heads.size());
        int colIndex = 0;
        boolean effective = false;
        for (String value : csvRecord) {
            if (colIndex >= this.heads.size()) break;
            if (HRStringUtils.isNotEmpty((String)value)) {
                value = value.trim();
            }
            if (!effective && HRStringUtils.isNotEmpty((String)value)) {
                effective = true;
                ++this.effectiveRowCount;
            }
            int recordNumber = (int)csvRecord.getRecordNumber();
            this.validateHandler.validateValueLength(value, recordNumber);
            this.importInfo.getFieldLengthMap().merge(colIndex, value.length(), Math::max);
            data.add(value);
            ++colIndex;
        }
        return data;
    }

    private void parseRowDataGenerateFieldMsg(List<String> data) {
        if (data.isEmpty()) {
            return;
        }
        for (int colIndex = 0; colIndex < data.size(); ++colIndex) {
            ReportDataStoreFieldBo fieldBo = (ReportDataStoreFieldBo)this.importInfo.getFields().get(colIndex);
            ReportDataStoreType dataType = this.getDataType(colIndex, data.get(colIndex));
            fieldBo.setType(dataType);
            this.setFieldProp(fieldBo);
        }
    }

    private void setFieldProp(ReportDataStoreFieldBo fieldBo) {
        ReportDataStoreType type = fieldBo.getType();
        if (type == null) {
            return;
        }
        switch (type) {
            case NVARCHAR: {
                fieldBo.setType(ReportDataStoreType.NVARCHAR);
                fieldBo.setDefaultVal((Object)"' '");
                fieldBo.setAllowNull(false);
                fieldBo.setLength(255);
                break;
            }
            case DECIMAL: {
                fieldBo.setDefaultVal((Object)"0");
                fieldBo.setAllowNull(false);
                break;
            }
            case DATETIME: {
                fieldBo.setDefaultVal(null);
                fieldBo.setAllowNull(true);
                break;
            }
        }
    }

    private void handleNullCol() {
        List fields = this.importInfo.getFields();
        for (ReportDataStoreFieldBo field : fields) {
            if (field.getType() != null) continue;
            field.setType(ReportDataStoreType.NVARCHAR);
            this.setFieldProp(field);
        }
    }

    private ReportDataStoreType getDataType(int index, String value) {
        ReportDataStoreType lastType = this.lastFieldTypeMap.get(index);
        if (lastType == ReportDataStoreType.NVARCHAR) {
            return ReportDataStoreType.NVARCHAR;
        }
        if (value == null || value.isEmpty()) {
            return lastType;
        }
        ReportDataStoreType currentType = ReportDataStoreType.NVARCHAR;
        if (NUMBER_PATTERN.matcher(value).matches()) {
            if (value.length() < 12) {
                currentType = ReportDataStoreType.DECIMAL;
            }
        } else if (!value.contains("E") && !value.contains("e")) {
            try {
                Date date = ReportFileSourceDateUtils.parseDate(value);
                if (date != null) {
                    currentType = ReportDataStoreType.DATETIME;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (lastType == null) {
            lastType = currentType;
            this.lastFieldTypeMap.put(index, lastType);
        }
        if (currentType == lastType) {
            return currentType;
        }
        this.lastFieldTypeMap.put(index, ReportDataStoreType.NVARCHAR);
        return ReportDataStoreType.NVARCHAR;
    }

    private void buildFieldInfo() {
        for (int i = 0; i < this.heads.size(); ++i) {
            ReportDataStoreFieldBo fieldBo = new ReportDataStoreFieldBo();
            String fieldName = this.heads.get(i);
            fieldBo.setFieldDisplayName(fieldName);
            fieldBo.setFieldName(FIELD_NAME_PREFIX + i);
            this.importInfo.getFields().add(fieldBo);
        }
    }

    private void parseRowData(CSVRecord row, JSONObject rowEntity) {
        for (int idx = 0; idx < this.heads.size(); ++idx) {
            String fieldName = ReportFileSourceService.getInstance().getFieldName(idx);
            String value = row.get(idx);
            JSONObject dataJson = new JSONObject();
            dataJson.put("originData", this.transferValue(value, idx));
            dataJson.put("stringData", (Object)this.transferStringValue(value));
            rowEntity.put(fieldName, (Object)dataJson);
        }
    }

    private Object transferValue(String value, int colIndex) {
        Object result = null;
        if (NUMBER_PATTERN.matcher(value).matches()) {
            result = value.length() > 11 ? value : Double.valueOf(Double.parseDouble(value));
        } else if (value.contains("E") || value.contains("e")) {
            try {
                BigDecimal bd = new BigDecimal(value);
                result = bd.toPlainString();
            }
            catch (Exception bd) {}
        } else {
            try {
                result = ReportFileSourceDateUtils.parseDate(value);
                if (result == null) {
                    throw new Exception();
                }
            }
            catch (Exception bd) {
                // empty catch block
            }
        }
        if (result == null) {
            result = value;
        }
        if (this.currentRowIndex > 201) {
            ReportDataStoreFieldBo dataStoreFieldBo = (ReportDataStoreFieldBo)this.importInfo.getFields().get(colIndex);
            if (this.getTypeByData(result) != dataStoreFieldBo.getType()) {
                if (dataStoreFieldBo.getType() == ReportDataStoreType.NVARCHAR) {
                    return value;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201d%1$s\u201c\u5217\u7684\u7b2c%2$s\u884c\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u524d200\u884c\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ReportFileSourceCsvHandler_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), dataStoreFieldBo.getFieldDisplayName(), this.currentRowIndex));
            }
        }
        return result;
    }

    private ReportDataStoreType getTypeByData(Object data) {
        if (data instanceof Double) {
            return ReportDataStoreType.DECIMAL;
        }
        if (data instanceof String) {
            return ReportDataStoreType.NVARCHAR;
        }
        if (data instanceof Date) {
            return ReportDataStoreType.DATETIME;
        }
        return null;
    }

    private String transferStringValue(String value) {
        String result = value;
        if (value.contains("E") || value.contains("e")) {
            try {
                BigDecimal bd = new BigDecimal(value);
                result = bd.toPlainString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"ReportFileSourceCsvHandler_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"ReportFileSourceCsvHandler_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean hasErrorLine(int rowNum) {
        Set errorExcelLineSet = this.importLogger.getLogCache().keySet();
        return !CollectionUtils.isEmpty(errorExcelLineSet) && errorExcelLineSet.contains(rowNum);
    }

    @Override
    public void endDocument() {
        this.ctx.setResolveComplete(this.url);
        this.validateHandler.validateSheetIsEmpty(this.effectiveRowCount);
        this.handleNullCol();
    }
}

