/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource.excel;

import java.io.IOException;
import java.io.InputStream;
import kd.hr.hrptmc.formplugin.web.filesource.excel.AbstractExcelHandler;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportFileExcelReader {
    public void read(InputStream inputStream, String fileName, AbstractExcelHandler handler) throws IOException {
        if (fileName.endsWith(".xlsx")) {
            this.handleXlsX(inputStream, handler);
        } else if (fileName.endsWith(".xls")) {
            this.handleXls(inputStream, handler);
        }
        handler.endDocument();
    }

    private void handleXlsX(InputStream inputStream, AbstractExcelHandler handler) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        this.handleSheet((Workbook)workbook, handler);
    }

    private void handleXls(InputStream inputStream, AbstractExcelHandler handler) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
        this.handleSheet((Workbook)workbook, handler);
    }

    private void handleSheet(Workbook workbook, AbstractExcelHandler handler) {
        Sheet sheet = workbook.getSheetAt(0);
        handler.startDocument(sheet);
        int rowCount = sheet.getPhysicalNumberOfRows();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            handler.handle(sheet.getRow(rowIndex));
        }
    }
}

