/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreFieldBo;
import kd.hr.hrptmc.business.datastore.physicaltable.model.ReportDataStoreType;
import kd.hr.hrptmc.business.filesource.ReportFileSourceImportInfo;
import kd.hr.hrptmc.business.filesource.ReportFileSourceService;
import kd.hr.hrptmc.formplugin.web.filesource.ReportFileSourceValidateHandler;
import kd.hr.hrptmc.formplugin.web.filesource.util.ReportFileSourceDateUtils;

public class ReportFileSourceReadListener
implements ReadListener<Map<Integer, String>> {
    private final ImportContext conf;
    private final String url;
    private final LinkedBlockingQueue<ImportBillData> dataQueue;
    private final ImportLogger importLogger;
    private final ReportFileSourceImportInfo importInfo;
    private int currentRowIndex = 0;
    private int lastStartRowNum = 0;
    private final Map<Integer, String> headMap = Maps.newHashMapWithExpectedSize((int)16);
    private final ReportFileSourceValidateHandler validateHandler;
    private int effectiveRowCount = 0;
    private static final String FIELD_NAME_PREFIX = "field";
    private final Map<Integer, ReportDataStoreType> lastFieldTypeMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");

    public ReportFileSourceReadListener(ImportContext conf, String path, ReportFileSourceImportInfo importInfo, ImportLogger importLogger) {
        this.conf = conf;
        this.url = path;
        this.dataQueue = this.conf.getDataQueue(this.url);
        this.importLogger = importLogger;
        this.importInfo = importInfo;
        this.validateHandler = new ReportFileSourceValidateHandler(importLogger);
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        this.importLogger.setTotal(context.readSheetHolder().getApproximateTotalRowNumber().intValue());
        ArrayList heads = Lists.newArrayListWithCapacity((int)10);
        headMap.forEach((colIndex, head) -> {
            String headStr;
            String string = headStr = HRStringUtils.isNotEmpty((String)head.getStringValue()) ? head.getStringValue() : String.valueOf(head.getNumberValue());
            if (HRStringUtils.isNotEmpty((String)headStr)) {
                this.validateHandler.validateHeadName(headStr, heads, 0, (int)colIndex);
                heads.add(headStr);
                this.headMap.put((Integer)colIndex, headStr);
                ReportDataStoreFieldBo fieldBo = new ReportDataStoreFieldBo();
                fieldBo.setFieldDisplayName(headStr);
                fieldBo.setFieldName(FIELD_NAME_PREFIX + colIndex);
                this.importInfo.getFields().add(fieldBo);
            }
        });
        this.validateHandler.validateHeadIsEmpty(this.headMap.values());
        this.validateHandler.validateHeadCount(headMap.size(), 0);
    }

    public void invoke(Map<Integer, String> row, AnalysisContext analysisContext) {
        if (this.headMap.size() == 0) {
            return;
        }
        Map cellMap = analysisContext.readSheetHolder().getCellMap();
        this.currentRowIndex = analysisContext.readSheetHolder().getRowIndex();
        this.validateRow(cellMap, row);
        if (this.currentRowIndex <= 200 && !this.hasErrorLine(this.currentRowIndex)) {
            this.parseRowDataGenerateFieldMsg(cellMap, row);
            if (this.currentRowIndex == 200) {
                this.handleNullCol();
            }
        }
        JSONObject rowEntity = new JSONObject();
        if (!this.hasErrorLine(this.currentRowIndex)) {
            JSONObject rowObj = new JSONObject();
            this.parseRowData(cellMap, row, rowEntity);
            rowObj.put("data", (Object)rowEntity);
            rowObj.put("rownum", (Object)this.currentRowIndex);
            this.addBillData(new ImportBillData(rowObj, this.currentRowIndex, this.currentRowIndex + 1, null));
        }
    }

    private void handleNullCol() {
        List fields = this.importInfo.getFields();
        for (ReportDataStoreFieldBo field : fields) {
            if (field.getType() != null) continue;
            field.setType(ReportDataStoreType.NVARCHAR);
            this.setFieldProp(field);
        }
    }

    private void validateRow(Map<Integer, Cell> cellMap, Map<Integer, String> row) {
        boolean effective = false;
        for (Map.Entry<Integer, Cell> cellEntry : cellMap.entrySet()) {
            Cell cell = cellEntry.getValue();
            if (cell == null) continue;
            String stringValue = row.get(cellEntry.getKey());
            if (!effective && HRStringUtils.isNotEmpty((String)stringValue)) {
                effective = true;
                ++this.effectiveRowCount;
            }
            this.validateHandler.validateContainsFormula(cell);
            if (stringValue == null) continue;
            this.validateHandler.validateValueLength(stringValue, cell.getRowIndex());
            this.importInfo.getFieldLengthMap().merge(cell.getColumnIndex(), stringValue.length(), Math::max);
        }
    }

    public void extra(CellExtra extra, AnalysisContext context) {
        if (extra.getType() == CellExtraTypeEnum.MERGE) {
            this.importLogger.log(extra.getRowIndex(), String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u7b2c%s\u884c\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", (String)"ReportFileSourceReadListener_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), extra.getFirstRowIndex()));
        }
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.conf.setResolveComplete(this.url);
        this.validateHandler.validateSheetIsEmpty(this.effectiveRowCount);
        this.handleNullCol();
    }

    private void parseRowDataGenerateFieldMsg(Map<Integer, Cell> cellMap, Map<Integer, String> row) {
        if (this.importInfo.getFields().isEmpty()) {
            return;
        }
        for (int colIndex = 0; colIndex < this.headMap.size(); ++colIndex) {
            Cell cell = cellMap.get(colIndex);
            ReportDataStoreFieldBo fieldBo = (ReportDataStoreFieldBo)this.importInfo.getFields().get(colIndex);
            String stringValue = row.get(colIndex);
            ReportDataStoreType dataType = this.getDataType(colIndex, cell, stringValue);
            fieldBo.setType(dataType);
            this.setFieldProp(fieldBo);
        }
    }

    private ReportDataStoreType getDataType(int index, Cell cell, String stringValue) {
        ReadCellData cellData = (ReadCellData)cell;
        ReportDataStoreType lastType = this.lastFieldTypeMap.get(index);
        if (lastType == ReportDataStoreType.NVARCHAR) {
            return ReportDataStoreType.NVARCHAR;
        }
        if (cell == null) {
            return lastType;
        }
        ReportDataStoreType currentType = ReportDataStoreType.NVARCHAR;
        if (cellData.getType() == CellDataTypeEnum.NUMBER) {
            Date date = null;
            try {
                date = ReportFileSourceDateUtils.parseDate(stringValue);
                if (date == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (date == null) {
                if (stringValue.length() < 12) {
                    currentType = ReportDataStoreType.DECIMAL;
                }
            } else {
                currentType = ReportDataStoreType.DATETIME;
            }
        } else if (cellData.getType() == CellDataTypeEnum.DATE) {
            currentType = ReportDataStoreType.DATETIME;
        }
        if (lastType == null) {
            lastType = currentType;
            this.lastFieldTypeMap.put(index, lastType);
        }
        if (currentType == lastType) {
            return currentType;
        }
        this.lastFieldTypeMap.put(index, ReportDataStoreType.NVARCHAR);
        return ReportDataStoreType.NVARCHAR;
    }

    private void setFieldProp(ReportDataStoreFieldBo fieldBo) {
        ReportDataStoreType type = fieldBo.getType();
        if (type == null) {
            return;
        }
        switch (type) {
            case NVARCHAR: {
                fieldBo.setType(ReportDataStoreType.NVARCHAR);
                fieldBo.setDefaultVal((Object)"' '");
                fieldBo.setAllowNull(false);
                fieldBo.setLength(255);
                break;
            }
            case DECIMAL: {
                fieldBo.setDefaultVal((Object)"0");
                fieldBo.setAllowNull(false);
                break;
            }
            case DATETIME: {
                fieldBo.setDefaultVal(null);
                fieldBo.setAllowNull(true);
                break;
            }
        }
    }

    private void parseRowData(Map<Integer, Cell> cellMap, Map<Integer, String> row, JSONObject rowEntity) {
        for (Map.Entry<Integer, String> headEntry : this.headMap.entrySet()) {
            Integer idx = headEntry.getKey();
            String fieldName = ReportFileSourceService.getInstance().getFieldName(idx.intValue());
            Object data = this.transferData(cellMap.get(idx), row.get(idx));
            JSONObject dataJson = new JSONObject();
            dataJson.put("originData", data);
            dataJson.put("stringData", (Object)row.get(idx));
            rowEntity.put(fieldName, (Object)dataJson);
        }
    }

    private Object transferData(Cell cell, String stringValue) {
        if (cell == null) {
            return null;
        }
        ReadCellData readCellData = (ReadCellData)cell;
        Object result = null;
        CellDataTypeEnum cellType = readCellData.getType();
        if (cellType == CellDataTypeEnum.NUMBER) {
            try {
                result = ReportFileSourceDateUtils.parseDate(stringValue);
                if (result == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                result = stringValue.length() > 11 ? stringValue : Double.valueOf(readCellData.getNumberValue().doubleValue());
            }
        } else if (cellType == CellDataTypeEnum.DATE) {
            try {
                result = ReportFileSourceDateUtils.parseDate(stringValue);
                if (result == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = stringValue;
        }
        if (this.currentRowIndex > 200) {
            ReportDataStoreFieldBo dataStoreFieldBo = (ReportDataStoreFieldBo)this.importInfo.getFields().get(cell.getColumnIndex());
            if (result != null && this.getTypeByData(result) != dataStoreFieldBo.getType()) {
                if (dataStoreFieldBo.getType() == ReportDataStoreType.NVARCHAR) {
                    return stringValue;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201d%1$s\u201c\u5217\u7684\u7b2c%2$s\u884c\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u524d200\u884c\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ReportFileSourceReadListener_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), dataStoreFieldBo.getFieldDisplayName(), this.currentRowIndex));
            }
        }
        return result;
    }

    private ReportDataStoreType getTypeByData(Object data) {
        if (data instanceof Double) {
            return ReportDataStoreType.DECIMAL;
        }
        if (data instanceof String) {
            return ReportDataStoreType.NVARCHAR;
        }
        if (data instanceof Date) {
            return ReportDataStoreType.DATETIME;
        }
        return null;
    }

    private boolean hasErrorLine(Integer rowIndex) {
        Set errorExcelLineSet = this.importLogger.getLogCache().keySet();
        return !CollectionUtils.isEmpty(errorExcelLineSet) && errorExcelLineSet.contains(rowIndex);
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"ReportFileSourceReadListener_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"ReportFileSourceReadListener_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 500) {
            this.conf.feedbackProgress(0, this.conf.getLogger(this.url), null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }
}

