/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.filesource.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class ReportFileSourceDateUtils {
    private static final Pattern ZH_CN_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static final Log LOGGER = LogFactory.getLog(HRDateTimeUtils.class);

    public static Date parseDate(String dateStr) throws ParseException {
        if (ZH_CN_PATTERN.matcher(dateStr).find()) {
            dateStr = dateStr.replaceAll("\\u5e74", "-");
            dateStr = dateStr.replaceAll("\\u6708", "-");
            dateStr = dateStr.replaceAll("\\u65e5", "");
            dateStr = dateStr.replaceAll("\\u65f6", ":");
            dateStr = dateStr.replaceAll("\\u5206", ":");
            dateStr = dateStr.replaceAll("\\u79d2", "");
        }
        return ReportFileSourceDateUtils.doParseDate(dateStr);
    }

    private static Date doParseDate(String str) throws ParseException {
        try {
            return ReportFileSourceDateUtils.parseDate(str, "yyyy/MM/dd");
        }
        catch (ParseException parseException) {
            try {
                return ReportFileSourceDateUtils.parseDate(str, "yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException parseException2) {
                try {
                    return ReportFileSourceDateUtils.parseDate(str, "yyyy-MM-dd");
                }
                catch (ParseException parseException3) {
                    try {
                        return ReportFileSourceDateUtils.parseDate(str, "yyyy/MM/dd HH:mm:ss");
                    }
                    catch (ParseException parseException4) {
                        try {
                            return ReportFileSourceDateUtils.parseDate(str, "yyyy/MM");
                        }
                        catch (ParseException parseException5) {
                            try {
                                return ReportFileSourceDateUtils.parseDate(str, "yyyy-MM");
                            }
                            catch (ParseException parseException6) {
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }

    private static Date parseDate(String dateStr, String pattern) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.parse(dateStr);
    }
}

