/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.common.util.HRImpDuplicateData;

public class HReportCorrectImportPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HReportCorrectImportPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirmbtn"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        switch (((Control)evt.getSource()).getKey()) {
            case "confirmbtn": {
                this.startImporting();
                break;
            }
        }
    }

    private boolean startImporting() {
        try {
            IFormView view = this.getView();
            view.getFormShowParameter().getCustomParams();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrptmc_configimporting");
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            Map params = view.getFormShowParameter().getCustomParams();
            String importType = (String)this.getModel().getValue("importtype");
            if (HRStringUtils.isEmpty((String)importType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5904\u7406\u65b9\u5f0f\u3002", (String)"HReportCorrectImportPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return false;
            }
            params.put("importtype", importType);
            params.put("anObjIsTemplate", view.getFormShowParameter().getCustomParam("anObjIsTemplate"));
            showParameter.setCustomParams(params);
            view.showForm(showParameter);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONArray duplicateDataSetArr = (JSONArray)view.getFormShowParameter().getCustomParam("duplicateDataSet");
        try {
            List dataList = duplicateDataSetArr.stream().map(obj -> (HRImpDuplicateData)SerializationUtils.fromJsonString((String)((JSON)obj).toJSONString(), HRImpDuplicateData.class)).collect(Collectors.toList());
            if (dataList.size() > 1) {
                this.getModel().batchCreateNewEntryRow("correctlist", dataList.size() - 1);
            }
            int i = 0;
            for (HRImpDuplicateData data : dataList) {
                this.getModel().setValue("originid", (Object)data.getId(), i);
                this.getModel().setValue("originumber", (Object)data.getNumber(), i);
                this.getModel().setValue("originame", (Object)data.getName(), i);
                this.getModel().setValue("correctfield", (Object)data.getDesc(), i);
                ++i;
            }
            view.updateView("correctlist");
            Label label = (Label)this.getView().getControl("tips");
            String entityName = (String)view.getFormShowParameter().getCustomParam("entityName");
            String text = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4ee5\u4e0b%1$s\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u5b9a\u91cd\u590d\u6570\u636e\u7684\u5904\u7406\u65b9\u5f0f\uff1a", (String)"HReportCorrectImportPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), entityName);
            label.setText(text);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            view.showErrorNotification(ex.getMessage());
        }
    }
}

