/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.imp.pre.HReportPreImportFailedSheetHandler;
import kd.hr.hrptmc.business.imp.pre.HReportPreImportSheetHandler;
import kd.hr.hrptmc.common.util.HRImpDuplicateData;
import kd.hr.hrptmc.common.util.ImportFileUtil;

public class HReportImportStartPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(HReportImportStartPlugin.class);
    private final Map<String, ImportLogger> importLoggerMap = Maps.newHashMap();
    private static final String CURRENT_STATUS = "currentStatus";
    private static final String INIT = "init";
    private static final String UPLOAD = "upload";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnstart", "btnstop", "btnreupload"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("fileupload");
        attachmentPanel.addUploadListener((UploadListener)this);
        Button btnreupload = (Button)this.getView().getControl("btnreupload");
        btnreupload.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.statusControlDisplay(INIT);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            return;
        }
        IDataModel model = this.getModel();
        String fileName = "";
        String fileSize = "";
        String serverUrl = "";
        String clientUrl = "";
        try {
            if (urls[0] instanceof Map) {
                Map map = (Map)urls[0];
                clientUrl = String.valueOf(map.get("url"));
                fileName = String.valueOf(map.get("name"));
                fileSize = String.valueOf(map.get("size"));
                serverUrl = ImportFileUtil.downloadTempFile((String)clientUrl);
            } else {
                this.statusControlDisplay(INIT);
                serverUrl = String.valueOf(urls[0]);
                if (serverUrl.lastIndexOf("/") != -1) {
                    fileName = serverUrl.substring(serverUrl.lastIndexOf("/") + 1);
                }
            }
            model.setValue("filename", (Object)fileName);
            model.setValue("filesize", (Object)fileSize);
            model.setValue("serverUrl", (Object)serverUrl);
            model.setValue("clienturl", (Object)clientUrl);
            this.displayFilename(fileName);
            this.startImport();
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            this.getView().showErrorNotification(exception.getMessage());
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnreupload": {
                this.statusControlDisplay(INIT);
                break;
            }
            case "btnstart": {
                this.startImport();
                break;
            }
            case "lblfilename1": {
                this.getView().download((String)this.getModel().getValue("clientUrl"));
                break;
            }
        }
    }

    private List<HRImpDuplicateData> queryDuplicateNumber(String formId, List<HRImpDuplicateData> originNumberList) {
        if (CollectionUtils.isEmpty(originNumberList)) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        QFilter qFilter = new QFilter("number", "in", (Object)originNumberList.stream().map(data -> data.getNumber()).toArray());
        if (HRStringUtils.equals((String)formId, (String)"hrptmc_analyseobject")) {
            QFilter nameQFilter = new QFilter("name", "in", (Object)originNumberList.stream().map(data -> data.getName()).toArray());
            Boolean isTemplate = (Boolean)this.getView().getFormShowParameter().getCustomParam("anObjIsTemplate");
            if (isTemplate != null && isTemplate.booleanValue()) {
                nameQFilter.and(new QFilter("objecttype", "=", (Object)"template"));
            } else {
                nameQFilter.and(new QFilter("objecttype", "!=", (Object)"template"));
            }
            qFilter.or(nameQFilter);
        } else {
            qFilter.or(new QFilter("name", "in", (Object)originNumberList.stream().map(data -> data.getName()).toArray()));
        }
        DynamicObject[] dynamicObjectArr = helper.query("id,number,name", qFilter.toArray());
        if (dynamicObjectArr == null || dynamicObjectArr.length == 0) {
            return null;
        }
        List<HRImpDuplicateData> queryNumberList = Arrays.stream(dynamicObjectArr).map(dynamic -> {
            HRImpDuplicateData duplicateData = new HRImpDuplicateData();
            duplicateData.setDistId(dynamic.getString("id"));
            duplicateData.setDistNumber(dynamic.getString("number"));
            duplicateData.setDistName(dynamic.getString("name"));
            originNumberList.stream().forEach(data -> {
                String desc = null;
                String dataIdDesc = null;
                if (HRStringUtils.equalsIgnoreCase((String)data.getNumber(), (String)duplicateData.getDistNumber()) && HRStringUtils.equalsIgnoreCase((String)data.getName(), (String)duplicateData.getDistName())) {
                    desc = ResManager.loadKDString((String)"\u7f16\u7801\u548c\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u3002", (String)"HReportImportStartPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
                    dataIdDesc = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s/\u540d\u79f0\u4e3a%2$s", (String)"HReportImportStartPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), data.getNumber(), data.getName());
                    this.checkDataID(duplicateData, (HRImpDuplicateData)data, dataIdDesc);
                } else if (HRStringUtils.equalsIgnoreCase((String)data.getNumber(), (String)duplicateData.getDistNumber())) {
                    desc = ResManager.loadKDString((String)"\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u3002", (String)"HReportImportStartPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
                    dataIdDesc = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s", (String)"HReportImportStartPlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), data.getNumber());
                    this.checkDataID(duplicateData, (HRImpDuplicateData)data, dataIdDesc);
                } else if (HRStringUtils.equalsIgnoreCase((String)data.getName(), (String)duplicateData.getDistName())) {
                    desc = ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"HReportImportStartPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
                    dataIdDesc = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540d\u79f0\u4e3a%1$s", (String)"HReportImportStartPlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), data.getName());
                    this.checkDataID(duplicateData, (HRImpDuplicateData)data, dataIdDesc);
                }
                if (HRStringUtils.isNotEmpty((String)desc)) {
                    this.rebuildDuplicateData(duplicateData, (HRImpDuplicateData)data, desc);
                    return;
                }
            });
            return duplicateData;
        }).collect(Collectors.toList());
        return queryNumberList;
    }

    private void checkDataID(HRImpDuplicateData duplicateData, HRImpDuplicateData data, String dataIdDesc) {
        if (!HRStringUtils.equalsIgnoreCase((String)data.getId(), (String)duplicateData.getDistId())) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u201c%1$s\u201d\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u91cd\u590d\u5bfc\u5165\u3002", (String)"HReportImportStartPlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), dataIdDesc));
        }
    }

    private void rebuildDuplicateData(HRImpDuplicateData duplicateData, HRImpDuplicateData data, String desc) {
        duplicateData.setId(data.getId());
        duplicateData.setNumber(data.getNumber());
        duplicateData.setName(data.getName());
        duplicateData.setDesc(desc);
    }

    private void startImport() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        String fileName = (String)this.getModel().getValue("filename");
        ArrayList originNumberList = Lists.newArrayListWithExpectedSize((int)10);
        String serverUrl = (String)this.getModel().getValue("serverUrl");
        try {
            if (!StringUtils.isNotBlank((CharSequence)serverUrl)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"HReportImportStartPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            this.parseExcel(formId, serverUrl, originNumberList);
            if (!this.importLoggerMap.containsKey(formId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u5bfc\u5165\u53e3\u3002", (String)"HReportImportStartPlugin_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.importLoggerMap.containsKey("hrptmc_workreport") && HRStringUtils.equals((String)formId, (String)"hrptmc_reportmanage")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u65e7\u7248\u672c\u62a5\u8868\u914d\u7f6e\u5df2\u4e0d\u88ab\u652f\u6301\u3002", (String)"HReportImportStartPlugin_11", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            List<HRImpDuplicateData> queryNumberList = this.queryDuplicateNumber(formId, originNumberList);
            String clientUrl = (String)this.getModel().getValue("clienturl");
            if (CollectionUtils.isEmpty(queryNumberList)) {
                this.startImporting(serverUrl, clientUrl, fileName);
            } else {
                this.startCorrectImport(serverUrl, clientUrl, fileName, queryNumberList);
            }
        }
        catch (Exception ex) {
            LOGGER.error("startImport_error", (Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void parseExcel(String formId, String url, List<HRImpDuplicateData> originNumberList) throws Exception {
        String listName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        Object logId = ImportLogHelper.create((String)ImportDataTask.getCacheKey((String)formId, (String)this.getView().getPageId()), (String)listName);
        this.getPageCache().put("logId", logId.toString());
        ImportContext ctx = new ImportContext(this.getView(), logId, "hrptmc", null, listName, formId, null, url);
        ExcelReader excelReader = new ExcelReader();
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(url);){
            excelReader.read(in, (SheetHandler)new HReportPreImportSheetHandler(ctx, url, this.importLoggerMap, originNumberList));
        }
        HashMap retdata = Maps.newHashMapWithExpectedSize((int)16);
        retdata.put("complete", Boolean.TRUE);
        retdata.put("info", ctx.getUrlLoggers());
        int total = 0;
        int failed = 0;
        for (Map.Entry<String, ImportLogger> loggerEntry : this.importLoggerMap.entrySet()) {
            ImportLogger logger = loggerEntry.getValue();
            total += logger.getTotal();
            failed += logger.getLogCache().size();
            HashMap sheetResult = Maps.newHashMapWithExpectedSize((int)2);
            sheetResult.put("sheetTotal", logger.getTotal());
            sheetResult.put("sheetFailed", logger.getLogCache().size());
            retdata.put(loggerEntry.getKey(), sheetResult);
        }
        if (failed > 0) {
            this.outputFailedData(ctx, url, ctx.getLogger(url));
            ImportLogHelper.logAll((Object)ctx.getLogId(), (String)JSON.toJSONString((Object)retdata), (int)total, (int)failed);
            JSONObject map = new JSONObject();
            map.put("total", (Object)total);
            map.put("succeed", (Object)(total - failed));
            map.put("failed", (Object)failed);
            this.validateFail(map, formId, this.getView().getPageId());
        }
    }

    private void validateFail(JSONObject info, String formId, String pageId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_validatefail");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setCustomParam("validateInfo", (Object)info);
        showParameter.setCustomParam("formId", (Object)formId);
        String menuEntityName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        showParameter.setCustomParam("entityName", (Object)menuEntityName);
        showParameter.setCustomParam("vid", (Object)pageId);
        this.getView().showForm(showParameter);
    }

    private void outputFailedData(ImportContext ctx, String url, ImportLogger importLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new HReportPreImportFailedSheetHandler(ctx, importLogger, service, this.importLoggerMap));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void removeAttachmentPanel(IFormView view) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("fileupload");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)attachmentData)) {
            attachmentPanel.remove((Map)attachmentData.get(0));
        }
    }

    private void statusControlDisplay(String type) {
        LOGGER.info("statusControlDisplay=" + type);
        switch (type) {
            case "init": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefleupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flestate"});
                this.getModel().setValue("serverUrl", (Object)"");
                this.getModel().setValue("clienturl", (Object)"");
                this.removeAttachmentPanel(this.getView());
                this.getPageCache().put(CURRENT_STATUS, INIT);
                break;
            }
            case "upload": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnstart"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinishedupload", "btnreupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "btnstop", "btnbackground"});
                this.getPageCache().put(CURRENT_STATUS, UPLOAD);
                break;
            }
        }
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("formId");
    }

    private boolean startImporting(String url, String clientUrl, String fileName) {
        IFormView view = this.getView();
        if (HRStringUtils.isEmpty((String)url)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u3002", (String)"HReportImportStartPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        try {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrptmc_configimporting");
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            params.put("importtype", "1");
            params.put("serverUrl", url);
            params.put("clienturl", clientUrl);
            params.put("filename", fileName);
            params.put("formId", view.getFormShowParameter().getCustomParam("formId"));
            params.put("anObjIsTemplate", view.getFormShowParameter().getCustomParam("anObjIsTemplate"));
            params.put("entityName", view.getFormShowParameter().getCustomParam("entityName"));
            showParameter.setCustomParams((Map)params);
            showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
            view.showForm(showParameter);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            view.showErrorNotification(ex.getMessage());
        }
        return true;
    }

    private boolean startCorrectImport(String url, String clientUrl, String fileName, List<HRImpDuplicateData> queryNumberList) {
        IFormView view = this.getView();
        if (HRStringUtils.isEmpty((String)url)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u3002", (String)"HReportImportStartPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        try {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrptmc_correctimport");
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            params.put("serverUrl", url);
            params.put("clienturl", clientUrl);
            params.put("filename", fileName);
            params.put("formId", view.getFormShowParameter().getCustomParam("formId"));
            params.put("entityName", view.getFormShowParameter().getCustomParam("entityName"));
            params.put("anObjIsTemplate", view.getFormShowParameter().getCustomParam("anObjIsTemplate"));
            params.put("duplicateDataSet", queryNumberList);
            showParameter.setCustomParams((Map)params);
            showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
            view.showForm(showParameter);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            view.showErrorNotification(ex.getMessage());
        }
        return true;
    }

    private void displayFilename(String filename) {
        Label lblfilename1 = (Label)this.getControl("lblfilename1");
        lblfilename1.setText(filename);
    }
}

