/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.imp.HReportImportPlugin;
import kd.hr.hrptmc.business.imp.HReportImportUtil;
import kd.hr.hrptmc.business.imp.model.ReportImportDetailVo;

public class HReportImportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String BTNSUSPEND = "btnsuspend";
    private static final String PROGRESSBARAP = "progressbarap";
    public static int THREAD_COUNT;
    private static final Log LOGGER;
    public final Object syncLock = new Object();
    private final HReportImportPlugin importPlugin = new HReportImportPlugin();
    protected static ThreadPool threadPool;

    public void initialize() {
        this.addClickListeners(new String[]{"btndetails", "btnresult", BTNSUSPEND});
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter params = this.getView().getFormShowParameter();
        String url = (String)params.getCustomParam("serverUrl");
        String importType = (String)params.getCustomParam("importtype");
        String billFormId = (String)params.getCustomParam("formId");
        this.getView().getFormShowParameter().setCustomParam("BillFormId", (Object)billFormId);
        this.displayFilename(params);
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        IAppCache appCache = AppCache.get((String)"HRPTMC");
        appCache.put("notify", (Object)"false");
        try {
            progress.start();
            String listName = (String)params.getCustomParam("entityName");
            Object logId = ImportLogHelper.create((String)ImportDataTask.getCacheKey((String)billFormId, (String)this.getView().getPageId()), (String)listName);
            this.getPageCache().put("logId", logId.toString());
            RequestContext rc = RequestContext.get();
            ImportContext ctx = new ImportContext(this.getView(), logId, "hrptmc", null, listName, billFormId, null, url).addOption("importtype", (Object)importType);
            Object duplicateDataSet = params.getCustomParam("duplicateDataSet");
            if (duplicateDataSet != null) {
                ctx.addOption("duplicateDataSet", duplicateDataSet);
            }
            ctx.addOption("anObjIsTemplate", params.getCustomParam("anObjIsTemplate"));
            this.importPlugin.setContext(rc, ctx, Arrays.asList("resolveExcel", "importData"));
            threadPool.submit((Callable)this.importPlugin);
            threadPool.submit((Callable)this.importPlugin);
        }
        catch (Throwable ex) {
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"HReportImportingPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
        }
    }

    private void displayFilename(FormShowParameter params) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "okbtn", "buttonap", BTNSUSPEND});
        this.getModel().setValue("clienturl", params.getCustomParam("filename"));
        Label lblfilename1 = (Label)this.getControl("lblfilename1");
        lblfilename1.setText((String)params.getCustomParam("filename"));
    }

    public void onProgress(ProgressEvent evt) {
        JSONObject info;
        int importProgress = 0;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Logger");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Cached_Import_Logger<----" + cacheLogStr);
        }
        if ((info = JSON.parseObject((String)cacheLogStr)) != null) {
            IAppCache appCache;
            String handleResult;
            importProgress = info.getIntValue("progress");
            if (importProgress < 0) {
                this.importProgressError(info);
                return;
            }
            String baseDataIdStr = (String)this.getAppCache().get(HReportImportUtil.getImportCacheKeySuffix((String)"HR_REPORT_IMP_BaseDataId"), String.class);
            String baseDataIdPageIsOpen = this.getView().getPageCache().get("BaseDataIdPageIsOpen");
            if (!HRStringUtils.equals((String)baseDataIdPageIsOpen, (String)"true") && HRStringUtils.isNotEmpty((String)baseDataIdStr)) {
                this.openHandleBaseDataIdPage(baseDataIdStr);
            }
            if (HRStringUtils.isNotEmpty((String)(handleResult = (String)(appCache = AppCache.get((String)"HRPTMC")).get(HReportImportUtil.getImportCacheKeySuffix((String)"HR_REPORT_IMP_baseDataIdResult"), String.class)))) {
                appCache.put("notify", (Object)"true");
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{BTNSUSPEND});
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handleCount = (Label)this.getControl("handlecount");
            int row = info.getIntValue("rowindex") - 2;
            int lastRow = info.getIntValue("lastrowindex") - 3;
            int total = info.getIntValue("total");
            int succeed = info.getIntValue("succeed");
            if (row >= 0) {
                currRow.setText("" + row);
                rowCount.setText("" + lastRow);
            }
            handleCount.setText("" + total);
            if (importProgress >= 100) {
                this.importProgressDone(info, succeed);
            }
            if (lastRow > 0) {
                this.importProcessing();
            }
        }
        evt.setProgress(importProgress);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String cancelImportFlag;
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)"handleBaseDataId", (String)evt.getActionId()) && HRStringUtils.equals((String)(cancelImportFlag = this.getView().getPageCache().get("cancelImport")), (String)"true")) {
            this.getAppCache().put(this.getSuspendKey(), (Object)this.getSuspendKey());
            this.getAppCache().put("notify", (Object)"true");
            this.getView().close();
        }
    }

    private void importProgressFinish(JSONObject info) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrptmc_validatefail");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setCustomParam("validateInfo", (Object)info);
        String menuFormId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        showParameter.setCustomParam("formId", (Object)menuFormId);
        String menuEntityName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        showParameter.setCustomParam("entityName", (Object)menuEntityName);
        showParameter.setCustomParam("vid", (Object)this.getView().getPageId());
        this.getView().showForm(showParameter);
    }

    private void openHandleBaseDataIdPage(String baseDataIdStr) {
        this.getView().getPageCache().put("BaseDataIdPageIsOpen", "true");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hrptmc_bdimportconfirm");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u786e\u8ba4", (String)"HReportImportingPlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(style);
        formShowParameter.setCustomParam("baseDataBoSet", (Object)baseDataIdStr);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "handleBaseDataId"));
        this.getView().showForm(formShowParameter);
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btndetails".equals(controlKey)) {
            this.detailClick();
        } else if ("lblfilename1".equals(controlKey)) {
            this.getView().download((String)this.getModel().getValue("clientUrl"));
        } else if (BTNSUSPEND.equals(controlKey)) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HReportImportingPlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.getAppCache().put(this.getSuspendKey(), (Object)this.getSuspendKey());
            this.getView().close();
        }
    }

    private String getSuspendKey() {
        String logId = this.getPageCache().get("logId");
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        return "IMPT_SUSPEND_" + billFormId + "_" + logId;
    }

    private IAppCache getAppCache() {
        return AppCache.get((String)"HRPTMC");
    }

    private void detailClick() {
        String jsonData;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        DynamicObject taskData = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ImportDataTask.getCacheKey((String)entityId, (String)this.getView().getPageId()))});
        if (taskData != null && !StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
            JSONObject data = JSON.parseObject((String)jsonData);
            try {
                JSONObject info = data.getJSONObject("info");
                for (Object obj : info.values()) {
                    this.downloadDetail(obj);
                }
            }
            catch (Exception var8) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\u3002\u53ef\u80fd\u662f\u56e0\u4e3a\u65e5\u5fd7\u683c\u5f0f\u592a\u65e7\uff0c\u8bf7\u624b\u52a8\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u5730\u5740\u5e76\u5728\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"HReportImportingPlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"HReportImportingPlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
    }

    private void downloadDetail(Object obj) {
        ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
            proxy.addAction("download", (Object)(logger.getErrFile() + "&a=t"));
        } else {
            this.detailClickErrorShow(logger);
        }
    }

    private void detailClickErrorShow(ImportLogger logger) {
        if (logger.getFailed() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"HReportImportingPlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        } else {
            String msg = logger.toString().trim();
            if (!msg.isEmpty()) {
                this.getView().showErrorNotification(msg);
            }
        }
    }

    private void importProgressError(JSONObject info) {
        String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u8fdb\u5ea6\u6761\u5931\u8d25", (String)"HReportImportingPlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(err);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.stop();
    }

    private void importProgressDone(JSONObject info, int succeed) {
        String jsonData;
        if (succeed < 0) {
            succeed = 0;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel", BTNSUSPEND});
        int failed = info.getIntValue("failed");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        DynamicObject taskData = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ImportDataTask.getCacheKey((String)entityId, (String)this.getView().getPageId()))});
        JSONObject dataCount = null;
        if (taskData != null && !StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
            JSONObject data = JSON.parseObject((String)jsonData);
            dataCount = data.getJSONObject("dataCount");
        }
        boolean ignore = false;
        if (dataCount != null) {
            ignore = dataCount.values().stream().anyMatch(value -> {
                String valueStr = SerializationUtils.toJsonString((Object)value);
                ReportImportDetailVo detailVo = (ReportImportDetailVo)SerializationUtils.fromJsonString((String)valueStr, ReportImportDetailVo.class);
                return HRStringUtils.isNotEmpty((String)detailVo.getErrMsg());
            });
        }
        if (failed == 0 || ignore) {
            Label successLabel = (Label)this.getControl("successall");
            successLabel.setText("" + succeed);
            this.getView().setVisible(Boolean.TRUE, new String[]{"successpanel"});
            HashMap notHidden = Maps.newHashMap();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata("successpanel", (Map)notHidden);
            this.openImportCompletePage(dataCount);
        } else {
            Label successLabel = (Label)this.getControl("success");
            Label failLabel = (Label)this.getControl("failed");
            successLabel.setText("" + succeed);
            failLabel.setText("" + failed);
            this.getView().setVisible(Boolean.TRUE, new String[]{"failpanel"});
            HashMap notHidden = Maps.newHashMap();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata("failpanel", (Map)notHidden);
            this.getView().setVisible(Boolean.TRUE, new String[]{"okbtn"});
            this.importProgressFinish(info);
        }
    }

    private void openImportCompletePage(JSONObject dataCount) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrptmc_importcomplete");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        String caption = null;
        if (HRStringUtils.equals((String)entityId, (String)"hrptmc_analyseobject")) {
            caption = ResManager.loadKDString((String)"\u5206\u6790\u5bf9\u8c61\u5bfc\u5165", (String)"HReportImportingPlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        } else if (HRStringUtils.equals((String)entityId, (String)"hrptmc_reportmanage")) {
            caption = ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u5165", (String)"HReportImportingPlugin_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        } else if (HRStringUtils.equals((String)entityId, (String)"hrptmc_preindex")) {
            caption = ResManager.loadKDString((String)"\u9884\u7f6e\u6307\u6807\u5bfc\u5165", (String)"HReportImportingPlugin_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        }
        parameter.setCaption(caption);
        if (dataCount == null || dataCount.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38", (String)"HReportImportingPlugin_11", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("dataCount", (Object)SerializationUtils.toJsonString((Object)dataCount));
        parameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        this.getView().showForm(parameter);
    }

    private void importProcessing() {
        HashMap meta = Maps.newHashMap();
        meta.put("itime", 3000);
        this.getView().updateControlMetadata(PROGRESSBARAP, (Map)meta);
    }

    static {
        LOGGER = LogFactory.getLog(HReportImportingPlugin.class);
        try {
            THREAD_COUNT = Integer.parseInt(System.getProperty("bos.importing.thread.max", "12"));
        }
        catch (NumberFormatException e) {
            LOGGER.error(ResManager.loadKDString((String)"\u8b66\u544a\uff1aMC\u53c2\u6570bos.importing.thread.max\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u68c0\u67e5\u3002", (String)"HReportImportingPlugin_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        }
        threadPool = ThreadPools.newCachedThreadPool((String)"HReportImportThreadPool", (int)2, (int)THREAD_COUNT);
    }
}

