/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrptmc.common.constant.preindex.PresetIndexConstants;

public class SelectColPlugin
extends HRDynamicFormBasePlugin
implements PresetIndexConstants {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildColInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectRow();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey = evt.getOperateKey();
        if ("rtnselcol".equals(opKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList selCos = Lists.newArrayListWithExpectedSize((int)selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                HashMap<String, Object> selCol = new HashMap<String, Object>(4);
                selCol.put("colfrom", this.getModel().getValue("colfrom", selectRows[i]));
                selCol.put("colname", this.getModel().getValue("colname", selectRows[i]));
                selCol.put("colnumber", this.getModel().getValue("colnumber", selectRows[i]));
                selCol.put("coltype", this.getModel().getValue("coltype", selectRows[i]));
                selCos.add(selCol);
            }
            this.getView().returnDataToParent((Object)selCos);
            this.getView().close();
        }
    }

    private void buildColInfo() {
        DynamicObject[] calCols;
        DynamicObject[] qryCols;
        Object anObjId = this.getView().getFormShowParameter().getCustomParam("anObjId");
        if (null == anObjId) {
            return;
        }
        DynamicObjectCollection colInfos = this.getModel().getEntryEntity("entryentity");
        colInfos.clear();
        HRBaseServiceHelper qryHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
        QFilter idFilter = new QFilter("anobj", "=", anObjId);
        QFilter valTypeFilter = new QFilter("valuetype", "not in", (Object)TARGET_VALUE_TYPE);
        QFilter[] qFilters = new QFilter[]{idFilter, valTypeFilter};
        for (DynamicObject qryCol : qryCols = qryHelper.query("fieldname,fieldpath,valuetype,complextype", qFilters)) {
            DynamicObject colInfo = new DynamicObject(colInfos.getDynamicObjectType());
            colInfo.set("colfrom", (Object)"20");
            colInfo.set("colnumber", qryCol.get("fieldpath"));
            colInfo.set("colname", qryCol.get("fieldname"));
            String complexType = qryCol.getString("complextype");
            if (FieldComplexType.ADMIN_ORG.getValue().equals(complexType) || FieldComplexType.BASE_DATA.getValue().equals(complexType)) {
                colInfo.set("coltype", (Object)complexType);
            } else {
                colInfo.set("coltype", qryCol.get("valuetype"));
            }
            colInfos.add((Object)colInfo);
        }
        HRBaseServiceHelper calHelper = new HRBaseServiceHelper("hrptmc_calculatefield");
        for (DynamicObject calCol : calCols = calHelper.query("number,name,valuetype", qFilters)) {
            DynamicObject colInfo = new DynamicObject(colInfos.getDynamicObjectType());
            colInfo.set("colfrom", (Object)"10");
            colInfo.set("colnumber", calCol.get("number"));
            colInfo.set("colname", calCol.get("name"));
            colInfo.set("coltype", calCol.get("valuetype"));
            colInfos.add((Object)colInfo);
        }
        this.getModel().updateCache();
        this.getModel().updateEntryCache(colInfos);
        this.getView().updateView("entryentity");
    }

    private void selectRow() {
        List selCols = (List)this.getView().getFormShowParameter().getCustomParam("selCols");
        DynamicObjectCollection colInfos = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)selCols) || CollectionUtils.isEmpty((Collection)colInfos)) {
            return;
        }
        int[] selIdxS = new int[selCols.size()];
        block0: for (int i = 0; i < selCols.size(); ++i) {
            Map selCol = (Map)selCols.get(i);
            String selColFrom = (String)selCol.get("colfrom");
            String selColNumber = (String)selCol.get("colnumber");
            for (int j = 0; j < colInfos.size(); ++j) {
                String colFrom = ((DynamicObject)colInfos.get(j)).getString("colfrom");
                String colNumber = ((DynamicObject)colInfos.get(j)).getString("colnumber");
                if (!StringUtils.equals((CharSequence)selColFrom, (CharSequence)colFrom) || !StringUtils.equals((CharSequence)selColNumber, (CharSequence)colNumber)) continue;
                selIdxS[i] = j;
                continue block0;
            }
        }
        if (selIdxS.length > 0) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            grid.selectRows(selIdxS, selIdxS[0]);
        }
    }
}

