/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.preindex.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.preindex.PresetIndexServiceHelper;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;

public class PreIndexPageUtil {
    public static void updateCurrentWorkSheetDimMaps(IFormView reportView, List<DimMapBo> dimMapBos) {
        String workStr = reportView.getPageCache().get("workRptInfo");
        if (HRStringUtils.isEmpty((String)workStr)) {
            return;
        }
        List workRptInfoList = JSON.parseArray((String)workStr, WorkRptInfo.class);
        Optional<WorkRptInfo> curWorkInfo = workRptInfoList.stream().filter(WorkRptInfo::getShow).findFirst();
        curWorkInfo.ifPresent(workRptInfo -> workRptInfo.setDimMaps(dimMapBos));
        reportView.getPageCache().put("workRptInfo", SerializationUtils.toJsonString((Object)workRptInfoList));
    }

    public static List<DimMapBo> getCurrentWorkSheetDimMaps(IFormView reportView) {
        List dimMaps;
        String workStr = reportView.getPageCache().get("workRptInfo");
        if (HRStringUtils.isEmpty((String)workStr)) {
            return Lists.newArrayListWithCapacity((int)16);
        }
        List workRptInfoList = JSON.parseArray((String)workStr, WorkRptInfo.class);
        Optional<WorkRptInfo> curWorkInfo = workRptInfoList.stream().filter(WorkRptInfo::getShow).findFirst();
        if (curWorkInfo.isPresent() && (dimMaps = curWorkInfo.get().getDimMaps()) != null) {
            return dimMaps;
        }
        return Lists.newArrayListWithCapacity((int)16);
    }

    public static List<DimMapBo> getDimMapsByReportId(Long workRptId) {
        PresetIndexServiceHelper presetIndexHelper = new PresetIndexServiceHelper();
        List dimMapInfosDb = presetIndexHelper.getDimMapByReportWorkId(workRptId);
        ArrayList<DimMapBo> dimMaps = new ArrayList<DimMapBo>(dimMapInfosDb.size());
        if (CollectionUtils.isEmpty((Collection)dimMapInfosDb)) {
            return dimMaps;
        }
        for (DynamicObject dimMapInfoDb : dimMapInfosDb) {
            dimMaps.add(PreIndexPageUtil.transferToDimMapBo(dimMapInfoDb));
        }
        return dimMaps;
    }

    public static DimMapBo transferToDimMapBo(DynamicObject dimMapDy) {
        DimMapBo dimMapBo = new DimMapBo();
        dimMapBo.setReportId(BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dimMapDy, (String)"report"));
        dimMapBo.setWorkPageId(BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dimMapDy, (String)"workrpt"));
        dimMapBo.setPreIndexId(BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dimMapDy, (String)"preindex"));
        dimMapBo.setPreIndexNumber(dimMapDy.getString("preindexnumber"));
        DynamicObjectCollection dimMapEntryCol = dimMapDy.getDynamicObjectCollection("entryentity");
        List<DimMapEntryBo> dimMapEntryBos = PreIndexPageUtil.transferToDimMapEntry(dimMapEntryCol);
        dimMapBo.setDimMapEntryBos(dimMapEntryBos);
        return dimMapBo;
    }

    public static List<DimMapEntryBo> transferToDimMapEntry(DynamicObjectCollection dimMapEntryCol) {
        ArrayList dimMapEntryBos = Lists.newArrayListWithExpectedSize((int)dimMapEntryCol.size());
        for (DynamicObject dimMapEntryDy : dimMapEntryCol) {
            DimMapEntryBo entryBo = new DimMapEntryBo();
            OrmLocaleValue dimName = (OrmLocaleValue)dimMapEntryDy.getLocaleString("dim");
            entryBo.setDim(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)dimName));
            entryBo.setDimType(dimMapEntryDy.getString("dimtype"));
            entryBo.setDimFrom(dimMapEntryDy.getString("dimfrom"));
            entryBo.setDimRealFrom(dimMapEntryDy.getString("dimrealfrom"));
            entryBo.setParamRule(dimMapEntryDy.getString("paramrule"));
            entryBo.setPreIndexParam(dimMapEntryDy.getString("preindexparam"));
            entryBo.setDimNumber(dimMapEntryDy.getString("dimnumber"));
            dimMapEntryBos.add(entryBo);
        }
        return dimMapEntryBos;
    }
}

