/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.filter.control.HRFilter;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.control.Control;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnobjFilterUtil;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;

public class ReportManageDataFilterEditPlugin
extends HRDataBaseEdit {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus()) {
            this.getPageCache().put("pageState", "VIEW");
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String key = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"ruledate", (String)key)) {
            Date newData = (Date)evt.getChangeSet()[0].getNewValue();
            if (null == newData) {
                return;
            }
            String data = HRDateTimeUtils.format((Date)newData, (String)"yyyy-MM-dd");
            this.getHRFilter().setDate(data);
            this.getModel().setValue("ruledate", null);
        }
    }

    private HRFilter getHRFilter() {
        return (HRFilter)this.getControl("hrfilterap");
    }

    public void afterBindData(EventObject eventObject) {
        String datafilterValue;
        super.afterBindData(eventObject);
        Long anObjId = (Long)this.getView().getFormShowParameter().getCustomParams().get("anObjId");
        AnalyseObjectService analyseObjectService = AnalyseObjectService.getInstance();
        List queryFieldBos = analyseObjectService.queryAndAssembleQueryFields(anObjId);
        List queryFieldCommonBos = queryFieldBos.stream().map(queryFieldBo -> queryFieldBo).collect(Collectors.toList());
        HashMap fileSourceEnumItemMap = Maps.newHashMapWithExpectedSize((int)16);
        if (analyseObjectService.isFileSourceAnObj(anObjId)) {
            AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(anObjId.longValue(), new MainEntityTypeUtil());
            for (QueryFieldCommonBo queryFieldCommonBo : queryFieldCommonBos) {
                List enumItems = enumFieldHandler.getEnumItems(queryFieldCommonBo);
                if (enumItems == null) continue;
                List items = fileSourceEnumItemMap.getOrDefault(queryFieldCommonBo.getFieldAlias(), Lists.newArrayListWithCapacity((int)10));
                items.addAll(enumItems.stream().map(AnObjEnumFieldHandler.AnObjEnumItem::getValue).collect(Collectors.toList()));
                fileSourceEnumItemMap.putIfAbsent(queryFieldCommonBo.getFieldAlias(), items);
            }
        }
        List inputMap = AnobjFilterUtil.getParamList(queryFieldCommonBos, (Map)fileSourceEnumItemMap);
        HRFilter hrFilter = (HRFilter)this.getControl("hrfilterap");
        Object datafilter = this.getView().getFormShowParameter().getCustomParams().get("datafilter");
        if (Objects.nonNull(datafilter) && HRStringUtils.isNotEmpty((String)(datafilterValue = datafilter.toString()))) {
            datafilterValue = RuleUtil.getNewestConditionValue((String)datafilterValue);
            HashMap data = Maps.newHashMapWithExpectedSize((int)4);
            data.put("param", inputMap);
            data.put("value", datafilterValue);
            data.put("onlyUpdateWeb", "true");
            hrFilter.setValue(datafilterValue);
            hrFilter.updateControlData((Map)data);
            return;
        }
        hrFilter.setParamAndUpdateControl(inputMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)BTN_OK, (String)key)) {
            RuleValidateInfo ruleValidateInfo;
            String hrfilterStr = ((HRFilter)this.getControl("hrfilterap")).getValue();
            if (StringUtils.isNotEmpty((CharSequence)hrfilterStr) && !(ruleValidateInfo = RuleValidateUtil.validCondition((String)hrfilterStr, (boolean)true)).isSuccess()) {
                this.getView().showErrorNotification(ruleValidateInfo.getMsgList().toString());
                return;
            }
            this.getView().returnDataToParent((Object)hrfilterStr);
            this.getView().close();
        }
    }
}

