/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.CustomSortInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.LocaleStringUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManagePopUtil;

public class SetCustomSortPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SetCustomSortPlugin.class);

    public void afterBindData(EventObject evt) {
        String entityNumber;
        super.afterBindData(evt);
        CustomSortInfo customSort = new CustomSortInfo();
        ArrayList sortValues = new ArrayList();
        FieldInfo fieldInfo = this.getFieldInfo();
        if (SortEnum.CUSTOM.getValue().equals(fieldInfo.getSort()) && null != fieldInfo.getCustomSort()) {
            sortValues.addAll(fieldInfo.getCustomSort().getValue());
        }
        String string = entityNumber = StringUtils.isNotEmpty((CharSequence)fieldInfo.getBaseDataNum()) ? fieldInfo.getBaseDataNum() : fieldInfo.getEntityNumber();
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            boolean isBaseData;
            customSort.setEntityNumber(entityNumber);
            ArrayList<ValueMapItem> mapItemList = new ArrayList<ValueMapItem>();
            String number = fieldInfo.getNumber();
            String field = number.contains(".") ? number.substring(number.lastIndexOf(".") + 1) : number;
            customSort.setField(field);
            boolean bl = isBaseData = "name".equals(field) || "number".equals(field);
            if (isBaseData) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                customSort.setFieldType("basedata");
                customSort.setValueType(this.getValueType(mainEntityType.getPrimaryKey().getPropertyType().getTypeName()));
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
                DynamicObject[] allBaseData = helper.query(null);
                Map<String, DynamicObject> baseDataMap = Arrays.stream(allBaseData).collect(Collectors.toMap(dy -> dy.getPkValue().toString(), dy -> dy));
                for (String baseDataId2 : sortValues) {
                    if (!baseDataMap.containsKey(baseDataId2)) continue;
                    ValueMapItem item2 = new ValueMapItem();
                    DynamicObject baseData = baseDataMap.remove(baseDataId2);
                    item2.setName(LocaleStringUtils.getLocaleString(baseData.get("name")));
                    item2.setImageKey(baseData.getString("number"));
                    item2.setValue(baseDataId2);
                    mapItemList.add(item2);
                }
                baseDataMap.forEach((baseDataId, dy) -> {
                    ValueMapItem item = new ValueMapItem();
                    if (dy.get("name") instanceof ILocaleString) {
                        item.setName(LocaleStringUtils.getLocaleString(dy.get("name")));
                    } else {
                        item.setName(new LocaleString(dy.getString("name")));
                    }
                    item.setValue(baseDataId);
                    item.setImageKey(dy.getString("number"));
                    mapItemList.add(item);
                });
            } else {
                customSort.setFieldType("enum");
                customSort.setValueType("string");
                String anObjId = (String)this.getView().getFormShowParameter().getCustomParam("anObjId");
                AnObjEnumFieldHandler anObjEnumFieldHandler = new AnObjEnumFieldHandler(Long.parseLong(anObjId), new MainEntityTypeUtil());
                List enumItems = anObjEnumFieldHandler.getEnumItems(fieldInfo.getNumber(), fieldInfo.getEntityNumber());
                Map<String, ValueMapItem> enumItemMap = enumItems.stream().map(item -> new ValueMapItem("", item.getValue(), item.getName())).collect(Collectors.toMap(ValueMapItem::getValue, item -> item));
                for (String value2 : sortValues) {
                    if (!enumItemMap.containsKey(value2)) continue;
                    mapItemList.add(enumItemMap.remove(value2));
                }
                enumItemMap.forEach((value, item) -> mapItemList.add((ValueMapItem)item));
            }
            this.setEntry(mapItemList, isBaseData);
        }
        this.getPageCache().put("customSortInfo", SerializationUtils.toJsonString((Object)customSort));
    }

    private void setEntry(List<ValueMapItem> mapItemList, boolean isBaseData) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (CollectionUtils.isNotEmpty(mapItemList)) {
            model.batchCreateNewEntryRow("entryentity", mapItemList.size());
            for (int i = 0; i < mapItemList.size(); ++i) {
                ValueMapItem item = mapItemList.get(i);
                model.setValue("itemname", (Object)item.getName().getLocaleValue(), i);
                model.setValue("itemnumber", (Object)(isBaseData ? item.getImageKey() : item.getValue()), i);
                model.setValue("itemvalue", (Object)item.getValue(), i);
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private String getValueType(String type) {
        return "long".equals(type) ? "long" : "string";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("enter".equals(operateKey)) {
            DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
            String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
            String operateArea = (String)this.getView().getFormShowParameter().getCustomParam("operateArea");
            if ("row".equals(operateArea)) {
                RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
                this.handleCustomSort(rowFieldInfo.getGroupName(), dyColl);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)rowFieldInfo));
            } else {
                FieldInfo fieldInfo = (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
                this.handleCustomSort(fieldInfo, dyColl);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)fieldInfo));
            }
            this.getView().close();
        } else if ("moveentryup".equals(operateKey) || "moveentrydown".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] rowIdx = entryGrid.getSelectRows();
            entryGrid.focusCell(rowIdx[0], "itemname");
        } else if ("moveto".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] rowIdx = entryGrid.getSelectRows();
            if (rowIdx.length > 0) {
                ReportManagePopUtil.openMoveTo(this, rowIdx[0]);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u52a8\u7684\u9879\u76ee\u3002", (String)"SetCustomSortPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        int from = Integer.parseInt(actionId.substring(0, actionId.indexOf("_")));
        if (null != closedCallBackEvent.getReturnData()) {
            int to = (Integer)closedCallBackEvent.getReturnData();
            ArrayList<ValueMapItem> mapItemList = new ArrayList<ValueMapItem>();
            FieldInfo fieldInfo = this.getFieldInfo();
            String number = fieldInfo.getNumber();
            String field = number.contains(".") ? number.substring(number.lastIndexOf(".") + 1) : number;
            boolean isBaseData = "name".equals(field) || "number".equals(field);
            DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
            dyColl.forEach(dy -> {
                ValueMapItem item = new ValueMapItem();
                if (dy.get("itemname") instanceof ILocaleString) {
                    item.setName(LocaleStringUtils.getLocaleString(dy.get("itemname")));
                } else {
                    item.setName(new LocaleString(dy.getString("itemname")));
                }
                item.setValue(dy.getString("itemvalue"));
                item.setImageKey(dy.getString("itemnumber"));
                mapItemList.add(item);
            });
            ValueMapItem item = (ValueMapItem)mapItemList.remove(from);
            if (mapItemList.size() >= to) {
                mapItemList.add(to - 1, item);
            } else {
                mapItemList.add(item);
            }
            this.setEntry(mapItemList, isBaseData);
        }
    }

    private void handleCustomSort(FieldInfo fieldInfo, DynamicObjectCollection dyColl) {
        fieldInfo.setSort(SortEnum.CUSTOM.getValue());
        CustomSortInfo customSort = (CustomSortInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("customSortInfo"), CustomSortInfo.class);
        customSort.setValue(dyColl.stream().map(dy -> dy.getString("itemvalue")).collect(Collectors.toList()));
        fieldInfo.setCustomSort(customSort);
    }

    private FieldInfo getFieldInfo() {
        FieldInfo fieldInfo;
        String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
        String operateArea = (String)this.getView().getFormShowParameter().getCustomParam("operateArea");
        if ("row".equals(operateArea)) {
            RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
            fieldInfo = rowFieldInfo.getGroupName();
        } else {
            fieldInfo = (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
        }
        return fieldInfo;
    }
}

