/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptmc.business.repdesign.info.DataFormatInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import org.jetbrains.annotations.NotNull;

public class SetDataFormatPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SetDataFormatPlugin.class);

    public void beforeBindData(EventObject evt) {
        DataFormatInfo dataFormatInfo;
        super.beforeBindData(evt);
        String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
        String fieldArea = (String)this.getView().getFormShowParameter().getCustomParam("fieldArea");
        LOGGER.info("fieldInfoStr:{}", (Object)fieldInfoStr);
        if ("row".equals(fieldArea)) {
            RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
            dataFormatInfo = rowFieldInfo.getGroupName().getDataFormat();
        } else {
            FieldInfo fieldInfo = (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
            dataFormatInfo = fieldInfo.getDataFormat();
        }
        if (dataFormatInfo != null) {
            this.getModel().setValue("displaymode", (Object)dataFormatInfo.getDisplayMode());
            this.getModel().setValue("nullrule", (Object)dataFormatInfo.getNullRule());
            this.getModel().setValue("decimaldigits", (Object)dataFormatInfo.getDecimalDigits());
            this.getModel().setValue("roundmethod", (Object)dataFormatInfo.getRoundMethod());
        } else {
            this.getModel().setValue("decimaldigits", (Object)0);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BigDecimal decimaldigits;
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("enter".equals(operateKey) && (decimaldigits = (BigDecimal)this.getModel().getValue("decimaldigits")).compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"SetDataFormatPlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("enter".equals(operateKey)) {
            String newField;
            String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
            String fieldArea = (String)this.getView().getFormShowParameter().getCustomParam("fieldArea");
            if ("row".equals(fieldArea)) {
                RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
                rowFieldInfo.getGroupName().setDataFormat(this.getDataFormatInfo(rowFieldInfo.getGroupName().getDataFormat()));
                newField = SerializationUtils.toJsonString((Object)rowFieldInfo);
            } else {
                FieldInfo fieldInfo = (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
                fieldInfo.setDataFormat(this.getDataFormatInfo(fieldInfo.getDataFormat()));
                newField = SerializationUtils.toJsonString((Object)fieldInfo);
            }
            this.getView().returnDataToParent((Object)newField);
            this.getView().close();
        }
    }

    @NotNull
    private DataFormatInfo getDataFormatInfo(DataFormatInfo dataFormatInfo) {
        if (dataFormatInfo == null) {
            dataFormatInfo = new DataFormatInfo();
        }
        dataFormatInfo.setDisplayMode((String)this.getModel().getValue("displaymode"));
        dataFormatInfo.setNullRule((String)this.getModel().getValue("nullrule"));
        dataFormatInfo.setDecimalDigits(((BigDecimal)this.getModel().getValue("decimaldigits")).intValue());
        dataFormatInfo.setRoundMethod((String)this.getModel().getValue("roundmethod"));
        return dataFormatInfo;
    }
}

