/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.formplugin.web.repdesign.ReportManageEditPlugin;

public class SetDisplayModePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ReportManageEditPlugin.class);

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String key = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"displaymode", (String)key)) {
            String displayMode = (String)evt.getChangeSet()[0].getNewValue();
            this.getView().setVisible(Boolean.valueOf("tree".equals(displayMode)), new String[]{"orgversiondate"});
        }
    }

    private boolean isOrgMust() {
        String filterBoListStr = (String)this.getView().getFormShowParameter().getCustomParam("filterBoList");
        List filterBoList = SerializationUtils.fromJsonStringToList((String)filterBoListStr, FilterBo.class);
        if (!CollectionUtils.isEmpty((Collection)filterBoList)) {
            for (FilterBo filterBo : filterBoList) {
                if (!"adminorg".equals(filterBo.getFilterType()) || !filterBo.getMustInput()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMulWorkRpt() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam("mulWorkRpt");
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
        RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
        String displayMode = rowFieldInfo.getGroupName().getDisplayMode();
        if (StringUtils.isNotEmpty((CharSequence)displayMode)) {
            this.getPageCache().put("displaymode", displayMode);
            this.getModel().setValue("displaymode", (Object)displayMode);
        }
        this.getView().setVisible(Boolean.valueOf("tree".equals(displayMode)), new String[]{"orgversiondate"});
        String filterBoListStr = (String)this.getView().getFormShowParameter().getCustomParam("filterBoList");
        List tempList = SerializationUtils.fromJsonStringToList((String)filterBoListStr, FilterBo.class);
        List filterBoList = tempList.stream().filter(filterBo -> filterBo.getFilterType().equals(FilterType.DATE.getValue())).collect(Collectors.toList());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem curDateItem = new ComboItem();
        curDateItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f", (String)"SetDisplayModePlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
        curDateItem.setValue("curdate");
        items.add(curDateItem);
        for (FilterBo filterBo2 : filterBoList) {
            if ("0".equals(filterBo2.getDateType())) {
                ComboItem startFilterItem = new ComboItem();
                startFilterItem.setCaption(new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s.\u5f00\u59cb", (String)"SetDisplayModePlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), filterBo2.getFieldName().get((Object)Lang.get().toString()))));
                startFilterItem.setValue(filterBo2.getFieldAlias() + "_start");
                items.add(startFilterItem);
                ComboItem endFilterItem = new ComboItem();
                endFilterItem.setCaption(new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s.\u7ed3\u675f", (String)"SetDisplayModePlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), filterBo2.getFieldName().get((Object)Lang.get().toString()))));
                endFilterItem.setValue(filterBo2.getFieldAlias() + "_end");
                items.add(endFilterItem);
                continue;
            }
            ComboItem filterItem = new ComboItem();
            filterItem.setCaption(new LocaleString((String)filterBo2.getFieldName().get((Object)Lang.get().toString())));
            filterItem.setValue(filterBo2.getFieldAlias());
            items.add(filterItem);
        }
        ComboEdit versionDateControl = (ComboEdit)this.getView().getControl("orgversiondate");
        versionDateControl.setComboItems(items);
        String orgVersionDate = rowFieldInfo.getGroupName().getOrgVersionDate();
        if (StringUtils.isNotEmpty((CharSequence)orgVersionDate)) {
            this.getPageCache().put("orgversiondate", orgVersionDate);
            this.getModel().setValue("orgversiondate", (Object)orgVersionDate);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String reportConfigInfoStr;
        String displayMode;
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("enter".equals(operateKey) && "tree".equals(displayMode = this.getModel().getValue("displaymode").toString()) && StringUtils.isNotEmpty((CharSequence)(reportConfigInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("reportConfigInfo")))) {
            ReportConfigInfo reportConfig = (ReportConfigInfo)SerializationUtils.fromJsonString((String)reportConfigInfoStr, ReportConfigInfo.class);
            ArrayList finalMsg = Lists.newArrayListWithCapacity((int)10);
            if (reportConfig.getTotal()) {
                finalMsg.add(ResManager.loadKDString((String)"\u5f00\u542f\u603b\u8ba1\u884c\u65f6\u65e0\u6cd5\u8bbe\u7f6e\u663e\u793a\u65b9\u5f0f\uff0c\u8bf7\u5173\u95ed\u603b\u8ba1\u884c\u540e\u91cd\u8bd5\u3002", (String)"SetDisplayModePlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            if (reportConfig.getPage()) {
                finalMsg.add(ResManager.loadKDString((String)"\u5f00\u542f\u8868\u683c\u5206\u9875\u65f6\u65e0\u6cd5\u8bbe\u7f6e\u663e\u793a\u65b9\u5f0f\uff0c\u8bf7\u5173\u95ed\u8868\u683c\u5206\u9875\u540e\u91cd\u8bd5\u3002", (String)"SetDisplayModePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            if (reportConfig.getShowSeq()) {
                finalMsg.add(ResManager.loadKDString((String)"\u5f00\u542f\u663e\u793a\u884c\u5e8f\u53f7\u65f6\u65e0\u6cd5\u8bbe\u7f6e\u663e\u793a\u65b9\u5f0f\uff0c\u8bf7\u5173\u95ed\u663e\u793a\u884c\u5e8f\u53f7\u540e\u91cd\u8bd5\u3002", (String)"SetDisplayModePlugin_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            if (reportConfig.getMergeCell()) {
                finalMsg.add(ResManager.loadKDString((String)"\u5f00\u542f\u5408\u5e76\u540c\u7c7b\u5355\u5143\u683c\u65f6\u65e0\u6cd5\u8bbe\u7f6e\u663e\u793a\u65b9\u5f0f\uff0c\u8bf7\u5173\u95ed\u5408\u5e76\u540c\u7c7b\u5355\u5143\u683c\u540e\u91cd\u8bd5\u3002", (String)"SetDisplayModePlugin_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            if (!this.isOrgMust()) {
                finalMsg.add(ResManager.loadKDString((String)"\u7b5b\u9009\u5668\u5185\u672a\u914d\u7f6e\u884c\u653f\u7ec4\u7ec7\u7b5b\u9009\u5668\u6216\u884c\u653f\u7ec4\u7ec7\u7b5b\u9009\u5668\u975e\u5fc5\u9009\uff0c\u8bf7\u914d\u7f6e\u7ec4\u7ec7\u7b5b\u9009\u5668\u540e\u91cd\u8bd5\u3002", (String)"SetDisplayModePlugin_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            if (this.isMulWorkRpt()) {
                finalMsg.add(ResManager.loadKDString((String)"\u591a\u5de5\u4f5c\u8868\u573a\u666f\u4e0b\u65e0\u6cd5\u5f00\u542f\u884c\u653f\u7ec4\u7ec7\u6811\u5f62\u5c55\u793a", (String)"SetDisplayModePlugin_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)finalMsg)) {
                if (finalMsg.size() == 1) {
                    this.getView().showTipNotification((String)finalMsg.get(0));
                } else {
                    String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5207\u6362\u663e\u793a\u65b9\u5f0f\u3002\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"SetDisplayModePlugin_9", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, String.join((CharSequence)"\r\n", finalMsg), MessageBoxOptions.OK, ConfirmTypes.Save, null, null);
                }
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("enter".equals(operateKey)) {
            String displayMode = this.getModel().getValue("displaymode").toString();
            String orgVersionDate = this.getModel().getValue("orgversiondate").toString();
            if (displayMode.equals(this.getPageCache().get("displaymode")) && orgVersionDate.equals(this.getPageCache().get("orgversiondate"))) {
                this.getView().close();
                return;
            }
            String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
            RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
            rowFieldInfo.getGroupName().setDisplayMode(displayMode);
            rowFieldInfo.getGroupName().setOrgVersionDate(orgVersionDate);
            String newField = SerializationUtils.toJsonString((Object)rowFieldInfo);
            this.getView().returnDataToParent((Object)newField);
            this.getView().close();
        }
    }
}

