/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.util.TreeViewSearchTool;
import kd.hr.hrptmc.business.repdesign.info.DisplaySchemeInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class SetDisplaySchemePlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String LEFT_TREE = "lefttree";
    private static final String RIGHT_TREE = "righttree";
    private static final String LEFT_SEARCH = "leftsearchap";
    private static final String RIGHT_SEARCH = "rightsearchap";
    private static final String ROOT = "ROOT";
    private static final String ROW_FIELD = "rowField";
    private static final String COL_FIELD = "colField";
    private static final String IDX_FIELD = "idxField";
    private static final String PARENT_ID = "parentid";
    private static final String CACHE_REPORT_HEAD = "reportHeadRowAndColCfgInfo";
    private static final String CACHE_DISPLAY_SCHEME = "displaySchemeInfo";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getPageCache().put(CACHE_REPORT_HEAD, (String)this.getView().getFormShowParameter().getCustomParam(CACHE_REPORT_HEAD));
        this.getPageCache().put(CACHE_DISPLAY_SCHEME, (String)this.getView().getFormShowParameter().getCustomParam(CACHE_DISPLAY_SCHEME));
        this.initTree();
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String reportStatus = (String)parameter.getCustomParam("reportStatus");
        if (StringUtils.isNotEmpty((CharSequence)reportStatus) && OperationStatus.VIEW.toString().equals(reportStatus)) {
            parameter.setStatus(OperationStatus.valueOf((String)reportStatus));
        }
    }

    private void initTree() {
        TreeView leftTreeView = (TreeView)this.getView().getControl(LEFT_TREE);
        leftTreeView.deleteAllNodes();
        leftTreeView.setMulti(true);
        leftTreeView.setRootVisible(false);
        TreeNode leftRootNode = new TreeNode("", ROOT, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5b57\u6bb5", (String)"SetDisplaySchemePlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        TreeView rightTreeView = (TreeView)this.getView().getControl(RIGHT_TREE);
        rightTreeView.deleteAllNodes();
        rightTreeView.setMulti(true);
        rightTreeView.setRootVisible(false);
        TreeNode rightRootNode = new TreeNode("", ROOT, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5b57\u6bb5", (String)"SetDisplaySchemePlugin_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
        DisplaySchemeInfo displaySchemeInfo = this.getDisplaySchemeInfo();
        String reportHeadRowAndColCfgInfo = this.getPageCache().get(CACHE_REPORT_HEAD);
        if (StringUtils.isNotEmpty((CharSequence)reportHeadRowAndColCfgInfo)) {
            Set<String> selectedFields = Stream.concat(displaySchemeInfo.getSelectedRowField().stream(), displaySchemeInfo.getSelectedIdxField().stream()).collect(Collectors.toSet());
            ReportHeadRowAndColCfgInfo rowAndColumnCfgInfo = (ReportHeadRowAndColCfgInfo)SerializationUtils.fromJsonString((String)reportHeadRowAndColCfgInfo, ReportHeadRowAndColCfgInfo.class);
            if (CollectionUtils.isEmpty((Collection)rowAndColumnCfgInfo.getColumns())) {
                TreeNode leftRowNode = new TreeNode(ROOT, ROW_FIELD, ResManager.loadKDString((String)"\u884c\u914d\u7f6e", (String)"SetDisplaySchemePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                TreeNode rightRowNode = new TreeNode(ROOT, ROW_FIELD, ResManager.loadKDString((String)"\u884c\u914d\u7f6e", (String)"SetDisplaySchemePlugin_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                leftRootNode.addChild(leftRowNode);
                rightRootNode.addChild(rightRowNode);
                for (RowFieldInfo rowFieldInfo : rowAndColumnCfgInfo.getRows()) {
                    if ("0".equals(rowFieldInfo.getMergeType())) {
                        this.addNode(selectedFields, rowFieldInfo.getGroupName(), leftRowNode, rightRowNode, ROW_FIELD);
                    }
                    FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> this.addNode(selectedFields, (FieldInfo)fieldInfo, leftRowNode, rightRowNode, ROW_FIELD));
                }
                leftTreeView.addNode(leftRootNode);
                leftTreeView.expand(ROW_FIELD);
                rightTreeView.addNode(rightRootNode);
                rightTreeView.expand(ROW_FIELD);
            } else {
                TreeNode leftRowNode = new TreeNode(ROOT, ROW_FIELD, ResManager.loadKDString((String)"\u884c\u7ef4\u5ea6", (String)"SetDisplaySchemePlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                TreeNode rightRowNode = new TreeNode(ROOT, ROW_FIELD, ResManager.loadKDString((String)"\u884c\u7ef4\u5ea6", (String)"SetDisplaySchemePlugin_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                leftRootNode.addChild(leftRowNode);
                rightRootNode.addChild(rightRowNode);
                for (RowFieldInfo rowFieldInfo : rowAndColumnCfgInfo.getRows()) {
                    if ("1".equals(rowFieldInfo.getGroupName().getType())) {
                        this.addNode(selectedFields, rowFieldInfo.getGroupName(), leftRowNode, rightRowNode, ROW_FIELD);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)rowFieldInfo._getChildFields())) continue;
                    for (FieldInfo fieldInfo2 : rowFieldInfo._getChildFields()) {
                        if (!"1".equals(fieldInfo2.getType())) continue;
                        this.addNode(selectedFields, fieldInfo2, leftRowNode, rightRowNode, ROW_FIELD);
                    }
                }
                TreeNode leftColNode = new TreeNode(ROOT, COL_FIELD, ResManager.loadKDString((String)"\u5217\u7ef4\u5ea6", (String)"SetDisplaySchemePlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                leftRootNode.addChild(leftColNode);
                TreeNode rightColNode = new TreeNode(ROOT, COL_FIELD, ResManager.loadKDString((String)"\u5217\u7ef4\u5ea6", (String)"SetDisplaySchemePlugin_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                rightRootNode.addChild(rightColNode);
                for (FieldInfo fieldInfo2 : rowAndColumnCfgInfo.getColumns()) {
                    this.addNode(displaySchemeInfo.getSelectedColField(), fieldInfo2, leftColNode, rightColNode, COL_FIELD);
                }
                TreeNode leftIdxNode = new TreeNode(ROOT, IDX_FIELD, ResManager.loadKDString((String)"\u6307\u6807", (String)"SetDisplaySchemePlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                leftRootNode.addChild(leftIdxNode);
                TreeNode rightIdxNode = new TreeNode(ROOT, IDX_FIELD, ResManager.loadKDString((String)"\u6307\u6807", (String)"SetDisplaySchemePlugin_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                rightRootNode.addChild(rightIdxNode);
                for (RowFieldInfo rowFieldInfo : rowAndColumnCfgInfo.getRows()) {
                    if ("2".equals(rowFieldInfo.getGroupName().getType())) {
                        this.addNode(selectedFields, rowFieldInfo.getGroupName(), leftIdxNode, rightIdxNode, IDX_FIELD);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)rowFieldInfo._getChildFields())) continue;
                    for (FieldInfo fieldInfo3 : rowFieldInfo._getChildFields()) {
                        if (!"2".equals(fieldInfo3.getType())) continue;
                        this.addNode(selectedFields, fieldInfo3, leftIdxNode, rightIdxNode, IDX_FIELD);
                    }
                }
                leftTreeView.addNode(leftRootNode);
                leftTreeView.expand(ROW_FIELD);
                leftTreeView.expand(COL_FIELD);
                leftTreeView.expand(IDX_FIELD);
                rightTreeView.addNode(rightRootNode);
                rightTreeView.expand(ROW_FIELD);
                rightTreeView.expand(COL_FIELD);
                rightTreeView.expand(IDX_FIELD);
            }
        }
        this.getPageCache().put(leftTreeView.getKey(), SerializationUtils.toJsonString((Object)leftRootNode));
        this.getPageCache().put(rightTreeView.getKey(), SerializationUtils.toJsonString((Object)rightRootNode));
    }

    private void addNode(Set<String> selectedFiled, FieldInfo fieldInfo, TreeNode leftNode, TreeNode rightNode, String parentId) {
        if (CollectionUtils.isNotEmpty(selectedFiled) && selectedFiled.contains(fieldInfo.getNumberAlias())) {
            rightNode.addChild(this.transferTreeNode(parentId, fieldInfo));
        } else {
            leftNode.addChild(this.transferTreeNode(parentId, fieldInfo));
        }
    }

    private TreeNode transferTreeNode(String parentId, FieldInfo fieldInfo) {
        return new TreeNode(parentId, fieldInfo.getNumberAlias(), fieldInfo.getDisplayName().getLocaleValue());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("moveright".equals(operateKey)) {
            TreeView leftTreeView = (TreeView)this.getControl(LEFT_TREE);
            List selectedNodes = leftTreeView.getTreeState().getSelectedNodes();
            if (!selectedNodes.isEmpty()) {
                DisplaySchemeInfo displaySchemeInfo = this.getDisplaySchemeInfo();
                this.addDisplaySchemeField(displaySchemeInfo, selectedNodes);
                this.getView().getPageCache().put(CACHE_DISPLAY_SCHEME, SerializationUtils.toJsonString((Object)displaySchemeInfo));
                this.initTree();
            }
        } else if ("moveleft".equals(operateKey)) {
            TreeView rightTreeView = (TreeView)this.getControl(RIGHT_TREE);
            List selectedNodes = rightTreeView.getTreeState().getSelectedNodes();
            if (!selectedNodes.isEmpty()) {
                DisplaySchemeInfo displaySchemeInfo = this.getDisplaySchemeInfo();
                this.removeDisplaySchemeField(displaySchemeInfo, selectedNodes);
                this.getView().getPageCache().put(CACHE_DISPLAY_SCHEME, SerializationUtils.toJsonString((Object)displaySchemeInfo));
                this.initTree();
            }
        } else if ("enter".equals(operateKey)) {
            DisplaySchemeInfo displaySchemeInfo = this.getDisplaySchemeInfo();
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)displaySchemeInfo));
            this.getView().close();
        }
    }

    private void addDisplaySchemeField(DisplaySchemeInfo displaySchemeInfo, List<Map<String, Object>> selectedNodes) {
        for (Map<String, Object> node : selectedNodes) {
            String parentId = node.get(PARENT_ID).toString();
            if (ROW_FIELD.equals(parentId)) {
                displaySchemeInfo.getSelectedRowField().add(node.get("id").toString());
                continue;
            }
            if (COL_FIELD.equals(parentId)) {
                displaySchemeInfo.getSelectedColField().add(node.get("id").toString());
                continue;
            }
            if (!IDX_FIELD.equals(parentId)) continue;
            displaySchemeInfo.getSelectedIdxField().add(node.get("id").toString());
        }
    }

    private void removeDisplaySchemeField(DisplaySchemeInfo displaySchemeInfo, List<Map<String, Object>> selectedNodes) {
        for (Map<String, Object> node : selectedNodes) {
            String nodeId = node.get("id").toString();
            if (COL_FIELD.equals(node.get(PARENT_ID).toString())) {
                displaySchemeInfo.getSelectedColField().remove(nodeId);
                continue;
            }
            displaySchemeInfo.getSelectedRowField().remove(nodeId);
            displaySchemeInfo.getSelectedIdxField().remove(nodeId);
        }
    }

    private DisplaySchemeInfo getDisplaySchemeInfo() {
        DisplaySchemeInfo displaySchemeInfo = null;
        String displaySchemeInfoStr = this.getView().getPageCache().get(CACHE_DISPLAY_SCHEME);
        if (StringUtils.isNotEmpty((CharSequence)displaySchemeInfoStr)) {
            displaySchemeInfo = (DisplaySchemeInfo)SerializationUtils.fromJsonString((String)displaySchemeInfoStr, DisplaySchemeInfo.class);
        }
        if (null == displaySchemeInfo) {
            displaySchemeInfo = new DisplaySchemeInfo();
        }
        return displaySchemeInfo;
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Search leftSearch = (Search)this.getControl(LEFT_SEARCH);
        leftSearch.addEnterListener((SearchEnterListener)this);
        Search rightSearch = (Search)this.getControl(RIGHT_SEARCH);
        rightSearch.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        if (LEFT_SEARCH.equals(search.getKey())) {
            TreeView tv = (TreeView)this.getView().getControl(LEFT_TREE);
            TreeViewSearchTool.search((String)searchText, (TreeView)tv, (IPageCache)this.getPageCache(), (String)LEFT_TREE);
        } else {
            TreeView tv = (TreeView)this.getView().getControl(RIGHT_TREE);
            TreeViewSearchTool.search((String)searchText, (TreeView)tv, (IPageCache)this.getPageCache(), (String)RIGHT_TREE);
        }
    }
}

