/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.StringUtils;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldSortInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;

public class SetFieldSortPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        List<ComboItem> fieldItem = this.getFieldItem();
        ComboEdit fieldCombo = (ComboEdit)this.getControl("field");
        fieldCombo.setComboItems(fieldItem);
        fieldCombo.setMustInput(true);
        FieldSortInfo fieldSortInfo = this.getFieldSortInfo();
        if (null != fieldSortInfo) {
            this.getModel().setValue("field", (Object)fieldSortInfo.getNumber());
            this.getModel().setValue("type", (Object)fieldSortInfo.getSort());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("enter".equals(operateKey)) {
            String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
            String operateArea = (String)this.getView().getFormShowParameter().getCustomParam("operateArea");
            FieldSortInfo fieldSortInfo = this.getSelectedFieldSortInfo();
            if (StringUtils.isEmpty((Object)fieldSortInfo.getNumber())) {
                return;
            }
            if ("row".equals(operateArea)) {
                RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
                rowFieldInfo.getGroupName().setSort("field");
                rowFieldInfo.getGroupName().setFieldSortInfo(fieldSortInfo);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)rowFieldInfo));
            } else {
                FieldInfo fieldInfo = (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
                fieldInfo.setSort("field");
                fieldInfo.setFieldSortInfo(fieldSortInfo);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)fieldInfo));
            }
            this.getView().close();
        }
    }

    private FieldSortInfo getSelectedFieldSortInfo() {
        DynamicObject dy = this.getModel().getDataEntity();
        FieldSortInfo fieldSortInfo = new FieldSortInfo();
        fieldSortInfo.setNumber(dy.getString("field"));
        fieldSortInfo.setSort(dy.getString("type"));
        List<ComboItem> fieldItem = this.getFieldItem();
        Map<String, String> fieldTypeMap = fieldItem.stream().collect(Collectors.toMap(ComboItem::getValue, ComboItem::getImageKey));
        fieldSortInfo.setFieldType(fieldTypeMap.get(dy.getString("field")));
        return fieldSortInfo;
    }

    private List<ComboItem> getFieldItem() {
        String fieldListStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldList");
        return SerializationUtils.fromJsonStringToList((String)fieldListStr, ComboItem.class);
    }

    private FieldSortInfo getFieldSortInfo() {
        FieldInfo fieldInfo;
        String fieldInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldInfo");
        String operateArea = (String)this.getView().getFormShowParameter().getCustomParam("operateArea");
        if ("row".equals(operateArea)) {
            RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
            fieldInfo = rowFieldInfo.getGroupName();
        } else {
            fieldInfo = (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
        }
        return fieldInfo.getFieldSortInfo();
    }
}

