/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.datamonitor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjDataMonitorService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;

public class ReportDataMonitorService
implements ReportManageConstants {
    private Set<String> notExistFieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);
    private Set<String> anObjAllFields = Sets.newHashSetWithExpectedSize((int)16);
    private final Set<String> notExistReportFields = Sets.newHashSetWithExpectedSize((int)16);
    private final HRBaseServiceHelper rowFieldHelper = new HRBaseServiceHelper("hrptmc_rowfield");
    private final HRBaseServiceHelper colFieldHelper = new HRBaseServiceHelper("hrptmc_colfield");
    private final HRBaseServiceHelper rptConfigHelper = new HRBaseServiceHelper("hrptmc_reportconfig");
    private final HRBaseServiceHelper workRptHelper = new HRBaseServiceHelper("hrptmc_workreport");

    public boolean checkReport(long reportId, boolean repair, StringBuilder errorMsg) {
        AnObjDataMonitorService anObjDataMonitorService = new AnObjDataMonitorService();
        StringBuilder anObjErrorMsg = new StringBuilder();
        HRBaseServiceHelper reportHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = reportHelper.loadSingle((Object)reportId);
        long anObjId = reportDy.getDynamicObject("anobjid").getLong("id");
        anObjDataMonitorService.checkAnObj(anObjId, false, anObjErrorMsg);
        this.notExistFieldAliasSet = anObjDataMonitorService.getNotExistFieldAliasSet();
        List queryFields = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(Long.valueOf(anObjId));
        List anObjCalFields = CalculateFieldService.getInstance().loadCalFieldsByAnObjIdForBo(Long.valueOf(anObjId), true);
        List analysePivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(Long.valueOf(anObjId), queryFields, anObjCalFields, true);
        this.anObjAllFields = queryFields.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
        this.anObjAllFields.addAll(anObjCalFields.stream().map(CalculateFieldBo::getFieldNumber).collect(Collectors.toSet()));
        this.anObjAllFields.addAll(analysePivotIndexes.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet()));
        this.anObjAllFields.removeAll(this.notExistFieldAliasSet);
        DynamicObject[] workRptDys = ReportManageService.loadWorkRpt((Long)reportId);
        for (int i = 0; i < workRptDys.length; ++i) {
            DynamicObject workRptDy = workRptDys[i];
            long workRptId = workRptDy.getLong("id");
            String rowStr = this.handleRowFields(i, workRptDy.getString("row"), errorMsg);
            workRptDy.set("row", (Object)rowStr);
            String colStr = this.handleColFields(i, reportDy.getString("column"), errorMsg);
            workRptDy.set("column", (Object)colStr);
            if (i == 0) {
                reportDy.set("row", (Object)rowStr);
                reportDy.set("column", (Object)colStr);
            }
            this.handlePresetIndexDimMap(i, workRptId, repair, errorMsg);
            DynamicObject reportConfigDy = ReportManageService.getRptConfig((Long)workRptId);
            if (reportConfigDy != null) {
                this.handleTotalRow(i, reportConfigDy, errorMsg);
                this.handlePivot(reportConfigDy);
                this.handleHeaderMerge(reportConfigDy);
                this.handleTotalCol(reportConfigDy.getLong("id"), repair);
            }
            this.handleJumpConfig(workRptId, repair);
            if (!repair) continue;
            if (reportConfigDy != null) {
                this.rptConfigHelper.saveOne(reportConfigDy);
            }
            this.workRptHelper.saveOne(workRptDy);
        }
        this.handleDataFilter(reportDy, errorMsg);
        if (repair) {
            reportHelper.saveOne(reportDy);
            if (!this.notExistReportFields.isEmpty()) {
                this.rowFieldHelper.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)reportId), new QFilter("numberalias", "in", this.notExistReportFields)});
                this.colFieldHelper.deleteByFilter(new QFilter[]{new QFilter("rptmanage", "=", (Object)reportId), new QFilter("numberalias", "in", this.notExistReportFields)});
            }
        }
        this.handleFilter(reportId, repair, errorMsg);
        this.handleCalculateIndexes(reportId, repair, errorMsg);
        return errorMsg.length() == 0;
    }

    private String handleColFields(int i, String colStr, StringBuilder errorMsg) {
        if (HRStringUtils.isEmpty((String)colStr)) {
            return colStr;
        }
        List columns = SerializationUtils.fromJsonStringToList((String)colStr, FieldInfo.class);
        StringBuilder notExistFieldNameSb = new StringBuilder();
        columns.removeIf(col -> {
            if (this.validateRowOrColFieldExist((FieldInfo)col, notExistFieldNameSb)) {
                this.notExistReportFields.add(col.getNumberAlias());
                return true;
            }
            return false;
        });
        if (notExistFieldNameSb.length() > 0) {
            errorMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1s\u5f20\u5de5\u4f5c\u8868\u5217\u4e0a\u7684\u5b57\u6bb5\u201c%2s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ReportDataMonitorService_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), i + 1, notExistFieldNameSb.substring(0, notExistFieldNameSb.length() - 1)));
            errorMsg.append("\r\n");
        }
        return SerializationUtils.toJsonString((Object)columns);
    }

    private String handleRowFields(int i, String rowStr, StringBuilder errorMsg) {
        if (HRStringUtils.isEmpty((String)rowStr)) {
            return rowStr;
        }
        List rows = SerializationUtils.fromJsonStringToList((String)rowStr, RowFieldInfo.class);
        StringBuilder notExistFieldNameSb = new StringBuilder();
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            RowFieldInfo row = (RowFieldInfo)iterator.next();
            if (HRStringUtils.equals((String)row.getMergeType(), (String)"1")) {
                FieldInfoUtil.recursive(row._getChildFields(), subField -> {
                    if (this.validateRowOrColFieldExist((FieldInfo)subField, notExistFieldNameSb)) {
                        this.notExistReportFields.add(subField.getNumberAlias());
                    }
                });
                if (row._getChildFields() == null) continue;
                row._getChildFields().removeIf(field -> this.notExistReportFields.contains(field.getNumberAlias()));
                row._getOriFields().removeIf(field -> this.notExistReportFields.contains(field.getNumberAlias()));
                if (!row._getChildFields().isEmpty() || !row._getOriFields().isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (HRStringUtils.equals((String)row.getMergeType(), (String)"2")) {
                FieldInfo dimField = row.getGroupName();
                if (this.validateRowOrColFieldExist(dimField, notExistFieldNameSb)) {
                    this.notExistReportFields.add(row.getGroupName().getNumberAlias());
                    iterator.remove();
                    continue;
                }
                if (row._getChildFields() == null) continue;
                row._getChildFields().removeIf(subField -> {
                    if (this.validateRowOrColFieldExist((FieldInfo)subField, notExistFieldNameSb)) {
                        this.notExistReportFields.add(subField.getNumberAlias());
                        return true;
                    }
                    return false;
                });
                if (!row._getChildFields().isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (!this.validateRowOrColFieldExist(row.getGroupName(), notExistFieldNameSb)) continue;
            iterator.remove();
        }
        if (notExistFieldNameSb.length() > 0) {
            errorMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1s\u5f20\u5de5\u4f5c\u8868\u884c\u4e0a\u7684\u5b57\u6bb5\u201c%2s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ReportDataMonitorService_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), i + 1, notExistFieldNameSb.substring(0, notExistFieldNameSb.length() - 1)));
            errorMsg.append("\r\n");
        }
        return SerializationUtils.toJsonString((Object)rows);
    }

    private boolean validateRowOrColFieldExist(FieldInfo fieldInfo, StringBuilder notExistFieldNameSb) {
        if (this.fieldNotExist(fieldInfo.getNumber())) {
            this.notExistReportFields.add(fieldInfo.getNumberAlias());
            notExistFieldNameSb.append(fieldInfo.getDisplayName().getLocaleValue()).append(",");
            return true;
        }
        return false;
    }

    private boolean fieldNotExist(String fieldAlias) {
        if (fieldAlias != null && fieldAlias.contains("!")) {
            fieldAlias = fieldAlias.split("!")[0];
        }
        return this.notExistFieldAliasSet.contains(fieldAlias) || !this.anObjAllFields.contains(fieldAlias);
    }

    private boolean fieldNotExistForReportField(String fieldNumberAlias) {
        return this.notExistReportFields.contains(fieldNumberAlias);
    }

    private boolean fieldNotExistForReportCalField(String reportFieldAlias) {
        String fieldAlias = reportFieldAlias;
        if (reportFieldAlias != null && reportFieldAlias.contains("!")) {
            fieldAlias = reportFieldAlias.split("!")[0];
        }
        return this.notExistReportFields.contains(reportFieldAlias) || !this.anObjAllFields.contains(fieldAlias);
    }

    private void handleDataFilter(DynamicObject reportDy, StringBuilder errorMsg) {
        String dataFilter = reportDy.getString("datafilter");
        if (HRStringUtils.isEmpty((String)dataFilter)) {
            return;
        }
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
        List paramList = conditionInfo.getConditionList().stream().map(ConditionInfo::getParam).collect(Collectors.toList());
        List notExistFields = paramList.stream().filter(this::fieldNotExist).collect(Collectors.toList());
        if (notExistFields.size() > 0) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u8fc7\u6ee4\u4e2d\u5f15\u7528\u7684\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"ReportDataMonitorService_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[]{String.join((CharSequence)",", notExistFields)}), new Object[0]));
            errorMsg.append("\r\n");
            reportDy.set("datafilter", null);
        }
    }

    private void handleFilter(long reportId, boolean repair, StringBuilder errorMsg) {
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("hrptmc_filter");
        DynamicObject[] filterDys = filterHelper.query("anobjfield,name", new QFilter[]{new QFilter("rptmanage", "=", (Object)reportId)});
        ArrayList deleteFilterIds = Lists.newArrayListWithCapacity((int)10);
        ArrayList anObjFieldIds = Lists.newArrayListWithCapacity((int)10);
        StringBuilder filterNameSb = new StringBuilder();
        for (DynamicObject filterDy : filterDys) {
            DynamicObject anObjFieldDy = filterDy.getDynamicObject("anobjfield");
            if (anObjFieldDy == null) {
                deleteFilterIds.add(filterDy.getLong("id"));
                filterNameSb.append(filterDy.getLocaleString("name").getLocaleValue()).append(",");
                continue;
            }
            anObjFieldIds.add(anObjFieldDy.getLong("id"));
        }
        HRBaseServiceHelper anObjFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
        DynamicObjectCollection anObjFieldDys = anObjFieldHelper.queryOriginalCollection("id,fieldalias", new QFilter[]{new QFilter("id", "in", (Object)anObjFieldIds)});
        Map<Long, String> anObjFieldMap = anObjFieldDys.stream().collect(Collectors.toMap(field -> field.getLong("id"), field -> field.getString("fieldalias")));
        for (DynamicObject filterDy : filterDys) {
            long anObjFieldId;
            String fieldAlias;
            DynamicObject anObjFieldDy = filterDy.getDynamicObject("anobjfield");
            if (anObjFieldDy == null || !this.fieldNotExist(fieldAlias = anObjFieldMap.get(anObjFieldId = anObjFieldDy.getLong("id")))) continue;
            deleteFilterIds.add(filterDy.getLong("id"));
            filterNameSb.append(filterDy.getLocaleString("name").getLocaleValue()).append(",");
        }
        if (filterNameSb.length() > 0) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b5b\u9009\u5668\u4e2d\u5f15\u7528\u7684\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"ReportDataMonitorService_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[]{filterNameSb.substring(0, filterNameSb.length() - 1)}), new Object[0]));
            errorMsg.append("\r\n");
        }
        if (repair) {
            filterHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", (Object)deleteFilterIds)});
        }
    }

    private void handleCalculateIndexes(long reportId, boolean repair, StringBuilder errorMsg) {
        DynamicObject[] calculateFields = CalculateFieldService.getInstance().loadCalFieldByReportId(Long.valueOf(reportId));
        ArrayList notExistCalculateFields = Lists.newArrayListWithCapacity((int)10);
        List calculateFieldList = Arrays.stream(calculateFields).sorted(Comparator.comparing(field -> field.getInt("index"))).collect(Collectors.toList());
        StringBuilder notExistCalFieldSb = new StringBuilder();
        block0: for (DynamicObject calculateField : calculateFieldList) {
            String calculateName = calculateField.getLocaleString("name").getLocaleValue();
            String calculateNumber = calculateField.getString("number");
            DynamicObjectCollection refFieldEntry = calculateField.getDynamicObjectCollection("reffieldentry");
            for (DynamicObject refFieldDy : refFieldEntry) {
                String refType = refFieldDy.getString("reftype");
                String refNum = "";
                if (HRStringUtils.equals((String)refType, (String)"entityfield")) {
                    refNum = refFieldDy.getString("reffieldalias");
                } else if (HRStringUtils.equals((String)refType, (String)"calfield")) {
                    refNum = refFieldDy.getDynamicObject("refcalfield").getString("number");
                }
                if (!this.fieldNotExistForReportCalField(refNum)) continue;
                notExistCalculateFields.add(calculateField);
                this.notExistReportFields.add(calculateNumber);
                notExistCalFieldSb.append(calculateName).append("(").append(calculateNumber).append(")").append("\uff0c");
                continue block0;
            }
        }
        if (notExistCalFieldSb.length() > 0) {
            errorMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u62a5\u8868\u4e2d\u7684\u8ba1\u7b97\u5b57\u6bb5%s\u6570\u636e\u5f02\u5e38\u3002", (String)"ReportDataMonitorService_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), notExistCalFieldSb.substring(0, notExistCalFieldSb.length() - 1)));
            errorMsg.append("\r\n");
            if (repair) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_calculatefield");
                List ids = notExistCalculateFields.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", ids)});
            }
        }
    }

    private void handlePresetIndexDimMap(int i, long workRptId, boolean repair, StringBuilder errorMsg) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_dimmap");
        DynamicObject[] dimMapDys = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)});
        StringBuilder notExistDimSb = new StringBuilder();
        HashSet notExistDimSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dimMapDy : dimMapDys) {
            DynamicObjectCollection dimMapEntryCol = dimMapDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dimMapEntryDy : dimMapEntryCol) {
                String dimNum = dimMapEntryDy.getString("dimnumber");
                if (!this.notExistReportFields.contains(dimNum) && !this.notExistFieldAliasSet.contains(dimNum)) continue;
                String dimName = dimMapEntryDy.getLocaleString("dim").getLocaleValue();
                notExistDimSb.append(dimName).append("(").append(dimNum).append(")").append("\uff0c");
                notExistDimSet.add(dimNum);
            }
            dimMapEntryCol.removeIf(dim -> notExistDimSet.contains(dim.getString("dimnumber")));
        }
        if (notExistDimSb.length() > 0) {
            errorMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%1s\u5f20\u5de5\u4f5c\u8868\u7684\u9884\u7f6e\u6307\u6807\u7ef4\u5ea6\u6620\u5c04\u4e2d\u5f15\u7528\u7684\u5b57\u6bb5\u201c%2s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ReportDataMonitorService_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), i + 1, notExistDimSb.substring(0, notExistDimSb.length() - 1)));
            errorMsg.append("\r\n");
            if (repair) {
                helper.save(dimMapDys);
            }
        }
    }

    private void handleTotalRow(int i, DynamicObject reportConfigDy, StringBuilder errorMsg) {
        DynamicObjectCollection rowSubTotalFields = reportConfigDy.getDynamicObjectCollection("subtotalfield");
        Set rowFieldIds = rowSubTotalFields.stream().map(field -> field.getLong("fbasedataid.id")).collect(Collectors.toSet());
        DynamicObject[] rowFieldCol = this.rowFieldHelper.query("id,numberalias", new QFilter[]{new QFilter("id", "in", rowFieldIds)});
        rowSubTotalFields.clear();
        StringBuilder fieldNameSb = new StringBuilder();
        for (DynamicObject rowFieldDy : rowFieldCol) {
            String fieldNumberAlias = rowFieldDy.getString("numberalias");
            if (this.fieldNotExistForReportField(fieldNumberAlias)) {
                fieldNameSb.append(rowFieldDy.getLocaleString("displayname").getLocaleValue()).append(",");
                continue;
            }
            DynamicObject newRowFieldDy = new DynamicObject(rowSubTotalFields.getDynamicObjectType());
            newRowFieldDy.set("fbasedataId", (Object)rowFieldDy);
            rowSubTotalFields.add((Object)newRowFieldDy);
        }
        reportConfigDy.set("subtotalfield", (Object)rowSubTotalFields);
        DynamicObjectCollection indexAlgorithmEntry = reportConfigDy.getDynamicObjectCollection("entryentity1");
        indexAlgorithmEntry.removeIf(entryBo -> this.fieldNotExistForReportField(entryBo.getString("numberalias")));
        reportConfigDy.set("entryentity1", (Object)indexAlgorithmEntry);
        if (fieldNameSb.length() > 0) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1s\u5f20\u62a5\u8868\u6c47\u603b\u884c\u5c0f\u8ba1\u7ef4\u5ea6\u5b57\u6bb5\u201c%2s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ReportDataMonitorService_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[]{i + 1, fieldNameSb.substring(0, fieldNameSb.length() - 1)}), new Object[0]));
            errorMsg.append("\r\n");
        }
    }

    private void handleTotalCol(long reportCfgId, boolean repair) {
        HRBaseServiceHelper totalColHelper = new HRBaseServiceHelper("hrptmc_algorithmcol");
        DynamicObject totalDy = totalColHelper.loadDynamicObject(new QFilter[]{new QFilter("rptconfig.id", "=", (Object)reportCfgId)});
        if (totalDy == null) {
            return;
        }
        String dimFieldStr = totalDy.getString("dimfield");
        if (HRStringUtils.isNotEmpty((String)dimFieldStr)) {
            String[] split = dimFieldStr.split(",");
            List dimFields = Arrays.stream(split).filter(dimField -> !this.fieldNotExistForReportField((String)dimField)).collect(Collectors.toList());
            dimFieldStr = String.join((CharSequence)",", dimFields);
            totalDy.set("dimfield", (Object)dimFieldStr);
        }
        DynamicObjectCollection algorithmTypeEntry = totalDy.getDynamicObjectCollection("entryentity");
        algorithmTypeEntry.removeIf(algoType -> this.fieldNotExistForReportField(algoType.getString("numberalias")));
        if (repair) {
            totalColHelper.saveOne(totalDy);
        }
    }

    private void handlePivot(DynamicObject reportConfigDy) {
        String pivotStr = reportConfigDy.getString("rowcoltransposition");
        if (HRStringUtils.isEmpty((String)pivotStr)) {
            return;
        }
        MergeInfo rowColTranspositionInfo = (MergeInfo)SerializationUtils.fromJsonString((String)pivotStr, MergeInfo.class);
        rowColTranspositionInfo.getHeaders().removeIf(head -> {
            head._getChildFields().removeIf(subHead -> this.fieldNotExistForReportField(subHead.getNumberAlias()));
            return this.fieldNotExistForReportField(head.getGroupName().getNumberAlias());
        });
        rowColTranspositionInfo.getRefFields().removeIf(head -> this.fieldNotExistForReportField(head.getGroupName().getNumberAlias()));
        if (rowColTranspositionInfo.getRefFields().isEmpty()) {
            reportConfigDy.set("rowcoltransposition", null);
        } else {
            reportConfigDy.set("rowcoltransposition", (Object)SerializationUtils.toJsonString((Object)rowColTranspositionInfo));
        }
    }

    private void handleHeaderMerge(DynamicObject reportConfigDy) {
        String headerMergeStr = reportConfigDy.getString("headermerge");
        if (HRStringUtils.isEmpty((String)headerMergeStr)) {
            return;
        }
        MergeInfo headerMergeInfo = (MergeInfo)SerializationUtils.fromJsonString((String)headerMergeStr, MergeInfo.class);
        headerMergeInfo.getHeaders().removeIf(head -> {
            if (head._getChildFields() == null) {
                return false;
            }
            head._getChildFields().removeIf(subHead -> this.fieldNotExistForReportField(subHead.getNumberAlias()));
            return this.fieldNotExistForReportField(head.getGroupName().getNumberAlias());
        });
        List refFields = headerMergeInfo.getRefFields();
        if (refFields != null && !refFields.isEmpty()) {
            headerMergeInfo.getRefFields().removeIf(head -> this.fieldNotExistForReportField(head.getGroupName().getNumberAlias()));
        }
        reportConfigDy.set("headermerge", (Object)SerializationUtils.toJsonString((Object)headerMergeInfo));
    }

    private void handleJumpConfig(long workRptId, boolean repair) {
        DynamicObject[] jumpConfigDys;
        HRBaseServiceHelper jumpConfigHelper = new HRBaseServiceHelper("hrptmc_reportjump");
        for (DynamicObject jumpConfigDy : jumpConfigDys = jumpConfigHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("workrpt", "=", (Object)workRptId)})) {
            String ruleGroup = jumpConfigDy.getString("rulegroup");
            if (HRStringUtils.isNotEmpty((String)ruleGroup)) {
                String[] split = ruleGroup.split(",");
                List dimFields = Arrays.stream(split).filter(dimField -> !this.fieldNotExistForReportField((String)dimField)).collect(Collectors.toList());
                ruleGroup = String.join((CharSequence)",", dimFields);
                jumpConfigDy.set("dimfield", (Object)ruleGroup);
            }
            DynamicObjectCollection jumpRuleCol = jumpConfigDy.getDynamicObjectCollection("jumpruleentry");
            jumpRuleCol.removeIf(jumpRuleDy -> {
                String type = jumpRuleDy.getString("type");
                if (HRStringUtils.equals((String)type, (String)"field")) {
                    String sourceField = jumpRuleDy.getString("sourcefield");
                    return this.fieldNotExistForReportField(sourceField);
                }
                return false;
            });
        }
        if (repair) {
            jumpConfigHelper.save(jumpConfigDys);
        }
    }
}

