/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.display;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;

public class DisplaySchemeInfoEditPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String KEY_SCHEME_NAME = "name";
    private static final String KEY_SCHEME_DESC = "schemedesc";
    private static final String FORM_PLUGIN_PRJECT_ROOT = "hrmp-hrptmc-formplugin";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterBindData(EventObject evt) {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        Map params = formParam.getCustomParams();
        Object schemename = params.get(KEY_SCHEME_NAME);
        Object schemedesc = params.get(KEY_SCHEME_DESC);
        IDataModel model = this.getModel();
        model.setValue(KEY_SCHEME_NAME, schemename);
        model.setValue(KEY_SCHEME_DESC, schemedesc);
        this.getView().updateView(KEY_SCHEME_NAME);
        this.getView().updateView(KEY_SCHEME_DESC);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                if (!this.checkNameLength()) {
                    return;
                }
                if (!this.checkNameExists()) {
                    return;
                }
                HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
                IDataModel model = this.getModel();
                returnData.put(KEY_SCHEME_NAME, model.getValue(KEY_SCHEME_NAME));
                returnData.put(KEY_SCHEME_DESC, model.getValue(KEY_SCHEME_DESC));
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkNameLength() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String currName = dataEntity.getString(KEY_SCHEME_NAME);
        TextEdit nameControl = (TextEdit)this.getView().getControl(KEY_SCHEME_NAME);
        TextProp prop = (TextProp)nameControl.getProperty();
        if (StringUtils.isEmpty((CharSequence)currName)) {
            String tip = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u65b9\u6848\u540d\u79f0\u201d\u3002", (String)"DisplaySchemeInfoEditPlugin_2", (String)FORM_PLUGIN_PRJECT_ROOT, (Object[])new Object[0]);
            this.getView().showErrorNotification(tip);
            return false;
        }
        if (currName.length() > prop.getMaxLenth()) {
            String tip = MessageFormat.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e{0}\u548c{1}\u4e4b\u95f4\u3002", (String)"DisplaySchemeInfoEditPlugin_0", (String)FORM_PLUGIN_PRJECT_ROOT, (Object[])new Object[0]), prop.getMinLenth(), prop.getMaxLenth());
            this.getView().showErrorNotification(tip);
            return false;
        }
        return true;
    }

    private boolean checkNameExists() {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        Map params = formParam.getCustomParams();
        String pkId = String.valueOf(params.get("id"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String currName = dataEntity.getString(KEY_SCHEME_NAME);
        IHRAppCache cache = HRAppCache.get((String)"hrptmc");
        String schmNodeStr = (String)cache.get(this.getView().getPageId() + "_schmNodes", String.class);
        if (schmNodeStr == null) {
            schmNodeStr = this.getView().getParentView().getPageCache().get("schmNodes");
        }
        if (schmNodeStr == null) {
            return true;
        }
        List schmNodes = (List)SerializationUtils.deSerializeFromBase64((String)schmNodeStr);
        TreeNode schmNode = null;
        for (int i = 0; i < schmNodes.size(); ++i) {
            schmNode = (TreeNode)schmNodes.get(i);
            if (schmNode.getId().equals(pkId) || !schmNode.getText().equals(currName)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DisplaySchemeInfoEditPlugin_1", (String)FORM_PLUGIN_PRJECT_ROOT, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void pageRelease(EventObject eventObject) {
        IHRAppCache cache = HRAppCache.get((String)"hrptmc");
        cache.remove(this.getView().getPageId() + "_schmNodes");
    }
}

