/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.filter;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.metadata.edit.MulHisModelBasedataEdit;
import kd.bos.ext.hr.report.control.VestDate;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterConstants;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterDataBo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldApUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldEditUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldPropUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SplitDateUtil;
import org.springframework.beans.BeanUtils;

public class FilterSettingEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
FilterConstants {
    private static final String CACHE_KEY_OLD = "cache_old";
    private static final String BEGIN_DATE = "begindate";
    private static final String END_DATE = "enddate";
    private static final String END_DATE_AP = "flexpanelapbegindate";
    private static final Log LOGGER = LogFactory.getLog(FilterSettingEdit.class);
    public static final String FILTER_DEF_VALUE_SCOPE = "filterdefvaluescope";
    public static final String FILTER_MUL_DEF_VALUE = "filtermuldefvalue";
    public static final String FILTER_DEF_VALUE = "filterdefvalue";
    public static final String QUICK_SCOPE_AP = "flexpanelapquickscope";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs customControlMetasArgs) {
        super.loadCustomControlMetas(customControlMetasArgs);
        FormShowParameter formShowParameter = (FormShowParameter)customControlMetasArgs.getSource();
        String controlType = (String)formShowParameter.getCustomParam("controlType");
        try {
            FilterDataBo cast = (FilterDataBo)HRJSONUtils.cast((String)controlType, FilterDataBo.class);
            FilterBo bo = cast.getData();
            if (bo == null) {
                return;
            }
            List<FilterBo> list = this.getFilterBos(bo);
            formShowParameter.setCustomParam("filterBo", (Object)SerializationUtils.toJsonString(list));
            for (FilterBo filterBo : list) {
                FlexPanelAp headPanelAp = new FlexPanelAp();
                headPanelAp.setKey("headAp" + filterBo.getFieldAlias());
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                FieldApUtils.handDateFilter(filterBo, map);
                map.put("type", "set");
                if (FILTER_MUL_DEF_VALUE.equals(filterBo.getFieldAlias()) && "number".equals(filterBo.getFilterType())) {
                    List<ControlAp<?>> numberAp = FieldApUtils.getNumberAp(filterBo);
                    headPanelAp.getItems().addAll(numberAp);
                } else {
                    FieldAp fieldAp = FieldApUtils.customTypeAp(filterBo, null, map, null);
                    FieldApUtils.handlerStyle(fieldAp, "30px", null);
                    headPanelAp.getItems().add(fieldAp);
                }
                HashMap<String, String> mapHead = new HashMap<String, String>(16);
                mapHead.put("id", filterBo.getFieldAlias() + "ap");
                mapHead.put("items", (String)headPanelAp.createControl().get("items"));
                customControlMetasArgs.getItems().add(mapHead);
            }
        }
        catch (IOException ioException) {
            LOGGER.error((Throwable)ioException);
        }
    }

    private List<FilterBo> getFilterBos(FilterBo bo) {
        ArrayList<FilterBo> list = new ArrayList<FilterBo>();
        if (!HRStringUtils.equals((String)bo.getFilterType(), (String)"date") && !HRStringUtils.equals((String)bo.getFilterType(), (String)"number")) {
            FilterBo bo1 = new FilterBo();
            BeanUtils.copyProperties((Object)bo, (Object)bo1);
            bo1.setMustInput(false);
            bo1.setFieldAlias(FILTER_DEF_VALUE_SCOPE);
            bo1.setSelectedAll(true);
            bo1.setFilterAlias(new LocaleString(ResManager.loadKDString((String)"\u53ef\u7b5b\u9009\u8303\u56f4", (String)"FilterSettingEdit_7", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
            bo1.setBaseDataMul(true);
            list.add(bo1);
        }
        FilterBo filterBo1 = new FilterBo();
        BeanUtils.copyProperties((Object)bo, (Object)filterBo1);
        filterBo1.setMustInput(false);
        filterBo1.setFieldAlias(FILTER_MUL_DEF_VALUE);
        filterBo1.setFilterAlias(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u7b5b\u9009\u503c", (String)"FilterSettingEdit_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
        filterBo1.setBaseDataMul(true);
        filterBo1.setDateType("0");
        list.add(filterBo1);
        FilterBo filterBo2 = new FilterBo();
        BeanUtils.copyProperties((Object)bo, (Object)filterBo2);
        filterBo2.setMustInput(false);
        filterBo2.setFieldAlias(FILTER_DEF_VALUE);
        filterBo2.setFilterAlias(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u7b5b\u9009\u503c", (String)"FilterSettingEdit_8", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0])));
        filterBo2.setBaseDataMul(false);
        filterBo2.setDateType("1");
        list.add(filterBo2);
        return list;
    }

    public void getEntityType(GetEntityTypeEventArgs eventArgs) {
        MainEntityType newMainType;
        MainEntityType oldMainType = eventArgs.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("filterBo");
        if (data == null) {
            return;
        }
        List filterBoList = SerializationUtils.fromJsonStringToList((String)data, FilterBo.class);
        for (FilterBo filterBo : filterBoList) {
            FieldPropUtils.getProp(filterBo, newMainType);
        }
        eventArgs.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs onGetControlArgs) {
        super.onGetControl(onGetControlArgs);
        String key = onGetControlArgs.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("filterBo");
        if (data == null) {
            return;
        }
        List filterBoList = SerializationUtils.fromJsonStringToList((String)data, FilterBo.class);
        for (FilterBo filterBo : filterBoList) {
            FieldEdit edit;
            if (HRStringUtils.equalsIgnoreCase((String)key, (String)filterBo.getFieldAlias())) {
                edit = FieldEditUtils.getEdit(filterBo, this);
                onGetControlArgs.setControl((Control)edit);
                continue;
            }
            if (key.equals(filterBo.getFieldAlias() + "_" + "beginnumber") || key.equals(filterBo.getFieldAlias() + "_" + "endnumber")) {
                edit = FieldEditUtils.getDecimalEdit(key, (AbstractFormPlugin)this);
                onGetControlArgs.setControl((Control)edit);
                continue;
            }
            if (!key.equals(filterBo.getFieldAlias() + "_" + "opt")) continue;
            edit = FieldEditUtils.getComboEdit(key, (AbstractFormPlugin)this);
            onGetControlArgs.setControl((Control)edit);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("controlType");
        try {
            FilterDataBo cast = (FilterDataBo)HRJSONUtils.cast((String)type, FilterDataBo.class);
            FilterBo filterBo = cast.getData();
            this.setVisible(filterBo);
        }
        catch (IOException ioException) {
            LOGGER.error((Throwable)ioException);
        }
    }

    private void setVisible(FilterBo filterBo) {
        if (filterBo.getBaseDataMul()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"filtermuldefvalueapap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"filterdefvalueapap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtermuldefvalueapap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filterdefvalueapap"});
        }
        FilterType filterTypeByValue = FilterType.getFilterTypeByValue((String)filterBo.getFilterType());
        switch (filterTypeByValue) {
            case BASE_DATA: 
            case HIS_BASE_DATA: 
            case ADMIN_ORG: {
                ArrayList idList;
                String[] split;
                String bdDefaultValue = filterBo.getBdDefaultValue();
                String bdFilterRange = filterBo.getBdFilterRange();
                if (HRStringUtils.isEmpty((String)bdFilterRange)) {
                    this.getModel().setValue(FILTER_DEF_VALUE_SCOPE, null);
                } else {
                    split = bdFilterRange.split(",");
                    idList = Lists.newArrayListWithCapacity((int)split.length);
                    for (String id : split) {
                        idList.add(Long.parseLong(id));
                    }
                    this.getModel().setValue(FILTER_DEF_VALUE_SCOPE, (Object)idList.toArray());
                }
                if (HRStringUtils.isEmpty((String)bdDefaultValue)) {
                    this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
                    this.getModel().setValue(FILTER_DEF_VALUE, null);
                    break;
                }
                split = bdDefaultValue.split(",");
                idList = Lists.newArrayListWithCapacity((int)split.length);
                for (String id : split) {
                    idList.add(Long.parseLong(id));
                }
                if (filterBo.getBaseDataMul()) {
                    this.getModel().setValue(FILTER_MUL_DEF_VALUE, (Object)idList.toArray());
                    break;
                }
                this.getModel().setValue(FILTER_DEF_VALUE, (Object)Long.parseLong(bdDefaultValue));
                break;
            }
            case DATE: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"filterdefvaluescopeapap"});
                String filterStartDateStr = filterBo.getFilterStartDateStr();
                if (HRStringUtils.equals((String)filterBo.getDateType(), (String)"0")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"filterdefvalueapap"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"filtermuldefvalueapap"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"filterdefvalueapap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"filtermuldefvalueapap"});
                try {
                    if (HRStringUtils.isNotEmpty((String)filterStartDateStr)) {
                        Date date = HRDateTimeUtils.parseDate((String)filterStartDateStr);
                        this.getModel().setValue(FILTER_DEF_VALUE, (Object)date);
                        break;
                    }
                    this.getModel().setValue(FILTER_DEF_VALUE, null);
                }
                catch (ParseException e) {
                    LOGGER.error((Throwable)e);
                }
                break;
            }
            case ENUM: {
                this.handleCombo(filterBo);
                break;
            }
            case STRING: {
                String textDefaultValue = filterBo.getTextDefaultValue();
                this.getModel().setValue(FILTER_MUL_DEF_VALUE, (Object)textDefaultValue);
                break;
            }
            case NUMBER: {
                String opt = filterBo.getOpt();
                this.getModel().setValue("filtermuldefvalue_opt", (Object)opt);
                this.getView().updateView("filtermuldefvalue_opt");
                String defaultValue = filterBo.getTextDefaultValue();
                if ("between".equals(opt)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_MUL_DEF_VALUE});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"filternumberdefvalueap"});
                    if (!HRStringUtils.isNotEmpty((String)defaultValue)) break;
                    String[] number = defaultValue.split(",", 2);
                    if (HRStringUtils.isNotEmpty((String)number[0])) {
                        this.getModel().setValue("filtermuldefvalue_beginnumber", (Object)new BigDecimal(number[0]));
                        this.getView().updateView("filtermuldefvalue_beginnumber");
                    }
                    if (!HRStringUtils.isNotEmpty((String)number[1])) break;
                    this.getModel().setValue("filtermuldefvalue_endnumber", (Object)new BigDecimal(number[1]));
                    this.getView().updateView("filtermuldefvalue_endnumber");
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{FILTER_MUL_DEF_VALUE});
                this.getView().setVisible(Boolean.FALSE, new String[]{"filternumberdefvalueap"});
                if (!HRStringUtils.isNotEmpty((String)defaultValue)) break;
                this.getModel().setValue(FILTER_MUL_DEF_VALUE, (Object)new BigDecimal(defaultValue));
                break;
            }
        }
        this.getView().updateView(FILTER_MUL_DEF_VALUE);
        this.getView().updateView(FILTER_DEF_VALUE_SCOPE);
        this.getView().updateView(FILTER_DEF_VALUE);
    }

    private void handleCombo(FilterBo filterBo) {
        String textDefaultValue = filterBo.getTextDefaultValue();
        String textFilterRange = filterBo.getTextFilterRange();
        this.getModel().setValue(FILTER_MUL_DEF_VALUE, (Object)textDefaultValue);
        this.getModel().setValue(FILTER_DEF_VALUE, (Object)textDefaultValue);
        this.getModel().setValue(FILTER_DEF_VALUE_SCOPE, (Object)textFilterRange);
        if (HRStringUtils.isNotEmpty((String)textFilterRange)) {
            String[] split = textFilterRange.split(",");
            String fieldPath = filterBo.getFieldPath();
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
            if (filterBo.getGroupField()) {
                int i;
                List groupFieldEnums = AnObjGroupFieldService.getInstance().getGroupFieldEnums(Long.parseLong(filterBo.getGroupFieldId()));
                if (split.length > 0) {
                    for (i = 0; i < groupFieldEnums.size(); ++i) {
                        String number = (String)((Map)groupFieldEnums.get(i)).get("number");
                        if (!textFilterRange.contains(number)) continue;
                        list.add(new ComboItem((LocaleString)((Map)groupFieldEnums.get(i)).get("name"), (String)((Map)groupFieldEnums.get(i)).get("number")));
                    }
                } else {
                    for (i = 0; i < groupFieldEnums.size(); ++i) {
                        list.add(new ComboItem((LocaleString)((Map)groupFieldEnums.get(i)).get("name"), (String)((Map)groupFieldEnums.get(i)).get("number")));
                    }
                }
            } else if (HRStringUtils.isNotEmpty((String)fieldPath) && fieldPath.contains("!")) {
                List<ComboItem> comboItemList = SplitDateUtil.getInstance().getComboItemsByFieldPath(fieldPath);
                block2: for (ComboItem comboItem : comboItemList) {
                    for (String st : split) {
                        if (!HRStringUtils.equals((String)st, (String)comboItem.getValue())) continue;
                        list.add(new ComboItem(comboItem.getCaption(), comboItem.getValue()));
                        continue block2;
                    }
                }
            } else {
                IDataEntityProperty dataEntityProperty = FieldApUtils.getDataEntityProperty(filterBo);
                ComboProp comboProp = (ComboProp)dataEntityProperty;
                List comboItems = comboProp.getComboItems();
                block4: for (int i = 0; i < comboItems.size(); ++i) {
                    for (String st : split) {
                        if (!HRStringUtils.equals((String)st, (String)((ValueMapItem)comboItems.get(i)).getValue())) continue;
                        list.add(new ComboItem(((ValueMapItem)comboItems.get(i)).getName(), ((ValueMapItem)comboItems.get(i)).getValue()));
                        continue block4;
                    }
                }
            }
            ComboEdit mulControl = (ComboEdit)this.getControl(FILTER_MUL_DEF_VALUE);
            mulControl.setComboItems(list);
            ComboEdit control = (ComboEdit)this.getControl(FILTER_DEF_VALUE);
            control.setComboItems(list);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("controlType");
        try {
            FilterDataBo cast = (FilterDataBo)HRJSONUtils.cast((String)type, FilterDataBo.class);
            FilterBo filterBo = cast.getData();
            if (HRStringUtils.equals((String)filterBo.getDateScope(), (String)",,")) {
                filterBo.setDateScope("");
            }
            if (HRStringUtils.equals((String)filterBo.getQuickScope(), (String)",,")) {
                filterBo.setQuickScope("");
            }
            this.getPageCache().put(CACHE_KEY_OLD, HRJSONUtils.toString((Object)cast.getData()));
            if (HRStringUtils.equals((String)cast.getStatus(), (String)"edit")) {
                String substring;
                this.getModel().setValue("filtertype", (Object)cast.getData().getFilterType());
                this.getModel().setValue("hisdate", (Object)cast.getData().getHisDate());
                this.getModel().setValue("hisscope", (Object)(cast.getData().getHisData() ? "1" : "0"));
                this.getModel().setValue("datetype", (Object)cast.getData().getDateType());
                this.getModel().setValue("enable", (Object)(cast.getData().getEnable() ? "1" : "0"));
                this.getModel().setValue("ismust", (Object)(cast.getData().getMustInput() ? "1" : "0"));
                this.getModel().setValue("datescope", (Object)cast.getData().getDateScope());
                this.getModel().setValue("quickscope", (Object)cast.getData().getQuickScope());
                String fieldPath = cast.getData().getFieldPath();
                if (HRStringUtils.isNotEmpty((String)fieldPath) && (HRStringUtils.equals((String)(substring = fieldPath.substring(fieldPath.indexOf("!") + 1)), (String)SplitDateTypeEnum.SN_YEAR_QUARTER.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_YEAR_QUARTER.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_YEAR.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_YEAR.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.SN_YEAR_MONTH.getKey()) || HRStringUtils.equals((String)substring, (String)SplitDateTypeEnum.FN_YEAR_MONTH.getKey()))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"datescope", "flexpanelap1"});
                }
                this.getModel().setValue("basedataismul", (Object)(cast.getData().getBaseDataMul() ? "1" : "0"));
                this.getModel().setValue("suborg", (Object)cast.getData().getContainSub());
                this.getModel().setValue("orglevel", (Object)(cast.getData().getOrgLevel() ? "1" : "0"));
                this.getModel().setValue("groupdate", (Object)(cast.getData().getGroupDate() ? "1" : "0"));
                String beginDateId = cast.getData().getBeginDateId();
                String endDateId = cast.getData().getEndDateId();
                if (HRStringUtils.isNotEmpty((String)beginDateId) && HRStringUtils.isNotEmpty((String)endDateId)) {
                    HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
                    DynamicObject beginDyn = queryFieldHelper.queryOne((Object)Long.valueOf(beginDateId));
                    DynamicObject endDyn = queryFieldHelper.queryOne((Object)Long.valueOf(endDateId));
                    this.getModel().setValue(BEGIN_DATE, (Object)beginDyn);
                    this.getModel().setValue(END_DATE, (Object)endDyn);
                }
            }
            this.showModel(cast);
        }
        catch (IOException ioException) {
            LOGGER.error((Throwable)ioException);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("filterBo");
        if (data == null) {
            return;
        }
        List filterBoList = SerializationUtils.fromJsonStringToList((String)data, FilterBo.class);
        for (FilterBo filterBo : filterBoList) {
            FlexPanelAp headPanelAp = new FlexPanelAp();
            headPanelAp.setKey("headAp" + filterBo.getFieldAlias());
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            FieldApUtils.handDateFilter(filterBo, map);
            map.put("type", "set");
            FieldAp fieldAp = FieldApUtils.customTypeAp(filterBo, null, map, null);
            headPanelAp.getItems().add(fieldAp);
            Container myFldPanel = (Container)this.getView().getControl(filterBo.getFieldAlias() + "ap");
            myFldPanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(myFldPanel.getItems());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"donothing") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String type = (String)this.getView().getFormShowParameter().getCustomParam("controlType");
            this.getView().getFormShowParameter().setCustomParam("isConfirm", (Object)true);
            try {
                FilterDataBo cast = (FilterDataBo)HRJSONUtils.cast((String)type, FilterDataBo.class);
                FilterBo filterBo = cast.getData();
                cast.setRadNum(System.currentTimeMillis());
                filterBo.setBaseDataMul(HRStringUtils.equals((String)((String)this.getModel().getValue("basedataismul")), (String)"1"));
                filterBo.setEnable(HRStringUtils.equals((String)((String)this.getModel().getValue("enable")), (String)"1"));
                filterBo.setMustInput(HRStringUtils.equals((String)((String)this.getModel().getValue("ismust")), (String)"1"));
                filterBo.setHisData(HRStringUtils.equals((String)((String)this.getModel().getValue("hisscope")), (String)"1"));
                filterBo.setHisDate((String)this.getModel().getValue("hisdate"));
                filterBo.setFilterType((String)this.getModel().getValue("filtertype"));
                filterBo.setDateType((String)this.getModel().getValue("datetype"));
                filterBo.setContainSub((String)this.getModel().getValue("suborg"));
                filterBo.setQuickScope((String)this.getModel().getValue("quickscope"));
                if (HRStringUtils.equals((String)((String)this.getModel().getValue("orglevel")), (String)"1")) {
                    filterBo.setOrgLevel(true);
                } else {
                    filterBo.setOrgLevel(false);
                }
                String filterType = filterBo.getFilterType();
                if (HRStringUtils.equals((String)((String)this.getModel().getValue("datetype")), (String)"1") && HRStringUtils.equals((String)((String)this.getModel().getValue("groupdate")), (String)"1") && "date".equals(filterType)) {
                    String endDateStr;
                    filterBo.setGroupDate(true);
                    Object beginDate = this.getModel().getValue(BEGIN_DATE);
                    Object endDate = this.getModel().getValue(END_DATE);
                    if (beginDate == null && endDate == null) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u65e5\u671f\u4e0e\u7ed3\u675f\u65e5\u671f\u3002", (String)"FilterSettingEdit_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (beginDate == null) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u65e5\u671f\u3002", (String)"FilterSettingEdit_3", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (endDate == null) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u675f\u65e5\u671f\u3002", (String)"FilterSettingEdit_4", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    long beginId = ((DynamicObject)beginDate).getLong("id");
                    long endId = ((DynamicObject)endDate).getLong("id");
                    if (!HRStringUtils.equals((String)filterBo.getFieldId(), (String)String.valueOf(beginId)) && !HRStringUtils.equals((String)filterBo.getFieldId(), (String)String.valueOf(endId))) {
                        this.getView().showMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u6216\u7ed3\u675f\u65e5\u671f\u987b\u7b49\u4e8e%s\u5b57\u6bb5\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"FilterSettingEdit_5", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), filterBo.getFilterAlias().getLocaleValue()));
                        return;
                    }
                    String beginDateStr = ((DynamicObject)beginDate).getString("fieldAlias");
                    if (HRStringUtils.equals((String)beginDateStr, (String)(endDateStr = ((DynamicObject)endDate).getString("fieldAlias")))) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0e\u7ed3\u675f\u65e5\u671f\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"FilterSettingEdit_6", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    filterBo.setBeginDate(beginDateStr);
                    Long beginDateId = ((DynamicObject)beginDate).getLong("id");
                    Long endDateId = ((DynamicObject)endDate).getLong("id");
                    filterBo.setBeginDateId(beginDateId + "");
                    filterBo.setEndDate(endDateStr);
                    filterBo.setEndDateId(endDateId + "");
                } else {
                    filterBo.setGroupDate(false);
                }
                Object dateScope = this.getModel().getValue("datescope");
                if (HRStringUtils.equals((String)filterBo.getDateType(), (String)"1")) {
                    filterBo.setDateScope(dateScope == null ? "" : (String)dateScope);
                } else {
                    if (dateScope == null) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8303\u56f4\u201d\u3002", (String)"FilterSettingEdit_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String value = (String)dateScope;
                    String[] split = value.split(",");
                    if (split.length <= 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8303\u56f4\u201d\u3002", (String)"FilterSettingEdit_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    filterBo.setDateScope((String)dateScope);
                    if (value.contains("quickscope")) {
                        String quickScope = (String)this.getModel().getValue("quickscope");
                        if (HRStringUtils.isEmpty((String)quickScope)) {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5feb\u6377\u533a\u95f4\u201d\u3002", (String)"FilterSettingEdit_12", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        String[] quickScopeSplit = quickScope.split(",");
                        if (quickScopeSplit.length == 0) {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5feb\u6377\u533a\u95f4\u201d\u3002", (String)"FilterSettingEdit_12", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
                this.setDefValue(filterBo);
                this.getView().returnDataToParent((Object)HRJSONUtils.toString((Object)cast));
            }
            catch (IOException ioException) {
                LOGGER.error((Throwable)ioException);
            }
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        String oriReportManage = this.getPageCache().get(CACHE_KEY_OLD);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("controlType");
        try {
            Boolean isConfirm;
            FilterDataBo cast = (FilterDataBo)HRJSONUtils.cast((String)type, FilterDataBo.class);
            FilterBo filterBo = cast.getData();
            filterBo.setBaseDataMul(HRStringUtils.equals((String)((String)this.getModel().getValue("basedataismul")), (String)"1"));
            filterBo.setEnable(HRStringUtils.equals((String)((String)this.getModel().getValue("enable")), (String)"1"));
            filterBo.setMustInput(HRStringUtils.equals((String)((String)this.getModel().getValue("ismust")), (String)"1"));
            filterBo.setGroupDate(HRStringUtils.equals((String)((String)this.getModel().getValue("groupdate")), (String)"1"));
            filterBo.setDateType((String)this.getModel().getValue("datetype"));
            filterBo.setQuickScope((String)this.getModel().getValue("quickscope"));
            filterBo.setHisDate((String)this.getModel().getValue("hisdate"));
            filterBo.setFilterType((String)this.getModel().getValue("filtertype"));
            Object dateScope = this.getModel().getValue("datescope");
            if (dateScope == null) {
                filterBo.setDateScope(null);
            } else {
                String dateScopeStr = (String)dateScope;
                String[] split = dateScopeStr.split(",");
                if (split.length > 0) {
                    filterBo.setDateScope((String)dateScope);
                } else {
                    filterBo.setDateScope(",,");
                }
            }
            String curReportManage = HRJSONUtils.toString((Object)filterBo);
            String curReportManageExp = "";
            if (HRStringUtils.equals((String)filterBo.getDateScope(), (String)",,")) {
                filterBo.setDateScope("");
                curReportManageExp = HRJSONUtils.toString((Object)filterBo);
            }
            if (HRStringUtils.equals((String)filterBo.getQuickScope(), (String)",,")) {
                filterBo.setQuickScope("");
                curReportManageExp = HRJSONUtils.toString((Object)filterBo);
            }
            if (!((isConfirm = (Boolean)this.getView().getFormShowParameter().getCustomParam("isConfirm")) != null && isConfirm.booleanValue() || oriReportManage.equals(curReportManage) || oriReportManage.equals(curReportManageExp))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"FilterSettingEdit_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close_page", (IFormPlugin)this));
                beforeClosedEvent.setCancel(true);
            }
        }
        catch (IOException ioException) {
            LOGGER.error((Throwable)ioException);
        }
    }

    private void setDefValue(FilterBo filterBo) {
        FilterType filterTypeByValue = FilterType.getFilterTypeByValue((String)filterBo.getFilterType());
        switch (filterTypeByValue) {
            case BASE_DATA: 
            case HIS_BASE_DATA: 
            case ADMIN_ORG: {
                String join;
                DynamicObjectCollection scopeDyn = (DynamicObjectCollection)this.getModel().getValue(FILTER_DEF_VALUE_SCOPE);
                DynamicObject defValueDyn = (DynamicObject)this.getModel().getValue(FILTER_DEF_VALUE);
                DynamicObjectCollection mulDefValueDyn = (DynamicObjectCollection)this.getModel().getValue(FILTER_MUL_DEF_VALUE);
                List scopeIds = scopeDyn.stream().map(scope -> scope.getString("fbasedataid_id")).collect(Collectors.toList());
                List mulDefIds = mulDefValueDyn.stream().map(scope -> scope.getString("fbasedataid_id")).collect(Collectors.toList());
                if (filterBo.getBaseDataMul()) {
                    join = String.join((CharSequence)",", mulDefIds);
                    filterBo.setBdDefaultValue(join);
                } else if (!Objects.isNull(defValueDyn)) {
                    filterBo.setBdDefaultValue(defValueDyn.getString("id"));
                } else {
                    filterBo.setBdDefaultValue(null);
                }
                join = String.join((CharSequence)",", scopeIds);
                filterBo.setBdFilterRange(join);
                break;
            }
            case DATE: {
                if (HRStringUtils.equals((String)"0", (String)filterBo.getDateType())) {
                    String vestDate = this.getPageCache().get("filtermuldefvalue_vestdate");
                    if (vestDate == null) {
                        return;
                    }
                    try {
                        Map cast = (Map)HRJSONUtils.cast((String)vestDate, Map.class);
                        String datePickerType = (String)cast.get("datePickerType");
                        if (HRStringUtils.isNotEmpty((String)datePickerType) && datePickerType.startsWith("timescope")) {
                            List datePickerContent = (List)cast.get("datePickerContent");
                            filterBo.setFilterStartDateStr((String)datePickerContent.get(0));
                            filterBo.setFilterEndDateStr((String)datePickerContent.get(1));
                            filterBo.setDateFilterType(datePickerType);
                            filterBo.setDateFilterText(null);
                            break;
                        }
                        String datePickerContent = (String)cast.get("datePickerContent");
                        filterBo.setDateFilterType(datePickerType);
                        filterBo.setDateFilterText(datePickerContent);
                        filterBo.setFilterStartDateStr(null);
                        filterBo.setFilterEndDateStr(null);
                    }
                    catch (IOException e) {
                        LOGGER.error((Throwable)e);
                    }
                    break;
                }
                Date defValue = (Date)this.getModel().getValue(FILTER_DEF_VALUE);
                if (!Objects.isNull(defValue)) {
                    filterBo.setFilterStartDateStr(HRDateTimeUtils.defaultDateString((Date)defValue));
                    break;
                }
                filterBo.setFilterStartDateStr(null);
                break;
            }
            case ENUM: {
                String enumScope = (String)this.getModel().getValue(FILTER_DEF_VALUE_SCOPE);
                String enumDefValue = (String)this.getModel().getValue(FILTER_DEF_VALUE);
                String enumMulDefValue = (String)this.getModel().getValue(FILTER_MUL_DEF_VALUE);
                if (filterBo.getBaseDataMul()) {
                    filterBo.setTextDefaultValue(enumMulDefValue);
                } else {
                    filterBo.setTextDefaultValue(enumDefValue);
                }
                filterBo.setTextFilterRange(enumScope);
                break;
            }
            case ADMIN_DIVISION: {
                break;
            }
            case STRING: {
                String textDefValue = (String)this.getModel().getValue(FILTER_MUL_DEF_VALUE);
                filterBo.setTextDefaultValue(textDefValue);
                break;
            }
            case NUMBER: {
                String opt = (String)this.getModel().getValue("filtermuldefvalue_opt");
                filterBo.setOpt(opt);
                if ("between".equals(opt)) {
                    BigDecimal defValue1 = (BigDecimal)this.getModel().getValue("filtermuldefvalue_beginnumber");
                    BigDecimal defValue2 = (BigDecimal)this.getModel().getValue("filtermuldefvalue_endnumber");
                    String value = "";
                    if (null != defValue1) {
                        value = defValue1.toPlainString();
                    }
                    value = value + ",";
                    if (null != defValue2) {
                        value = value + defValue2.toPlainString();
                    }
                    filterBo.setTextDefaultValue(value);
                    break;
                }
                BigDecimal defValue = (BigDecimal)this.getModel().getValue(FILTER_MUL_DEF_VALUE);
                if (null == defValue) break;
                filterBo.setTextDefaultValue(defValue.toPlainString());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if ("close_page".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.getView().getFormShowParameter().setCustomParam("isConfirm", (Object)true);
            this.getView().close();
        }
    }

    private void showModel(FilterDataBo filterDataBo) {
        String controlType = filterDataBo.getData().getFilterType();
        FilterType filterType = FilterType.getFilterTypeByValue((String)controlType);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{END_DATE_AP, "groupdatepanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{QUICK_SCOPE_AP});
        switch (filterType) {
            case DATE: {
                if (HRStringUtils.equals((String)filterDataBo.getStatus(), (String)"edit") && HRStringUtils.equals((String)filterDataBo.getData().getDateType(), (String)"0")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"selectpanel", "hisscopepanel", "flexpanelaphisdate", "enablepanel", "orglevelpanel", "subpanel"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"groupdatepanel"});
                    ComboEdit control = (ComboEdit)this.getControl("datescope");
                    control.setMustInput(Boolean.TRUE.booleanValue());
                    String dateScope = filterDataBo.getData().getDateScope();
                    if (!dateScope.contains("quickscope")) break;
                    this.getView().setVisible(Boolean.TRUE, new String[]{QUICK_SCOPE_AP});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"selectpanel", "hisscopepanel", "flexpanelaphisdate", "enablepanel", "flexpanelapdatescope", "orglevelpanel", "subpanel"});
                ComboEdit control = (ComboEdit)this.getControl("datescope");
                control.setMustInput(Boolean.FALSE.booleanValue());
                if (filterDataBo.getData().getVirtualEntityField() && !filterDataBo.getData().getHisDateQuery()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"groupdatepanel"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"groupdatepanel"});
                if (filterDataBo.getData().getGroupDate()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{END_DATE_AP});
                    BasedataEdit edit = (BasedataEdit)this.getControl(BEGIN_DATE);
                    edit.setMustInput(Boolean.TRUE.booleanValue());
                    BasedataEdit basedataEdit = (BasedataEdit)this.getControl(END_DATE);
                    basedataEdit.setMustInput(Boolean.TRUE.booleanValue());
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{END_DATE_AP});
                BasedataEdit edit = (BasedataEdit)this.getControl(BEGIN_DATE);
                edit.setMustInput(false);
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(END_DATE);
                basedataEdit.setMustInput(false);
                break;
            }
            case STRING: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"selectpanel", "hisscopepanel", "datepanel", "flexpanelapdatescope", "flexpanelaphisdate", "enablepanel", "orglevelpanel", "subpanel", "filterdefvaluescopeapap"});
                break;
            }
            case ENUM: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"hisscopepanel", "datepanel", "flexpanelapdatescope", "flexpanelaphisdate", "enablepanel", "orglevelpanel", "subpanel"});
                break;
            }
            case BASE_DATA: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datepanel", "hisscopepanel", "flexpanelapdatescope", "flexpanelaphisdate", "enablepanel", "orglevelpanel", "subpanel"});
                break;
            }
            case ADMIN_ORG: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datepanel", "hisscopepanel", "flexpanelapdatescope", "flexpanelaphisdate", "enablepanel", "orglevelpanel", "subpanel"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"selectpanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
                if (filterDataBo.getData().getBaseDataMul()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"orglevelpanel"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"subpanel"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"ismustpanelnew"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"orglevelpanel", "subpanel"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"ismustpanelnew"});
                }
                String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
                if (!HRStringUtils.equals((String)type, (String)"1")) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"subpanel"});
                break;
            }
            case HIS_BASE_DATA: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datepanel", "flexpanelapdatescope", "orglevelpanel", "subpanel"});
                boolean hisData = filterDataBo.getData().getHisData();
                if (hisData) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelaphisdate"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelaphisdate"});
                break;
            }
            case NUMBER: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"selectpanel", "hisscopepanel", "datepanel", "flexpanelapdatescope", "flexpanelaphisdate", "enablepanel", "orglevelpanel", "subpanel", "filterdefvaluescopeapap"});
                break;
            }
        }
    }

    public void registerListener(EventObject evt) {
        Container button = (Container)this.getView().getControl("flexpanelap");
        button.addClickListener((ClickListener)this);
        BasedataEdit beginDate = (BasedataEdit)this.getView().getControl(BEGIN_DATE);
        BasedataEdit endDate = (BasedataEdit)this.getView().getControl(END_DATE);
        beginDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        endDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("filterBo");
        if (data == null) {
            return;
        }
        try {
            List cast = (List)HRJSONUtils.cast((String)data, List.class, (Class[])new Class[]{FilterBo.class});
            for (FilterBo filterBo : cast) {
                BasedataEdit sceneEdit;
                if (!HRStringUtils.equalsIgnoreCase((String)filterBo.getControlType(), (String)FieldControlType.BASE_DATA.getValue()) && !HRStringUtils.equalsIgnoreCase((String)filterBo.getControlType(), (String)FieldControlType.HIS_BASE_DATA.getValue()) || (sceneEdit = (BasedataEdit)this.getView().getControl(filterBo.getFieldAlias())) == null) continue;
                sceneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
        catch (IOException ioException) {
            LOGGER.error((Throwable)ioException);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"flexpanelap", (String)source.getKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String key = evt.getProperty().getName();
        String value = (String)this.getModel().getValue("filtertype");
        if (HRStringUtils.equals((String)"datetype", (String)key)) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            this.getModel().setValue(FILTER_DEF_VALUE, null);
            this.getModel().setValue("datescope", null);
            if (HRStringUtils.equals((String)newValue, (String)"0")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapdatescope"});
                ComboEdit edit = (ComboEdit)this.getControl("datescope");
                edit.setMustInput(true);
                this.getView().setVisible(Boolean.FALSE, new String[]{"groupdatepanel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{END_DATE_AP});
                this.getView().setVisible(Boolean.FALSE, new String[]{"filterdefvalueapap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"filtermuldefvalueapap"});
                VestDate control = (VestDate)this.getControl(FILTER_MUL_DEF_VALUE);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("datascope", null);
                map.put("mustInput", false);
                map.put("color", "");
                map.put("title", "");
                map.put("type", "set");
                map.put("timestr", System.currentTimeMillis());
                control.setControlValue(map);
            } else if (HRStringUtils.equals((String)newValue, (String)"1")) {
                this.handleSingleDay();
            }
        } else if (HRStringUtils.equals((String)"hisscope", (String)key)) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
            this.getModel().setValue(FILTER_DEF_VALUE, null);
            this.getModel().setValue(FILTER_DEF_VALUE_SCOPE, null);
            if (HRStringUtils.equals((String)newValue, (String)"0")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelaphisdate"});
            } else if (HRStringUtils.equals((String)newValue, (String)"1")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelaphisdate"});
            }
        } else if (HRStringUtils.equals((String)"basedataismul", (String)key) && HRStringUtils.equals((String)FilterType.ADMIN_ORG.getValue(), (String)value)) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            if (HRStringUtils.equals((String)newValue, (String)"1")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"orglevelpanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"subpanel"});
            } else if (HRStringUtils.equals((String)newValue, (String)"0")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"orglevelpanel", "subpanel"});
            }
        } else if (HRStringUtils.equals((String)"groupdate", (String)key)) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            if (HRStringUtils.equals((String)newValue, (String)"1")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{END_DATE_AP});
                BasedataEdit edit = (BasedataEdit)this.getControl(BEGIN_DATE);
                edit.setMustInput(true);
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(END_DATE);
                basedataEdit.setMustInput(true);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{END_DATE_AP});
                BasedataEdit edit = (BasedataEdit)this.getControl(BEGIN_DATE);
                edit.setMustInput(false);
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(END_DATE);
                basedataEdit.setMustInput(false);
            }
        } else if (HRStringUtils.equals((String)"basedataismul", (String)key)) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            if (HRStringUtils.equals((String)newValue, (String)"1")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"filtermuldefvalueapap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"filterdefvalueapap"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"filtermuldefvalueapap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"filterdefvalueapap"});
            }
            this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
            this.getModel().setValue(FILTER_DEF_VALUE, null);
        } else if (HRStringUtils.equals((String)"datescope", (String)key)) {
            this.handleDateScope();
        } else if (HRStringUtils.equals((String)FILTER_DEF_VALUE_SCOPE, (String)key)) {
            this.updateDefValue(evt, value);
        } else if (HRStringUtils.equals((String)"suborg", (String)key)) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            String oldValue = (String)evt.getChangeSet()[0].getOldValue();
            String isMustValue = (String)this.getModel().getValue("ismust");
            if (HRStringUtils.equals((String)isMustValue, (String)"0") && HRStringUtils.equals((String)newValue, (String)"0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u4ec5\u5fc5\u9009\u89c4\u5219\u4e3a\u201c\u5fc5\u9009\u201d\u65f6\uff0c\u7edf\u8ba1\u5305\u542b\u4e0b\u7ea7\u89c4\u5219\u53ef\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u201c\u5305\u542b\u201d\u3002", (String)"FilterSettingEdit_10", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("suborg", (Object)oldValue);
            }
        } else if (HRStringUtils.equals((String)"ismust", (String)key)) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            String oldValue = (String)evt.getChangeSet()[0].getOldValue();
            String subOrg = (String)this.getModel().getValue("suborg");
            if (HRStringUtils.equals((String)subOrg, (String)"0") && HRStringUtils.equals((String)newValue, (String)"0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5305\u542b\u4e0b\u7ea7\u89c4\u5219\u4e3a\u9ed8\u8ba4\u201c\u5305\u542b\u201d\u65f6\uff0c\u4ec5\u53ef\u9009\u62e9\u201c\u5fc5\u9009\u201d\u3002", (String)"FilterSettingEdit_11", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("ismust", (Object)oldValue);
            }
        } else if (HRStringUtils.equals((String)"quickscope", (String)key)) {
            this.handleQuickScope();
        } else if (key.endsWith("_opt")) {
            String newValue = (String)evt.getChangeSet()[0].getNewValue();
            if ("between".equals(newValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_MUL_DEF_VALUE});
                this.getView().setVisible(Boolean.TRUE, new String[]{"filternumberdefvalueap"});
                this.getView().updateView("filtermuldefvalueapap");
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{FILTER_MUL_DEF_VALUE});
                this.getView().setVisible(Boolean.FALSE, new String[]{"filternumberdefvalueap"});
                this.getView().updateView("filtermuldefvalueapap");
            }
        }
    }

    private void handleQuickScope() {
        String va = (String)this.getModel().getValue("datescope");
        String quickScope = (String)this.getModel().getValue("quickscope");
        VestDate control = (VestDate)this.getControl(FILTER_MUL_DEF_VALUE);
        String[] split = va.split(",");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (quickScope == null) {
            map.put("datascope", null);
        } else {
            String[] quickScopes = quickScope.split(",");
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(split));
            HashSet<String> quickScopeSet = new HashSet<String>(Arrays.asList(quickScopes));
            if (hashSet.size() == 0 && quickScopeSet.size() == 0) {
                map.put("datascope", null);
            } else {
                map.put("datascope", va + quickScope);
            }
        }
        map.put("mustInput", false);
        map.put("color", "");
        map.put("title", "");
        map.put("type", "set");
        map.put("timestr", System.currentTimeMillis());
        control.setControlValue(map);
    }

    private void handleDateScope() {
        String va = (String)this.getModel().getValue("datescope");
        VestDate control = (VestDate)this.getControl(FILTER_MUL_DEF_VALUE);
        if (HRStringUtils.isEmpty((String)va)) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("datascope", null);
            map.put("mustInput", false);
            map.put("color", "");
            map.put("title", "");
            map.put("type", "set");
            map.put("timestr", System.currentTimeMillis());
            control.setControlValue(map);
        } else {
            if (va.contains("quickscope")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{QUICK_SCOPE_AP});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{QUICK_SCOPE_AP});
                this.getModel().setValue("quickscope", null);
            }
            String[] split = va.split(",");
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(split));
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            if (hashSet.size() == 0) {
                map.put("datascope", null);
            } else {
                String[] quickScopes;
                HashSet<String> quickScopeSet;
                map.put("datascope", va);
                String quickScope = (String)this.getModel().getValue("quickscope");
                if (quickScope != null && (quickScopeSet = new HashSet<String>(Arrays.asList(quickScopes = quickScope.split(",")))).size() > 0) {
                    map.put("datascope", va + quickScope);
                }
            }
            map.put("mustInput", false);
            map.put("color", "");
            map.put("title", "");
            map.put("type", "set");
            map.put("timestr", System.currentTimeMillis());
            control.setControlValue(map);
        }
    }

    private void handleSingleDay() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String controlType = (String)formShowParameter.getCustomParam("controlType");
        try {
            FilterDataBo cast = (FilterDataBo)HRJSONUtils.cast((String)controlType, FilterDataBo.class);
            FilterBo bo = cast.getData();
            if (bo == null) {
                return;
            }
            Object date = this.getView().getModel().getValue("groupdate");
            if (date != null && HRStringUtils.equals((String)"1", (String)((String)date))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{END_DATE_AP});
            }
            if (bo.getVirtualEntityField() && !bo.getHisDateQuery()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"groupdatepanel"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"groupdatepanel"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapdatescope"});
            this.getView().setVisible(Boolean.FALSE, new String[]{QUICK_SCOPE_AP});
            ComboEdit edit = (ComboEdit)this.getControl("datescope");
            edit.setMustInput(Boolean.FALSE.booleanValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{"filterdefvalueapap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtermuldefvalueapap"});
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    private void updateDefValue(PropertyChangedArgs evt, String value) {
        Object newValue = evt.getChangeSet()[0].getNewValue();
        if (Objects.isNull(newValue)) {
            this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
            this.getModel().setValue(FILTER_DEF_VALUE, null);
        } else if (HRStringUtils.equals((String)((String)this.getModel().getValue("basedataismul")), (String)"1")) {
            Object defValue = this.getModel().getValue(FILTER_MUL_DEF_VALUE);
            if (!Objects.isNull(defValue)) {
                if (HRStringUtils.equals((String)FilterType.ENUM.getValue(), (String)value)) {
                    String defStr;
                    String[] defStrSplit;
                    HashSet<String> defHashSet;
                    String str = (String)newValue;
                    String[] split = str.split(",");
                    HashSet<String> hashSet = new HashSet<String>(Arrays.asList(split));
                    if (!hashSet.containsAll(defHashSet = new HashSet<String>(Arrays.asList(defStrSplit = (defStr = (String)defValue).split(","))))) {
                        this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
                        this.getModel().setValue(FILTER_DEF_VALUE, null);
                    }
                } else {
                    List defIds;
                    DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)newValue;
                    DynamicObjectCollection defValues = (DynamicObjectCollection)defValue;
                    List ids = dynamicObjects.stream().map(data -> data.get("fbasedataid_id")).collect(Collectors.toList());
                    if (!ids.containsAll(defIds = defValues.stream().map(data -> data.get("fbasedataid_id")).collect(Collectors.toList()))) {
                        this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
                        this.getModel().setValue(FILTER_DEF_VALUE, null);
                    }
                }
            }
        } else {
            Object defValue = this.getModel().getValue(FILTER_DEF_VALUE);
            if (!Objects.isNull(defValue)) {
                if (HRStringUtils.equals((String)FilterType.ENUM.getValue(), (String)value)) {
                    String defStr;
                    String str = (String)newValue;
                    String[] split = str.split(",");
                    HashSet<String> hashSet = new HashSet<String>(Arrays.asList(split));
                    if (!hashSet.contains(defStr = (String)defValue)) {
                        this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
                        this.getModel().setValue(FILTER_DEF_VALUE, null);
                    }
                } else {
                    DynamicObject dyn;
                    DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)newValue;
                    List ids = dynamicObjects.stream().map(data -> data.get("fbasedataid_id")).collect(Collectors.toList());
                    if (!ids.contains((dyn = (DynamicObject)defValue).get("id"))) {
                        this.getModel().setValue(FILTER_MUL_DEF_VALUE, null);
                        this.getModel().setValue(FILTER_DEF_VALUE, null);
                    }
                }
            }
        }
        if (HRStringUtils.equals((String)FilterType.ENUM.getValue(), (String)value)) {
            this.handleEnum(newValue);
        }
    }

    private void handleEnum(Object newValue) {
        String str = (String)newValue;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("filterBo");
        if (data == null) {
            return;
        }
        List filterBoList = SerializationUtils.fromJsonStringToList((String)data, FilterBo.class);
        FilterBo filterBo = (FilterBo)filterBoList.get(0);
        String fieldPath = filterBo.getFieldPath();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        if (HRStringUtils.isNotEmpty((String)fieldPath) && fieldPath.contains("!")) {
            this.addListBySplitDate(str, fieldPath, list);
        } else if (filterBo.getGroupField()) {
            this.addListByGroup(str, filterBo, list);
        } else {
            this.addListByAnObj(str, filterBo, list);
        }
        ComboEdit mulControl = (ComboEdit)this.getControl(FILTER_MUL_DEF_VALUE);
        mulControl.setComboItems(list);
        ComboEdit control = (ComboEdit)this.getControl(FILTER_DEF_VALUE);
        control.setComboItems(list);
    }

    private void addListByGroup(String str, FilterBo filterBo, List<ComboItem> list) {
        List groupFieldEnums = AnObjGroupFieldService.getInstance().getGroupFieldEnums(Long.parseLong(filterBo.getGroupFieldId()));
        if (HRStringUtils.isNotEmpty((String)str)) {
            String[] split = str.split(",");
            if (split.length > 0) {
                for (Map groupFieldEnum : groupFieldEnums) {
                    String number = (String)groupFieldEnum.get("number");
                    if (!str.contains(number)) continue;
                    list.add(new ComboItem((LocaleString)groupFieldEnum.get("name"), (String)groupFieldEnum.get("number")));
                }
            } else {
                for (Map groupFieldEnum : groupFieldEnums) {
                    list.add(new ComboItem((LocaleString)groupFieldEnum.get("name"), (String)groupFieldEnum.get("number")));
                }
            }
        } else {
            for (Map groupFieldEnum : groupFieldEnums) {
                list.add(new ComboItem((LocaleString)groupFieldEnum.get("name"), (String)groupFieldEnum.get("number")));
            }
        }
    }

    private void addListByAnObj(String str, FilterBo filterBo, List<ComboItem> list) {
        String anObjDetailInfoStr = this.getView().getParentView().getPageCache().get("anObjDetailInfo");
        AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)SerializationUtils.fromJsonString((String)anObjDetailInfoStr, AnObjDetailInfo.class);
        AnObjEnumFieldHandler anObjEnumFieldHandler = new AnObjEnumFieldHandler(Long.parseLong(anObjDetailInfo.getAnObj().getId()), new MainEntityTypeUtil());
        List enumItems = anObjEnumFieldHandler.getEnumItems(filterBo.getFieldNumber(), filterBo.getEntityNumber());
        block0: for (AnObjEnumFieldHandler.AnObjEnumItem enumItem : enumItems) {
            if (HRStringUtils.isNotEmpty((String)str)) {
                String[] split;
                for (String st : split = str.split(",")) {
                    if (!HRStringUtils.equals((String)st, (String)enumItem.getValue())) continue;
                    list.add(new ComboItem(enumItem.getName(), enumItem.getValue()));
                    continue block0;
                }
                continue;
            }
            list.add(new ComboItem(enumItem.getName(), enumItem.getValue()));
        }
    }

    private void addListBySplitDate(String str, String fieldPath, List<ComboItem> list) {
        List<ComboItem> allList = SplitDateUtil.getInstance().getComboItemsByFieldPath(fieldPath);
        block0: for (ComboItem comboItem : allList) {
            if (HRStringUtils.isNotEmpty((String)str)) {
                String[] split;
                for (String st : split = str.split(",")) {
                    if (!HRStringUtils.equals((String)st, (String)comboItem.getValue())) continue;
                    list.add(new ComboItem(comboItem.getCaption(), comboItem.getValue()));
                    continue block0;
                }
                continue;
            }
            list.add(new ComboItem(comboItem.getCaption(), comboItem.getValue()));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("controlType");
        try {
            FilterDataBo cast = (FilterDataBo)HRJSONUtils.cast((String)type, FilterDataBo.class);
            String entityNumber = cast.getData().getEntityNumber();
            FilterBo filterBo = cast.getData();
            String cache = this.getView().getParentView().getPageCache().get("anObjDetailInfo");
            AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)SerializationUtils.fromJsonString((String)cache, AnObjDetailInfo.class);
            if (HRStringUtils.equals((String)fieldKey, (String)BEGIN_DATE) || HRStringUtils.equals((String)fieldKey, (String)END_DATE)) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
                QFilter qFilter = new QFilter("anobj", "=", (Object)Long.valueOf(anObjDetailInfo.getAnObj().getId()));
                qFilter.and(new QFilter("entitynumber", "=", (Object)entityNumber));
                if (!anObjDetailInfo.getVirtualEntity()) {
                    qFilter.and(new QFilter("complextype", "not in", Stream.of("basedata", "adminorg", "hisbasedata").collect(Collectors.toList())));
                }
                qFilter.and(new QFilter("valuetype", "=", (Object)"datetime"));
                DynamicObjectCollection dataCol = helper.queryOriginalCollection("id, fieldpath, entitynumber", new QFilter[]{qFilter});
                if (!anObjDetailInfo.getVirtualEntity()) {
                    dataCol.removeIf(data -> {
                        String fieldEntityNumber;
                        String fieldPath = data.getString("fieldpath");
                        if (fieldPath.startsWith((fieldEntityNumber = data.getString("entitynumber")) + ".")) {
                            return fieldPath.split("\\.").length > 2;
                        }
                        return fieldPath.contains(".");
                    });
                }
                List queryIds = dataCol.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getCustomParams().put("filterSetting", "true");
                qFilter = new QFilter("id", "in", queryIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else if (HRStringUtils.equals((String)fieldKey, (String)FILTER_DEF_VALUE_SCOPE) || HRStringUtils.equals((String)fieldKey, (String)FILTER_MUL_DEF_VALUE)) {
                this.selectBasedata(beforeF7SelectEvent, filterBo);
            }
            if (HRStringUtils.equals((String)filterBo.getBaseDataNum(), (String)"bos_org") && !filterBo.getVirtualEntityField()) {
                DynamicProperty prop;
                ListShowParameter fsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                if (HRStringUtils.isEmpty((String)filterBo.getBaseDataNum())) {
                    return;
                }
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)filterBo.getBaseDataNum());
                String str = filterBo.getFieldAlias();
                if (filterBo.getFieldAlias().endsWith("name") || filterBo.getFieldAlias().endsWith("number")) {
                    str = filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf("."));
                }
                if ((prop = (DynamicProperty)mainEntityType.getAllFields().get(str)) instanceof OrgProp) {
                    OrgProp orgProp = (OrgProp)prop;
                    String orgFunId = orgProp.getOrgFunc();
                    OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
                    String orgViewSchemeNumber = orgViewScheme == null ? null : orgViewScheme.getNumber();
                    fsp.setCustomParam("orgFuncId", (Object)orgFunId);
                    fsp.setCustomParam("orgViewSchemeNumber", (Object)orgViewSchemeNumber);
                }
            }
        }
        catch (IOException ioException) {
            LOGGER.error((Throwable)ioException);
        }
        if (HRStringUtils.equals((String)fieldKey, (String)FILTER_DEF_VALUE) || HRStringUtils.equals((String)fieldKey, (String)FILTER_MUL_DEF_VALUE)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(FILTER_DEF_VALUE_SCOPE);
            List ids = dynamicObjectCollection.stream().map(it -> it.get("fbasedataid_id")).collect(Collectors.toList());
            if (ids.size() > 0) {
                QFilter filter = new QFilter("id", "in", ids);
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    private void selectBasedata(BeforeF7SelectEvent beforeF7SelectEvent, FilterBo filterBo) {
        if (HRStringUtils.equals((String)filterBo.getFilterType(), (String)"hisbasedata")) {
            MulHisModelBasedataEdit edit = (MulHisModelBasedataEdit)beforeF7SelectEvent.getSource();
            String hisScope = (String)this.getModel().getValue("hisscope");
            if (HRStringUtils.equals((String)hisScope, (String)"0")) {
                edit.setSelData("bd");
            } else {
                edit.setSelData("bdversion");
                String value = (String)this.getModel().getValue("hisdate");
                if (HRStringUtils.equals((String)value, (String)"0")) {
                    edit.setEffDateFieldType("effDate");
                } else {
                    edit.setEffDateFieldType("effDateRange");
                }
            }
        } else if (HRStringUtils.equals((String)filterBo.getFilterType(), (String)"adminorg")) {
            MulHisModelBasedataEdit edit = (MulHisModelBasedataEdit)beforeF7SelectEvent.getSource();
            edit.setSelData("bd");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setF7ClickByFilter(true);
            String fieldAlias = filterBo.getFieldAlias();
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)fieldAlias.substring(0, fieldAlias.lastIndexOf(".")));
            this.getView().cacheFormShowParameter();
        }
    }
}

