/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;

public interface IReportService
extends ReportManageConstants {
    public AbstractFormPlugin getPlugin();

    public ReportCacheService getRptCacheService();

    default public <T> T getPageCache(String key, Class<?> valueType) {
        return this.getPageCache(key, valueType, null);
    }

    default public <T> T getPageCache(String key, Class<?> valueType, T defaultValue) {
        return this.getRptCacheService().getPageCache(key, valueType, defaultValue);
    }

    default public String getPageCache(String key) {
        return this.getRptCacheService().getPageCache(key);
    }

    default public void putPageCache(String key, Object value) {
        this.getRptCacheService().putPageCache(key, value);
    }

    default public void putPageCache(ReportManageConfigInfo reportManageConfigInfo) {
        this.putPageCache("anObjDetailInfo", reportManageConfigInfo.getAssignObj());
        this.putPageCache("workRptInfo", reportManageConfigInfo.getWorkRpt());
        if (StringUtils.isNotEmpty((CharSequence)reportManageConfigInfo.getDataFilter())) {
            this.putPageCache("dataFilterCondition", reportManageConfigInfo.getDataFilter());
        }
        if (!CollectionUtils.isEmpty((Map)reportManageConfigInfo.getDrillingDrl())) {
            this.putPageCache("drillingDrl", reportManageConfigInfo.getDrillingDrl());
        }
        if (!CollectionUtils.isEmpty((Collection)reportManageConfigInfo.getFilter())) {
            this.putPageCache("filter", reportManageConfigInfo.getFilter());
        }
        if (null != reportManageConfigInfo.getVirtualConfigInfo()) {
            this.putPageCache("virtualConfigInfo", reportManageConfigInfo.getVirtualConfigInfo());
        }
    }

    default public void removePageCache(String key) {
        this.getRptCacheService().removePageCache(key);
    }

    default public void invokeControl(Object data) {
        CustomControl customControl = (CustomControl)this.getPlugin().getControl("customcontrolap");
        customControl.setData(data);
    }

    default public void invokeSchemeControl(Object data) {
        CustomControl customControl = (CustomControl)this.getPlugin().getControl("schemecontrolap");
        customControl.setData(data);
    }

    default public void invokeSelectF7Control(Object data) {
        CustomControl customControl = (CustomControl)this.getPlugin().getControl("SelectF7Ap");
        customControl.setData(data);
    }
}

