/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportHisPageService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManageUtil;

public class PreViewService
extends ReportService {
    protected final IDataModel dataModel;
    private static final Log LOGGER = LogFactory.getLog(PreViewService.class);

    public PreViewService(AbstractFormPlugin plugin, ReportCacheService rptCacheService, IDataModel dataModel) {
        super(plugin, rptCacheService);
        this.dataModel = dataModel;
    }

    protected boolean isReportPreview(FormShowParameter formShowParameter) {
        return "true".equals(formShowParameter.getCustomParam("mark_is_report_preview"));
    }

    protected boolean isReportJumpView(FormShowParameter formShowParameter) {
        return "true".equals(formShowParameter.getCustomParam("mark_is_report_jump_view"));
    }

    protected String validateIsMustAndShowMessage(List<FilterBo> cast) {
        List<String> operateErrorInfoList = this.validateIsMust(cast);
        if (operateErrorInfoList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String operateErrorInfo : operateErrorInfoList) {
                sb.append(operateErrorInfo).append("\u3001");
            }
            sb.delete(sb.lastIndexOf("\u3001"), sb.length());
            return sb.toString();
        }
        return null;
    }

    private List<String> validateIsMust(List<FilterBo> cast) {
        ArrayList<String> operateErrorInfoList = new ArrayList<String>();
        for (FilterBo filterBo : cast) {
            String opt;
            if (HRStringUtils.equals((String)FilterType.BASE_DATA_ENUM.getValue(), (String)filterBo.getFilterType())) {
                String selectF7 = this.getPageCache(filterBo.getFieldAlias() + "_selectF7");
                if (!filterBo.getMustInput()) continue;
                if (HRStringUtils.isEmpty((String)selectF7)) {
                    operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
                    continue;
                }
                List ids = SerializationUtils.fromJsonStringToList((String)selectF7, String.class);
                ids.remove("");
                ids.remove(null);
                if (ids.size() != 0) continue;
                operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
                continue;
            }
            if (filterBo.getFilterType().equals("date")) {
                this.mustDate(operateErrorInfoList, filterBo);
                continue;
            }
            Object value = this.dataModel.getValue(filterBo.getFieldAlias());
            if (!filterBo.getMustInput()) continue;
            if (filterBo.getFilterType().equals(FilterType.NUMBER.getValue()) && (opt = (String)this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "opt")).equals("between")) {
                Object startNumber = this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "beginnumber");
                Object endNumber = this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "endnumber");
                if (!StringUtils.isBlank((Object)startNumber) && !StringUtils.isBlank((Object)endNumber)) continue;
                operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
            }
            if (filterBo.getFilterType().equals(FilterType.STRING.getValue()) && StringUtils.isEmpty((CharSequence)((String)value))) {
                operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
                continue;
            }
            if (!filterBo.getFilterType().equals(FilterType.STRING.getValue()) && StringUtils.isBlank((Object)value)) {
                operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
                continue;
            }
            if (filterBo.getFilterType().equals(FilterType.ENUM.getValue())) {
                String[] split = ((String)value).split(",");
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
                list.remove("");
                if (list.size() != 0) continue;
                operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
                continue;
            }
            if (!(value instanceof MulBasedataDynamicObjectCollection) || !filterBo.getMustInput() || ((MulBasedataDynamicObjectCollection)value).size() != 0) continue;
            operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
        }
        return operateErrorInfoList;
    }

    private void mustDate(List<String> operateErrorInfoList, FilterBo filterBo) {
        String vestDate = this.getPageCache(filterBo.getFieldAlias() + "_vestdate");
        if (filterBo.getMustInput()) {
            Object value;
            boolean flag;
            boolean bl = flag = HRStringUtils.equals((String)filterBo.getDateType(), (String)"0") && (vestDate == null || HRStringUtils.equals((String)"{}", (String)vestDate));
            if (flag) {
                operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
            } else if (HRStringUtils.equals((String)filterBo.getDateType(), (String)"1") && (value = this.dataModel.getValue(filterBo.getFieldAlias())) == null) {
                operateErrorInfoList.add((String)filterBo.getFilterAlias().get((Object)RequestContext.get().getLang().name()));
            }
        }
    }

    protected String getCurRptWorkId() {
        return (String)this.getPageCache("curRptWorkId", String.class, "0");
    }

    public ReportManageConfigInfo getReportManageConfigInfo(FormShowParameter formShowParameter) {
        DynamicObject reportManageDy;
        ReportManageConfigInfo reportManageConfigInfo = null;
        if (this.isReportPreview(formShowParameter)) {
            String reportManage = (String)formShowParameter.getCustomParam("reportManageConfigInfo");
            if (StringUtils.isNotEmpty((CharSequence)reportManage)) {
                reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportManage, ReportManageConfigInfo.class);
            } else {
                LOGGER.error("error in getReportManageConfigInfo, preview fail !");
            }
        } else if (this.isReportJumpView(formShowParameter)) {
            reportManageDy = ReportManageService.getRptManage((Long)((Long)formShowParameter.getCustomParam("reportId")));
            if (reportManageDy == null) {
                return null;
            }
            reportManageConfigInfo = ReportManageUtil.getReportManageConfigInfo(reportManageDy);
            this.putPageCache("name", reportManageDy.getString("name"));
        } else {
            reportManageDy = ReportManageService.getRptManage((String)formShowParameter.getFormId());
            if (reportManageDy == null) {
                return null;
            }
            reportManageConfigInfo = ReportHisPageService.switchReportConfigHisVersion(reportManageDy, formShowParameter);
            if (reportManageConfigInfo == null) {
                reportManageConfigInfo = ReportManageUtil.getReportManageConfigInfo(reportManageDy);
                this.putPageCache("name", reportManageDy.getString("name"));
            }
            reportManageConfigInfo.setPublishQuery(true);
        }
        String curRptWorkId = this.getCurRptWorkId();
        if (!"0".equals(curRptWorkId) && null != reportManageConfigInfo) {
            reportManageConfigInfo.getWorkRpt().forEach(info -> info.setShow(curRptWorkId.equals(info.getWorkRptId())));
        }
        return reportManageConfigInfo;
    }

    public String getReportPublishType() {
        String publishType = "appMenu";
        Object CustomPublishType = this.plugin.getView().getFormShowParameter().getCustomParam("CUSTOM_PARAM_PUBLISH_TYPE");
        if (CustomPublishType != null) {
            publishType = String.valueOf(CustomPublishType);
        }
        return publishType;
    }
}

