/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.virtulentity.VirtualConfigInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;

public class ReportCacheService
implements ReportManageConstants {
    private Long rptManageId;
    private AbstractFormPlugin plugin;

    public ReportCacheService(Long rptManageId, AbstractFormPlugin plugin) {
        this.rptManageId = rptManageId;
        this.plugin = plugin;
    }

    public void removePageCache(String key) {
        if (null != this.plugin.getPageCache()) {
            this.plugin.getPageCache().remove(key);
        }
    }

    private <T> T getPageCache(String key, Class<?> valueType) {
        return this.getPageCache(key, valueType, null);
    }

    public <T> T getPageCache(String key, Class<?> valueType, T defaultValue) {
        String value = this.getPageCache(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if ("workRptInfo".equals(key) || "filter".equals(key)) {
                return (T)SerializationUtils.fromJsonStringToList((String)value, valueType);
            }
            return (T)SerializationUtils.fromJsonString((String)value, valueType);
        }
        return defaultValue;
    }

    public String getPageCache(String key) {
        if ("reportManageConfigInfo".equals(key)) {
            return SerializationUtils.toJsonString((Object)this.getReportManageNoDetail());
        }
        if ("closeReportManageConfigInfo".equals(key)) {
            ReportManageConfigInfo info = this.getReportManageNoAssignObj();
            info.getReportConfig().setDrillingInfo(null);
            return SerializationUtils.toJsonString((Object)info);
        }
        if ("reportConfigInfo".equals(key)) {
            List workRptInfoList = (List)this.getPageCache("workRptInfo", WorkRptInfo.class);
            if (!CollectionUtils.isEmpty((Collection)workRptInfoList)) {
                for (WorkRptInfo workRptInfo : workRptInfoList) {
                    if (!workRptInfo.getShow()) continue;
                    return SerializationUtils.toJsonString((Object)workRptInfo.getReportConfig());
                }
            }
            return SerializationUtils.toJsonString((Object)new ReportConfigInfo());
        }
        if ("rowAndColumnCfgInfo".equals(key)) {
            List workRptInfoList = (List)this.getPageCache("workRptInfo", WorkRptInfo.class);
            if (!CollectionUtils.isEmpty((Collection)workRptInfoList)) {
                for (WorkRptInfo workRptInfo : workRptInfoList) {
                    if (!workRptInfo.getShow()) continue;
                    return SerializationUtils.toJsonString((Object)new ReportHeadRowAndColCfgInfo(workRptInfo.getRows(), workRptInfo.getColumns()));
                }
            }
            return SerializationUtils.toJsonString((Object)new ReportHeadRowAndColCfgInfo());
        }
        if (null == this.plugin.getPageCache()) {
            return "";
        }
        return this.plugin.getPageCache().get(key);
    }

    public void putPageCache(String key, Object value) {
        if (key.equals("reportManageConfigInfo")) {
            ReportManageConfigInfo reportManageConfigInfo = value instanceof String ? (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)((String)value), ReportManageConfigInfo.class) : (ReportManageConfigInfo)value;
            this.putPluginCache("anObjDetailInfo", reportManageConfigInfo.getAssignObj());
            this.putPluginCache("workRptInfo", reportManageConfigInfo.getWorkRpt());
            if (StringUtils.isNotEmpty((CharSequence)reportManageConfigInfo.getDataFilter())) {
                this.putPluginCache("dataFilterCondition", reportManageConfigInfo.getDataFilter());
            }
            if (!CollectionUtils.isEmpty((Map)reportManageConfigInfo.getDrillingDrl())) {
                this.putPluginCache("drillingDrl", reportManageConfigInfo.getDrillingDrl());
            }
            if (!CollectionUtils.isEmpty((Collection)reportManageConfigInfo.getFilter())) {
                this.putPluginCache("filter", reportManageConfigInfo.getFilter());
            }
            if (null != reportManageConfigInfo.getVirtualConfigInfo()) {
                this.putPluginCache("virtualConfigInfo", reportManageConfigInfo.getVirtualConfigInfo());
            }
        } else if (key.equals("oriReportManageConfigInfo")) {
            ReportManageConfigInfo reportManageConfigInfo = value instanceof String ? (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)((String)value), ReportManageConfigInfo.class) : (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)value), ReportManageConfigInfo.class);
            reportManageConfigInfo.setAssignObj(null);
            this.putPluginCache(key, reportManageConfigInfo);
        } else if ("reportConfigInfo".equals(key)) {
            List workRptInfoList = (List)this.getPageCache("workRptInfo", WorkRptInfo.class);
            if (!CollectionUtils.isEmpty((Collection)workRptInfoList)) {
                for (WorkRptInfo workRptInfo : workRptInfoList) {
                    if (!workRptInfo.getShow()) continue;
                    ReportConfigInfo reportConfigInfo = value instanceof String ? (ReportConfigInfo)SerializationUtils.fromJsonString((String)((String)value), ReportConfigInfo.class) : (ReportConfigInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)value), ReportConfigInfo.class);
                    workRptInfo.setReportConfig(reportConfigInfo);
                }
            }
            this.putPluginCache("workRptInfo", workRptInfoList);
        } else if ("rowAndColumnCfgInfo".equals(key)) {
            List workRptInfoList = (List)this.getPageCache("workRptInfo", WorkRptInfo.class);
            if (!CollectionUtils.isEmpty((Collection)workRptInfoList)) {
                for (WorkRptInfo workRptInfo : workRptInfoList) {
                    if (!workRptInfo.getShow()) continue;
                    ReportHeadRowAndColCfgInfo rowAndColCfgInfo = value instanceof String ? (ReportHeadRowAndColCfgInfo)SerializationUtils.fromJsonString((String)((String)value), ReportHeadRowAndColCfgInfo.class) : (ReportHeadRowAndColCfgInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)value), ReportHeadRowAndColCfgInfo.class);
                    workRptInfo.setRows(rowAndColCfgInfo.getRows());
                    workRptInfo.setColumns(rowAndColCfgInfo.getColumns());
                }
            }
            this.putPluginCache("workRptInfo", workRptInfoList);
        } else {
            this.putPluginCache(key, value);
        }
    }

    private void putPluginCache(String key, Object value) {
        if (null == this.plugin.getPageCache()) {
            return;
        }
        if (value instanceof String) {
            this.plugin.getPageCache().put(key, (String)value);
        } else {
            this.plugin.getPageCache().put(key, SerializationUtils.toJsonString((Object)value));
        }
    }

    private ReportManageConfigInfo getReportManageNoDetail() {
        ReportManageConfigInfo info = this.getReportManageNoAssignObj();
        info.setAssignObj((AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class));
        return info;
    }

    private ReportManageConfigInfo getReportManageNoAssignObj() {
        String virtualCfgStr;
        String filterStr;
        String drillingDrlStr;
        ReportManageConfigInfo info = new ReportManageConfigInfo();
        if (this.rptManageId != null && this.rptManageId != 0L) {
            info.setId(this.rptManageId);
        }
        List workRptInfoList = (List)this.getPageCache("workRptInfo", WorkRptInfo.class);
        info.setWorkRpt(workRptInfoList);
        String dataFilterCondition = this.getPageCache("dataFilterCondition");
        if (HRStringUtils.isNotEmpty((String)dataFilterCondition)) {
            info.setDataFilter(dataFilterCondition);
        }
        if (HRStringUtils.isNotEmpty((String)(drillingDrlStr = this.getPageCache("drillingDrl")))) {
            info.setDrillingDrl((Map)SerializationUtils.fromJsonString((String)drillingDrlStr, Map.class));
        }
        if (HRStringUtils.isNotEmpty((String)(filterStr = this.getPageCache("filter")))) {
            info.setFilter(SerializationUtils.fromJsonStringToList((String)filterStr, FilterBo.class));
        }
        if (HRStringUtils.isNotEmpty((String)(virtualCfgStr = this.getPageCache("virtualConfigInfo")))) {
            info.setVirtualConfigInfo((VirtualConfigInfo)SerializationUtils.fromJsonString((String)virtualCfgStr, VirtualConfigInfo.class));
        }
        return info;
    }
}

