/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.calfield.CalculateFieldService;
import kd.hr.hrptmc.business.repdesign.enums.RowOrColOperateEnum;
import kd.hr.hrptmc.business.repdesign.enums.SortEnum;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.jump.ReportJumpConfigService;
import kd.hr.hrptmc.business.repdesign.opt.DimCountCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.MergeOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptCfgCallBackInfo;
import kd.hr.hrptmc.business.repdesign.opt.RptFieldCallBackInfo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexReportPageHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportService;
import kd.hr.hrptmc.formplugin.web.repdesign.subtotal.ReportSubTotalHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.util.AdvanceSortUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManagePopUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SummaryAlgorithmUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.TransformUtil;

public class ReportFieldService
extends ReportService {
    private static final Log LOGGER = LogFactory.getLog(ReportFieldService.class);
    private final PreIndexReportPageHandler preIndexHandler;

    public ReportFieldService(AbstractFormPlugin plugin, ReportCacheService rptCacheService) {
        super(plugin, rptCacheService);
        this.preIndexHandler = new PreIndexReportPageHandler(plugin);
    }

    public void clickMenuItem(String param) {
        try {
            RowOrColClickOptInfo operateInfo = (RowOrColClickOptInfo)SerializationUtils.fromJsonString((String)param, RowOrColClickOptInfo.class);
            switch (Objects.requireNonNull(RowOrColOperateEnum.of((String)operateInfo.getOperateType()))) {
                case SETDISPLAYNAME: {
                    ReportManagePopUtil.openSetDisplayNamePop(this.plugin, operateInfo, (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class));
                    break;
                }
                case SETDISPLAYMODE: {
                    ReportManagePopUtil.openSetDisplayModePop(this.plugin, operateInfo, (ReportManageConfigInfo)this.getPageCache("reportManageConfigInfo", ReportManageConfigInfo.class));
                    break;
                }
                case SETDATAFORMAT: {
                    ReportManagePopUtil.openSetDataFormatPop(this.plugin, operateInfo, (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class));
                    break;
                }
                case AGGREGATION: {
                    this.aggregationField(operateInfo);
                    break;
                }
                case SETSORT: {
                    this.setSort(operateInfo);
                    break;
                }
                case SHOWEMPTYCOL: {
                    this.showEmptyCol(operateInfo);
                    break;
                }
                case DELETEFIELD: {
                    this.deleteField(operateInfo);
                    this.preIndexHandler.getDimMapHandler().updateDimMapCacheForRemovePreIndex(operateInfo.getFieldAlias());
                    ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class);
                    ReportJumpConfigService.getInstance().updateJumpConfigCache(operateInfo.getFieldAlias(), reportConfigInfo);
                    this.putPageCache("reportConfigInfo", reportConfigInfo);
                    break;
                }
                case DELETEPREIDX: {
                    this.preIndexHandler.deletePreIdx(operateInfo);
                    break;
                }
                case SPLITMERGEFIELD: {
                    this.splitMergeField(operateInfo);
                    break;
                }
                case SETDIMMAP: {
                    this.preIndexHandler.dragNewPreIndexHandle(param);
                    this.preIndexHandler.getDimMapHandler().setDimMap(operateInfo);
                    break;
                }
                case CONVERTIDX: {
                    this.dimCount(operateInfo);
                    break;
                }
                case SETROWALIGN: {
                    this.setRowAlign(operateInfo);
                    break;
                }
                case ADVANCESORT: {
                    this.advanceSort(operateInfo);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
    }

    private void aggregationField(RowOrColClickOptInfo operateInfo) {
        String method = operateInfo.getMethod();
        String fieldAlias = operateInfo.getFieldAlias();
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        if ("row".equals(operateInfo.getOperateArea())) {
            rowAndColCfgInfo.getRows().stream().filter(rowFieldInfo -> HRStringUtils.equals((String)rowFieldInfo.getGroupName().getType(), (String)"2") && HRStringUtils.equals((String)rowFieldInfo.getGroupName().getNumberAlias(), (String)fieldAlias)).forEach(rowFieldInfo -> rowFieldInfo.getGroupName().setAlgorithm(method));
        } else {
            rowAndColCfgInfo.getColumns().stream().filter(fieldInfo -> HRStringUtils.equals((String)fieldInfo.getType(), (String)"2") && HRStringUtils.equals((String)fieldInfo.getNumberAlias(), (String)fieldAlias)).forEach(fieldInfo -> fieldInfo.setAlgorithm(method));
        }
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
    }

    private void setSort(RowOrColClickOptInfo operateInfo, FieldInfo fieldInfo, String fieldInfoStr, Object cacheObj) {
        String method = operateInfo.getMethod();
        String fieldAlias = operateInfo.getFieldAlias();
        String data = operateInfo.getData();
        if (SortEnum.CUSTOM.getValue().equals(method)) {
            if (!"legend".equals(operateInfo.getOperateArea())) {
                this.putPageCache("isAdvanceSort", data);
            }
            this.putPageCache("fieldInfoBeforeSort", fieldInfoStr);
            if (fieldInfo != null) {
                fieldInfo.setFieldSortInfo(null);
            }
            ReportManagePopUtil.openCustomSortPop(this.plugin, operateInfo, fieldInfoStr);
        } else if (SortEnum.FIELD.getValue().equals(method)) {
            if (!"legend".equals(operateInfo.getOperateArea())) {
                this.putPageCache("isAdvanceSort", data);
            }
            this.putPageCache("fieldInfoBeforeSort", fieldInfoStr);
            if (fieldInfo != null) {
                fieldInfo.setCustomSort(null);
            }
            String number = FieldInfoUtil.getNumber(fieldAlias);
            ReportManagePopUtil.openFieldSortPop(this.plugin, operateInfo, fieldInfoStr, this.getFieldSortList(number));
        } else {
            ReportConfigInfo reportConfigInfo;
            if ("row".equals(operateInfo.getOperateArea()) && !this.validateSort(operateInfo)) {
                return;
            }
            if (fieldInfo != null) {
                fieldInfo.setCustomSort(null);
                fieldInfo.setFieldSortInfo(null);
                fieldInfo.setSort(method);
            }
            if ("legend".equals(operateInfo.getOperateArea())) {
                this.putPageCache("reportConfigInfo", cacheObj);
            } else {
                this.putPageCache("rowAndColumnCfgInfo", cacheObj);
            }
            if (!"legend".equals(operateInfo.getOperateArea()) && !AdvanceSortUtil.updateAdvanceSort(reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo()), fieldInfo, operateInfo.getOperateArea(), method)) {
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                this.invokeControl(new RptCfgCallBackInfo((ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class)));
            }
        }
    }

    private void setSort(RowOrColClickOptInfo operateInfo) {
        if ("legend".equals(operateInfo.getOperateArea())) {
            ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class);
            FieldInfo fieldInfo = (FieldInfo)reportConfigInfo.getLegend().get(0);
            String fieldInfoStr = SerializationUtils.toJsonString((Object)fieldInfo);
            this.setSort(operateInfo, fieldInfo, fieldInfoStr, reportConfigInfo);
        } else {
            ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class);
            FieldInfo fieldInfo = FieldInfoUtil.getFieldInfo(operateInfo, rowAndColCfgInfo);
            String fieldInfoStr = ReportManagePopUtil.getFieldInfo(operateInfo, rowAndColCfgInfo);
            this.setSort(operateInfo, fieldInfo, fieldInfoStr, rowAndColCfgInfo);
        }
    }

    private boolean validateSort(RowOrColClickOptInfo operateInfo) {
        List numberAliass;
        ReportConfigInfo reportConfigInfo;
        if (SortEnum.NONE.getValue().equals(operateInfo.getMethod()) && null != (reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo())).getSubtotal() && reportConfigInfo.getSubtotal().getSubtotal() && (numberAliass = reportConfigInfo.getSubtotal().getFields().stream().map(FieldInfo::getNumberAlias).collect(Collectors.toList())).contains(operateInfo.getFieldAlias())) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u5df2\u5f00\u542f\u5c0f\u8ba1\u884c\uff0c\u4e0d\u652f\u6301\u201c\u4e0d\u6392\u5e8f\u201d\u903b\u8f91\u3002", (String)"ReportManageEditPlugin_19", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class);
            String fieldInfoStr = ReportManagePopUtil.getFieldInfo(operateInfo, rowAndColCfgInfo);
            this.invokeControl(new RowOrColClickOptCallBackInfo(RowOrColOperateEnum.SETSORT.getOperate(), fieldInfoStr, "row", false));
            return false;
        }
        return true;
    }

    private List<ComboItem> getFieldSortList(String fieldAlias) {
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        boolean isSummary = !"1".equals(reportConfigInfo.getType());
        AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class, new AnObjDetailInfo());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (QueryFieldBo queryFieldBo : anObjDetailInfo.getQueryFields()) {
            boolean flag;
            boolean bl = flag = isSummary && TransformUtil.isIndex(queryFieldBo.getValueType()) || fieldAlias.equals(queryFieldBo.getFieldAlias());
            if (flag) continue;
            ComboItem fieldItem = new ComboItem();
            fieldItem.setCaption(queryFieldBo.getFieldName());
            fieldItem.setValue(queryFieldBo.getFieldAlias());
            fieldItem.setImageKey(queryFieldBo.getValueType());
            items.add(fieldItem);
        }
        return items;
    }

    private void showEmptyCol(RowOrColClickOptInfo operateInfo) {
        String method = operateInfo.getMethod();
        String fieldAlias = operateInfo.getFieldAlias();
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        if ("row".equals(operateInfo.getOperateArea())) {
            rowAndColCfgInfo.getRows().stream().filter(rowFieldInfo -> HRStringUtils.equals((String)rowFieldInfo.getGroupName().getNumberAlias(), (String)fieldAlias)).forEach(rowFieldInfo -> rowFieldInfo.getGroupName().setShowEmptyCol(Boolean.parseBoolean(method)));
        } else {
            rowAndColCfgInfo.getColumns().stream().filter(fieldInfo -> HRStringUtils.equals((String)fieldInfo.getNumberAlias(), (String)fieldAlias)).forEach(fieldInfo -> fieldInfo.setShowEmptyCol(Boolean.parseBoolean(method)));
        }
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
    }

    private void deleteField(RowOrColClickOptInfo operateInfo) {
        String fieldAlias = operateInfo.getFieldAlias();
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        if ("row".equals(operateInfo.getOperateArea())) {
            List rows = rowAndColCfgInfo.getRows();
            this.removeRow(rows, fieldAlias, reportConfigInfo);
            if (null != reportConfigInfo.getDisplaySchemeInfo()) {
                reportConfigInfo.getDisplaySchemeInfo().getSelectedRowField().remove(fieldAlias);
                reportConfigInfo.getDisplaySchemeInfo().getSelectedIdxField().remove(fieldAlias);
            }
            SummaryAlgorithmUtil.updateSummaryRow(reportConfigInfo, rowAndColCfgInfo);
            AdvanceSortUtil.updateAdvanceSort(reportConfigInfo, rowAndColCfgInfo);
        } else {
            List columns = rowAndColCfgInfo.getColumns();
            for (int i = columns.size() - 1; i >= 0; --i) {
                if (!fieldAlias.equals(((FieldInfo)columns.get(i)).getNumberAlias())) continue;
                columns.remove(i);
            }
            if (null != reportConfigInfo.getDisplaySchemeInfo()) {
                reportConfigInfo.getDisplaySchemeInfo().getSelectedColField().remove(fieldAlias);
            }
            AdvanceSortUtil.updateAdvanceSort(reportConfigInfo, rowAndColCfgInfo);
        }
        SummaryAlgorithmUtil.updateSummaryCol(reportConfigInfo, rowAndColCfgInfo);
        this.putPageCache("reportConfigInfo", reportConfigInfo);
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
        this.invokeControl(new RptCfgCallBackInfo((ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class)));
    }

    private void removeRow(List<RowFieldInfo> rows, String fieldAlias, ReportConfigInfo reportConfigInfo) {
        for (int i = rows.size() - 1; i >= 0; --i) {
            RowFieldInfo rowFieldInfo = rows.get(i);
            if (!fieldAlias.equals(rowFieldInfo.getGroupName().getNumberAlias())) continue;
            if (rowFieldInfo._isMerge()) {
                MergeInfo mergeInfo = "1".equals(rowFieldInfo.getMergeType()) ? reportConfigInfo.getHeaderMerge() : reportConfigInfo.getRowColTransposition();
                for (int j = 0; j < mergeInfo.getHeaders().size(); ++j) {
                    RowFieldInfo rowFieldInfo2 = (RowFieldInfo)mergeInfo.getHeaders().get(j);
                    if (!fieldAlias.equals(rowFieldInfo2.getGroupName().getNumberAlias())) continue;
                    mergeInfo.getHeaders().remove(j);
                    break;
                }
            }
            rows.remove(i);
        }
    }

    private void splitMergeField(RowOrColClickOptInfo operateInfo) {
        ReportHeadRowAndColCfgInfo reportHeadRowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        ArrayList splitFields = Lists.newArrayListWithCapacity((int)10);
        List rows = reportHeadRowAndColCfgInfo.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            if (!((RowFieldInfo)rows.get(i)).getGroupName().getNumberAlias().equals(operateInfo.getFieldAlias())) continue;
            RowFieldInfo rowFieldInfo = (RowFieldInfo)rows.get(i);
            rows.remove(i);
            if ("2".equals(rowFieldInfo.getMergeType())) {
                for (Object fieldInfo : rowFieldInfo._getAllGns()) {
                    RowFieldInfo rowFieldInfo1 = this.getRowFieldInfo((FieldInfo)fieldInfo);
                    rows.add(i++, rowFieldInfo1);
                    splitFields.add(rowFieldInfo1);
                }
            }
            List childrenFields = "1".equals(rowFieldInfo.getMergeType()) ? rowFieldInfo.getGroupName().getFields() : rowFieldInfo.getFields();
            for (FieldInfo childFieldInfo : childrenFields) {
                RowFieldInfo rowFieldInfo1 = this.getRowFieldInfo(childFieldInfo);
                rows.add(i++, rowFieldInfo1);
                splitFields.add(rowFieldInfo1);
            }
            break;
        }
        this.putPageCache("rowAndColumnCfgInfo", reportHeadRowAndColCfgInfo);
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        List headers = "1".equals(operateInfo.getMethod()) ? reportConfigInfo.getHeaderMerge().getHeaders() : reportConfigInfo.getRowColTransposition().getHeaders();
        Iterator iterator = headers.iterator();
        while (iterator.hasNext()) {
            RowFieldInfo rowFieldInfo = (RowFieldInfo)iterator.next();
            if (!rowFieldInfo.getGroupName().getNumberAlias().equals(operateInfo.getFieldAlias())) continue;
            iterator.remove();
            if (!"2".equals(operateInfo.getMethod())) break;
            List refFields = reportConfigInfo.getRowColTransposition().getRefFields();
            for (RowFieldInfo refRowFieldInfo : refFields) {
                for (RowFieldInfo splitField : splitFields) {
                    if (!refRowFieldInfo.getGroupName().getNumberAlias().equals(splitField.getGroupName().getNumberAlias())) continue;
                    refRowFieldInfo.setType("0");
                    refRowFieldInfo.setMergeType("0");
                }
            }
        }
        this.putPageCache("reportConfigInfo", reportConfigInfo);
        this.invokeControl(new MergeOptCallBackInfo(reportConfigInfo, reportHeadRowAndColCfgInfo.getRows()));
    }

    private RowFieldInfo getRowFieldInfo(FieldInfo childFieldInfo) {
        childFieldInfo.setMergeRef(false);
        RowFieldInfo rowFieldInfo = new RowFieldInfo(childFieldInfo);
        if (!CollectionUtils.isEmpty((Collection)childFieldInfo.getFields())) {
            rowFieldInfo.setMergeType("1");
            rowFieldInfo.setType("1");
        }
        return rowFieldInfo;
    }

    private void dimCount(RowOrColClickOptInfo operateInfo) {
        String method = operateInfo.getMethod();
        String fieldAlias = operateInfo.getFieldAlias();
        String operateArea = operateInfo.getOperateArea();
        AnObjDetailInfo anObjDetailInfo = (AnObjDetailInfo)this.getPageCache("anObjDetailInfo", AnObjDetailInfo.class, new AnObjDetailInfo());
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        CalculateFieldService service = CalculateFieldService.getInstance();
        if (StringUtils.isEmpty((CharSequence)operateArea)) {
            QueryFieldBo queryFieldBo = anObjDetailInfo.getQueryFields().stream().filter(bo -> bo.getFieldAlias().equals(fieldAlias)).findAny().orElse(null);
            if (queryFieldBo == null) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u901a\u8fc7\u8ba1\u7b97\u5b57\u6bb5\u529f\u80fd\u751f\u6210\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6307\u6807\u3002", (String)"ReportManageEditPlugin_20", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                return;
            }
            String dimCountFieldAlias = service.getDimCountFieldAlias(fieldAlias);
            if (anObjDetailInfo.getReportCalFields().stream().noneMatch(field -> HRStringUtils.equals((String)field.getFieldNumber(), (String)dimCountFieldAlias))) {
                LocaleString displayName = this.getCountDisplayName(queryFieldBo.getFieldName());
                CalculateFieldBo calculateFieldBo = CalculateFieldService.getInstance().generateCalculateFieldForCount(fieldAlias, displayName, anObjDetailInfo.getReportCalFields().size());
                anObjDetailInfo.getReportCalFields().add(calculateFieldBo);
                anObjDetailInfo.addIndex(TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
            }
        } else {
            List rows = rowAndColCfgInfo.getRows();
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                RowFieldInfo rowFieldInfo = (RowFieldInfo)iterator.next();
                if (!HRStringUtils.equals((String)rowFieldInfo.getGroupName().getType(), (String)"1") || !HRStringUtils.equals((String)rowFieldInfo.getGroupName().getNumberAlias(), (String)fieldAlias)) continue;
                if ("1".equals(rowFieldInfo.getGroupName().getFieldSrc())) {
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u901a\u8fc7\u8ba1\u7b97\u5b57\u6bb5\u529f\u80fd\u751f\u6210\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6307\u6807\u3002", (String)"ReportManageEditPlugin_20", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
                    return;
                }
                LocaleString displayName = this.getCountDisplayName(rowFieldInfo.getGroupName().getDisplayName());
                String calculateFieldAlias = rowFieldInfo.getGroupName().getNumber();
                String dimCountFieldAlias = service.getDimCountFieldAlias(rowFieldInfo.getGroupName().getNumber());
                rowFieldInfo.getGroupName().setAlgorithm(method);
                rowFieldInfo.getGroupName().setType("2");
                rowFieldInfo.getGroupName().setFieldSrc("1");
                rowFieldInfo.getGroupName().setDisplayName(displayName);
                rowFieldInfo.getGroupName().setName(displayName);
                rowFieldInfo.getGroupName().setValueType(DataTypeEnum.INTEGER.getDataTypeKey());
                rowFieldInfo.getGroupName().setControlType(FieldControlType.INTEGER.getValue());
                rowFieldInfo.getGroupName().setEntityNumber(null);
                rowFieldInfo.getGroupName().setBaseDataNum(null);
                rowFieldInfo.getGroupName().setComplexType(FieldComplexType.NORMAL.getValue());
                rowFieldInfo.getGroupName().setCalculateField("true");
                rowFieldInfo.getGroupName().setFieldPath(null);
                rowFieldInfo.getGroupName().setSort(null);
                rowFieldInfo.getGroupName().setCustomSort(null);
                rowFieldInfo.getGroupName().setNumber(dimCountFieldAlias);
                rowFieldInfo.getGroupName().setNumberAlias(dimCountFieldAlias + new SecureRandom().nextInt());
                if (!CollectionUtils.isEmpty((Collection)rowAndColCfgInfo.getColumns())) {
                    iterator.remove();
                    for (int i = 0; i < rows.size(); ++i) {
                        if (!"2".equals(((RowFieldInfo)rows.get(i)).getGroupName().getType())) continue;
                        rows.add(i, rowFieldInfo);
                        break;
                    }
                }
                if (anObjDetailInfo.getReportCalFields().stream().noneMatch(field -> HRStringUtils.equals((String)field.getFieldNumber(), (String)dimCountFieldAlias))) {
                    CalculateFieldBo calculateFieldBo = CalculateFieldService.getInstance().generateCalculateFieldForCount(calculateFieldAlias, displayName, anObjDetailInfo.getReportCalFields().size());
                    anObjDetailInfo.getReportCalFields().add(calculateFieldBo);
                    anObjDetailInfo.addIndex(TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
                }
                ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class);
                SummaryAlgorithmUtil.updateSummaryRow(reportConfigInfo, rowAndColCfgInfo);
                SummaryAlgorithmUtil.updateSummaryCol(reportConfigInfo, rowAndColCfgInfo);
                this.putPageCache("reportConfigInfo", reportConfigInfo);
                break;
            }
            this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
        }
        this.putPageCache("anObjDetailInfo", anObjDetailInfo);
        this.invokeControl(new DimCountCallBackInfo(rowAndColCfgInfo.getRows(), anObjDetailInfo.getIndexList()));
        this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ReportManageEditPlugin_25", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
    }

    private LocaleString getCountDisplayName(LocaleString displayName) {
        LocaleString countLocalString = ResManager.getLocaleString((String)"\uff08\u8ba1\u6570\uff09", (String)"ReportManageEditPlugin_17", (String)"hrmp-hrptmc-formplugin");
        displayName.setLocaleValue_zh_CN(displayName.getLocaleValue_zh_CN() + countLocalString.getLocaleValue_zh_CN());
        displayName.setLocaleValue_zh_TW(displayName.getLocaleValue_zh_TW() + countLocalString.getLocaleValue_zh_TW());
        displayName.setLocaleValue_en(displayName.getLocaleValue_en() + countLocalString.getLocaleValue_en());
        return displayName;
    }

    private void setRowAlign(RowOrColClickOptInfo operateInfo) {
        String method = operateInfo.getMethod();
        String fieldAlias = operateInfo.getFieldAlias();
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        for (RowFieldInfo rowFieldInfo : rowAndColCfgInfo.getRows()) {
            if (!HRStringUtils.equals((String)rowFieldInfo.getGroupName().getNumberAlias(), (String)fieldAlias)) continue;
            rowFieldInfo.getGroupName().setAlign(method);
        }
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
    }

    private void advanceSort(RowOrColClickOptInfo operateInfo) {
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class);
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class);
        AdvanceSortUtil.advanceSort(operateInfo, reportConfigInfo, rowAndColCfgInfo);
        this.putPageCache("rowAndColumnCfgInfo", rowAndColCfgInfo);
        this.putPageCache("reportConfigInfo", reportConfigInfo);
        this.invokeControl(new RptFieldCallBackInfo(rowAndColCfgInfo));
    }

    public void dragField(String param) {
        ReportHeadRowAndColCfgInfo oldHeadInfo = (ReportHeadRowAndColCfgInfo)this.getPageCache("rowAndColumnCfgInfo", ReportHeadRowAndColCfgInfo.class, new ReportHeadRowAndColCfgInfo());
        ReportHeadRowAndColCfgInfo newHeadInfo = (ReportHeadRowAndColCfgInfo)SerializationUtils.fromJsonString((String)param, ReportHeadRowAndColCfgInfo.class);
        FieldInfoUtil.updateFieldId(newHeadInfo, oldHeadInfo);
        this.putPageCache("rowAndColumnCfgInfo", newHeadInfo);
        this.updateSummaryRow(param);
        this.updateSummaryCol(param);
        this.updateAdvanceSort(newHeadInfo);
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class);
        List reportJumpConfigList = reportConfigInfo.getReportJumpConfigList();
        if (!CollectionUtils.isEmpty((Collection)reportJumpConfigList) && ("2".equals(reportConfigInfo.getType()) || "3".equals(reportConfigInfo.getType()) || "4".equals(reportConfigInfo.getType()))) {
            reportJumpConfigList.clear();
            this.putPageCache("reportConfigInfo", reportConfigInfo);
        }
        this.invokeControl(new RptCfgCallBackInfo((ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class)));
    }

    private void updateSummaryRow(String rowAndColCfgInfoStr) {
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)SerializationUtils.fromJsonString((String)rowAndColCfgInfoStr, ReportHeadRowAndColCfgInfo.class);
        SummaryAlgorithmUtil.updateSummaryRow(reportConfigInfo, rowAndColCfgInfo);
        if (ReportSubTotalHandler.getIsSubTotal(reportConfigInfo) || reportConfigInfo.getTotal()) {
            this.putPageCache("reportConfigInfo", reportConfigInfo);
        }
    }

    private void updateSummaryCol(String rowAndColCfgInfoStr) {
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class, new ReportConfigInfo());
        ReportHeadRowAndColCfgInfo rowAndColCfgInfo = (ReportHeadRowAndColCfgInfo)SerializationUtils.fromJsonString((String)rowAndColCfgInfoStr, ReportHeadRowAndColCfgInfo.class);
        SummaryAlgorithmUtil.updateSummaryCol(reportConfigInfo, rowAndColCfgInfo);
        if (null != reportConfigInfo.getAlgorithmCol()) {
            this.putPageCache("reportConfigInfo", reportConfigInfo);
        }
    }

    private void updateAdvanceSort(ReportHeadRowAndColCfgInfo rowAndColCfgInfo) {
        ReportConfigInfo reportConfigInfo = (ReportConfigInfo)this.getPageCache("reportConfigInfo", ReportConfigInfo.class);
        AdvanceSortUtil.updateAdvanceSort(reportConfigInfo, rowAndColCfgInfo);
        this.putPageCache("reportConfigInfo", reportConfigInfo);
    }
}

