/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hbp.common.model.report.DayTypeEnum;
import kd.hr.hbp.common.model.report.MonthTypeEnum;
import kd.hr.hbp.common.model.report.QuarterTypeEnum;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnObjGroupFieldService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.center.utils.ReportCenterAdminOrgFilterUtil;
import kd.hr.hrptmc.business.center.utils.ReportCenterUtil;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.business.exception.ReportQueryBizException;
import kd.hr.hrptmc.business.publish.ReportCenterPublishService;
import kd.hr.hrptmc.business.repcalculate.org.helper.AdminOrgCalHelper;
import kd.hr.hrptmc.business.repdesign.ReportQuerySchemeRuleService;
import kd.hr.hrptmc.business.repdesign.display.ReportDisplayHelper;
import kd.hr.hrptmc.business.repdesign.enums.ControlType2ParamType;
import kd.hr.hrptmc.business.repdesign.enums.ParamTypeEnum;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.AuthorityInfo;
import kd.hr.hrptmc.business.repdesign.info.DisplaySchemeInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.RptFilterInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterConstants;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterValueBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeFieldBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.QuerySchemeValueBo;
import kd.hr.hrptmc.common.model.repdesign.queryscheme.enums.EnumOperatorEnum;
import kd.hr.hrptmc.formplugin.web.repdesign.service.PreViewService;
import kd.hr.hrptmc.formplugin.web.repdesign.service.ReportCacheService;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldApUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FilterBoUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FilterVestDateUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.IDStringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ReportFilterService
extends PreViewService
implements ReportManageConstants,
FilterConstants {
    private static final String LAST_LEVEL = "lastlevel";
    private static final String CONTAIN_SUB = "containsub";
    private static final String PAGE_PRE_VIEW = "hrptmc_report_preview";
    private static final String CACHE_WHERE_QFILTER = "whereQFilters";
    private static final String CACHE_ON_QFILTER = "onQFilters";
    private static final String CACHE_WHERE_CUS_QFILTER = "whereCusQFilters";
    private static final String CACHE_ON_CUS_QFILTER = "onCusQFilters";
    private static final String CACHE_IS_QUERY_SCHEME = "isOrinalQuerySchem";
    private static final String CACHE_QUERY_SCHEME_VALUE = "querySchemValue";
    public static final String FILTER_DATA = "filterdata";
    private static final Log LOGGER = LogFactory.getLog(ReportFilterService.class);

    public ReportFilterService(AbstractFormPlugin plugin, ReportCacheService rptCacheService, IDataModel dataModel) {
        super(plugin, rptCacheService, dataModel);
    }

    public List<QFilter> getWhereQFilterFromCache() {
        return this.getQFilterFromCache(CACHE_WHERE_QFILTER);
    }

    public List<QFilter> getOnQFilterFromCache() {
        return this.getQFilterFromCache(CACHE_ON_QFILTER);
    }

    private List<QFilter> getQFilterFromCache(String key) {
        String qFilterStr = this.getPageCache(key);
        if (StringUtils.isNotEmpty((CharSequence)qFilterStr)) {
            List qFilters = SerializationUtils.fromJsonStringToList((String)qFilterStr, String.class);
            return qFilters.stream().map(QFilter::fromSerializedString).collect(Collectors.toList());
        }
        return new ArrayList<QFilter>();
    }

    public RptFilterInfo getRptFilterInfo(boolean addPermissionQFilter) throws Exception {
        RptFilterInfo rptFilterInfo = new RptFilterInfo();
        String data = (String)this.plugin.getView().getFormShowParameter().getCustomParam(FILTER_DATA);
        String formId = this.plugin.getView().getFormShowParameter().getFormId();
        String appId = this.plugin.getView().getFormShowParameter().getAppId();
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            if (HRStringUtils.equals((String)this.getPageCache(CACHE_IS_QUERY_SCHEME), (String)Boolean.TRUE.toString())) {
                QuerySchemeBo querySchemeBo = (QuerySchemeBo)this.getPageCache(CACHE_QUERY_SCHEME_VALUE, QuerySchemeBo.class);
                List querySchemeList = querySchemeBo.getQuerySchemeList();
                rptFilterInfo = this.handleQFilterByQueryScheme(querySchemeList);
                for (QuerySchemeValueBo querySchemeValueBo : querySchemeList) {
                    QuerySchemeFieldBo querySchemeFieldBo = querySchemeValueBo.getQuerySchemeFieldBo();
                    if (!this.isAdminOrg(querySchemeFieldBo)) continue;
                    LOGGER.info("kd.hr.hrptmc.formplugin.web.repdesign.ReportPreViewPlugin.handlerPermission", (Object)SerializationUtils.toJsonString((Object)querySchemeValueBo));
                    this.setAdminOrgFilterByScheme(rptFilterInfo, querySchemeValueBo, appId, formId);
                }
            } else {
                List filterBoList = SerializationUtils.fromJsonStringToList((String)data, FilterBo.class);
                String str = this.validateIsMustAndShowMessage(filterBoList);
                if (!HRStringUtils.isEmpty((String)str) && !this.isReportJumpView(this.plugin.getView().getFormShowParameter())) {
                    throw new ReportQueryBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5fc5\u586b\u7b5b\u9009\u6761\u4ef6%s", (String)"ReportFilterService_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]), str));
                }
                rptFilterInfo = this.handleQFilter(filterBoList);
                for (FilterBo filterBo : filterBoList) {
                    if (!filterBo.getFilterType().equals("adminorg")) continue;
                    this.setAdminOrgFilter(rptFilterInfo, filterBo, appId, formId);
                }
            }
        }
        if (!PAGE_PRE_VIEW.equals(formId) && addPermissionQFilter) {
            if (ReportCenterUtil.openFromReportCenter((Map)this.plugin.getView().getFormShowParameter().getCustomParams())) {
                QFilter permissionQFilter = ReportCenterUtil.getReportCenterPermissionQFilter((Map)this.plugin.getView().getFormShowParameter().getCustomParams());
                if (null != permissionQFilter) {
                    rptFilterInfo.addWhereQFilter(permissionQFilter);
                }
            } else {
                String appIdStr = ReportFilterService.getAppId(formId);
                QFilter permissionQFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appIdStr, formId, "47150e89000000ac", null});
                if (null != permissionQFilter) {
                    rptFilterInfo.addWhereQFilter(permissionQFilter);
                }
            }
        }
        return rptFilterInfo;
    }

    private boolean isBaseData(QuerySchemeFieldBo querySchemeFieldBo) {
        return FieldComplexType.BASE_DATA.getValue().equals(querySchemeFieldBo.getComplexType()) || FieldComplexType.ADMIN_ORG.getValue().equals(querySchemeFieldBo.getComplexType()) || FieldComplexType.HIS_BASE_DATA.getValue().equals(querySchemeFieldBo.getComplexType());
    }

    private QFilter getQuerySchemeQFilter(QuerySchemeValueBo querySchemeValueBo, List<Map<Long, String>> groupFieldInfo) throws ParseException {
        QuerySchemeFieldBo querySchemeFieldBo = querySchemeValueBo.getQuerySchemeFieldBo();
        String fieldAlias = querySchemeFieldBo.getFieldAlias();
        boolean isBaseData = this.isBaseData(querySchemeFieldBo);
        String value = querySchemeValueBo.getValue();
        QFilter qFilter = null;
        if (isBaseData) {
            qFilter = ReportQuerySchemeRuleService.matchBaseData((QuerySchemeValueBo)querySchemeValueBo);
        } else if (FieldControlType.CHECKBOX.getValue().equals(querySchemeFieldBo.getControlType()) || FieldControlType.COMBO.getValue().equals(querySchemeFieldBo.getControlType()) || FieldControlType.MUL_COMBO.getValue().equals(querySchemeFieldBo.getControlType()) || querySchemeFieldBo.getGroupField()) {
            String compare = querySchemeValueBo.getCompare();
            if (HRStringUtils.isEmpty((String)value) && !EnumOperatorEnum.IS_NOT_NULL.getValue().equals(compare) && !EnumOperatorEnum.IS_NULL.getValue().equals(compare)) {
                return null;
            }
            if (querySchemeFieldBo.getGroupField()) {
                HashMap<Long, String> objectObjectHashMap = new HashMap<Long, String>(16);
                objectObjectHashMap.put(Long.parseLong(querySchemeFieldBo.getGroupFieldId()), value);
                groupFieldInfo.add(objectObjectHashMap);
                return null;
            }
            qFilter = ReportQuerySchemeRuleService.matchEnum((QuerySchemeValueBo)querySchemeValueBo);
        } else if (fieldAlias.contains("!")) {
            if (fieldAlias.contains(SplitDateTypeEnum.FN_QUARTER.getKey()) || fieldAlias.contains(SplitDateTypeEnum.SN_QUARTER.getKey()) || fieldAlias.contains(SplitDateTypeEnum.FN_MONTH.getKey()) || fieldAlias.contains(SplitDateTypeEnum.SN_MONTH.getKey()) || fieldAlias.contains(SplitDateTypeEnum.FN_DAY.getKey()) || fieldAlias.contains(SplitDateTypeEnum.SN_DAY.getKey())) {
                qFilter = ReportQuerySchemeRuleService.matchEnum((QuerySchemeValueBo)querySchemeValueBo);
            } else {
                ReportManageConfigInfo rptManageConfigInfo = this.getReportManageConfigInfo(this.plugin.getView().getFormShowParameter());
                List queryFields = rptManageConfigInfo.getAssignObj().getQueryFields();
                DateTimeFieldTimeZoneUtil.setTimeZoneInfoIntoFilterBo((QuerySchemeFieldBo)querySchemeValueBo.getQuerySchemeFieldBo(), (List)queryFields);
                qFilter = ReportQuerySchemeRuleService.matchDate((QuerySchemeValueBo)querySchemeValueBo);
            }
        } else if (FieldControlType.DATE.getValue().equals(querySchemeFieldBo.getControlType()) || FieldControlType.DATE_TIME.getValue().equals(querySchemeFieldBo.getControlType())) {
            ReportManageConfigInfo rptManageConfigInfo = this.getReportManageConfigInfo(this.plugin.getView().getFormShowParameter());
            List queryFields = rptManageConfigInfo.getAssignObj().getQueryFields();
            DateTimeFieldTimeZoneUtil.setTimeZoneInfoIntoFilterBo((QuerySchemeFieldBo)querySchemeValueBo.getQuerySchemeFieldBo(), (List)queryFields);
            qFilter = ReportQuerySchemeRuleService.matchDate((QuerySchemeValueBo)querySchemeValueBo);
        } else if (ParamTypeEnum.NUMBER == ControlType2ParamType.controlType2ParamType((FieldControlType)FieldControlType.getFieldControlTypeByValue((String)querySchemeFieldBo.getControlType()), null)) {
            qFilter = ReportQuerySchemeRuleService.matchNumber((QuerySchemeValueBo)querySchemeValueBo);
        } else if (ParamTypeEnum.BOOLEAN == ControlType2ParamType.controlType2ParamType((FieldControlType)FieldControlType.getFieldControlTypeByValue((String)querySchemeFieldBo.getControlType()), null)) {
            qFilter = ReportQuerySchemeRuleService.matchBoolean((QuerySchemeValueBo)querySchemeValueBo);
        } else if (ParamTypeEnum.TEXT == ControlType2ParamType.controlType2ParamType((FieldControlType)FieldControlType.getFieldControlTypeByValue((String)querySchemeFieldBo.getControlType()), null)) {
            qFilter = ReportQuerySchemeRuleService.matchText((QuerySchemeValueBo)querySchemeValueBo);
        }
        return qFilter;
    }

    private boolean isAdminOrg(QuerySchemeFieldBo querySchemeFieldBo) {
        return FieldComplexType.ADMIN_ORG.getValue().equals(querySchemeFieldBo.getComplexType()) && (querySchemeFieldBo.getFieldAlias().endsWith(".name") || querySchemeFieldBo.getFieldAlias().endsWith(".number"));
    }

    @ExcludeFromJacocoGeneratedReport
    private void setAdminOrgFilterByScheme(RptFilterInfo rptFilterInfo, QuerySchemeValueBo querySchemeValueBo, String appId, String formId) {
        QuerySchemeFieldBo querySchemeFieldBo = querySchemeValueBo.getQuerySchemeFieldBo();
        String fieldAlias = querySchemeFieldBo.getFieldAlias();
        String fieldPath = querySchemeFieldBo.getFieldPath();
        boolean containSub = querySchemeValueBo.getContainSub();
        int lastLevel = querySchemeValueBo.getSelectLevel();
        String param = fieldAlias.substring(0, fieldAlias.lastIndexOf(46));
        AuthorityInfo authorityInfo = new AuthorityInfo(appId, formId, RequestContext.get().getCurrUserId(), new Date(), "47150e89000000ac", param);
        AdminOrgSummaryInfo adminOrgSummaryInfo = new AdminOrgSummaryInfo();
        if (!querySchemeValueBo.getMul()) {
            String baseDataId = querySchemeValueBo.getBaseDataId();
            if (HRStringUtils.isNotEmpty((String)baseDataId)) {
                adminOrgSummaryInfo.setAdminOrgIds(IDStringUtils.getLongIds(baseDataId));
            }
            if (HRStringUtils.equals((String)querySchemeValueBo.getCompare(), (String)"is_not_null")) {
                adminOrgSummaryInfo.setIncludeSubOrg(false);
            }
            adminOrgSummaryInfo.setDate(this.getDate());
            if (lastLevel != 0) {
                adminOrgSummaryInfo.setSummaryLevel(Integer.valueOf(lastLevel));
            }
            adminOrgSummaryInfo.setAuthorityInfo(authorityInfo);
        } else {
            this.handlerWhereQFilter(rptFilterInfo, formId, authorityInfo, param);
        }
        this.handlerAdminOrgSummaryInfo(adminOrgSummaryInfo, fieldAlias, fieldPath, containSub, !querySchemeValueBo.getMul());
        rptFilterInfo.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
        LOGGER.info("adminOrgSummaryInfo:{}", (Object)adminOrgSummaryInfo);
    }

    private void handlerAdminOrgSummaryInfo(AdminOrgSummaryInfo adminOrgSummaryInfo, String fieldAlias, String fieldPath, boolean containSub, boolean treeShow) {
        adminOrgSummaryInfo.setAdminOrgFieldAlias(fieldAlias);
        adminOrgSummaryInfo.setAdminOrgFieldFullPath(fieldPath);
        adminOrgSummaryInfo.setIncludeSubOrg(containSub);
        adminOrgSummaryInfo.setTreeShow(treeShow);
        String architectureId = this.getPageCache("current_orgscheme_type_" + fieldAlias);
        long admOrgArchitectureId = HRStringUtils.isEmpty((String)architectureId) ? 1010L : Long.parseLong(architectureId);
        adminOrgSummaryInfo.setAdmOrgArchitectureId(Long.valueOf(admOrgArchitectureId));
    }

    @ExcludeFromJacocoGeneratedReport
    private RptFilterInfo handleQFilterByQueryScheme(List<QuerySchemeValueBo> querySchemeList) throws ParseException {
        ArrayList<QFilter> onList = new ArrayList<QFilter>();
        ArrayList<QFilter> whereList = new ArrayList<QFilter>();
        QFilter whereQFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        ArrayList<QFilter> preIdxList = new ArrayList<QFilter>();
        QFilter preIdxQFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        ArrayList groupFieldInfo = Lists.newArrayListWithCapacity((int)10);
        for (QuerySchemeValueBo querySchemeValueBo : querySchemeList) {
            QFilter qFilter = this.getQuerySchemeQFilter(querySchemeValueBo, groupFieldInfo);
            if (null == qFilter) continue;
            whereQFilter.and(qFilter);
            preIdxQFilter.and(qFilter);
        }
        whereList.add(whereQFilter);
        preIdxList.add(preIdxQFilter);
        return this.getRptFilterInfo(groupFieldInfo, onList, whereList, preIdxList);
    }

    private RptFilterInfo handleQFilter(List<FilterBo> cast) {
        ArrayList<QFilter> onList = new ArrayList<QFilter>();
        ArrayList<QFilter> whereList = new ArrayList<QFilter>();
        QFilter whereQFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        ArrayList<QFilter> preIdxList = new ArrayList<QFilter>();
        QFilter preIdxQFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        ArrayList groupFieldInfo = Lists.newArrayListWithCapacity((int)10);
        for (FilterBo filterBo : cast) {
            if (this.handleBizFilter(onList, whereList, preIdxList, filterBo)) continue;
            Object value = this.dataModel.getValue(filterBo.getFieldAlias());
            String filterType = filterBo.getFilterType();
            FilterType filterTypeByValue = FilterType.getFilterTypeByValue((String)filterType);
            if (value == null && filterTypeByValue != FilterType.DATE && filterTypeByValue != FilterType.NUMBER && filterTypeByValue != FilterType.BASE_DATA_ENUM || value == null && filterTypeByValue == FilterType.NUMBER && !"between".equals(this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "opt"))) continue;
            this.addQFilterByFilterBo(onList, whereQFilter, preIdxQFilter, groupFieldInfo, filterBo, value, filterTypeByValue);
        }
        whereList.add(whereQFilter);
        preIdxList.add(preIdxQFilter);
        return this.getRptFilterInfo(groupFieldInfo, onList, whereList, preIdxList);
    }

    private List<QFilter> getGroupFieldQFilter(List<Map<Long, String>> groupFieldInfo) {
        ReportManageConfigInfo reportManageConfigInfo = this.getReportManageConfigInfo(this.plugin.getView().getFormShowParameter());
        List anObjGroupFields = reportManageConfigInfo.getAssignObj().getAnObjGroupFields();
        List groupFieldQFilter = AnObjGroupFieldService.getInstance().getGroupFieldQFilter(groupFieldInfo, anObjGroupFields, true);
        groupFieldQFilter.forEach(qFilter -> LOGGER.info("GROUP_FIELD_QFILTER: {}", qFilter));
        return groupFieldQFilter;
    }

    private RptFilterInfo getRptFilterInfo(List<Map<Long, String>> groupFieldInfo, List<QFilter> onList, List<QFilter> whereList, List<QFilter> preIdxList) {
        List<QFilter> groupFieldQFilter = this.getGroupFieldQFilter(groupFieldInfo);
        whereList.addAll(groupFieldQFilter);
        preIdxList.addAll(groupFieldQFilter);
        RptFilterInfo rptFilterInfo = new RptFilterInfo();
        rptFilterInfo.setOnQFilter(onList);
        rptFilterInfo.setWhereQFilter(whereList);
        rptFilterInfo.setPreIdxQFilter(preIdxList);
        return rptFilterInfo;
    }

    private void setAdminOrgFilter(RptFilterInfo rptFilterInfo, FilterBo filterBo, String appId, String formId) {
        AdminOrgSummaryInfo adminOrgSummaryInfo = new AdminOrgSummaryInfo();
        String fieldAlias = filterBo.getFieldAlias();
        boolean isMulBaseData = filterBo.getBaseDataMul();
        String fieldPath = filterBo.getFieldPath();
        String lastLevel = !isMulBaseData && filterBo.getOrgLevel() ? (String)this.dataModel.getValue(LAST_LEVEL) : null;
        adminOrgSummaryInfo.setQuerySubLevel(filterBo.getLevel());
        String param = fieldAlias.substring(0, fieldAlias.lastIndexOf(46));
        AuthorityInfo authorityInfo = new AuthorityInfo(appId, formId, RequestContext.get().getCurrUserId(), new Date(), "47150e89000000ac", param);
        boolean containSub = (Boolean)this.dataModel.getValue(CONTAIN_SUB);
        Object value = this.dataModel.getValue(fieldAlias);
        if (!isMulBaseData) {
            if (value != null) {
                long id = ((DynamicObject)value).getLong("id");
                Long boId = (Long)ReportCenterAdminOrgFilterUtil.getAdminOrgBoId((Object)id);
                adminOrgSummaryInfo.addAndClearOldAdminOrgId(boId.longValue());
            }
            adminOrgSummaryInfo.setDate(this.getDate());
            if (HRStringUtils.isNotEmpty((String)lastLevel)) {
                adminOrgSummaryInfo.setSummaryLevel(Integer.valueOf(lastLevel));
            }
            adminOrgSummaryInfo.setAuthorityInfo(authorityInfo);
        } else {
            if (value != null) {
                MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)value;
                List ids = mulBasedataDynamicObjectCollection.stream().map(row -> row.getLong("fbasedataid_id")).collect(Collectors.toList());
                adminOrgSummaryInfo.setAdminOrgIds(ReportCenterAdminOrgFilterUtil.getAdminOrgBoIds(ids));
            }
            this.handlerWhereQFilter(rptFilterInfo, formId, authorityInfo, param);
        }
        this.handlerAdminOrgSummaryInfo(adminOrgSummaryInfo, fieldAlias, fieldPath, containSub, !isMulBaseData);
        rptFilterInfo.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
        LOGGER.info("adminOrgSummaryInfo:{}", (Object)adminOrgSummaryInfo);
    }

    private Date getDate() {
        ReportManageConfigInfo reportManageConfigInfo = this.getReportManageConfigInfo(this.plugin.getView().getFormShowParameter());
        Date date = new Date();
        String data = (String)this.plugin.getView().getFormShowParameter().getCustomParam(FILTER_DATA);
        if (reportManageConfigInfo != null && !StringUtils.isEmpty((CharSequence)data)) {
            List filterBos = SerializationUtils.fromJsonStringToList((String)data, FilterBo.class);
            for (RowFieldInfo rowFieldInfo : reportManageConfigInfo.getRows()) {
                FieldInfo groupName = rowFieldInfo.getGroupName();
                if (!"tree".equals(groupName.getDisplayMode())) continue;
                date = this.getDateValueByOrg(groupName, filterBos);
            }
        }
        return date;
    }

    private void handlerWhereQFilter(RptFilterInfo rptFilterInfo, String formId, AuthorityInfo authorityInfo, String param) {
        AuthorizedOrgResult authorityOrgResult;
        if (!PAGE_PRE_VIEW.equals(formId) && (authorityOrgResult = AdminOrgCalHelper.getAuthorityOrgResult((AuthorityInfo)authorityInfo)) != null && !authorityOrgResult.isHasAllOrgPerm()) {
            List orgIds = authorityOrgResult.getHasPermOrgs();
            if (CollectionUtils.isEmpty((Collection)orgIds)) {
                rptFilterInfo.addWhereQFilter(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            } else {
                rptFilterInfo.addWhereQFilter(new QFilter(param, "in", (Object)orgIds));
            }
        }
    }

    private static String getAppId(String formId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        if (mainEntityType == null) {
            return null;
        }
        List publishAppList = mainEntityType.getPermissionControlType().getPublishApps();
        if (publishAppList.size() > 0) {
            return (String)publishAppList.get(0);
        }
        return "2VKJ94YEM7AU";
    }

    private Date getDateValueByOrg(FieldInfo column, List<FilterBo> filterBoList) {
        String orgVersionDate;
        Date date = new Date();
        String sp = "";
        if (column.getOrgVersionDate().contains("\\_")) {
            String[] split = column.getOrgVersionDate().split("_");
            orgVersionDate = split[0];
            sp = split[1];
        } else {
            orgVersionDate = column.getOrgVersionDate();
        }
        for (FilterBo filterBo : filterBoList) {
            if (!filterBo.getFieldAlias().equals(orgVersionDate)) continue;
            if (HRStringUtils.equals((String)filterBo.getDateType(), (String)"1")) {
                Object versionDateValue = this.dataModel.getValue(orgVersionDate);
                if (versionDateValue == null) continue;
                date = (Date)versionDateValue;
                continue;
            }
            String vestDate = this.getPageCache(filterBo.getFieldAlias() + "_vestdate");
            if (vestDate == null) continue;
            Date[] dateArr = this.getDate(filterBo);
            date = "end".equals(sp) ? dateArr[1] : dateArr[0];
        }
        return date;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean handleBizFilter(List<QFilter> onList, List<QFilter> whereList, List<QFilter> preIdxList, FilterBo filterBo) {
        if (filterBo.getCustomBo() && filterBo.getCustomQFilter()) {
            List onQFilters;
            List<QFilter> whereCusQFilters = this.getQFilterFromCache(CACHE_WHERE_CUS_QFILTER);
            List<QFilter> onCusQFilters = this.getQFilterFromCache(CACHE_ON_CUS_QFILTER);
            if (!CollectionUtils.isEmpty(whereCusQFilters) || !CollectionUtils.isEmpty(onCusQFilters)) {
                for (QFilter qFilter : whereCusQFilters) {
                    boolean isContain;
                    boolean isExist = whereList.stream().anyMatch(filter -> HRStringUtils.equals((String)filter.toSerializedString(), (String)qFilter.toSerializedString()));
                    if (!isExist) {
                        whereList.add(qFilter);
                    }
                    if (isContain = preIdxList.stream().anyMatch(filter -> HRStringUtils.equals((String)filter.toSerializedString(), (String)qFilter.toSerializedString()))) continue;
                    preIdxList.add(qFilter);
                }
                for (QFilter qFilter : onCusQFilters) {
                    boolean isContain = onList.stream().anyMatch(filter -> HRStringUtils.equals((String)filter.toSerializedString(), (String)qFilter.toSerializedString()));
                    if (isContain) continue;
                    onList.add(qFilter);
                }
                return true;
            }
            Map customQFilter = (Map)this.plugin.getView().getFormShowParameter().getCustomParam("customQFilter");
            if (customQFilter == null) {
                return true;
            }
            List whereQFilters = (List)customQFilter.get("where");
            if (whereQFilters != null) {
                for (QFilter qFilter : whereQFilters) {
                    if (!whereList.contains(qFilter)) {
                        whereList.add(qFilter);
                    }
                    if (preIdxList.contains(qFilter)) continue;
                    preIdxList.add(qFilter);
                }
                List serializeQFilters = whereQFilters.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
                this.putPageCache(CACHE_WHERE_CUS_QFILTER, SerializationUtils.toJsonString(serializeQFilters));
            }
            if ((onQFilters = (List)customQFilter.get("on")) != null) {
                onList.addAll(onQFilters);
                List serializeQFilters = onQFilters.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
                this.putPageCache(CACHE_ON_CUS_QFILTER, SerializationUtils.toJsonString(serializeQFilters));
            }
            return true;
        }
        return false;
    }

    private void addQFilterByFilterBo(List<QFilter> onList, QFilter whereQFilter, QFilter preIdxQFilter, List<Map<Long, String>> groupFieldInfo, FilterBo filterBo, Object value, FilterType filterTypeByValue) {
        switch (filterTypeByValue) {
            case BASE_DATA: 
            case HIS_BASE_DATA: {
                if (value == null) {
                    return;
                }
                this.getBaseDataQfliter(false, whereQFilter, filterBo, value);
                this.getBaseDataQfliter(true, preIdxQFilter, filterBo, value);
                break;
            }
            case ADMIN_ORG: {
                if (value == null) {
                    return;
                }
                boolean dataMul = filterBo.getBaseDataMul();
                if (dataMul) {
                    MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)value;
                    Set ids = mulBasedataDynamicObjectCollection.stream().map(row -> row.get("fbasedataid_id")).collect(Collectors.toSet());
                    if (ids.size() <= 0) break;
                    ids = ReportCenterAdminOrgFilterUtil.getAdminOrgBoIds((FilterBo)filterBo, ids);
                    whereQFilter.and(new QFilter(filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf(46)) + ".id", "in", (Object)ids));
                    preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "in", (Object)ids));
                    break;
                }
                Object id = ((DynamicObject)value).get("id");
                id = ReportCenterAdminOrgFilterUtil.getAdminOrgBoId((FilterBo)filterBo, (Object)id);
                whereQFilter.and(new QFilter(filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf(46)) + ".id", "in", (Object)Lists.newArrayList((Object[])new Object[]{id})));
                preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "in", (Object)Lists.newArrayList((Object[])new Object[]{id})));
                break;
            }
            case STRING: {
                if (value == null) break;
                if (StringUtils.isEmpty((CharSequence)((String)value))) {
                    return;
                }
                whereQFilter.and(new QFilter(filterBo.getFieldAlias(), "like", (Object)(value + "%")));
                preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "like", (Object)(value + "%")));
                break;
            }
            case DATE: {
                this.handleDateQFilter(whereQFilter, filterBo, onList);
                this.handleDateQFilter(preIdxQFilter, filterBo, new ArrayList<QFilter>());
                break;
            }
            case ENUM: {
                if (null == value) {
                    return;
                }
                if (ObjectUtils.isEmpty((Object)value)) {
                    return;
                }
                if (filterBo.getGroupField()) {
                    HashMap<Long, String> objectObjectHashMap = new HashMap<Long, String>(16);
                    objectObjectHashMap.put(Long.parseLong(filterBo.getGroupFieldId()), (String)value);
                    groupFieldInfo.add(objectObjectHashMap);
                    return;
                }
                String[] split = ((String)value).split(",");
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
                list.remove("");
                if (list.size() == 0) break;
                if (HRStringUtils.equals((String)filterBo.getControlType(), (String)FieldControlType.MUL_COMBO.getValue())) {
                    QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                    for (String s : list) {
                        qFilter.and(new QFilter(filterBo.getFieldAlias(), "like", (Object)("%," + s + ",%")));
                    }
                    whereQFilter.and(qFilter);
                    preIdxQFilter.and(qFilter);
                    break;
                }
                whereQFilter.and(new QFilter(filterBo.getFieldAlias(), "in", list));
                preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "in", list));
                break;
            }
            case ADMIN_DIVISION: {
                if (value == null) break;
                whereQFilter.and(new QFilter(filterBo.getFieldAlias(), "=", value));
                preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "=", value));
                break;
            }
            case NUMBER: {
                String opt = (String)this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "opt");
                if (!StringUtils.isNotEmpty((CharSequence)opt)) break;
                if ("between".equals(opt)) {
                    BigDecimal endNumber;
                    BigDecimal beginNumber = (BigDecimal)this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "beginnumber");
                    if (beginNumber != null) {
                        beginNumber = beginNumber.setScale(2, RoundingMode.HALF_UP);
                        whereQFilter.and(new QFilter(filterBo.getFieldAlias(), ">=", (Object)beginNumber));
                        preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), ">=", (Object)beginNumber));
                    }
                    if ((endNumber = (BigDecimal)this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "endnumber")) == null) break;
                    endNumber = endNumber.setScale(2, RoundingMode.HALF_UP);
                    whereQFilter.and(new QFilter(filterBo.getFieldAlias(), "<=", (Object)endNumber));
                    preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "<=", (Object)endNumber));
                    break;
                }
                if ("==".equals(opt)) {
                    if (value == null) break;
                    BigDecimal newValue = ((BigDecimal)value).setScale(2, RoundingMode.HALF_UP);
                    whereQFilter.and(new QFilter(filterBo.getFieldAlias(), "=", (Object)newValue));
                    preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "=", (Object)newValue));
                    break;
                }
                if (value == null) break;
                BigDecimal newValue = ((BigDecimal)value).setScale(2, RoundingMode.HALF_UP);
                whereQFilter.and(new QFilter(filterBo.getFieldAlias(), opt, (Object)newValue));
                preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), opt, (Object)newValue));
                break;
            }
            case BOOLEAN: {
                whereQFilter.and(new QFilter(filterBo.getFieldAlias(), "=", (Object)((Boolean)value != false ? "1" : "0")));
                preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "=", (Object)((Boolean)value != false ? "1" : "0")));
                break;
            }
            case BASE_DATA_ENUM: {
                String selectF7 = this.getPageCache(filterBo.getFieldAlias() + "_selectF7");
                if (!HRStringUtils.isNotEmpty((String)selectF7)) break;
                List ids = SerializationUtils.fromJsonStringToList((String)selectF7, String.class);
                ids.remove("");
                ids.remove(null);
                if (ids.size() <= 0) break;
                List idList = ReportCenterPublishService.getIds((List)ids);
                whereQFilter.and(new QFilter(filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf(46)) + ".id", "in", (Object)idList));
                preIdxQFilter.and(new QFilter(filterBo.getFieldAlias(), "in", (Object)idList));
                break;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Date[] getDate(FilterBo filterBo) {
        Date[] dateByYear = new Date[]{null, null};
        String vestDate = this.getPageCache(filterBo.getFieldAlias() + "_vestdate");
        if (vestDate == null) {
            return dateByYear;
        }
        try {
            Map cast = (Map)HRJSONUtils.cast((String)vestDate, Map.class);
            String datePickerType = (String)cast.get("datePickerType");
            Object datePickerContent = cast.get("datePickerContent");
            if (datePickerContent instanceof String && HRStringUtils.isEmpty((String)((String)datePickerContent))) {
                return dateByYear;
            }
            if (datePickerContent instanceof List) {
                if (CollectionUtils.isEmpty((Collection)((List)datePickerContent))) {
                    return dateByYear;
                }
                List list = (List)datePickerContent;
                for (String str : list) {
                    if (!HRStringUtils.isEmpty((String)str)) continue;
                    return dateByYear;
                }
            }
            if (HRStringUtils.isEmpty((String)datePickerType)) {
                return dateByYear;
            }
            this.handlerDateByYear(dateByYear, filterBo.getTimeZoneInfo(), datePickerType, datePickerContent);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        return dateByYear;
    }

    private void getBaseDataQfliter(boolean handlePresetIndexQFilter, QFilter qFilter, FilterBo filterBo, Object value) {
        boolean baseDataMul = filterBo.getBaseDataMul();
        if (baseDataMul) {
            MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)value;
            Set ids = mulBasedataDynamicObjectCollection.stream().map(row -> row.get("fbasedataid_id")).collect(Collectors.toSet());
            if (ids.size() > 0) {
                if (handlePresetIndexQFilter) {
                    qFilter.and(new QFilter(filterBo.getFieldAlias(), "in", ids));
                } else {
                    String propertyPrefix = filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf(46));
                    qFilter.and(new QFilter(propertyPrefix + ".id", "in", ids));
                }
            }
        } else {
            Object id = ((DynamicObject)value).get("id");
            if (id != null) {
                if (handlePresetIndexQFilter) {
                    qFilter.and(new QFilter(filterBo.getFieldAlias(), "=", id));
                } else if (filterBo.getVirtualEntityField()) {
                    qFilter.and(new QFilter(filterBo.getFieldAlias(), "=", id));
                } else {
                    String propertyPrefix = filterBo.getFieldAlias().substring(0, filterBo.getFieldAlias().lastIndexOf(46));
                    qFilter.and(new QFilter(propertyPrefix + ".id", "=", id));
                }
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleDateQFilter(QFilter qFilter, FilterBo filterBo, List<QFilter> onList) {
        String vestDate;
        if (HRStringUtils.equals((String)filterBo.getDateType(), (String)"1")) {
            Object value = this.dataModel.getValue(filterBo.getFieldAlias());
            if (value == null) {
                return;
            }
            Date[] dates = new Date[2];
            FilterVestDateUtils.getDateByValue((Date)value, dates, filterBo.getTimeZoneInfo());
            if (filterBo.getGroupDate()) {
                String beginDate = filterBo.getBeginDate();
                String endDate = filterBo.getEndDate();
                QFilter beginQFilter = new QFilter(beginDate, "<=", (Object)dates[1]);
                QFilter endQFilter = new QFilter(endDate, ">=", (Object)dates[0]);
                onList.add(beginQFilter);
                onList.add(endQFilter);
            } else {
                qFilter.and(new QFilter(filterBo.getFieldAlias(), ">=", (Object)dates[0])).and(new QFilter(filterBo.getFieldAlias(), "<=", (Object)dates[1]));
                return;
            }
        }
        if ((vestDate = this.getPageCache(filterBo.getFieldAlias() + "_vestdate")) == null) {
            return;
        }
        try {
            Map cast = (Map)HRJSONUtils.cast((String)vestDate, Map.class);
            String datePickerType = (String)cast.get("datePickerType");
            Object datePickerContent = cast.get("datePickerContent");
            if (datePickerContent instanceof String && HRStringUtils.isEmpty((String)((String)datePickerContent))) {
                return;
            }
            if (datePickerContent instanceof List) {
                if (CollectionUtils.isEmpty((Collection)((List)datePickerContent))) {
                    return;
                }
                List list = (List)datePickerContent;
                for (String str : list) {
                    if (!HRStringUtils.isEmpty((String)str)) continue;
                    return;
                }
            }
            if (HRStringUtils.isEmpty((String)datePickerType)) {
                return;
            }
            Date[] dateByYear = new Date[2];
            this.handlerDateByYear(dateByYear, filterBo.getTimeZoneInfo(), datePickerType, datePickerContent);
            qFilter.and(new QFilter(filterBo.getFieldAlias(), ">=", (Object)dateByYear[0])).and(new QFilter(filterBo.getFieldAlias(), "<=", (Object)dateByYear[1]));
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private void handlerDateByYear(Date[] dateByYear, TimeZoneInfo timeZoneInfo, String datePickerType, Object datePickerContent) {
        if (HRStringUtils.equals((String)datePickerType, (String)"year")) {
            FilterVestDateUtils.getDateByYear(dateByYear, (String)datePickerContent, timeZoneInfo);
        } else if (HRStringUtils.equals((String)datePickerType, (String)"month")) {
            FilterVestDateUtils.getDateByMonth(dateByYear, (String)datePickerContent, timeZoneInfo);
        } else if (HRStringUtils.equals((String)datePickerType, (String)"quarter")) {
            FilterVestDateUtils.getDateByQuarter(dateByYear, (String)datePickerContent, timeZoneInfo);
        } else if (HRStringUtils.isNotEmpty((String)datePickerType) && datePickerType.startsWith("timescope")) {
            FilterVestDateUtils.getDateByScope(dateByYear, (List)datePickerContent, timeZoneInfo);
        }
    }

    public List<FilterBo> getFilterBoList(FormShowParameter formShowParameter, ReportManageConfigInfo reportManageConfigInfo) {
        List filterBoList = reportManageConfigInfo.getFilter();
        List<FilterBo> filterBos = this.getCustomFilter(formShowParameter);
        for (FilterBo filterBo : filterBos) {
            filterBoList.add(filterBo.getIndex(), filterBo);
        }
        return filterBoList;
    }

    public Map<String, Object> getFilterControl(FormShowParameter formShowParameter, ReportManageConfigInfo reportManageConfigInfo) {
        DisplaySchemeInfo displaySchemeInfo;
        List<FilterBo> filterBoList = this.getFilterBoList(formShowParameter, reportManageConfigInfo);
        if (!this.isReportPreview(formShowParameter) && ReportDisplayHelper.isShowDisplayScheme((DisplaySchemeInfo)(displaySchemeInfo = this.getReportManageConfigInfo(formShowParameter).getReportConfig().getDisplaySchemeInfo()))) {
            filterBoList.add(FilterBoUtils.getUserdispscmFilterBo());
        }
        filterBoList.sort(Comparator.comparingInt(FilterBo::getIndex));
        ReportCenterPublishService.setBaseDataEnum((FormShowParameter)formShowParameter, filterBoList);
        formShowParameter.setCustomParam(FILTER_DATA, (Object)SerializationUtils.toJsonString(filterBoList));
        String openFrom = (String)formShowParameter.getCustomParam("openFrom");
        return this.createFilterControl(filterBoList, openFrom);
    }

    private Map<String, Object> createFilterControl(List<FilterBo> filterBoList, String openFrom) {
        FlexPanelAp headAp = this.createDynamicPanel(filterBoList, false, openFrom);
        HashMap<String, Object> mapHead = new HashMap<String, Object>(16);
        mapHead.put("id", "filterflexpanelap");
        mapHead.put("items", headAp.createControl().get("items"));
        return mapHead;
    }

    private List<FilterBo> getCustomFilter(FormShowParameter formShowParameter) {
        Object customData = formShowParameter.getCustomParam("customData");
        if (customData != null) {
            return (List)customData;
        }
        return new ArrayList<FilterBo>();
    }

    public FlexPanelAp createDynamicPanel(List<FilterBo> filterBos, boolean isBind, String openFrom) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        for (FilterBo filterBo : filterBos) {
            if ("number".equals(filterBo.getFilterType())) {
                List<ControlAp<?>> numberAp = FieldApUtils.getNumberAp2(filterBo, "#FAFAFA");
                headPanelAp.getItems().addAll(numberAp);
            } else {
                FieldAp fieldAp = FieldApUtils.getFilterAp(filterBo, openFrom);
                headPanelAp.getItems().add(fieldAp);
            }
            if (!HRStringUtils.equals((String)filterBo.getFilterType(), (String)"adminorg")) continue;
            FieldAp checkBox = FieldApUtils.getContainSubAp(CONTAIN_SUB);
            headPanelAp.getItems().add(checkBox);
            if (isBind) {
                if (filterBo.getContainSub().equals("2")) {
                    this.plugin.getView().setVisible(Boolean.TRUE, new String[]{CONTAIN_SUB});
                    this.plugin.getView().setEnable(Boolean.valueOf(HRStringUtils.isNotEmpty((String)filterBo.getBdDefaultValue())), new String[]{CONTAIN_SUB});
                } else {
                    this.plugin.getView().setVisible(Boolean.FALSE, new String[]{CONTAIN_SUB});
                    this.plugin.getView().getModel().setValue(CONTAIN_SUB, (Object)filterBo.getContainSub().equals("0"));
                }
            }
            if (filterBo.getBaseDataMul() || !filterBo.getOrgLevel()) continue;
            FieldAp comboAp = FieldApUtils.getLastLevelAp(LAST_LEVEL);
            headPanelAp.getItems().add(comboAp);
        }
        return headPanelAp;
    }

    public void getFilterValue() {
        String data = (String)this.plugin.getView().getFormShowParameter().getCustomParam(FILTER_DATA);
        if (StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        List filterBoList = SerializationUtils.fromJsonStringToList((String)data, FilterBo.class);
        List<FilterValueBo> filterValueBoList = this.getFilterValueBoList(filterBoList);
        CustomControl customControl = (CustomControl)this.plugin.getControl("filtercustomcontrolap");
        customControl.setData(filterValueBoList);
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)16);
        map.put("type", "customValue");
        map.put("timestr", System.currentTimeMillis());
        map.put("filterValueBoList", filterValueBoList);
        this.invokeSchemeControl(map);
    }

    private List<FilterValueBo> getFilterValueBoList(List<FilterBo> filterBoList) {
        ArrayList filterValueBoList = Lists.newArrayListWithCapacity((int)filterBoList.size());
        block11: for (FilterBo filterBo : filterBoList) {
            Object value = this.dataModel.getValue(filterBo.getFieldAlias());
            if (!HRStringUtils.equals((String)filterBo.getBaseDataNum(), (String)"userdispscm") && filterBo.getCustomBo()) continue;
            String filterType = filterBo.getFilterType();
            FilterType filterTypeByValue = FilterType.getFilterTypeByValue((String)filterType);
            String str = "";
            switch (filterTypeByValue) {
                case BASE_DATA: 
                case HIS_BASE_DATA: 
                case ADMIN_ORG: {
                    if (value == null) continue block11;
                    str = this.getBaseDataName(filterBo, value);
                    break;
                }
                case STRING: {
                    if (value == null) continue block11;
                    if (!StringUtils.isNotEmpty((CharSequence)((String)value))) break;
                    str = (String)value;
                    break;
                }
                case DATE: {
                    if (HRStringUtils.equals((String)filterBo.getDateType(), (String)"1")) {
                        if (value == null) continue block11;
                        str = HRDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
                        break;
                    }
                    String vestDate = this.getPageCache(filterBo.getFieldAlias() + "_vestdate");
                    if (vestDate == null) continue block11;
                    try {
                        Map dateMap = (Map)HRJSONUtils.cast((String)vestDate, Map.class);
                        String datePickerType = (String)dateMap.get("datePickerType");
                        Object datePickerContent = dateMap.get("datePickerContent");
                        if (datePickerContent instanceof String && HRStringUtils.isEmpty((String)((String)datePickerContent)) || datePickerContent instanceof List && CollectionUtils.isEmpty((Collection)((List)datePickerContent))) continue block11;
                        if (HRStringUtils.equals((String)datePickerType, (String)"year") || HRStringUtils.equals((String)datePickerType, (String)"month") || HRStringUtils.equals((String)datePickerType, (String)"quarter")) {
                            str = (String)datePickerContent;
                            break;
                        }
                        if (!HRStringUtils.isNotEmpty((String)datePickerType) || !datePickerType.startsWith("timescope")) break;
                        List datePickerContentList = (List)datePickerContent;
                        str = (String)datePickerContentList.get(0) + "-" + (String)datePickerContentList.get(1);
                    }
                    catch (IOException e) {
                        LOGGER.error((Throwable)e);
                    }
                    break;
                }
                case ENUM: {
                    if (value == null || HRStringUtils.isEmpty((String)((String)value))) continue block11;
                    StringBuilder sb = new StringBuilder();
                    String[] split = ((String)value).split(",");
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
                    String fieldPath = filterBo.getFieldPath();
                    if (HRStringUtils.isNotEmpty((String)fieldPath) && fieldPath.contains("!")) {
                        for (String valueStr : list) {
                            if (HRStringUtils.equals((String)valueStr, (String)SplitDateTypeEnum.SN_QUARTER.getKey()) || HRStringUtils.equals((String)valueStr, (String)SplitDateTypeEnum.FN_QUARTER.getKey())) {
                                sb.append(QuarterTypeEnum.getEnum((String)valueStr)).append(",");
                                continue;
                            }
                            if (HRStringUtils.equals((String)valueStr, (String)SplitDateTypeEnum.SN_MONTH.getKey()) || HRStringUtils.equals((String)valueStr, (String)SplitDateTypeEnum.FN_MONTH.getKey())) {
                                sb.append(MonthTypeEnum.getEnum((String)valueStr)).append(",");
                                continue;
                            }
                            if (!HRStringUtils.equals((String)valueStr, (String)SplitDateTypeEnum.SN_DAY.getKey()) && !HRStringUtils.equals((String)valueStr, (String)SplitDateTypeEnum.FN_DAY.getKey())) continue;
                            sb.append(DayTypeEnum.getEnum((String)valueStr)).append(",");
                        }
                    } else if (filterBo.getGroupField()) {
                        ReportManageConfigInfo reportManageConfigInfo = this.getReportManageConfigInfo(this.plugin.getView().getFormShowParameter());
                        List groupFieldEnums = AnObjGroupFieldService.getInstance().getGroupFieldEnums(reportManageConfigInfo.getAssignObj(), filterBo.getFieldAlias());
                        for (String string : list) {
                            for (Object groupFieldEnum : groupFieldEnums) {
                                if (!HRStringUtils.equals((String)string, (String)((String)groupFieldEnum.get("number")))) continue;
                                sb.append(((LocaleString)groupFieldEnum.get("name")).getLocaleValue()).append(",");
                            }
                        }
                    } else if (!filterBoList.isEmpty() && null != filterBoList.get(0).getFieldId()) {
                        Long anObjId = AnalyseObjectService.getInstance().getAnObjId(Long.parseLong(filterBoList.get(0).getFieldId()));
                        AnObjEnumFieldHandler enumFieldHandler = new AnObjEnumFieldHandler(anObjId.longValue(), new MainEntityTypeUtil());
                        List enumItems = enumFieldHandler.getEnumItems(filterBo.getFieldNumber(), filterBo.getEntityNumber());
                        for (String valueStr2 : list) {
                            Object groupFieldEnum;
                            groupFieldEnum = enumItems.iterator();
                            while (groupFieldEnum.hasNext()) {
                                AnObjEnumFieldHandler.AnObjEnumItem enumItem = (AnObjEnumFieldHandler.AnObjEnumItem)groupFieldEnum.next();
                                if (!HRStringUtils.equals((String)valueStr2, (String)enumItem.getValue())) continue;
                                sb.append(enumItem.getName().getLocaleValue()).append(",");
                            }
                        }
                    }
                    if ((str = sb.toString()).length() <= 0) break;
                    str = str.substring(0, str.length() - 1);
                    break;
                }
                case NUMBER: {
                    String opt = (String)this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "opt");
                    if (!StringUtils.isNotEmpty((CharSequence)opt)) break;
                    if ("between".equals(opt)) {
                        BigDecimal endNumber;
                        BigDecimal beginNumber = (BigDecimal)this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "beginnumber");
                        if (beginNumber != null) {
                            beginNumber = beginNumber.setScale(2, RoundingMode.HALF_UP);
                        }
                        if ((endNumber = (BigDecimal)this.dataModel.getValue(filterBo.getFieldAlias() + "_" + "endnumber")) != null) {
                            endNumber = endNumber.setScale(2, RoundingMode.HALF_UP);
                        }
                        str = EnumOperatorEnum.getName((String)opt) + beginNumber + "~" + endNumber;
                        break;
                    }
                    if (value == null) break;
                    BigDecimal number = (BigDecimal)value;
                    str = EnumOperatorEnum.getName((String)opt) + number.setScale(2, RoundingMode.HALF_UP);
                    break;
                }
                case BOOLEAN: {
                    Boolean flag = (Boolean)value;
                    str = flag != false ? ResManager.loadKDString((String)"\u662f", (String)"ReportManageUtil_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ReportManageUtil_2", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case BASE_DATA_ENUM: {
                    String selectF7 = this.getPageCache(filterBo.getFieldAlias() + "_selectF7");
                    if (!HRStringUtils.isNotEmpty((String)selectF7)) break;
                    List list = SerializationUtils.fromJsonStringToList((String)selectF7, String.class);
                    list.remove("");
                    list.remove(null);
                    List esF7QueryResultList = filterBo.getEsF7QueryResultList();
                    if (list.size() <= 0 || CollectionUtils.isEmpty((Collection)esF7QueryResultList)) break;
                    List collect = esF7QueryResultList.stream().filter(esF7QueryResult -> ids.contains(String.valueOf(esF7QueryResult.getId()))).collect(Collectors.toList());
                    List nameList = collect.stream().map(esF7QueryResult -> esF7QueryResult.getName().getLocaleValue()).collect(Collectors.toList());
                    str = String.join((CharSequence)",", nameList);
                    break;
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)str)) continue;
            FilterValueBo filterValueBo = new FilterValueBo(filterBo.getFieldAlias(), filterBo.getFilterAlias(), str);
            filterValueBo.setTimeStr(String.valueOf(System.currentTimeMillis()));
            filterValueBoList.add(filterValueBo);
        }
        return filterValueBoList;
    }

    private String getBaseDataName(FilterBo filterBo, Object value) {
        if (filterBo.getBaseDataMul()) {
            MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)value;
            Set ids = mulBasedataDynamicObjectCollection.stream().map(row -> row.get("fbasedataid_id")).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(ids)) {
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(filterBo.getBaseDataNum());
                DynamicObject[] names = hrBaseServiceHelper.query("name", new QFilter[]{new QFilter("id", "in", ids)});
                List nameList = Arrays.stream(names).map(row -> row.getString("name")).collect(Collectors.toList());
                return String.join((CharSequence)",", nameList);
            }
        } else {
            return ((DynamicObject)value).getString("name");
        }
        return null;
    }
}

