/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.enums.ParamTypeEnum;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowAndColCfgInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleMapInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleRuleInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.opt.RowOrColClickOptInfo;
import kd.hr.hrptmc.formplugin.web.repdesign.util.DisplayNameUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.LocaleStringUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.TransformUtil;

public class FieldInfoUtil {
    public static FieldInfo recursiveTest(List<FieldInfo> fields, Predicate<FieldInfo> predicate) {
        if (CollectionUtils.isEmpty(fields)) {
            return null;
        }
        for (FieldInfo children : fields) {
            if (!"0".equals(children.getType()) && predicate.test(children)) {
                return children;
            }
            if (!CollectionUtils.isNotEmpty((Collection)children.getFields())) continue;
            FieldInfoUtil.recursiveTest(children.getFields(), predicate);
        }
        return null;
    }

    public static void recursive(List<FieldInfo> fields, Consumer<FieldInfo> consumer) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (FieldInfo children : fields) {
            if (!"0".equals(children.getType())) {
                consumer.accept(children);
            }
            if (!CollectionUtils.isNotEmpty((Collection)children.getFields())) continue;
            FieldInfoUtil.recursive(children.getFields(), consumer);
        }
    }

    public static Map<String, FieldInfo> getAllRowFieldMap(List<RowFieldInfo> rows) {
        HashMap allFieldMap = Maps.newHashMapWithExpectedSize((int)rows.size());
        if (CollectionUtils.isEmpty(rows)) {
            return allFieldMap;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            allFieldMap.put(rowFieldInfo.getGroupName().getNumberAlias(), rowFieldInfo.getGroupName());
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> allFieldMap.put(children.getNumberAlias(), children));
        }
        return allFieldMap;
    }

    public static List<String> getAllRowField(List<RowFieldInfo> rows) {
        ArrayList allFieldList = Lists.newArrayListWithCapacity((int)rows.size());
        if (CollectionUtils.isEmpty(rows)) {
            return allFieldList;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            allFieldList.add(rowFieldInfo.getGroupName().getNumberAlias());
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> allFieldList.add(children.getNumberAlias()));
        }
        return allFieldList;
    }

    public static List<FieldInfo> getAdvanceSortRowFieldList(List<RowFieldInfo> rows) {
        ArrayList allFieldList = Lists.newArrayListWithCapacity((int)rows.size());
        if (CollectionUtils.isEmpty(rows)) {
            return allFieldList;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            if (!"0".equals(rowFieldInfo.getGroupName().getType())) {
                allFieldList.add(rowFieldInfo.getGroupName());
            }
            if (rowFieldInfo.getMergeType().equals("1")) {
                FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> {
                    if (!("1".equals(children.getFieldSrc()) || children.getSplitDateSub() || children.getGroupField() || "0".equals(children.getType()))) {
                        allFieldList.add(children);
                    }
                });
                continue;
            }
            if (!rowFieldInfo.getMergeType().equals("2")) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> {
                if (!("1".equals(children.getFieldSrc()) || children.getSplitDateSub() || children.getGroupField() || "2".equals(children.getType()))) {
                    allFieldList.add(children);
                }
            });
        }
        return allFieldList;
    }

    public static List<String> getAllRowIndexFieldList(List<RowFieldInfo> rows) {
        ArrayList<String> allIndexField = new ArrayList<String>(rows.size());
        if (CollectionUtils.isEmpty(rows)) {
            return allIndexField;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            if (TransformUtil.isIndex(rowFieldInfo.getGroupName().getValueType())) {
                allIndexField.add(rowFieldInfo.getGroupName().getNumberAlias());
                continue;
            }
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> {
                if (TransformUtil.isIndex(children.getValueType())) {
                    allIndexField.add(children.getNumberAlias());
                }
            });
        }
        return allIndexField;
    }

    public static Map<String, String> getAllRowIndexFieldMap(List<RowFieldInfo> rows) {
        HashMap allIndexField = Maps.newHashMapWithExpectedSize((int)rows.size());
        if (CollectionUtils.isEmpty(rows)) {
            return allIndexField;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            if (TransformUtil.isIndex(rowFieldInfo.getGroupName().getValueType())) {
                allIndexField.put(rowFieldInfo.getGroupName().getNumber(), rowFieldInfo.getGroupName().getNumber());
                continue;
            }
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                if (TransformUtil.isIndex(fieldInfo.getValueType())) {
                    allIndexField.put(fieldInfo.getNumber(), rowFieldInfo.getGroupName().getNumber());
                }
            });
        }
        return allIndexField;
    }

    public static Map<String, FieldInfo> getAllColFieldMap(List<FieldInfo> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            return new HashMap<String, FieldInfo>(2);
        }
        return cols.stream().collect(Collectors.toMap(FieldInfo::getNumberAlias, fieldInfo -> fieldInfo));
    }

    public static List<FieldInfo> getAllRowCalcFields(List<RowFieldInfo> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return null;
        }
        ArrayList fieldInfoList = Lists.newArrayListWithCapacity((int)rows.size());
        for (RowFieldInfo rowFieldInfo : rows) {
            FieldInfo fieldInfo = rowFieldInfo.getGroupName();
            if (!"0".equals(fieldInfo.getType()) && "1".equals(fieldInfo.getFieldSrc())) {
                fieldInfoList.add(fieldInfo);
            }
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> {
                if ("1".equals(children.getFieldSrc())) {
                    fieldInfoList.add(children);
                }
            });
        }
        return fieldInfoList;
    }

    public static List<FieldInfo> getAllColCalcFields(List<FieldInfo> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            return null;
        }
        return cols.stream().filter(fieldInfo -> "1".equals(fieldInfo.getFieldSrc())).collect(Collectors.toList());
    }

    public static List<FieldInfo> getFieldInfos(List<String> numberAlias, List<RowFieldInfo> rows) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>(numberAlias.size());
        for (RowFieldInfo rowFieldInfo : rows) {
            if (numberAlias.contains(rowFieldInfo.getGroupName().getNumberAlias())) {
                fields.add(rowFieldInfo.getGroupName());
            }
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> {
                if (numberAlias.contains(children.getNumberAlias())) {
                    fields.add((FieldInfo)children);
                }
            });
        }
        return fields;
    }

    public static FieldInfo findField(String field, List<RowFieldInfo> rows) {
        for (RowFieldInfo row : rows) {
            FieldInfo fieldInfo;
            if (field.equals(row.getGroupName().getNumberAlias())) {
                return row.getGroupName();
            }
            if (!row._isMerge() || null == (fieldInfo = FieldInfoUtil.recursiveTest(row._getChildFields(), children -> field.equals(children.getNumberAlias())))) continue;
            return fieldInfo;
        }
        return null;
    }

    public static void handleRowFieldName(long workRptId, List<RowFieldInfo> rows, AnObjDetailInfo anObjDetail) {
        DynamicObject[] rowFieldDys = ReportManageService.getRowFields((long)workRptId);
        Map<String, LocaleString> displayNameMap = Arrays.stream(rowFieldDys).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> LocaleStringUtils.getLocaleString(dy.getLocaleString("displayname"))));
        Map<String, LocaleString> dfNameMap = anObjDetail.getDimensionList().stream().collect(Collectors.toMap(AnObjFieldInfo::getFieldId, AnObjFieldInfo::getFieldName, (x1, x2) -> x1));
        Map<String, LocaleString> idxNameMap = anObjDetail.getIndexList().stream().collect(Collectors.toMap(AnObjFieldInfo::getFieldAlias, AnObjFieldInfo::getFieldName));
        for (RowFieldInfo rowFieldInfo : rows) {
            FieldInfoUtil.updateDisplayName(displayNameMap, dfNameMap, idxNameMap, rowFieldInfo.getGroupName());
            if (rowFieldInfo._isMerge()) {
                FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> FieldInfoUtil.updateDisplayName(displayNameMap, dfNameMap, idxNameMap, fieldInfo));
            }
            if (!"1".equals(rowFieldInfo.getMergeType()) || null != rowFieldInfo._getChildFields() || rowFieldInfo._getOriFields() == null) continue;
            rowFieldInfo.setFields(new ArrayList(rowFieldInfo._getOriFields()));
            rowFieldInfo._setOriFields(null);
        }
    }

    private static void updateDisplayName(Map<String, LocaleString> displayNameMap, Map<String, LocaleString> dfNameMap, Map<String, LocaleString> idxNameMap, FieldInfo fieldInfo) {
        if (displayNameMap.containsKey(fieldInfo.getRowFieldId())) {
            fieldInfo.setDisplayName(displayNameMap.get(fieldInfo.getRowFieldId()));
        }
        if ("1".equals(fieldInfo.getType()) && dfNameMap.containsKey(fieldInfo.getFieldId())) {
            fieldInfo.setName(dfNameMap.get(fieldInfo.getFieldId()));
        } else if ("2".equals(fieldInfo.getType()) && idxNameMap.containsKey(fieldInfo.getNumber())) {
            fieldInfo.setName(idxNameMap.get(fieldInfo.getNumber()));
        }
        if (CollectionUtils.isNotEmpty((Collection)fieldInfo.getStyleMaps())) {
            List styleMapInfos = fieldInfo.getStyleMaps();
            for (ReportStyleMapInfo reportStyleMapInfo : styleMapInfos) {
                ReportStyleRuleInfo rule = reportStyleMapInfo.getR();
                if (!ParamTypeEnum.BASEDATA.getType().equals(rule.getPt()) && !ParamTypeEnum.ADMINORG.getType().equals(rule.getPt()) || !StringUtils.isNotEmpty((CharSequence)rule.getV())) continue;
                List ids = SerializationUtils.fromJsonStringToList((String)rule.getV(), String.class);
                String entityNumber = StringUtils.isNotEmpty((CharSequence)fieldInfo.getBaseDataNum()) ? fieldInfo.getBaseDataNum() : fieldInfo.getEntityNumber();
                rule.setDv(DisplayNameUtil.getNewestDisplayValue(ids, entityNumber));
            }
        }
    }

    public static void handleColFieldName(long rptManageId, List<FieldInfo> columns, AnObjDetailInfo anObjDetail) {
        DynamicObject[] colFieldDys = ReportManageService.getColFields((long)rptManageId);
        Map<String, LocaleString> displayNameMap = Arrays.stream(colFieldDys).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> LocaleStringUtils.getLocaleString(dy.getLocaleString("displayname"))));
        Map<String, LocaleString> dfNameMap = anObjDetail.getDimensionList().stream().collect(Collectors.toMap(AnObjFieldInfo::getFieldId, AnObjFieldInfo::getFieldName, (x1, x2) -> x1));
        for (FieldInfo fieldInfo : columns) {
            if (displayNameMap.containsKey(fieldInfo.getRowFieldId())) {
                fieldInfo.setDisplayName(displayNameMap.get(fieldInfo.getRowFieldId()));
            }
            if (!dfNameMap.containsKey(fieldInfo.getFieldId())) continue;
            fieldInfo.setName(dfNameMap.get(fieldInfo.getFieldId()));
        }
    }

    public static void updateRowFieldId(List<RowFieldInfo> newRows, List<RowFieldInfo> oldRows) {
        FieldInfoUtil.updateRowFieldId(newRows, FieldInfoUtil.getNumber2IdMap(oldRows));
    }

    private static void updateRowFieldId(List<RowFieldInfo> rowFieldInfos, Map<String, String> numberAlisa2RowIdMap) {
        for (RowFieldInfo rowFieldInfo : rowFieldInfos) {
            rowFieldInfo.getGroupName().setRowFieldId(numberAlisa2RowIdMap.get(rowFieldInfo.getGroupName().getNumberAlias()));
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> fieldInfo.setRowFieldId((String)numberAlisa2RowIdMap.get(fieldInfo.getNumberAlias())));
        }
    }

    private static Map<String, String> getNumber2IdMap(List<RowFieldInfo> rowFieldInfos) {
        HashMap<String, String> numberAlisa2RowIdMap = new HashMap<String, String>(16);
        for (RowFieldInfo rowFieldInfo : rowFieldInfos) {
            numberAlisa2RowIdMap.put(rowFieldInfo.getGroupName().getNumberAlias(), rowFieldInfo.getGroupName().getRowFieldId());
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> numberAlisa2RowIdMap.put(fieldInfo.getNumberAlias(), fieldInfo.getRowFieldId()));
        }
        return numberAlisa2RowIdMap;
    }

    public static void setStyleMap(List<RowFieldInfo> rows, Map<String, List<ReportStyleMapInfo>> fieldStyleMap) {
        for (RowFieldInfo rowFieldInfo : rows) {
            String numberAlias = rowFieldInfo.getGroupName().getNumberAlias();
            if (fieldStyleMap.containsKey(numberAlias)) {
                rowFieldInfo.getGroupName().setStyleMaps(fieldStyleMap.get(numberAlias));
            }
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                String fieldNumberAlias = fieldInfo.getNumberAlias();
                if (fieldStyleMap.containsKey(fieldNumberAlias)) {
                    fieldInfo.setStyleMaps((List)fieldStyleMap.get(fieldNumberAlias));
                }
            });
        }
    }

    private static Map<String, String> getIdMap(ReportHeadRowAndColCfgInfo oldHeadInfo) {
        HashMap<String, String> idMap = new HashMap<String, String>(16);
        for (RowFieldInfo rowFieldInfo : oldHeadInfo.getRows()) {
            idMap.put("row_" + rowFieldInfo.getGroupName().getNumberAlias(), rowFieldInfo.getGroupName().getRowFieldId());
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> idMap.put("row_" + fieldInfo.getNumberAlias(), fieldInfo.getRowFieldId()));
        }
        for (FieldInfo fieldInfo2 : oldHeadInfo.getColumns()) {
            idMap.put("col_" + fieldInfo2.getNumberAlias(), fieldInfo2.getRowFieldId());
        }
        return idMap;
    }

    private static void setId(ReportHeadRowAndColCfgInfo newHeadInfo, Map<String, String> idMap) {
        for (RowFieldInfo rowFieldInfo : newHeadInfo.getRows()) {
            if (StringUtils.isEmpty((CharSequence)rowFieldInfo.getGroupName().getRowFieldId()) && idMap.containsKey("row_" + rowFieldInfo.getGroupName().getNumberAlias())) {
                rowFieldInfo.getGroupName().setRowFieldId(idMap.get("row_" + rowFieldInfo.getGroupName().getNumberAlias()));
            }
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                if (StringUtils.isEmpty((CharSequence)fieldInfo.getRowFieldId()) && idMap.containsKey("row_" + fieldInfo.getNumberAlias())) {
                    fieldInfo.setRowFieldId((String)idMap.get("row_" + fieldInfo.getNumberAlias()));
                }
            });
        }
        for (FieldInfo fieldInfo2 : newHeadInfo.getColumns()) {
            if (!StringUtils.isEmpty((CharSequence)fieldInfo2.getRowFieldId()) || !idMap.containsKey("col_" + fieldInfo2.getNumberAlias())) continue;
            fieldInfo2.setRowFieldId(idMap.get("col_" + fieldInfo2.getNumberAlias()));
        }
    }

    public static void updateFieldId(ReportHeadRowAndColCfgInfo newHeadInfo, ReportHeadRowAndColCfgInfo oldHeadInfo) {
        FieldInfoUtil.setId(newHeadInfo, FieldInfoUtil.getIdMap(oldHeadInfo));
    }

    public static List<RowFieldInfo> splitField(RowFieldInfo rowFieldInfo) {
        ArrayList splitField = Lists.newArrayListWithCapacity((int)10);
        if ("0".equals(rowFieldInfo.getMergeType())) {
            splitField.add(rowFieldInfo);
            return splitField;
        }
        if ("1".equals(rowFieldInfo.getMergeType())) {
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), children -> {
                children.setMergeRef(false);
                splitField.add(new RowFieldInfo(children));
            });
        } else if ("2".equals(rowFieldInfo.getMergeType())) {
            for (FieldInfo fieldInfo : rowFieldInfo._getAllGns()) {
                fieldInfo.setMergeRef(false);
                splitField.add(new RowFieldInfo(fieldInfo));
            }
            for (FieldInfo fieldInfo : rowFieldInfo.getFields()) {
                fieldInfo.setMergeRef(false);
                splitField.add(new RowFieldInfo(fieldInfo));
            }
        }
        return splitField;
    }

    public static boolean hasIndexField(List<RowFieldInfo> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return false;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            if (TransformUtil.isIndex(rowFieldInfo.getGroupName().getValueType())) {
                return true;
            }
            if (!rowFieldInfo._isMerge() || null == FieldInfoUtil.recursiveTest(rowFieldInfo._getChildFields(), fieldInfo -> TransformUtil.isIndex(fieldInfo.getValueType()))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDimField(List<RowFieldInfo> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return false;
        }
        for (RowFieldInfo rowFieldInfo : rows) {
            if ("1".equals(rowFieldInfo.getGroupName().getType())) {
                return true;
            }
            if (!rowFieldInfo._isMerge() || null == FieldInfoUtil.recursiveTest(rowFieldInfo._getChildFields(), fieldInfo -> "1".equals(rowFieldInfo.getGroupName().getType()))) continue;
            return true;
        }
        return false;
    }

    public static String getNumberAlias(String fieldName) {
        if (fieldName.contains("\u03b2")) {
            fieldName = fieldName.substring(fieldName.indexOf("\u03b2") + 1);
        }
        return fieldName;
    }

    public static String getNumber(String fieldName) {
        if ((fieldName = FieldInfoUtil.getNumberAlias(fieldName)).contains("\u03b4")) {
            fieldName = fieldName.substring(0, fieldName.indexOf("\u03b4"));
        }
        return fieldName;
    }

    public static FieldInfo getFieldInfo(RowOrColClickOptInfo operateInfo, ReportHeadRowAndColCfgInfo rowAndColumnCfgInfo) {
        String fieldAlias = operateInfo.getFieldAlias();
        if ("row".equals(operateInfo.getOperateArea())) {
            for (RowFieldInfo rowFieldInfo : rowAndColumnCfgInfo.getRows()) {
                if (!fieldAlias.equals(rowFieldInfo.getGroupName().getNumberAlias())) continue;
                return rowFieldInfo.getGroupName();
            }
        } else {
            for (FieldInfo fieldInfo : rowAndColumnCfgInfo.getColumns()) {
                if (!fieldAlias.equals(fieldInfo.getNumberAlias())) continue;
                return fieldInfo;
            }
        }
        return null;
    }

    public static FieldInfo getFieldInfo(String operateArea, String fieldInfoStr) {
        if ("row".equals(operateArea)) {
            RowFieldInfo rowFieldInfo = (RowFieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, RowFieldInfo.class);
            return rowFieldInfo.getGroupName();
        }
        return (FieldInfo)SerializationUtils.fromJsonString((String)fieldInfoStr, FieldInfo.class);
    }

    public static void handleRowFieldAlign(List<RowFieldInfo> rows) {
        rows.forEach(row -> {
            if (row._isMerge()) {
                row.getGroupName().setAlign("center");
            }
            FieldInfoUtil.recursive(row._getChildFields(), fieldInfo -> {
                if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)fieldInfo.getFields())) {
                    fieldInfo.setAlign("center");
                }
            });
        });
    }
}

