/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kd.bos.ext.hr.util.query.DateTimeUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.TimeZoneInfo;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;

public class FilterVestDateUtils {
    private static final Log LOGGER = LogFactory.getLog(FilterVestDateUtils.class);

    public static void getDateByYear(Date[] dates, String str, TimeZoneInfo timeZoneInfo) {
        Calendar startCal = Calendar.getInstance();
        FilterVestDateUtils.setTime(startCal, 1, Integer.parseInt(str), 2, 0, 5, 1, 11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        startCal.set(14, 0);
        dates[0] = startCal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(dates[0]);
        FilterVestDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = DateTimeUtils.addDay((Date)DateTimeUtils.addYear((Date)endCal.getTime(), (int)1), (long)-1L);
        FilterVestDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void getDateByQuarter(Date[] dates, String str, TimeZoneInfo timeZoneInfo) {
        Calendar cal = Calendar.getInstance();
        FilterVestDateUtils.setTime(cal, 11, 0, 12, 0, 13, 0, 14, 0);
        cal.set(5, 1);
        String[] split = str.split("-");
        String year = split[0];
        String quarter = split[1];
        cal.set(1, Integer.parseInt(year));
        switch (quarter) {
            case "Q1": {
                cal.set(2, 0);
                break;
            }
            case "Q2": {
                cal.set(2, 3);
                break;
            }
            case "Q3": {
                cal.set(2, 6);
                break;
            }
            case "Q4": {
                cal.set(2, 9);
                break;
            }
        }
        dates[0] = cal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(dates[0]);
        FilterVestDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = DateTimeUtils.addDay((Date)DateTimeUtils.addMonth((Date)endCal.getTime(), (int)3), (long)-1L);
        FilterVestDateUtils.dateFormat(dates, timeZoneInfo);
    }

    public static void getDateByMonth(Date[] dates, String str, TimeZoneInfo timeZoneInfo) {
        String[] split = str.split("-");
        String year = split[0];
        String month = split[1];
        Calendar cal = Calendar.getInstance();
        FilterVestDateUtils.setTime(cal, 1, Integer.parseInt(year), 2, Integer.parseInt(month) - 1, 5, 1, 11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        dates[0] = cal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(dates[0]);
        FilterVestDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = DateTimeUtils.addDay((Date)DateTimeUtils.addMonth((Date)endCal.getTime(), (int)1), (long)-1L);
        FilterVestDateUtils.dateFormat(dates, timeZoneInfo);
    }

    private static void setTime(Calendar endCal, int hourOfDay, int i1, int minute, int i2, int second, int i3, int millisecond, int i4) {
        endCal.set(hourOfDay, i1);
        endCal.set(minute, i2);
        endCal.set(second, i3);
        endCal.set(millisecond, i4);
    }

    public static void getDateByScope(Date[] dates, List<String> str, TimeZoneInfo timeZoneInfo) {
        try {
            Date date;
            try {
                dates[0] = DateTimeUtils.parseDate((String)str.get(0), (String)"yyyy-MM-dd");
                date = DateTimeUtils.parseDate((String)str.get(1), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                String format = DateTimeFieldTimeZoneUtil.getUserDateFormat();
                dates[0] = DateTimeUtils.parseDate((String)str.get(0), (String)format);
                date = DateTimeUtils.parseDate((String)str.get(1), (String)format);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            FilterVestDateUtils.setTime(cal, 11, 23, 12, 59, 13, 59, 14, 999);
            dates[1] = cal.getTime();
            FilterVestDateUtils.dateFormat(dates, timeZoneInfo);
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public static void getDateByValue(Date value, Date[] dates, TimeZoneInfo timeZoneInfo) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(value);
        FilterVestDateUtils.setTime(startCal, 11, 0, 12, 0, 13, 0, 14, 0);
        dates[0] = startCal.getTime();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(value);
        FilterVestDateUtils.setTime(endCal, 11, 23, 12, 59, 13, 59, 14, 999);
        dates[1] = endCal.getTime();
        FilterVestDateUtils.dateFormat(dates, timeZoneInfo);
    }

    private static void dateFormat(Date[] dates, TimeZoneInfo timeZoneInfo) {
        try {
            if (null != timeZoneInfo && 1 == timeZoneInfo.getTimeZoneTransType()) {
                String format = DateTimeFieldTimeZoneUtil.getUserDateTimeFormat();
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneInfo.getTimeZone());
                dates[0] = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)dates[0], (String)format), (String)format, (TimeZone)timeZone);
                dates[1] = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)dates[1], (String)format), (String)format, (TimeZone)timeZone);
            }
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
    }
}

