/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.utils.IDStringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repdesign.ReportStyleRuleService;
import kd.hr.hrptmc.business.repdesign.info.DataFormatInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleMapInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportStyleRuleInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.formplugin.web.repdesign.subtotal.ReportSubTotalHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManageUtil;

public class ReportBodyUtils
implements ReportManageConstants {
    private static final Log log = LogFactory.getLog(ReportBodyUtils.class);
    private static final String CHILDREN = "children";
    private static final String ADMINORGID = "adminOrgId";
    private static final String BEFORE_DATA_FORMAT = "#df";
    private static final Map<String, RoundingMode> ROUNDING_MAP = Maps.newHashMapWithExpectedSize((int)4);

    public static List<ReportBodyRowInfo> getBody(ReportResult reportResult, ReportQueryParamInfo reportQueryParamInfo) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        List<Map<String, Object>> body = new ArrayList<Map<String, Object>>(16);
        RowMeta rowMeta = reportResult.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        List calResultList = reportResult.getCalResultList();
        if (CollectionUtils.isNotEmpty((Collection)calResultList)) {
            log.info("resultSize:{}", (Object)calResultList.size());
        }
        for (CalResult calResult : calResultList) {
            Row row = calResult.getRowData();
            HashMap<String, Object> resultMap = new HashMap<String, Object>(fieldNames.length);
            for (String fieldName : fieldNames) {
                resultMap.put(fieldName, row.get(fieldName));
            }
            body.add(resultMap);
        }
        ReportBodyUtils.formatBody(reportManageConfigInfo, body, rowMeta);
        body = ReportSubTotalHandler.handleSubTotal(reportQueryParamInfo, body, rowMeta);
        return ReportBodyUtils.bodyMap2Info(body, reportQueryParamInfo);
    }

    public static void formatBody(ReportManageConfigInfo reportManageConfigInfo, List<Map<String, Object>> body, RowMeta rowMeta) {
        if (CollectionUtils.isEmpty(body) || CollectionUtils.isEmpty((Collection)reportManageConfigInfo.getRows())) {
            return;
        }
        for (RowFieldInfo rowFieldInfo : reportManageConfigInfo.getRows()) {
            if ("2".equals(rowFieldInfo.getGroupName().getType())) {
                ReportBodyUtils.formatRows(rowFieldInfo.getGroupName(), body, rowMeta);
            }
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> {
                if ("2".equals(fieldInfo.getType())) {
                    ReportBodyUtils.formatRows(fieldInfo, body, rowMeta);
                }
            });
        }
    }

    private static void formatRows(FieldInfo fieldInfo, List<Map<String, Object>> body, RowMeta rowMate) {
        String numberAlias = fieldInfo.getNumberAlias();
        DataFormatInfo dataFormatInfo = fieldInfo.getDataFormat();
        for (Map<String, Object> rowMap : body) {
            List keys = rowMap.keySet().stream().filter(key -> numberAlias.equals(FieldInfoUtil.getNumberAlias(key)) && !ReportManageUtil.isExtField(key)).collect(Collectors.toList());
            for (String key2 : keys) {
                ReportBodyUtils.formatRows(dataFormatInfo, rowMap, key2, rowMate);
            }
            if (null == rowMap.get(CHILDREN)) continue;
            ReportBodyUtils.formatRows(fieldInfo, (List)rowMap.get(CHILDREN), rowMate);
        }
    }

    private static void formatRows(DataFormatInfo dataFormatInfo, Map<String, Object> rowMap, String numberAlias, RowMeta rowMate) {
        Object value;
        if (null == dataFormatInfo) {
            DataType dataType = rowMate.getDataType(rowMate.getFieldIndex(numberAlias));
            Object value2 = rowMap.get(numberAlias);
            if ("--".equals(value2)) {
                return;
            }
            if (DataType.LongType.equals((Object)dataType) || DataType.IntegerType.equals((Object)dataType) || DataType.BigDecimalType.equals((Object)dataType)) {
                if (value2 == null) {
                    value2 = 0;
                }
                rowMap.put(numberAlias, new BigDecimal(String.valueOf(value2)).setScale(0, RoundingMode.HALF_UP).toPlainString());
                rowMap.put(numberAlias + BEFORE_DATA_FORMAT, value2);
            }
            return;
        }
        if (rowMap.containsKey(numberAlias + BEFORE_DATA_FORMAT)) {
            value = rowMap.get(numberAlias + BEFORE_DATA_FORMAT);
        } else {
            value = rowMap.get(numberAlias);
            rowMap.put(numberAlias + BEFORE_DATA_FORMAT, value);
        }
        if ("--".equals(value)) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)value) || BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
            if ("2".equals(dataFormatInfo.getNullRule())) {
                value = 0;
            } else {
                rowMap.put(numberAlias, null);
                return;
            }
        }
        BigDecimal temp = new BigDecimal(value.toString());
        if ("2".equals(dataFormatInfo.getDisplayMode())) {
            temp = temp.multiply(new BigDecimal(100)).setScale(dataFormatInfo.getDecimalDigits(), ROUNDING_MAP.get(dataFormatInfo.getRoundMethod()));
            rowMap.put(numberAlias, temp.toPlainString() + "%");
        } else {
            temp = temp.setScale(dataFormatInfo.getDecimalDigits(), ROUNDING_MAP.get(dataFormatInfo.getRoundMethod()));
            rowMap.put(numberAlias, temp.toPlainString());
        }
    }

    public static List<ReportBodyRowInfo> getTreeBody(ReportResult reportResult, ReportQueryParamInfo reportQueryParamInfo) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        List<Map<String, Object>> body = new ArrayList<Map<String, Object>>(10);
        RowMeta rowMeta = reportResult.getRowMeta();
        String[] fieldNames = reportResult.getRowMeta().getFieldNames();
        List calResultList = reportResult.getCalResultList();
        if (CollectionUtils.isNotEmpty((Collection)calResultList)) {
            log.info("resultSize:{}", (Object)calResultList.size());
        }
        for (int i = 0; i < calResultList.size(); ++i) {
            CalResult calResult = (CalResult)calResultList.get(i);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(fieldNames.length);
            if (calResult == null) {
                body.add(resultMap);
                continue;
            }
            Row row = calResult.getRowData();
            for (String fieldName : fieldNames) {
                resultMap.put(fieldName, row.get(fieldName));
            }
            resultMap.put("id", String.valueOf(i));
            if (calResult.getOrgId() != null && calResult.getOrgId() != 0L) {
                resultMap.put(ADMINORGID, calResult.getOrgId().toString());
            }
            if (CollectionUtils.isNotEmpty((Collection)calResult.getChildResultList())) {
                resultMap.put(CHILDREN, ReportBodyUtils.getTreeChildren(calResult.getChildResultList(), fieldNames, String.valueOf(i)));
            }
            body.add(resultMap);
        }
        ReportBodyUtils.formatBody(reportManageConfigInfo, body, rowMeta);
        body = ReportSubTotalHandler.handleSubTotal(reportQueryParamInfo, body, rowMeta);
        return ReportBodyUtils.bodyMap2Info(body, reportQueryParamInfo);
    }

    public static List<ReportBodyRowInfo> bodyMap2Info(List<Map<String, Object>> body, ReportQueryParamInfo reportQueryParamInfo) {
        Map styleMap = reportQueryParamInfo.getStyleMap();
        ArrayList<ReportBodyRowInfo> bodyRowInfos = new ArrayList<ReportBodyRowInfo>(body.size());
        for (Map<String, Object> row : body) {
            ReportBodyRowInfo reportBodyRowInfo = new ReportBodyRowInfo();
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                String idKey;
                ReportBodyCellInfo cellInfo;
                String key = entry.getKey();
                Object val = entry.getValue();
                if (ReportManageUtil.isExtField(key)) continue;
                if (CHILDREN.equals(key) && val instanceof List) {
                    cellInfo = new ReportBodyCellInfo();
                    cellInfo.setK(key);
                    cellInfo.setV(ReportBodyUtils.bodyMap2Info((List)val, reportQueryParamInfo));
                    reportBodyRowInfo.addCell(cellInfo);
                    continue;
                }
                cellInfo = new ReportBodyCellInfo();
                cellInfo.setK(key);
                cellInfo.setV(val == null ? "" : val);
                String keyNumber = FieldInfoUtil.getNumber(key);
                if ((keyNumber.endsWith(".name") || keyNumber.endsWith(".number")) && row.containsKey(idKey = keyNumber.substring(0, keyNumber.lastIndexOf(".") + 1) + "id") && null != row.get(idKey)) {
                    cellInfo.setId(String.valueOf(row.get(idKey)));
                }
                if (key.contains("\u03b8") || row.containsKey("kingdeeTotalMark")) {
                    cellInfo.setS("kingdeeTotalMark");
                } else if (key.contains("\u03b7") || row.containsKey("kingdeeSubtotalMark")) {
                    if (row.containsKey("kingdeeSubtotalField")) {
                        List mergeField = (List)row.get("kingdeeSubtotalField");
                        if (!mergeField.contains(key)) {
                            cellInfo.setS("kingdeeSubtotalMark");
                        }
                    } else {
                        cellInfo.setS("kingdeeSubtotalMark");
                    }
                } else {
                    String keyNumberAlias = FieldInfoUtil.getNumberAlias(key);
                    if (null != styleMap && styleMap.containsKey(keyNumberAlias) && CollectionUtils.isNotEmpty((Collection)((Collection)styleMap.get(keyNumberAlias)))) {
                        Object rv = StringUtils.isNotEmpty((CharSequence)cellInfo.getId()) ? cellInfo.getId() : cellInfo.getV();
                        cellInfo.setS(ReportBodyUtils.getStyle(rv, styleMap, keyNumberAlias));
                    }
                }
                reportBodyRowInfo.addCell(cellInfo);
            }
            bodyRowInfos.add(reportBodyRowInfo);
        }
        return bodyRowInfos;
    }

    public static String getStyle(Object val, Map<String, List<ReportStyleMapInfo>> styleMap, String numberAlias) {
        List<ReportStyleMapInfo> styleLists = styleMap.get(numberAlias);
        String sk = "";
        if (styleLists == null) {
            return sk;
        }
        SplitDateTypeEnum splitDateTypeEnum = null;
        if (numberAlias.contains("!")) {
            splitDateTypeEnum = SplitDateTypeEnum.getEnum((String)numberAlias.substring(numberAlias.indexOf("!") + 1));
        }
        for (ReportStyleMapInfo reportStyleMapInfo : styleLists) {
            if (!ReportStyleRuleService.matchRule((Object)val, (ReportStyleRuleInfo)reportStyleMapInfo.getR(), (SplitDateTypeEnum)splitDateTypeEnum)) continue;
            sk = reportStyleMapInfo.getK();
        }
        return sk;
    }

    public static List<Map<String, Object>> getTreeChildren(List<CalResult> calResultList, String[] fieldNames, String parentId) {
        ArrayList childrenList = Lists.newArrayListWithCapacity((int)calResultList.size());
        if (fieldNames != null) {
            for (int i = 0; i < calResultList.size(); ++i) {
                CalResult calResult = calResultList.get(i);
                HashMap<String, Object> resultMap = new HashMap<String, Object>(fieldNames.length);
                if (calResult == null) {
                    childrenList.add(resultMap);
                    continue;
                }
                Row row = calResult.getRowData();
                for (String fieldName : fieldNames) {
                    resultMap.put(fieldName, row.get(fieldName));
                }
                if (IDStringUtils.idNotEmpty((Long)calResult.getOrgId())) {
                    resultMap.put(ADMINORGID, calResult.getOrgId().toString());
                }
                resultMap.put("id", parentId + "-" + i);
                if (CollectionUtils.isNotEmpty((Collection)calResult.getChildResultList())) {
                    resultMap.put(CHILDREN, ReportBodyUtils.getTreeChildren(calResult.getChildResultList(), fieldNames, parentId + "-" + i));
                }
                childrenList.add(resultMap);
            }
        }
        return childrenList;
    }

    static {
        ROUNDING_MAP.put("roundup", RoundingMode.UP);
        ROUNDING_MAP.put("rounddown", RoundingMode.DOWN);
        ROUNDING_MAP.put("rounding", RoundingMode.HALF_UP);
    }
}

