/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.ValueMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.tracker.HRQueryLog;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.HRFilterUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnObjDataExtractService;
import kd.hr.hrptmc.business.anobj.AnObjPermRuleService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectPivotService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.center.query.EsQueryConverter;
import kd.hr.hrptmc.business.center.utils.ReportCenterUtil;
import kd.hr.hrptmc.business.common.DateTimeFieldTimeZoneUtil;
import kd.hr.hrptmc.business.datastore.metadata.util.RptDataExtractQueryConverter;
import kd.hr.hrptmc.business.repcalculate.CalculateContext;
import kd.hr.hrptmc.business.repcalculate.RepCalculateService;
import kd.hr.hrptmc.business.repcalculate.RepQueryCacheService;
import kd.hr.hrptmc.business.repcalculate.chart.RptChartQueryAdapterFactory;
import kd.hr.hrptmc.business.repcalculate.chart.adapter.AbstractRptChartQueryAdapter;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ColumnSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.model.RepQueryConfigBo;
import kd.hr.hrptmc.business.repcalculate.model.ReportCalculateInfo;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportRow;
import kd.hr.hrptmc.business.repcalculate.model.RowSummaryInfo;
import kd.hr.hrptmc.business.repcalculate.org.helper.AdminOrgCalHelper;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.ReportStyleRuleService;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;
import kd.hr.hrptmc.business.repdesign.info.AdvanceSortInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.AnObjFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.DrillingInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.MergeInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyCellInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportBodyRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportHeadRowInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.TransposeConfigInfo;
import kd.hr.hrptmc.business.repdesign.jump.ReportJumpConfigService;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.dataextract.AnObjExtractConfigBo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;
import kd.hr.hrptmc.common.model.repdesign.total.ReportTotalColConfigBo;
import kd.hr.hrptmc.formplugin.web.repdesign.subtotal.ReportSubTotalHandler;
import kd.hr.hrptmc.formplugin.web.repdesign.util.DrillingUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportBodyUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportHeadUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManageUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SummaryAlgorithmUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.TransformUtil;
import kd.hr.hrptmc.formplugin.web.util.AnObjPivotForReportUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ReportQueryUtil
implements ReportManageConstants {
    private static final Log log = LogFactory.getLog(ReportManageUtil.class);

    public static ReportQueryParamInfo getReportQueryParamInfo(ReportManageConfigInfo reportManageConfigInfo, int start, int limit, String pageId) {
        ReportQueryParamInfo reportQueryParamInfo = new ReportQueryParamInfo();
        reportQueryParamInfo.setAlgoX(true);
        reportQueryParamInfo.setReportManageConfigInfo(reportManageConfigInfo);
        reportQueryParamInfo.setStart(start);
        reportQueryParamInfo.setLimit(limit);
        reportQueryParamInfo.setPageId(pageId);
        reportQueryParamInfo.setFromCache(false);
        String type = reportQueryParamInfo.getReportManageConfigInfo().getReportConfig().getType();
        if (!HRStringUtils.equals((String)type, (String)"0") && !HRStringUtils.equals((String)type, (String)"1")) {
            reportQueryParamInfo.setChartType(type);
        }
        List filterBos = reportManageConfigInfo.getFilter();
        for (FilterBo filterBo : filterBos) {
            if (!"adminorg".equals(filterBo.getFilterType())) continue;
            AdminOrgSummaryInfo adminOrgSummaryInfo = new AdminOrgSummaryInfo();
            adminOrgSummaryInfo.setAdminOrgFieldAlias(filterBo.getFieldAlias());
            adminOrgSummaryInfo.setAdminOrgFieldFullPath(filterBo.getFieldPath());
            adminOrgSummaryInfo.setIncludeSubOrg("0".equals(filterBo.getContainSub()));
            adminOrgSummaryInfo.setTreeShow(!filterBo.getBaseDataMul());
            adminOrgSummaryInfo.setDate(new Date());
            reportQueryParamInfo.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
        }
        return reportQueryParamInfo;
    }

    private static List<QFilter> fromSerializedQFilter(List<String> qFilters) {
        return qFilters.stream().map(qFilter -> QFilter.fromSerializedString((String)qFilter)).collect(Collectors.toList());
    }

    private static ReportQueryParamInfo copyReportQueryParamInfo(ReportQueryParamInfo reportQueryParamInfo) {
        List oriWhereQFilter = reportQueryParamInfo.getWhereQFilter();
        List<Object> whereQFilters = Lists.newArrayListWithCapacity((int)10);
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)oriWhereQFilter)) {
            whereQFilters = oriWhereQFilter.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
            oriWhereQFilter.clear();
        }
        List oriOnQFilter = reportQueryParamInfo.getOnQFilter();
        List<Object> onQFilters = Lists.newArrayListWithCapacity((int)10);
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)oriOnQFilter)) {
            onQFilters = oriOnQFilter.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
            oriOnQFilter.clear();
        }
        List oriPreIdxQFilter = reportQueryParamInfo.getPreIdxQFilter();
        List<Object> preIdxQFilters = Lists.newArrayListWithCapacity((int)10);
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)oriPreIdxQFilter)) {
            preIdxQFilters = oriPreIdxQFilter.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
            oriPreIdxQFilter.clear();
        }
        ReportQueryParamInfo copyInfo = (ReportQueryParamInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)reportQueryParamInfo), ReportQueryParamInfo.class);
        copyInfo.setWhereQFilter(ReportQueryUtil.fromSerializedQFilter(whereQFilters));
        copyInfo.setOnQFilter(ReportQueryUtil.fromSerializedQFilter(onQFilters));
        copyInfo.setPreIdxQFilter(ReportQueryUtil.fromSerializedQFilter(preIdxQFilters));
        reportQueryParamInfo.setWhereQFilter(ReportQueryUtil.fromSerializedQFilter(whereQFilters));
        reportQueryParamInfo.setOnQFilter(ReportQueryUtil.fromSerializedQFilter(onQFilters));
        reportQueryParamInfo.setPreIdxQFilter(ReportQueryUtil.fromSerializedQFilter(preIdxQFilters));
        return copyInfo;
    }

    public static ReportInfo getReportInfo(ReportQueryParamInfo rptQueryParamInfo) {
        ReportResult reportResult;
        ReportInfo reportInfo = new ReportInfo();
        if (rptQueryParamInfo == null) {
            return reportInfo;
        }
        ReportQueryParamInfo reportQueryParamInfo = ReportQueryUtil.copyReportQueryParamInfo(rptQueryParamInfo);
        String reportType = reportQueryParamInfo.getReportManageConfigInfo().getReportConfig().getType();
        AbstractRptChartQueryAdapter chartQueryAdapter = RptChartQueryAdapterFactory.getChartQueryAdapter((String)reportType);
        if (chartQueryAdapter != null) {
            chartQueryAdapter.assembleReportField(reportQueryParamInfo);
        }
        HRQueryLog.initTrackConfig((long)reportQueryParamInfo.getReportManageConfigInfo().getId());
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        ReportQueryUtil.handleUserReportManageConfigInfo(reportManageConfigInfo, reportQueryParamInfo.getUserDispScmId(), rptQueryParamInfo.getPageId());
        if (!reportManageConfigInfo.isPublishQuery()) {
            String anObjId = reportQueryParamInfo.getReportManageConfigInfo().getAssignObj().getAnObj().getId();
            List anObjPermQFilters = AnObjPermRuleService.getInstance().getPermQFiltersForReportConfig(Long.parseLong(anObjId));
            reportQueryParamInfo.getWhereQFilter().addAll(anObjPermQFilters);
        }
        log.info("reportConfig:{}", (Object)SerializationUtils.toJsonString((Object)reportManageConfigInfo.getReportConfig()));
        log.info("rows:{}", (Object)SerializationUtils.toJsonString((Object)reportManageConfigInfo.getRows()));
        log.info("columns:{}", (Object)SerializationUtils.toJsonString((Object)reportManageConfigInfo.getColumns()));
        log.info("dataFilter:{}", (Object)SerializationUtils.toJsonString((Object)reportManageConfigInfo.getDataFilter()));
        log.info("dimMaps:{}", (Object)SerializationUtils.toJsonString((Object)reportManageConfigInfo.getCurWorkRpt().getDimMaps()));
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)reportQueryParamInfo.getWhereQFilter())) {
            log.info("whereQFilterList:{}", (Object)reportQueryParamInfo.getWhereQFilter().toString());
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)reportQueryParamInfo.getOnQFilter())) {
            log.info("onQFilterList:{}", (Object)reportQueryParamInfo.getOnQFilter().toString());
        }
        log.info("adminOrgSummaryInfo:{}", (Object)reportQueryParamInfo.getAdminOrgSummaryInfo());
        log.info("start:{}", (Object)reportQueryParamInfo.getStart());
        log.info("limit:{}", (Object)reportQueryParamInfo.getLimit());
        boolean isSubTotal = ReportSubTotalHandler.getIsSubTotal(reportManageConfigInfo);
        if (isSubTotal) {
            reportQueryParamInfo.setEsLimit(reportQueryParamInfo.getLimit());
            reportQueryParamInfo.setLimit(reportQueryParamInfo.getLimit() + 1);
        }
        if (null == (reportResult = "0".equals(reportManageConfigInfo.getReportConfig().getType()) ? ReportQueryUtil.queryData4Summary(reportQueryParamInfo) : ReportQueryUtil.queryData4Detail(reportQueryParamInfo))) {
            return reportInfo;
        }
        int reportSize = reportResult.getCalResultList().size();
        reportInfo.setSize(reportSize);
        log.info("reportSize:{}", (Object)reportSize);
        reportInfo.setHasNextPage(isSubTotal && reportSize == reportQueryParamInfo.getLimit());
        String[] fieldNames = reportResult.getRowMeta().getFieldNames();
        log.info("fieldNames:{}", Arrays.asList(fieldNames));
        HRQueryLog.info((String)"fieldNames:{}", Arrays.asList(fieldNames));
        List<ReportHeadRowInfo> headList = ReportHeadUtils.getHead(reportQueryParamInfo, fieldNames);
        List<ReportBodyRowInfo> body = ReportQueryUtil.isTreeShow(reportManageConfigInfo) ? ReportBodyUtils.getTreeBody(reportResult, reportQueryParamInfo) : ReportBodyUtils.getBody(reportResult, reportQueryParamInfo);
        reportInfo.setHead(new ReportHeadInfo(headList, reportManageConfigInfo.getReportConfig().getHs()));
        log.info("reportInfo.getHead:{}", (Object)SerializationUtils.toJsonString((Object)reportInfo.getHead()));
        reportInfo.setBody(body);
        log.info("body.size:{}", (Object)body.size());
        ReportJumpConfigService.getInstance().setTableHeadHyperLink(reportManageConfigInfo.getReportConfig(), reportInfo);
        if (chartQueryAdapter != null) {
            reportQueryParamInfo.getReportManageConfigInfo().getReportConfig().setType(reportType);
            chartQueryAdapter.adaptChartData(reportQueryParamInfo, reportInfo);
        }
        reportInfo.setObjSortValueMap(reportQueryParamInfo.getObjSortValueMap());
        reportInfo.setAfterKeyMap(reportQueryParamInfo.getAfterKeyMap());
        return reportInfo;
    }

    private static boolean isTreeShow(ReportManageConfigInfo reportManageConfigInfo) {
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)reportManageConfigInfo.getRows())) {
            RowFieldInfo rowFieldInfo = (RowFieldInfo)reportManageConfigInfo.getRows().get(0);
            DrillingInfo drillingInfo = reportManageConfigInfo.getReportConfig().getDrillingInfo();
            if (null != drillingInfo && null != drillingInfo.getReplaceMap() && !drillingInfo.getReplaceMap().isEmpty() && drillingInfo.getReplaceMap().containsKey(rowFieldInfo.getGroupName().getNumberAlias())) {
                return false;
            }
            return "tree".equals(rowFieldInfo.getGroupName().getDisplayMode());
        }
        return false;
    }

    public static List<Map<String, Object>> getReportTreeChildrenInfo(ReportQueryParamInfo reportQueryParamInfo, String parentId) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        log.info("reportManageConfigInfo:{}", (Object)SerializationUtils.toJsonString((Object)reportManageConfigInfo));
        log.info("adminOrgSummaryInfo:{}", (Object)SerializationUtils.toJsonString((Object)reportQueryParamInfo.getAdminOrgSummaryInfo()));
        if (!"0".equals(reportManageConfigInfo.getReportConfig().getType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u6682\u4e0d\u652f\u6301\u6811\u5f62\u5c55\u793a", (String)"", (String)"", (Object[])new Object[0]));
        }
        reportQueryParamInfo.setQueryCache(true);
        reportQueryParamInfo.setStart(-1);
        reportQueryParamInfo.setLimit(-1);
        reportQueryParamInfo.setFromCache(false);
        ReportResult reportResult = ReportQueryUtil.queryData4Summary(reportQueryParamInfo);
        if (reportResult != null) {
            CalResult parentResult;
            List childResultList;
            RowMeta rowMeta = reportResult.getRowMeta();
            List calResultList = reportResult.getCalResultList();
            if (calResultList != null && !calResultList.isEmpty() && (childResultList = (parentResult = (CalResult)calResultList.get(0)).getChildResultList()) != null && !childResultList.isEmpty()) {
                List<Map<String, Object>> treeChildren = ReportBodyUtils.getTreeChildren(childResultList, rowMeta.getFieldNames(), parentId);
                ReportBodyUtils.formatBody(reportManageConfigInfo, treeChildren, rowMeta);
                return treeChildren;
            }
        }
        return null;
    }

    private static void setTotalAndTotalRow(ReportInfo reportInfo, DataSet dataSet, ReportQueryParamInfo reportQueryParamInfo) {
        try (AlgoContext ignored = Algo.newContext();){
            Iterator iterator = dataSet.iterator();
            ArrayList<Map<String, Object>> body = new ArrayList<Map<String, Object>>();
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            log.info("fieldNames:{}", Arrays.asList(fieldNames));
            if (dataSet.isEmpty()) {
                ReportQueryUtil.buildTotalBody(reportInfo, body, fieldNames, (Row)new ReportRow(dataSet.getRowMeta()));
            } else {
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    ReportQueryUtil.buildTotalBody(reportInfo, body, fieldNames, row);
                }
            }
            ((Map)body.get(0)).put("kingdeeTotalMark", "true");
            ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
            ReportBodyUtils.formatBody(reportManageConfigInfo, body, dataSet.getRowMeta());
            List<ReportBodyRowInfo> newBody = ReportBodyUtils.bodyMap2Info(body, reportQueryParamInfo);
            Set<String> nonAggIndexAlias = ReportQueryUtil.getNonAggIndexAlias(reportManageConfigInfo);
            Map<String, String> indexAlgorithmList2Map = SummaryAlgorithmUtil.indexAlgorithmList2Map(reportManageConfigInfo.getReportConfig().getIndexAlgorithmList());
            Map<String, FieldInfo> allRowFieldMap = FieldInfoUtil.getAllRowFieldMap(reportManageConfigInfo.getRows());
            for (ReportBodyRowInfo reportBodyRowInfo : newBody) {
                List rowInfoR = reportBodyRowInfo.getR();
                for (ReportBodyCellInfo reportBodyCellInfo : rowInfoR) {
                    String function;
                    FieldInfo fieldInfo;
                    String key = reportBodyCellInfo.getK();
                    if (key.contains("\u03b2")) {
                        key = key.split("\u03b2")[1];
                    }
                    if (key.contains("\u03b1")) {
                        key = key.split("\u03b1")[0];
                    }
                    if ((fieldInfo = allRowFieldMap.get(key)) == null || !"2".equals(fieldInfo.getType()) || !nonAggIndexAlias.contains(key) || !HRStringUtils.isEmpty((String)(function = indexAlgorithmList2Map.get(key))) && !"auto".equals(function)) continue;
                    reportBodyCellInfo.setV((Object)"--");
                }
            }
            reportInfo.setTotalRow(newBody);
        }
    }

    private static void buildTotalBody(ReportInfo reportInfo, List<Map<String, Object>> body, String[] fieldNames, Row row) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(fieldNames.length);
        for (String fieldName : fieldNames) {
            Object value = row.get(fieldName);
            if ("REPORT_COUNT_FIELD".equals(fieldName)) {
                if (value == null) {
                    reportInfo.setTotal(Long.valueOf(0L));
                    continue;
                }
                reportInfo.setTotal(Long.valueOf(Long.parseLong(String.valueOf(value))));
                continue;
            }
            resultMap.put(fieldName, value);
        }
        body.add(resultMap);
    }

    public static ReportResult queryData4Summary(ReportQueryParamInfo reportQueryParamInfo) {
        CalculateContext globalContext;
        boolean isTreeShow;
        RepCalculateService repCalculateService = ReportQueryUtil.getRepCalculateService(reportQueryParamInfo);
        if (repCalculateService == null) {
            return null;
        }
        ReportCalculateInfo calculateInfo = repCalculateService.getCalculateInfo();
        ReportResult reportResult = null;
        calculateInfo.getCostTimeHelper().nestedStart();
        AdminOrgSummaryInfo adminOrgSummaryInfo = repCalculateService.getCalculateInfo().getAdminOrgSummaryInfo();
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        boolean bl = isTreeShow = adminOrgSummaryInfo != null && adminOrgSummaryInfo.getTreeShow();
        if (reportQueryParamInfo.getQueryCache() && HRStringUtils.isNotEmpty((String)reportQueryParamInfo.getPageId()) && isTreeShow) {
            try (DLock lock = DLock.create((String)("admin_org_tree_data_lock_prefix_" + reportQueryParamInfo.getPageId()));){
                if (lock.tryLock(3000L)) {
                    reportResult = AdminOrgCalHelper.getCacheCalResult((String)reportQueryParamInfo.getPageId(), (AdminOrgSummaryInfo)adminOrgSummaryInfo);
                }
                adminOrgSummaryInfo.setInsertCache(false);
            }
        }
        if (reportResult == null) {
            int start = reportQueryParamInfo.getStart();
            int limit = reportQueryParamInfo.getLimit();
            if (isTreeShow) {
                start = -1;
                limit = -1;
            }
            try (AlgoContext ignored = Algo.newContext();){
                DataSet dataSet;
                RepQueryConfigBo repQueryConfigBo = AnalyseObjectService.getInstance().queryRepQueryConfigBo(calculateInfo.getReportId(), (IPageCache)new PageCache(reportQueryParamInfo.getPageId()));
                if (calculateInfo.getReportId() != null && reportQueryParamInfo.getFromCache() && start != -1 && limit != -1 && repQueryConfigBo.isEnableCache()) {
                    RepQueryCacheService cacheService = new RepQueryCacheService(repQueryConfigBo, calculateInfo, (IPageCache)new PageCache(reportQueryParamInfo.getPageId()));
                    dataSet = cacheService.calculateFromCache(start, limit);
                    repCalculateService = cacheService.getRepCalculateService();
                } else {
                    dataSet = repCalculateService.calculate(start, limit);
                }
                reportResult = AdminOrgCalHelper.buildReportResult((ReportCalculateInfo)repCalculateService.getCalculateInfo(), (String)reportQueryParamInfo.getPageId(), (DataSet)dataSet);
            }
            catch (KDBizException exception) {
                log.error("queryData4Summary_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                throw exception;
            }
            catch (Exception e) {
                log.error("queryData4Summary_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                throw new KDBizException("queryData4Summary error!");
            }
        }
        if ((globalContext = repCalculateService.getGlobalContext()) != null) {
            ReportQueryUtil.setEsParam(globalContext.getComplexObjContext(), reportQueryParamInfo);
        }
        calculateInfo.getCostTimeHelper().logCost("buildReportResult", "buildReportResult");
        log.info("queryTreeData4Summary_id_is_{}_anObjId_is_{}_cost_time_list_{}", new Object[]{reportManageConfigInfo.getId(), calculateInfo.getAnObjRelId(), calculateInfo.getCostTimeHelper().getCostTimeMap().toString()});
        log.info("reportResult_data_count_{}", (Object)reportResult.getDataCount());
        return reportResult;
    }

    private static void removeDependAnObjOriginalIndexes(ReportCalculateInfo reportCalculateInfo, ReportManageConfigInfo reportManageConfigInfo, String transNameAlias, List<String> pivotIndexAlias) {
        AnalyseObjectService anObjService = AnalyseObjectService.getInstance();
        List originalIndexes = reportManageConfigInfo.getAssignObj().getQueryFields().stream().filter(queryField -> anObjService.isIndexField(queryField.getValueType()) && !pivotIndexAlias.contains(queryField.getFieldAlias())).map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toList());
        originalIndexes.addAll(reportManageConfigInfo.getAssignObj().getAnObjCalFields().stream().filter(calField -> anObjService.isIndexField(calField.getValueType())).map(CalculateFieldBo::getFieldNumber).collect(Collectors.toList()));
        originalIndexes.removeIf(idx -> !AnalyseObjectService.getInstance().isNotIdField(idx));
        reportCalculateInfo.getRowFieldList().removeIf(field -> HRStringUtils.equals((String)transNameAlias, (String)field.getFieldAlias()) || originalIndexes.contains(field.getFieldAlias()));
    }

    private static AnalyseObjectPivotService getAnObjPivotQueryService(ReportCalculateInfo reportCalculateInfo, ReportQueryParamInfo reportQueryParamInfo, ReportManageConfigInfo reportManageConfigInfo) {
        boolean flag;
        String reportManageConfigInfoStr = SerializationUtils.toJsonString((Object)reportManageConfigInfo);
        reportManageConfigInfo = (ReportManageConfigInfo)SerializationUtils.fromJsonString((String)reportManageConfigInfoStr, ReportManageConfigInfo.class);
        ArrayList pivotIndexes = Lists.newArrayListWithCapacity((int)10);
        Map<String, List> calRefFieldMap = reportManageConfigInfo.getAssignObj().getReportCalFields().stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, CalculateFieldBo::getRefEntityFields));
        Map<String, IndexFieldInfo> allPivotIndexMap = reportManageConfigInfo.getAssignObj().getIndexList().stream().filter(field -> HRStringUtils.isNotEmpty((String)field.getPivotDimAlias())).collect(Collectors.toMap(AnObjFieldInfo::getFieldAlias, field -> field));
        ArrayList refPivotIndexes = Lists.newArrayListWithCapacity((int)10);
        ArrayList fromReportCalList = Lists.newArrayListWithCapacity((int)10);
        List reportCalFields = reportManageConfigInfo.getAssignObj().getReportCalFields();
        Map<String, CalculateFieldBo> reportCalFieldMap = reportCalFields.stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, field -> field));
        List dimMaps = reportManageConfigInfo.getCurWorkRpt().getDimMaps();
        List<Object> presetIndexList = Lists.newArrayListWithCapacity((int)10);
        if (dimMaps != null) {
            Map dimMapBoMap = dimMaps.stream().collect(Collectors.toMap(DimMapBo::getPreIndexNumber, Function.identity(), (k1, k2) -> k1));
            presetIndexList = reportManageConfigInfo.getRows().stream().filter(row -> HRStringUtils.equals((String)row.getGroupName().getFieldSrc(), (String)"2")).map(row -> {
                PresetIndexField presetIndexField = TransformUtil.fieldInfo2PresetIndexField(row.getGroupName());
                presetIndexField.setDimMap((DimMapBo)dimMapBoMap.get(row.getGroupName().getNumberAlias()));
                return presetIndexField;
            }).collect(Collectors.toList());
        }
        ArrayList rowFieldList = Lists.newArrayListWithCapacity((int)10);
        for (RowFieldInfo row2 : reportManageConfigInfo.getRows()) {
            CalculateFieldBo calculateFieldBo;
            Object calRefFieldAliasList;
            if (row2.getGroupName().getPivotIndex()) {
                pivotIndexes.add(row2.getGroupName());
            }
            if ((calRefFieldAliasList = calRefFieldMap.get(row2.getGroupName().getNumber())) != null) {
                Iterator iterator = calRefFieldAliasList.iterator();
                while (iterator.hasNext()) {
                    String alias = (String)iterator.next();
                    IndexFieldInfo indexFieldInfo = allPivotIndexMap.get(alias);
                    if (indexFieldInfo == null) continue;
                    refPivotIndexes.add(indexFieldInfo);
                }
            }
            if (row2._getChildFields() != null && !row2._getChildFields().isEmpty()) {
                if (HRStringUtils.equals((String)row2.getMergeType(), (String)"2")) {
                    row2._getChildFields().stream().filter(field -> reportCalFieldMap.containsKey(field.getNumber()) || field.getPivotIndex()).forEach(field -> {
                        rowFieldList.add(field);
                        if (field.getPivotIndex()) {
                            pivotIndexes.add(field);
                        }
                        CalculateFieldBo calculateFieldBo = (CalculateFieldBo)reportCalFieldMap.get(field.getNumber());
                        fromReportCalList.add(TransformUtil.fieldInfo2ReportField(field, calculateFieldBo));
                    });
                    row2._getChildFields().clear();
                } else if (HRStringUtils.equals((String)row2.getMergeType(), (String)"1")) {
                    FieldInfoUtil.recursive(row2._getChildFields(), field -> {
                        rowFieldList.add(field);
                        if (field.getPivotIndex()) {
                            pivotIndexes.add(field);
                        }
                        if (reportCalFieldMap.containsKey(field.getNumber())) {
                            fromReportCalList.add(TransformUtil.fieldInfo2ReportField(field, (CalculateFieldBo)reportCalFieldMap.get(field.getNumber())));
                        }
                    });
                } else {
                    pivotIndexes.addAll(row2._getChildFields().stream().filter(FieldInfo::getPivotIndex).collect(Collectors.toList()));
                }
            } else {
                rowFieldList.add(row2.getGroupName());
            }
            if (!HRStringUtils.equals((String)row2.getGroupName().getFieldSrc(), (String)"1") || (calculateFieldBo = reportCalFieldMap.get(row2.getGroupName().getNumber())) == null) continue;
            ReportQueryUtil.collectCalculates(row2.getGroupName(), calculateFieldBo, fromReportCalList);
        }
        Set pivotIndexNumbers = pivotIndexes.stream().map(FieldInfo::getNumber).collect(Collectors.toSet());
        ArrayList dependPivotFields = Lists.newArrayListWithCapacity((int)10);
        for (ReportField reportField : reportCalculateInfo.getRowFieldList()) {
            if (reportField instanceof AggregateIndexField && reportField.isDependField()) {
                fromReportCalList.add(HRObjectUtils.clone((Object)reportField));
                continue;
            }
            if (!pivotIndexNumbers.contains(reportField.getFieldAlias()) || !reportField.isDependField()) continue;
            dependPivotFields.add(reportField);
        }
        ReportQueryUtil.sortCalFieldsByOrder(fromReportCalList, reportCalFields);
        Set fromReportCalFieldNums = fromReportCalList.stream().map(ReportField::getUniqueKey).collect(Collectors.toSet());
        reportManageConfigInfo.getRows().removeIf(field -> field.getGroupName() != null && fromReportCalFieldNums.contains(field.getGroupName().getNumberAlias()));
        if (pivotIndexes.isEmpty() && refPivotIndexes.isEmpty()) {
            return null;
        }
        Map<String, List<FieldInfo>> numberGroupMap = rowFieldList.stream().collect(Collectors.groupingBy(FieldInfo::getNumber));
        Map<String, FieldInfo> sortRowFieldMap = rowFieldList.stream().filter(field -> HRStringUtils.isNotEmpty((String)field.getSort()) || field.getCustomSort() != null || field.getFieldSortInfo() != null).collect(Collectors.toMap(FieldInfo::getNumberAlias, field -> field));
        String transNameAlias = null;
        ArrayList transPositionNames = Lists.newArrayListWithCapacity((int)10);
        ArrayList transFieldAliasList = Lists.newArrayListWithCapacity((int)10);
        List<String> pivotIndexAlias = pivotIndexes.stream().map(FieldInfo::getNumberAlias).map(AnalyseObjectUtil::getOriginFieldAlias).collect(Collectors.toList());
        pivotIndexAlias.addAll(refPivotIndexes.stream().map(AnObjFieldInfo::getFieldAlias).collect(Collectors.toList()));
        List indexList = reportManageConfigInfo.getAssignObj().getIndexList();
        for (IndexFieldInfo indexFieldInfo : indexList) {
            if (!pivotIndexAlias.contains(indexFieldInfo.getFieldAlias())) continue;
            transNameAlias = indexFieldInfo.getPivotDimAlias();
            String name = reportCalculateInfo.isTransferField() ? indexFieldInfo.getPivotDimVal() : indexFieldInfo.getPivotDimName();
            transPositionNames.add(name);
            if (transFieldAliasList.contains(indexFieldInfo.getPivotIndexAlias())) continue;
            transFieldAliasList.add(indexFieldInfo.getPivotIndexAlias());
        }
        ReportQueryUtil.removeDependAnObjOriginalIndexes(reportCalculateInfo, reportManageConfigInfo, transNameAlias, pivotIndexAlias);
        List rows = reportManageConfigInfo.getRows();
        rows.clear();
        rowFieldList.forEach(rowField -> rows.add(new RowFieldInfo(rowField)));
        List rowFieldAlias = reportManageConfigInfo.getRows().stream().filter(rowField -> !HRStringUtils.equals((String)rowField.getMergeType(), (String)"2")).map(rowField -> rowField.getGroupName().getNumber()).collect(Collectors.toList());
        List rowDimFieldAlias = reportManageConfigInfo.getRows().stream().filter(rowField -> HRStringUtils.equals((String)"1", (String)rowField.getGroupName().getType())).map(rowField -> rowField.getGroupName().getNumber()).collect(Collectors.toList());
        rows.removeIf(rowField -> HRStringUtils.equals((String)"1", (String)rowField.getGroupName().getType()));
        for (String fieldAlias : rowDimFieldAlias) {
            reportManageConfigInfo.getAssignObj().getDimensionList().stream().filter(dim -> HRStringUtils.equals((String)dim.getFieldAlias(), (String)fieldAlias) && rows.stream().noneMatch(row -> HRStringUtils.equals((String)fieldAlias, (String)row.getGroupName().getNumber()))).forEach(dim -> {
                List rowFieldInfoList = (List)numberGroupMap.get(dim.getFieldAlias());
                if (rowFieldInfoList == null) {
                    rows.add(ReportQueryUtil.generateRowFieldInfoForAnObjPivot(dim, dim.getFieldAlias(), sortRowFieldMap));
                } else {
                    rowFieldInfoList.forEach(row -> rows.add(ReportQueryUtil.generateRowFieldInfoForAnObjPivot(dim, row.getNumberAlias(), sortRowFieldMap)));
                }
            });
        }
        reportManageConfigInfo.getAssignObj().getDimensionList().stream().filter(dim -> !rowDimFieldAlias.contains(dim.getFieldAlias())).forEach(dim -> {
            List rowFieldInfoList = (List)numberGroupMap.get(dim.getFieldAlias());
            if (rowFieldInfoList == null) {
                rows.add(ReportQueryUtil.generateRowFieldInfoForAnObjPivot(dim, dim.getFieldAlias(), sortRowFieldMap));
            } else {
                rowFieldInfoList.forEach(row -> rows.add(ReportQueryUtil.generateRowFieldInfoForAnObjPivot(dim, row.getNumberAlias(), sortRowFieldMap)));
            }
        });
        Map queryFieldMap = reportManageConfigInfo.getAssignObj().getQueryFields().stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        String finalTransNameAlias = transNameAlias;
        if (rows.stream().noneMatch(rowFieldInfo -> HRStringUtils.equals((String)finalTransNameAlias, (String)rowFieldInfo.getGroupName().getNumber()))) {
            DimensionFieldInfo dimensionFieldInfo = TransformUtil.queryFieldBo2DimensionFieldInfo((QueryFieldBo)queryFieldMap.get(finalTransNameAlias), false);
            rows.add(ReportQueryUtil.generateRowFieldInfoForAnObjPivot(dimensionFieldInfo, dimensionFieldInfo.getFieldAlias(), sortRowFieldMap));
        }
        Set refPivotIndexNums = refPivotIndexes.stream().map(AnObjFieldInfo::getFieldNumber).collect(Collectors.toSet());
        for (Object indexAlias : transFieldAliasList) {
            reportManageConfigInfo.getAssignObj().getIndexList().stream().filter(arg_0 -> ReportQueryUtil.lambda$getAnObjPivotQueryService$31((String)indexAlias, refPivotIndexNums, arg_0)).forEach(index -> {
                RowFieldInfo rowFieldInfo = new RowFieldInfo();
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setFieldId(index.getFieldId());
                fieldInfo.setName(index.getFieldName());
                fieldInfo.setNumber(index.getFieldAlias());
                fieldInfo.setNumberAlias(index.getFieldAlias());
                fieldInfo.setFieldPath(index.getFieldPath());
                fieldInfo.setValueType(index.getValueType());
                fieldInfo.setType("2");
                fieldInfo.setFieldSrc(index.getFieldSrc());
                rowFieldInfo.setGroupName(fieldInfo);
                rows.add(rowFieldInfo);
            });
        }
        Map calculateFieldBoMap = reportManageConfigInfo.getAssignObj().getAnObjCalFields().stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, Function.identity()));
        for (String transFieldAlias : transFieldAliasList) {
            if (!rows.stream().noneMatch(rowFieldInfo -> HRStringUtils.equals((String)transFieldAlias, (String)rowFieldInfo.getGroupName().getNumber()))) continue;
            QueryFieldBo queryFieldBo = (QueryFieldBo)queryFieldMap.get(transFieldAlias);
            IndexFieldInfo indexFieldInfo = queryFieldBo == null ? TransformUtil.calculateFieldBo2IndexFieldInfo((CalculateFieldBo)calculateFieldBoMap.get(transFieldAlias)) : TransformUtil.queryFieldBo2IndexFieldInfo((QueryFieldBo)queryFieldMap.get(transFieldAlias), "sum");
            rows.add(ReportQueryUtil.generateRowFieldInfoForAnObjPivot(indexFieldInfo, indexFieldInfo.getFieldAlias()));
        }
        HashMap transPositionInfo = Maps.newHashMapWithExpectedSize((int)3);
        transPositionInfo.put("transNameAlias", transNameAlias);
        transPositionInfo.put("transPositionNames", transPositionNames);
        transPositionInfo.put("transFieldAliasList", transFieldAliasList);
        String anObjId = reportManageConfigInfo.getAssignObj().getAnObj().getId();
        HRComplexObjContext context = AnalyseObjectService.getInstance().getComplexObjContext(Long.valueOf(anObjId));
        MergeInfo rowColTransposition = reportManageConfigInfo.getReportConfig().getRowColTransposition();
        boolean bl = flag = "0".equals(reportManageConfigInfo.getReportConfig().getType()) || rowColTransposition != null && rowColTransposition.getHeaders() != null && !rowColTransposition.getHeaders().isEmpty();
        if (flag) {
            context.setQueryMode("2");
            Map groupFieldMap = context.getComplexObjFieldInfoList().stream().collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, Function.identity()));
            ArrayList groupFieldList = Lists.newArrayListWithCapacity((int)rowFieldAlias.size());
            for (String fieldAlias : rowFieldAlias) {
                String idFieldAlias;
                HRComplexObjFieldInfo idFieldInfo;
                HRComplexObjFieldInfo hrComplexObjFieldInfo = (HRComplexObjFieldInfo)groupFieldMap.get(fieldAlias);
                if (hrComplexObjFieldInfo != null) {
                    groupFieldList.add(hrComplexObjFieldInfo);
                }
                if (!fieldAlias.contains(".") || (idFieldInfo = (HRComplexObjFieldInfo)groupFieldMap.get(idFieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(".")) + ".id")) == null) continue;
                groupFieldList.add(idFieldInfo);
            }
            context.setGroupFieldList((List)groupFieldList);
        }
        return AnObjPivotForReportUtil.generateAnObjPivotQueryService(reportQueryParamInfo, pivotIndexes, refPivotIndexes, reportManageConfigInfo, context, transPositionInfo, fromReportCalList, presetIndexList, dependPivotFields);
    }

    private static void sortCalFieldsByOrder(List<ReportField> fromReportCalList, List<CalculateFieldBo> reportCalFields) {
        Map<String, List<ReportField>> fromReportCalMap = fromReportCalList.stream().collect(Collectors.groupingBy(ReportField::getFieldAlias));
        fromReportCalList.clear();
        reportCalFields = reportCalFields.stream().sorted(Comparator.comparingInt(CalculateFieldBo::getOrder)).collect(Collectors.toList());
        for (CalculateFieldBo calculateFieldBo : reportCalFields) {
            List<ReportField> reportFields = fromReportCalMap.get(calculateFieldBo.getFieldNumber());
            if (reportFields == null) continue;
            fromReportCalList.addAll(reportFields);
        }
    }

    private static void collectCalculates(FieldInfo calFieldInfo, CalculateFieldBo calculateFieldBo, List<ReportField> fromReportCalList) {
        List refCalculateFields = calculateFieldBo.getRefCalculateFields();
        ReportField reportField = TransformUtil.fieldInfo2ReportField(calFieldInfo, calculateFieldBo);
        if (fromReportCalList.stream().noneMatch(calField -> HRStringUtils.equals((String)calField.getFieldAlias(), (String)calculateFieldBo.getFieldNumber()))) {
            fromReportCalList.add(reportField);
        }
        Map aggregationMap = calculateFieldBo.getAggregationMap();
        for (CalculateFieldBo refCalculateField : refCalculateFields) {
            ReportQueryUtil.collectRefCalculates(refCalculateField, aggregationMap, fromReportCalList);
        }
    }

    private static void collectRefCalculates(CalculateFieldBo refCalculateField, Map<String, String> aggregationMap, List<ReportField> fromReportCalList) {
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)refCalculateField.getRefPreIndexes()) || HRStringUtils.equals((String)refCalculateField.getCalMethod(), (String)"summary")) {
            NonAggregateIndexField nonAggregateIndexField = TransformUtil.calculateFieldBo2NonAggregateIndexField(null, refCalculateField);
            if (fromReportCalList.stream().noneMatch(calField -> HRStringUtils.equals((String)calField.getFieldAlias(), (String)nonAggregateIndexField.getFieldAlias()))) {
                nonAggregateIndexField.setDependField(true);
                fromReportCalList.add((ReportField)nonAggregateIndexField);
            }
        } else {
            AggregateIndexField aggregateIndexField = TransformUtil.calculateFieldBo2AggregateIndexField(null, refCalculateField);
            String aggregation = aggregationMap.get(refCalculateField.getFieldNumber());
            if (HRStringUtils.isNotEmpty((String)aggregation)) {
                aggregateIndexField.setCalcFunction(aggregation);
            }
            if (fromReportCalList.stream().noneMatch(calField -> HRStringUtils.equals((String)calField.getFieldAlias(), (String)aggregateIndexField.getFieldAlias()))) {
                aggregateIndexField.setDependField(true);
                fromReportCalList.add((ReportField)aggregateIndexField);
            }
        }
        List refCalculateFields = refCalculateField.getRefCalculateFields();
        for (CalculateFieldBo refSubCal : refCalculateFields) {
            ReportQueryUtil.collectRefCalculates(refSubCal, refCalculateField.getAggregationMap(), fromReportCalList);
        }
    }

    private static RowFieldInfo generateRowFieldInfoForAnObjPivot(IndexFieldInfo indexFieldInfo, String numberAlias) {
        RowFieldInfo rowFieldInfo = new RowFieldInfo();
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setFieldId(indexFieldInfo.getFieldId());
        fieldInfo.setName(indexFieldInfo.getFieldName());
        fieldInfo.setNumber(indexFieldInfo.getFieldAlias());
        fieldInfo.setNumberAlias(numberAlias == null ? indexFieldInfo.getFieldAlias() : numberAlias);
        fieldInfo.setFieldPath(indexFieldInfo.getFieldPath());
        fieldInfo.setValueType(indexFieldInfo.getValueType());
        fieldInfo.setBaseDataNum(indexFieldInfo.getBaseDataNum());
        fieldInfo.setControlType(indexFieldInfo.getControlType());
        fieldInfo.setFieldSrc(indexFieldInfo.getFieldSrc());
        fieldInfo.setType("2");
        rowFieldInfo.setGroupName(fieldInfo);
        return rowFieldInfo;
    }

    private static RowFieldInfo generateRowFieldInfoForAnObjPivot(DimensionFieldInfo dim, String numberAlias, Map<String, FieldInfo> sortRowFieldMap) {
        RowFieldInfo rowFieldInfo = new RowFieldInfo();
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setFieldId(dim.getFieldId());
        fieldInfo.setName(dim.getFieldName());
        fieldInfo.setNumber(dim.getFieldAlias());
        fieldInfo.setNumberAlias(numberAlias == null ? dim.getFieldAlias() : numberAlias);
        fieldInfo.setFieldPath(dim.getFieldPath());
        fieldInfo.setValueType(dim.getValueType());
        fieldInfo.setEntityNumber(dim.getEntityNumber());
        fieldInfo.setBaseDataNum(dim.getBaseDataNum());
        FieldInfo sortRowField = sortRowFieldMap.get(fieldInfo.getNumberAlias());
        if (sortRowField != null) {
            fieldInfo.setRowFieldId(sortRowField.getRowFieldId());
            fieldInfo.setSort(sortRowField.getSort());
            fieldInfo.setCustomSort(sortRowField.getCustomSort());
            fieldInfo.setFieldSortInfo(sortRowField.getFieldSortInfo());
        }
        fieldInfo.setControlType(dim.getControlType());
        fieldInfo.setComplexType(dim.getComplexType());
        fieldInfo.setFieldSrc(dim.getFieldSrc());
        fieldInfo.setType("1");
        rowFieldInfo.setGroupName(fieldInfo);
        return rowFieldInfo;
    }

    public static ReportCalculateInfo getReportCalculateInfo4Summary(ReportQueryParamInfo reportQueryParamInfo) {
        List<ReportField> dependFields;
        List<FieldInfo> calcFieldInfos;
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        List rows = reportManageConfigInfo.getRows();
        List columns = reportManageConfigInfo.getColumns();
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)rows) && kd.bos.util.CollectionUtils.isEmpty((Collection)columns)) {
            return null;
        }
        ReportCalculateInfo reportCalculateInfo = new ReportCalculateInfo();
        reportCalculateInfo.getCostTimeHelper().nestedStart();
        reportCalculateInfo.setReportId(reportManageConfigInfo.getId());
        reportCalculateInfo.setPresetIndexQFiltersByCopy(reportQueryParamInfo.getWhereQFilter());
        reportCalculateInfo.setPageId(reportQueryParamInfo.getPageId());
        reportCalculateInfo.setAlgoX(reportQueryParamInfo.getAlgoX());
        ArrayList originQFilters = Lists.newArrayListWithCapacity((int)10);
        if (reportQueryParamInfo.getWhereQFilter() != null) {
            reportQueryParamInfo.getWhereQFilter().forEach(originQFilter -> originQFilters.add(originQFilter.copy()));
        }
        if (reportQueryParamInfo.getOnQFilter() != null) {
            reportQueryParamInfo.getOnQFilter().forEach(originQFilter -> originQFilters.add(originQFilter.copy()));
        }
        reportCalculateInfo.setOriginFilters((List)originQFilters);
        List dimMaps = reportManageConfigInfo.getCurWorkRpt().getDimMaps();
        if (dimMaps == null) {
            dimMaps = Lists.newArrayListWithCapacity((int)10);
        }
        Map dimMapBoMap = dimMaps.stream().collect(Collectors.toMap(DimMapBo::getPreIndexNumber, Function.identity(), (k1, k2) -> k1));
        AnObjDetailInfo anObjDetailInfo = reportManageConfigInfo.getAssignObj();
        if (HRStringUtils.isNotEmpty((String)anObjDetailInfo.getAnObj().getId())) {
            reportCalculateInfo.setAnObjRelId(Long.valueOf(Long.parseLong(anObjDetailInfo.getAnObj().getId())));
        }
        Map<String, CalculateFieldBo> allCalFields = anObjDetailInfo._getAllCalFields().stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, Function.identity()));
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)rows)) {
            calcFieldInfos = FieldInfoUtil.getAllRowCalcFields(rows);
            dependFields = TransformUtil.getDependFields(anObjDetailInfo, calcFieldInfos, reportQueryParamInfo);
            log.info("ReportQueryUtil summary getRowDependFields: {}", dependFields);
            ArrayList<ReportField> rowFieldList = new ArrayList<ReportField>();
            for (int i = 0; i < rows.size(); ++i) {
                RowFieldInfo rowFieldInfo = (RowFieldInfo)rows.get(i);
                if (i == 0 && "tree".equals(rowFieldInfo.getGroupName().getDisplayMode())) {
                    AdminOrgSummaryInfo adminOrgSummaryInfo = new AdminOrgSummaryInfo();
                    adminOrgSummaryInfo.setDate(new Date());
                    adminOrgSummaryInfo.setAdminOrgFieldAlias(rowFieldInfo.getGroupName().getNumber());
                    adminOrgSummaryInfo.setAdminOrgFieldFullPath(rowFieldInfo.getGroupName().getFieldPath());
                    adminOrgSummaryInfo.setTreeShow(true);
                    reportCalculateInfo.setAdminOrgSummaryInfo(adminOrgSummaryInfo);
                    log.info("AdminOrgSummaryInfo:{}", (Object)adminOrgSummaryInfo);
                }
                FieldInfo groupName = rowFieldInfo.getGroupName();
                ReportQueryUtil.addRowField(rowFieldList, groupName, allCalFields, (DimMapBo)dimMapBoMap.get(groupName.getNumberAlias()));
                if (!rowFieldInfo._isMerge()) continue;
                FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> ReportQueryUtil.addRowField(rowFieldList, fieldInfo, allCalFields, (DimMapBo)dimMapBoMap.get(fieldInfo.getNumberAlias())));
            }
            DrillingUtil.replaceDrillingField(reportManageConfigInfo, rowFieldList);
            List mergedList = Stream.concat(dependFields.stream(), rowFieldList.stream()).collect(Collectors.toList());
            reportCalculateInfo.setRowFieldList(mergedList);
            List advanceSortRowList = reportManageConfigInfo.getReportConfig().getAdvanceSortRowList();
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)advanceSortRowList)) {
                for (int i = 0; i < advanceSortRowList.size(); ++i) {
                    for (ReportField reportField : mergedList) {
                        if (reportField.isDependField() || !((AdvanceSortInfo)advanceSortRowList.get(i)).getField().equals(reportField.getUniqueKey())) continue;
                        reportField.setSortSeq(Integer.valueOf(i));
                    }
                }
            }
        }
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)columns)) {
            calcFieldInfos = FieldInfoUtil.getAllColCalcFields(columns);
            dependFields = TransformUtil.getDependFields(anObjDetailInfo, calcFieldInfos, reportQueryParamInfo);
            log.info("ReportQueryUtil summary getColDependFields: {}", dependFields);
            ArrayList columnFieldList = new ArrayList();
            columns.forEach(fieldInfo -> {
                if ("0".equals(fieldInfo.getFieldSrc())) {
                    columnFieldList.add(TransformUtil.fieldInfo2EntityPropField(fieldInfo));
                } else if ("1".equals(fieldInfo.getFieldSrc())) {
                    columnFieldList.add(TransformUtil.fieldInfo2ReportField(fieldInfo, (CalculateFieldBo)allCalFields.get(fieldInfo.getNumber())));
                }
            });
            ReportTotalColConfigBo algorithmCol = reportManageConfigInfo.getReportConfig().getAlgorithmCol();
            reportCalculateInfo.setColumnSummaryInfo(ReportQueryUtil.getColumnSummaryInfo(algorithmCol, rows, columns));
            List mergedList = Stream.concat(dependFields.stream(), columnFieldList.stream()).collect(Collectors.toList());
            reportCalculateInfo.setColumnFieldList(mergedList);
            List advanceSortColList = reportManageConfigInfo.getReportConfig().getAdvanceSortColList();
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)advanceSortColList)) {
                for (int i = 0; i < advanceSortColList.size(); ++i) {
                    for (ReportField reportField : mergedList) {
                        if (reportField.isDependField() || !((AdvanceSortInfo)advanceSortColList.get(i)).getField().equals(reportField.getUniqueKey())) continue;
                        reportField.setSortSeq(Integer.valueOf(i));
                    }
                }
            }
        }
        boolean addFilter = !"mySubscribe".equals(reportQueryParamInfo.getReportCenterOpenFrom()) && !"share".equals(reportQueryParamInfo.getReportCenterOpenFrom()) && !ReportQueryUtil.isDataExtract(reportManageConfigInfo);
        reportCalculateInfo.setqFilterList(ReportQueryUtil.handlerDataFilter(reportManageConfigInfo, reportQueryParamInfo.getWhereQFilter(), addFilter));
        reportCalculateInfo.setJoinQFilterList(reportQueryParamInfo.getOnQFilter());
        if (reportCalculateInfo.getqFilterList() != null) {
            List originFilters = reportCalculateInfo.getOriginFilters();
            reportCalculateInfo.getqFilterList().forEach(originQFilter -> originFilters.add(originQFilter.copy()));
            reportCalculateInfo.setOriginFilters(originFilters);
        }
        ReportQueryUtil.handTransposeConfigInfoList(reportCalculateInfo, reportManageConfigInfo.getReportConfig().getRowColTransposition(), allCalFields);
        reportCalculateInfo.getCostTimeHelper().logCost("buildCalCalculateInfo", "buildCalCalculateInfo");
        return reportCalculateInfo;
    }

    private static ColumnSummaryInfo getColumnSummaryInfo(ReportTotalColConfigBo algorithmCol, List<RowFieldInfo> rows, List<FieldInfo> columns) {
        if (null == algorithmCol) {
            return null;
        }
        ColumnSummaryInfo columnSummaryInfo = new ColumnSummaryInfo();
        columnSummaryInfo.setShowLocation(algorithmCol.getShowLocation());
        columnSummaryInfo.setShowSubTotalCol(algorithmCol.getShowSubTotalCol());
        columnSummaryInfo.setSubTotalColName(algorithmCol.getSubTotalColName());
        columnSummaryInfo.setShowTotalCol(algorithmCol.getShowTotalCol());
        columnSummaryInfo.setTotalColName(algorithmCol.getTotalColName());
        if (StringUtils.isNotEmpty((CharSequence)algorithmCol.getDimField())) {
            ArrayList<String> subTotalLatitudes = new ArrayList<String>(Arrays.asList(algorithmCol.getDimField().split(",")));
            subTotalLatitudes.removeIf(StringUtils::isEmpty);
            subTotalLatitudes.remove(columns.get(columns.size() - 1).getNumberAlias());
            List numberAliasList = columns.stream().map(FieldInfo::getNumberAlias).collect(Collectors.toList());
            subTotalLatitudes.removeIf(str -> !numberAliasList.contains(str));
            columnSummaryInfo.setSubTotalLatitudes(subTotalLatitudes);
        } else {
            columnSummaryInfo.setSubTotalLatitudes(new ArrayList(2));
        }
        if (!CollectionUtils.isEmpty((Collection)algorithmCol.getIndexAlgorithmList())) {
            Map<String, String> fieldAlgorithmMap = SummaryAlgorithmUtil.indexAlgorithmList2Map(rows, algorithmCol.getIndexAlgorithmList());
            columnSummaryInfo.setSubTotalIndexCalcFunctionMap(fieldAlgorithmMap);
        } else {
            columnSummaryInfo.setSubTotalIndexCalcFunctionMap(new HashMap(16));
        }
        return columnSummaryInfo;
    }

    public static long getReportTotal(ReportQueryParamInfo reportQueryParamInfo) {
        RepCalculateService repCalculateService;
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        ReportQueryUtil.handleUserReportManageConfigInfo(reportManageConfigInfo, reportQueryParamInfo.getUserDispScmId(), null);
        AdminOrgSummaryInfo adminOrgSummaryInfo = reportQueryParamInfo.getAdminOrgSummaryInfo();
        if (adminOrgSummaryInfo != null && adminOrgSummaryInfo.getTreeShow() && "0".equals(reportManageConfigInfo.getReportConfig().getType())) {
            reportQueryParamInfo.setQueryCache(true);
            adminOrgSummaryInfo.setShowAllSummaryLevel(true);
            ReportResult reportResult = ReportQueryUtil.queryData4Summary(reportQueryParamInfo);
            if (reportResult != null) {
                List calResultList = reportResult.getCalResultList();
                return CalResult.getTreeShowTotalValue((List)calResultList);
            }
        }
        if ((repCalculateService = ReportQueryUtil.getRepCalculateService(reportQueryParamInfo)) != null) {
            return repCalculateService.count(reportQueryParamInfo.getStart(), reportQueryParamInfo.getLimit());
        }
        return 0L;
    }

    private static ReportCalculateInfo getReportCalculateInfo(ReportQueryParamInfo reportQueryParamInfo) {
        ReportCalculateInfo reportCalculateInfo;
        if ("0".equals(reportQueryParamInfo.getReportManageConfigInfo().getReportConfig().getType())) {
            reportCalculateInfo = ReportQueryUtil.getReportCalculateInfo4Summary(reportQueryParamInfo);
            if (reportCalculateInfo != null && reportQueryParamInfo.getAdminOrgSummaryInfo() != null) {
                reportCalculateInfo.setAdminOrgSummaryInfo(reportQueryParamInfo.getAdminOrgSummaryInfo());
                log.info("adminOrgSummaryInfo:{}", (Object)reportCalculateInfo.getAdminOrgSummaryInfo());
            }
            if (reportCalculateInfo != null && !ReportQueryUtil.isTreeShow(reportQueryParamInfo.getReportManageConfigInfo()) && reportCalculateInfo.getAdminOrgSummaryInfo() != null) {
                reportCalculateInfo.getAdminOrgSummaryInfo().setTreeShow(false);
                log.info("adminOrgSummaryInfo:{}", (Object)reportCalculateInfo.getAdminOrgSummaryInfo());
            }
        } else {
            reportCalculateInfo = ReportQueryUtil.getReportCalculateInfo4Detail(reportQueryParamInfo);
        }
        if (reportCalculateInfo != null) {
            reportCalculateInfo.setTransferField(reportQueryParamInfo.isTransferField());
            List queryFields = reportQueryParamInfo.getReportManageConfigInfo().getAssignObj().getQueryFields();
            DateTimeFieldTimeZoneUtil.setFieldTimeZone((List)queryFields, (List)reportCalculateInfo.getRowFieldList(), (List)reportCalculateInfo.getColumnFieldList());
            AnalyseObjectPivotService anObjPivotService = ReportQueryUtil.getAnObjPivotQueryService(reportCalculateInfo, reportQueryParamInfo, reportQueryParamInfo.getReportManageConfigInfo());
            if (anObjPivotService != null) {
                reportCalculateInfo.setAnObjPivotService(anObjPivotService);
                reportCalculateInfo.setAnObjPivot(true);
            }
            reportCalculateInfo.setRouteByBigData(reportQueryParamInfo.getRouteByBigData());
            if (HRStringUtils.equals((String)reportQueryParamInfo.getReportManageConfigInfo().getAssignObj().getAnObjType(), (String)"filesource")) {
                reportCalculateInfo.setAlgoX(false);
            }
            reportCalculateInfo.setChartType(reportQueryParamInfo.getChartType());
            if (HRStringUtils.isNotEmpty((String)reportQueryParamInfo.getReportCenterOpenFrom())) {
                ReportCenterUtil.setEsQueryParam((ReportCalculateInfo)reportCalculateInfo, (String)reportQueryParamInfo.getReportCenterOpenFrom(), (Long)reportQueryParamInfo.getMySubscribeId(), (Long)reportQueryParamInfo.getShareId());
                EsQueryConverter esQueryConverter = new EsQueryConverter();
                esQueryConverter.convert2EsInfo(reportCalculateInfo);
            } else if (reportQueryParamInfo.getReportManageConfigInfo().isPublishQuery()) {
                RptDataExtractQueryConverter.getInstance().convertReportQueryParam(reportCalculateInfo);
            }
            reportCalculateInfo.setObjSortValueMap(reportQueryParamInfo.getObjSortValueMap());
            reportCalculateInfo.setAfterKeyMap(reportQueryParamInfo.getAfterKeyMap());
            reportCalculateInfo.setEsLimit(reportQueryParamInfo.getEsLimit());
        }
        return reportCalculateInfo;
    }

    public static ReportInfo getReportTotalRows(ReportQueryParamInfo reportQueryParamInfo) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        ReportQueryUtil.handleUserReportManageConfigInfo(reportManageConfigInfo, reportQueryParamInfo.getUserDispScmId(), null);
        ReportInfo reportInfo = new ReportInfo();
        if (!reportManageConfigInfo.getReportConfig().getTotal()) {
            return reportInfo;
        }
        RepCalculateService repCalculateService = ReportQueryUtil.getRepCalculateService(reportQueryParamInfo);
        if (null == repCalculateService) {
            return null;
        }
        Map<String, String> indexSummaryFunctionMap = ReportQueryUtil.getIndexSummaryFunctionMap(reportManageConfigInfo);
        RowSummaryInfo rowSummaryInfo = new RowSummaryInfo();
        rowSummaryInfo.setIndexFunctionMap(indexSummaryFunctionMap);
        repCalculateService.getCalculateInfo().setRowSummaryInfo(rowSummaryInfo);
        DataSet dataSet = repCalculateService.totalCalculate(reportQueryParamInfo.getStart(), reportQueryParamInfo.getLimit());
        if (null == dataSet) {
            return null;
        }
        ReportQueryUtil.setTotalAndTotalRow(reportInfo, dataSet, reportQueryParamInfo);
        return reportInfo;
    }

    public static Map<String, String> getIndexSummaryFunctionMap(ReportManageConfigInfo reportManageConfigInfo) {
        List indexAlgorithmList = reportManageConfigInfo.getReportConfig().getIndexAlgorithmList();
        if (!kd.bos.util.CollectionUtils.isEmpty((Collection)indexAlgorithmList)) {
            ArrayList<Map<String, String>> indexAlgorithmListCopy = new ArrayList<Map<String, String>>(indexAlgorithmList);
            Map<String, CalculateFieldBo> calFieldMap = reportManageConfigInfo.getAssignObj()._getAllCalFields().stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, bo -> bo));
            indexAlgorithmListCopy.removeIf(map -> {
                if ("auto".equals(map.get("algorithm"))) {
                    CalculateFieldBo bo;
                    String key = (String)map.get("indexField");
                    if (key.contains("\u03b4")) {
                        key = key.split("\u03b4")[0];
                    }
                    return null != (bo = (CalculateFieldBo)calFieldMap.get(key)) && ("summary".equals(bo.getCalMethod()) || kd.bos.util.CollectionUtils.isNotEmpty((Collection)bo.getRefPreIndexes()));
                }
                return false;
            });
            return SummaryAlgorithmUtil.indexAlgorithmList2Map(reportManageConfigInfo.getRows(), indexAlgorithmListCopy);
        }
        return Collections.emptyMap();
    }

    public static Set<String> getNonAggIndexAlias(ReportManageConfigInfo reportManageConfigInfo) {
        Map<String, CalculateFieldBo> calFieldMap = reportManageConfigInfo.getAssignObj()._getAllCalFields().stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, bo -> bo));
        Map<String, FieldInfo> rowFieldMap = FieldInfoUtil.getAllRowFieldMap(reportManageConfigInfo.getRows());
        HashSet nonAggIndexUniqueAliases = Sets.newHashSetWithExpectedSize((int)rowFieldMap.size());
        for (Map.Entry<String, FieldInfo> fieldInfoEntry : rowFieldMap.entrySet()) {
            FieldInfo fieldInfo = fieldInfoEntry.getValue();
            if (!"2".equals(fieldInfo.getType())) continue;
            CalculateFieldBo bo2 = calFieldMap.get(fieldInfo.getNumber());
            if (bo2 != null) {
                if (!"summary".equals(bo2.getCalMethod()) && !kd.bos.util.CollectionUtils.isNotEmpty((Collection)bo2.getRefPreIndexes())) continue;
                nonAggIndexUniqueAliases.add(fieldInfoEntry.getKey());
                continue;
            }
            if (!"2".equals(fieldInfo.getFieldSrc())) continue;
            nonAggIndexUniqueAliases.add(fieldInfoEntry.getKey());
        }
        return nonAggIndexUniqueAliases;
    }

    public static ReportResult queryData4Detail(ReportQueryParamInfo reportQueryParamInfo) {
        int start = reportQueryParamInfo.getStart();
        int limit = reportQueryParamInfo.getLimit();
        RepQueryConfigBo repQueryConfigBo = AnalyseObjectService.getInstance().queryRepQueryConfigBo(reportQueryParamInfo.getReportManageConfigInfo().getId(), (IPageCache)new PageCache(reportQueryParamInfo.getPageId()));
        if (reportQueryParamInfo.getReportManageConfigInfo().getId() != null && reportQueryParamInfo.getFromCache() && start != -1 && limit != -1 && repQueryConfigBo.isEnableCache()) {
            ReportCalculateInfo calculateInfo = ReportQueryUtil.getReportCalculateInfo(reportQueryParamInfo);
            RepQueryCacheService cacheService = new RepQueryCacheService(repQueryConfigBo, calculateInfo, (IPageCache)new PageCache(reportQueryParamInfo.getPageId()));
            try (AlgoContext ignored = Algo.newContext();){
                DataSet dataSet = cacheService.calculateFromCache(start, limit);
                CalculateContext globalContext = cacheService.getRepCalculateService().getGlobalContext();
                if (globalContext != null) {
                    ReportQueryUtil.setEsParam(globalContext.getComplexObjContext(), reportQueryParamInfo);
                }
                ReportResult reportResult = AdminOrgCalHelper.buildReportResult((ReportCalculateInfo)calculateInfo, null, (DataSet)dataSet);
                return reportResult;
            }
        }
        RepCalculateService repCalculateService = ReportQueryUtil.getRepCalculateService(reportQueryParamInfo);
        if (repCalculateService == null) {
            return null;
        }
        try (AlgoContext ignored = Algo.newContext();){
            DataSet dataSet = repCalculateService.calculate(start, limit);
            ReportQueryUtil.setEsParam(repCalculateService.getGlobalContext().getComplexObjContext(), reportQueryParamInfo);
            ReportResult reportResult = AdminOrgCalHelper.buildReportResult((ReportCalculateInfo)repCalculateService.getCalculateInfo(), null, (DataSet)dataSet);
            return reportResult;
        }
    }

    private static RepCalculateService getRepCalculateService(ReportQueryParamInfo reportQueryParamInfo) {
        ReportCalculateInfo reportCalculateInfo = ReportQueryUtil.getReportCalculateInfo(reportQueryParamInfo);
        if (reportCalculateInfo == null) {
            return null;
        }
        return new RepCalculateService(reportCalculateInfo);
    }

    public static ReportCalculateInfo getReportCalculateInfo4Detail(ReportQueryParamInfo reportQueryParamInfo) {
        ReportManageConfigInfo reportManageConfigInfo = reportQueryParamInfo.getReportManageConfigInfo();
        List rows = reportManageConfigInfo.getRows();
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)rows)) {
            return null;
        }
        ReportCalculateInfo reportCalculateInfo = new ReportCalculateInfo();
        reportCalculateInfo.setReportId(reportManageConfigInfo.getId());
        reportCalculateInfo.setPageId(reportQueryParamInfo.getPageId());
        reportCalculateInfo.setAlgoX(reportQueryParamInfo.getAlgoX());
        AnObjDetailInfo anObjDetailInfo = reportManageConfigInfo.getAssignObj();
        if (HRStringUtils.isNotEmpty((String)anObjDetailInfo.getAnObj().getId())) {
            reportCalculateInfo.setAnObjRelId(Long.valueOf(Long.parseLong(anObjDetailInfo.getAnObj().getId())));
        }
        reportCalculateInfo.setPresetIndexQFilters(reportQueryParamInfo.getPreIdxQFilter());
        ArrayList originQFilters = Lists.newArrayListWithCapacity((int)10);
        if (reportQueryParamInfo.getWhereQFilter() != null) {
            reportQueryParamInfo.getWhereQFilter().forEach(originQFilter -> originQFilters.add(originQFilter.copy()));
        }
        if (reportQueryParamInfo.getOnQFilter() != null) {
            reportQueryParamInfo.getOnQFilter().forEach(originQFilter -> originQFilters.add(originQFilter.copy()));
        }
        reportCalculateInfo.setOriginFilters((List)originQFilters);
        List<FieldInfo> calcFields = FieldInfoUtil.getAllRowCalcFields(rows);
        List<ReportField> dependFields = TransformUtil.getDependFields(anObjDetailInfo, calcFields, reportQueryParamInfo);
        ArrayList<ReportField> rowFieldList = new ArrayList<ReportField>(dependFields);
        Map<String, CalculateFieldBo> allCalFields = anObjDetailInfo._getAllCalFields().stream().collect(Collectors.toMap(CalculateFieldBo::getFieldNumber, Function.identity()));
        List dimMaps = reportManageConfigInfo.getCurWorkRpt().getDimMaps();
        if (dimMaps == null) {
            dimMaps = Lists.newArrayListWithCapacity((int)10);
        }
        Map dimMapBoMap = dimMaps.stream().collect(Collectors.toMap(DimMapBo::getPreIndexNumber, Function.identity(), (k1, k2) -> k1));
        for (RowFieldInfo rowFieldInfo : rows) {
            FieldInfo groupName = rowFieldInfo.getGroupName();
            ReportQueryUtil.addRowField(rowFieldList, groupName, allCalFields, (DimMapBo)dimMapBoMap.get(groupName.getNumberAlias()));
            if (!rowFieldInfo._isMerge()) continue;
            FieldInfoUtil.recursive(rowFieldInfo._getChildFields(), fieldInfo -> ReportQueryUtil.addRowField(rowFieldList, fieldInfo, allCalFields, (DimMapBo)dimMapBoMap.get(fieldInfo.getNumberAlias())));
        }
        reportCalculateInfo.setReportType("1");
        reportCalculateInfo.setRowFieldList(rowFieldList);
        List advanceSortRowList = reportManageConfigInfo.getReportConfig().getAdvanceSortRowList();
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)advanceSortRowList)) {
            for (int i = 0; i < advanceSortRowList.size(); ++i) {
                for (ReportField reportField : rowFieldList) {
                    if (reportField.isDependField() || !((AdvanceSortInfo)advanceSortRowList.get(i)).getField().equals(reportField.getUniqueKey())) continue;
                    reportField.setSortSeq(Integer.valueOf(i));
                }
            }
        }
        boolean addFilter = !"mySubscribe".equals(reportQueryParamInfo.getReportCenterOpenFrom()) && !"share".equals(reportQueryParamInfo.getReportCenterOpenFrom()) && !ReportQueryUtil.isDataExtract(reportManageConfigInfo);
        reportCalculateInfo.setqFilterList(ReportQueryUtil.handlerDataFilter(reportManageConfigInfo, reportQueryParamInfo.getWhereQFilter(), addFilter));
        reportCalculateInfo.setJoinQFilterList(reportQueryParamInfo.getOnQFilter());
        ReportQueryUtil.handTransposeConfigInfoList(reportCalculateInfo, reportManageConfigInfo.getReportConfig().getRowColTransposition(), allCalFields);
        reportCalculateInfo.setAlgoXDetailOptimize(reportQueryParamInfo.getAlgoXDetailOptimize());
        reportCalculateInfo.setTransferField(reportQueryParamInfo.isTransferField());
        return reportCalculateInfo;
    }

    private static void handTransposeConfigInfoList(ReportCalculateInfo reportCalculateInfo, MergeInfo mergeInfo, Map<String, CalculateFieldBo> allCalFields) {
        if (mergeInfo != null && kd.bos.util.CollectionUtils.isNotEmpty((Collection)mergeInfo.getHeaders())) {
            ArrayList<TransposeConfigInfo> transposeConfigInfoList = new ArrayList<TransposeConfigInfo>(10);
            for (RowFieldInfo rowFieldInfo : mergeInfo.getHeaders()) {
                TransposeConfigInfo transposeConfigInfo = new TransposeConfigInfo();
                List transposeFields = rowFieldInfo._getAllGns().stream().map(fieldInfo -> TransformUtil.fieldInfo2ReportField(fieldInfo, (CalculateFieldBo)allCalFields.get(fieldInfo.getNumber()))).collect(Collectors.toList());
                transposeConfigInfo.setTransposeFieldList(transposeFields);
                List transposeValueFieldList = rowFieldInfo.getFields().stream().map(fieldInfo -> TransformUtil.fieldInfo2ReportField(fieldInfo, (CalculateFieldBo)allCalFields.get(fieldInfo.getNumber()))).collect(Collectors.toList());
                transposeConfigInfo.setTransposeValueFieldList(transposeValueFieldList);
                transposeConfigInfoList.add(transposeConfigInfo);
            }
            reportCalculateInfo.setTransposeConfigInfoList(transposeConfigInfoList);
        }
    }

    private static List<QFilter> handlerDataFilter(ReportManageConfigInfo reportManageConfigInfo, List<QFilter> qFilterList, boolean addFilter) {
        String dataFilter = reportManageConfigInfo.getDataFilter();
        if (!HRStringUtils.isEmpty((String)dataFilter) && addFilter) {
            QFilter qFilter;
            List queryFieldBos = reportManageConfigInfo.getAssignObj().getQueryFields();
            if (queryFieldBos == null) {
                Long anObjId = Long.parseLong(reportManageConfigInfo.getAssignObj().getAnObj().getId());
                queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(anObjId);
            }
            if (Objects.nonNull(qFilter = HRFilterUtil.condition2QFilter4HRReport((String)dataFilter, (String)SerializationUtils.toJsonString((Object)queryFieldBos)))) {
                if (qFilterList == null) {
                    qFilterList = Lists.newArrayListWithCapacity((int)10);
                }
                qFilterList.add(qFilter);
            }
        }
        if ("0".equals(reportManageConfigInfo.getReportConfig().getType())) {
            DrillingInfo drillingInfo = reportManageConfigInfo.getReportConfig().getDrillingInfo();
            Map<String, QueryFieldBo> fieldAliasTypeMap = reportManageConfigInfo.getAssignObj().getQueryFields().stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, queryFieldBo -> queryFieldBo));
            if (null != drillingInfo && null != drillingInfo.getFilterMap() && !drillingInfo.getFilterMap().isEmpty()) {
                for (Map.Entry entry : drillingInfo.getFilterMap().entrySet()) {
                    String number = FieldInfoUtil.getNumber((String)entry.getKey());
                    if (number.contains("\u03b6")) {
                        number = number.substring(0, number.indexOf("\u03b6"));
                    }
                    if (!fieldAliasTypeMap.containsKey(number)) continue;
                    if (qFilterList == null) {
                        qFilterList = Lists.newArrayListWithCapacity((int)10);
                    }
                    Object value = null;
                    String valueType = fieldAliasTypeMap.get(number).getValueType();
                    String controlType = fieldAliasTypeMap.get(number).getControlType();
                    if (FieldControlType.COMBO.getValue().equals(controlType) || FieldControlType.MUL_COMBO.getValue().equals(controlType)) {
                        String data = fieldAliasTypeMap.get(number).getData();
                        if (StringUtils.isNotEmpty((CharSequence)data)) {
                            List valueMapItems = SerializationUtils.fromJsonStringToList((String)data, ValueMapItem.class);
                            for (ValueMapItem item : valueMapItems) {
                                if (!((String)entry.getValue()).equals(item.getName().getLocaleValue())) continue;
                                value = item.getValue();
                                break;
                            }
                        }
                    } else {
                        value = DataTypeEnum.BOOLEAN.getDataTypeKey().equals(valueType) ? (ResManager.loadKDString((String)"\u662f", (String)"ReportQueryUtil_0", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]).equals(entry.getValue()) ? "1" : "0") : ReportStyleRuleService.getValue((String)((String)entry.getValue()), (String)valueType);
                    }
                    if (ObjectUtils.isEmpty(value)) {
                        qFilterList.add(new QFilter(number, "=", (Object)QEmptyValue.value));
                        continue;
                    }
                    qFilterList.add(new QFilter(number, "=", value));
                }
            }
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(qFilterList)) {
            log.info("qFilterList:{}", (Object)((Object)qFilterList).toString());
        }
        return qFilterList;
    }

    private static void addRowField(List<ReportField> rowFieldList, FieldInfo fieldInfo, Map<String, CalculateFieldBo> allCalFields, DimMapBo dimMap) {
        EntityPropField reportField = null;
        if ("0".equals(fieldInfo.getFieldSrc())) {
            reportField = TransformUtil.fieldInfo2EntityPropField(fieldInfo);
        } else if ("1".equals(fieldInfo.getFieldSrc())) {
            reportField = TransformUtil.fieldInfo2ReportField(fieldInfo, allCalFields.get(fieldInfo.getNumber()));
        } else if ("2".equals(fieldInfo.getFieldSrc())) {
            reportField = TransformUtil.fieldInfo2ReportField(fieldInfo, allCalFields.get(fieldInfo.getNumber()), dimMap);
        }
        if (null != reportField) {
            rowFieldList.add((ReportField)reportField);
        }
    }

    public static void handleUserReportManageConfigInfo(ReportManageConfigInfo reportManageConfigInfo, long userDispScmId, String pageId) {
        if (userDispScmId == 0L) {
            return;
        }
        HashMap<String, FieldInfo> rptRowFieldMap = new HashMap<String, FieldInfo>(16);
        for (RowFieldInfo rptRowFieldInfo : reportManageConfigInfo.getRows()) {
            if (rptRowFieldInfo._isMerge()) {
                FieldInfoUtil.recursive(rptRowFieldInfo._getChildFields(), fieldInfo -> rptRowFieldMap.put(fieldInfo.getRowFieldId(), (FieldInfo)fieldInfo));
                continue;
            }
            rptRowFieldMap.put(rptRowFieldInfo.getGroupName().getRowFieldId(), rptRowFieldInfo.getGroupName());
        }
        ReportManageConfigInfo userRptManageCfgInfo = ReportManageService.getUserDispScmRptCfgInfo((long)userDispScmId);
        boolean isNotFoundField = false;
        for (int i = 0; i < userRptManageCfgInfo.getRows().size(); ++i) {
            RowFieldInfo userRowFieldInfo = (RowFieldInfo)userRptManageCfgInfo.getRows().get(i);
            if (rptRowFieldMap.containsKey(userRowFieldInfo.getGroupName().getRowFieldId())) {
                userRowFieldInfo.setGroupName((FieldInfo)rptRowFieldMap.get(userRowFieldInfo.getGroupName().getRowFieldId()));
            } else if (!"0".equals(userRowFieldInfo.getGroupName().getType())) {
                isNotFoundField = true;
            }
            if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)userRowFieldInfo._getChildFields())) continue;
            for (int j = 0; j < userRowFieldInfo._getChildFields().size(); ++j) {
                FieldInfo fieldInfo2 = (FieldInfo)userRowFieldInfo._getChildFields().get(j);
                if (rptRowFieldMap.containsKey(fieldInfo2.getRowFieldId())) {
                    userRowFieldInfo._getChildFields().set(j, rptRowFieldMap.get(fieldInfo2.getRowFieldId()));
                    continue;
                }
                isNotFoundField = true;
            }
        }
        Map<String, FieldInfo> rptColFieldMap = reportManageConfigInfo.getColumns().stream().collect(Collectors.toMap(FieldInfo::getRowFieldId, fieldInfo -> fieldInfo));
        for (int i = 0; i < userRptManageCfgInfo.getColumns().size(); ++i) {
            FieldInfo userColFieldInfo = (FieldInfo)userRptManageCfgInfo.getColumns().get(i);
            if (rptColFieldMap.containsKey(userColFieldInfo.getRowFieldId())) {
                userRptManageCfgInfo.getColumns().set(i, rptColFieldMap.get(userColFieldInfo.getRowFieldId()));
                continue;
            }
            isNotFoundField = true;
        }
        if (isNotFoundField) {
            IFormView view;
            log.info("ReportQueryUtil handleUserReportManageConfigInfo not found field, user display scheme is disable.");
            if (HRStringUtils.isNotEmpty((String)pageId) && (view = SessionManager.getCurrent().getView(pageId)) != null && ReportCenterUtil.openFromMySubscribeOrShare((Map)view.getFormShowParameter().getCustomParams())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u663e\u793a\u65b9\u6848\u5185\u7684\u5b57\u6bb5\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u6cd5\u5728\u5f53\u524d\u62a5\u8868\u4e2d\u4f7f\u7528\u3002", (String)"ReportQueryUtil_1", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        reportManageConfigInfo.getCurWorkRpt().setRows(userRptManageCfgInfo.getRows());
        reportManageConfigInfo.getCurWorkRpt().setColumns(userRptManageCfgInfo.getColumns());
        reportManageConfigInfo.getReportConfig().setFreezeCol(userRptManageCfgInfo.getReportConfig().getFreezeCol());
        reportManageConfigInfo.getReportConfig().setHeaderMerge(userRptManageCfgInfo.getReportConfig().getHeaderMerge());
    }

    private static boolean isDataExtract(ReportManageConfigInfo reportManageConfigInfo) {
        DynamicObject config;
        Long reportId = reportManageConfigInfo.getId();
        if (reportId != null && (config = ReportManageService.getParamConfigWithSchedule((long)reportId)) != null && config.getBoolean("enableextract") && "2".equals(config.getString("schedulestatus"))) {
            return true;
        }
        String id = reportManageConfigInfo.getAssignObj().getAnObj().getId();
        if (!HRStringUtils.isEmpty((String)id)) {
            long anObjRelId = Long.parseLong(id);
            AnObjExtractConfigBo anObjExtractConfig = AnObjDataExtractService.getInstance().getAnObjExtractConfig(anObjRelId);
            return anObjExtractConfig != null && anObjExtractConfig.isOpenExtract() && "2".equals(anObjExtractConfig.getRunStatus());
        }
        return false;
    }

    private static void setEsParam(HRComplexObjContext complexObjContext, ReportQueryParamInfo reportQueryParamInfo) {
        Map objSortValueMap = complexObjContext.getObjSortValueMap();
        Map afterKeyMap = complexObjContext.getAfterKeyMap();
        reportQueryParamInfo.setObjSortValueMap(objSortValueMap);
        reportQueryParamInfo.setAfterKeyMap(afterKeyMap);
    }

    private static /* synthetic */ boolean lambda$getAnObjPivotQueryService$31(String indexAlias, Set refPivotIndexNums, IndexFieldInfo index) {
        return HRStringUtils.equals((String)index.getFieldAlias(), (String)indexAlias) || refPivotIndexNums.contains(index.getFieldAlias());
    }
}

