/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseDimCountService;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.preindex.PresetIndexServiceHelper;
import kd.hr.hrptmc.business.repdesign.field.AggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.AnalysisObjectPresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.BizServicePresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPrimitiveIndexField;
import kd.hr.hrptmc.business.repdesign.field.EntityPropField;
import kd.hr.hrptmc.business.repdesign.field.LatitudeField;
import kd.hr.hrptmc.business.repdesign.field.NonAggregateIndexField;
import kd.hr.hrptmc.business.repdesign.field.PresetIndexField;
import kd.hr.hrptmc.business.repdesign.field.ReportField;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.DimensionFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.IndexFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportQueryParamInfo;
import kd.hr.hrptmc.common.model.anobj.PivotIndexFieldBo;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.calfield.PreIndexBo;
import kd.hr.hrptmc.common.model.preindex.DimMapBo;
import kd.hr.hrptmc.common.util.HRReportParamUtils;
import kd.hr.hrptmc.formplugin.web.repdesign.util.SplitDateUtil;

public class TransformUtil {
    private static final List<String> INDEX_TYPE_LIST = Arrays.asList(DataTypeEnum.INTEGER.getDataTypeKey(), DataTypeEnum.LONG.getDataTypeKey(), DataTypeEnum.BIGDECIMAL.getDataTypeKey());

    public static boolean isIndex(String valueType) {
        return INDEX_TYPE_LIST.contains(valueType);
    }

    public static DimensionFieldInfo queryFieldBo2SplitData(QueryFieldBo queryFieldBo, String number) {
        DimensionFieldInfo dimensionFieldInfo = TransformUtil.queryFieldBo2DimensionFieldInfo(queryFieldBo, true);
        dimensionFieldInfo.setSplitDate(false);
        dimensionFieldInfo.setSplitDateSub(true);
        dimensionFieldInfo.setSplitDateOriFieldPath(queryFieldBo.getFieldPath());
        dimensionFieldInfo.setSplitDateIndex(SplitDateTypeEnum.getEnum((String)number).getIndex());
        SplitDateTypeEnum splitDateTypeEnum = SplitDateTypeEnum.getEnum((String)number);
        dimensionFieldInfo.setSplitDateType(splitDateTypeEnum);
        dimensionFieldInfo.setFieldName(new LocaleString(splitDateTypeEnum.getName() + "\uff08" + queryFieldBo.getFieldName() + "\uff09"));
        dimensionFieldInfo.setFieldAlias(dimensionFieldInfo.getFieldAlias() + "!" + number);
        dimensionFieldInfo.setFieldPath(dimensionFieldInfo.getFieldPath() + "!" + number);
        List<ValueMapItem> list = SplitDateUtil.getInstance().getComboItems(number);
        if (list.size() > 0) {
            dimensionFieldInfo.setCanDrag(true);
            dimensionFieldInfo.setCanTrans(true);
            dimensionFieldInfo.setDimQuantity(list.size());
            dimensionFieldInfo.setData(SerializationUtils.toJsonString(list));
        }
        return dimensionFieldInfo;
    }

    public static DimensionFieldInfo queryFieldBo2DimensionFieldInfo(QueryFieldBo queryFieldBo, boolean queryDimCount) {
        DimensionFieldInfo dimensionFieldInfo = new DimensionFieldInfo();
        dimensionFieldInfo.setFieldId(queryFieldBo.getId());
        dimensionFieldInfo.setFieldName(queryFieldBo.getFieldName());
        dimensionFieldInfo.setFieldAlias(queryFieldBo.getFieldAlias());
        dimensionFieldInfo.setFieldPath(queryFieldBo.getFieldPath());
        dimensionFieldInfo.setValueType(queryFieldBo.getValueType());
        dimensionFieldInfo.setControlType(queryFieldBo.getControlType());
        dimensionFieldInfo.setFieldSrc("0");
        dimensionFieldInfo.setEntityNumber(queryFieldBo.getEntityNumber());
        dimensionFieldInfo.setComplexType(queryFieldBo.getComplexType());
        dimensionFieldInfo.setFieldNumber(queryFieldBo.getFieldNumber());
        dimensionFieldInfo.setData(queryFieldBo.getData());
        dimensionFieldInfo.setTimeZoneInfo(queryFieldBo.getTimeZoneInfo());
        AnalyseDimCountService service = new AnalyseDimCountService();
        int dimCount = queryFieldBo.getDimCount();
        if (queryDimCount && dimCount == 0) {
            if (queryFieldBo.isVirtualEntityField()) {
                if (!HRStringUtils.isEmpty((String)dimensionFieldInfo.getFieldPath())) {
                    dimCount = service.getDimensionCount(dimensionFieldInfo.getFieldPath().split("\\.")[0], dimensionFieldInfo.getFieldPath(), dimensionFieldInfo.getComplexType());
                }
            } else {
                dimCount = service.getDimensionCount(dimensionFieldInfo.getEntityNumber(), dimensionFieldInfo.getFieldPath(), dimensionFieldInfo.getComplexType());
            }
        }
        dimensionFieldInfo.setCanDrag(dimCount <= 500);
        dimensionFieldInfo.setCanTrans(dimCount <= HRReportParamUtils.getPivotDimCountThresh());
        dimensionFieldInfo.setDimQuantity(dimCount);
        dimensionFieldInfo.setBaseDataNum(queryFieldBo.getBaseDataNum());
        dimensionFieldInfo.setVirtualEntityField(queryFieldBo.isVirtualEntityField());
        return dimensionFieldInfo;
    }

    public static IndexFieldInfo queryFieldBo2IndexFieldInfo(QueryFieldBo queryFieldBo) {
        IndexFieldInfo indexFieldInfo = new IndexFieldInfo();
        indexFieldInfo.setFieldId(queryFieldBo.getId());
        indexFieldInfo.setFieldName(queryFieldBo.getFieldName());
        indexFieldInfo.setFieldAlias(queryFieldBo.getFieldAlias());
        indexFieldInfo.setFieldPath(queryFieldBo.getFieldPath());
        indexFieldInfo.setValueType(queryFieldBo.getValueType());
        indexFieldInfo.setControlType(queryFieldBo.getControlType());
        indexFieldInfo.setFieldNumber(queryFieldBo.getFieldNumber());
        indexFieldInfo.setFieldSrc("0");
        indexFieldInfo.setEntityNumber(queryFieldBo.getEntityNumber());
        indexFieldInfo.setBaseDataNum(queryFieldBo.getBaseDataNum());
        indexFieldInfo.setVirtualEntityField(queryFieldBo.isVirtualEntityField());
        return indexFieldInfo;
    }

    public static IndexFieldInfo queryFieldBo2IndexFieldInfo(QueryFieldBo queryFieldBo, String algorithm) {
        IndexFieldInfo indexFieldInfo = TransformUtil.queryFieldBo2IndexFieldInfo(queryFieldBo);
        indexFieldInfo.setAlgorithm(algorithm);
        String displayName = queryFieldBo.getFieldName().getLocaleValue();
        displayName = "count".equals(algorithm) ? displayName + ResManager.loadKDString((String)"\uff08\u8ba1\u6570\uff09", (String)"ReportManageEditPlugin_17", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]) : displayName + ResManager.loadKDString((String)"\uff08\u53bb\u91cd\u8ba1\u6570\uff09", (String)"ReportManageEditPlugin_18", (String)"hrmp-hrptmc-formplugin", (Object[])new Object[0]);
        indexFieldInfo.setFieldName(new LocaleString(displayName));
        indexFieldInfo.setSourceValueType(indexFieldInfo.getValueType());
        indexFieldInfo.setValueType(DataTypeEnum.INTEGER.getDataTypeKey());
        indexFieldInfo.setControlType(FieldControlType.INTEGER.getValue());
        indexFieldInfo.setEntityNumber(queryFieldBo.getEntityNumber());
        indexFieldInfo.setBaseDataNum(queryFieldBo.getBaseDataNum());
        return indexFieldInfo;
    }

    public static IndexFieldInfo pivotIndexFieldBo2IndexFieldInfo(PivotIndexFieldBo analysePivotIndex) {
        IndexFieldInfo indexFieldInfo = new IndexFieldInfo();
        indexFieldInfo.setFieldId(analysePivotIndex.getId());
        indexFieldInfo.setFieldName(analysePivotIndex.getFieldName());
        indexFieldInfo.setFieldAlias(analysePivotIndex.getFieldAlias());
        indexFieldInfo.setFieldPath(analysePivotIndex.getFieldPath());
        indexFieldInfo.setValueType(analysePivotIndex.getValueType());
        indexFieldInfo.setControlType(analysePivotIndex.getControlType());
        indexFieldInfo.setFieldNumber(analysePivotIndex.getFieldAlias());
        indexFieldInfo.setFieldSrc("0");
        indexFieldInfo.setVirtualEntityField(false);
        indexFieldInfo.setPivotIndex(true);
        indexFieldInfo.setPivotDimAlias(analysePivotIndex.getPivotDimAlias());
        indexFieldInfo.setPivotDimName(analysePivotIndex.getPivotDimName());
        indexFieldInfo.setPivotDimVal(analysePivotIndex.getPivotDimVal());
        indexFieldInfo.setPivotIndexAlias(analysePivotIndex.getPivotIndexAlias());
        indexFieldInfo.setEntityNumber(analysePivotIndex.getEntityNumber());
        indexFieldInfo.setBaseDataNum(analysePivotIndex.getBaseDataNum());
        return indexFieldInfo;
    }

    public static List<IndexFieldInfo> calculateFieldBos2IndexFieldInfos(List<CalculateFieldBo> calculateFieldBos) {
        ArrayList indexFieldInfos = Lists.newArrayListWithCapacity((int)calculateFieldBos.size());
        for (CalculateFieldBo calculateFieldBo : calculateFieldBos) {
            indexFieldInfos.add(TransformUtil.calculateFieldBo2IndexFieldInfo(calculateFieldBo));
        }
        return indexFieldInfos;
    }

    public static IndexFieldInfo calculateFieldBo2IndexFieldInfo(CalculateFieldBo calculateFieldBo) {
        IndexFieldInfo indexFieldInfo = new IndexFieldInfo();
        indexFieldInfo.setFieldId(calculateFieldBo.getId());
        indexFieldInfo.setFieldName(calculateFieldBo.getFieldName());
        indexFieldInfo.setFieldAlias(calculateFieldBo.getFieldNumber());
        indexFieldInfo.setValueType(calculateFieldBo.getValueType());
        indexFieldInfo.setControlType(calculateFieldBo.getControlType());
        indexFieldInfo.setFieldSrc("1");
        indexFieldInfo.setCalcFieldSrc(calculateFieldBo.getSource());
        indexFieldInfo.setBaseDataNum(calculateFieldBo.getBaseDataNum());
        indexFieldInfo.setCalMethod(calculateFieldBo.getCalMethod());
        if (CollectionUtils.isEmpty((Collection)calculateFieldBo.getRefPreIndexes())) {
            indexFieldInfo.setAlgorithm("sum");
        }
        indexFieldInfo.setCalculateField(true);
        return indexFieldInfo;
    }

    public static DimensionFieldInfo calculateFieldBo2DimensionFieldInfo(CalculateFieldBo calculateFieldBo) {
        DimensionFieldInfo dimensionFieldInfo = new DimensionFieldInfo();
        dimensionFieldInfo.setFieldId(calculateFieldBo.getId());
        dimensionFieldInfo.setFieldName(calculateFieldBo.getFieldName());
        dimensionFieldInfo.setFieldAlias(calculateFieldBo.getFieldNumber());
        dimensionFieldInfo.setFieldPath(calculateFieldBo.getFieldNumber());
        dimensionFieldInfo.setValueType(calculateFieldBo.getValueType());
        dimensionFieldInfo.setControlType(calculateFieldBo.getControlType());
        dimensionFieldInfo.setFieldSrc("1");
        dimensionFieldInfo.setCanDrag(calculateFieldBo.getDimCount() <= 500);
        dimensionFieldInfo.setCanTrans(calculateFieldBo.getDimCount() <= HRReportParamUtils.getPivotDimCountThresh());
        dimensionFieldInfo.setDimQuantity(calculateFieldBo.getDimCount().intValue());
        dimensionFieldInfo.setCalculateField(true);
        dimensionFieldInfo.setGroupField(calculateFieldBo.getGroupField().booleanValue());
        dimensionFieldInfo.setGroupFieldId(calculateFieldBo.getGroupFieldId());
        return dimensionFieldInfo;
    }

    public static EntityPropField fieldInfo2EntityPropField(FieldInfo fieldInfo) {
        if (HRStringUtils.equals((String)"2", (String)fieldInfo.getType())) {
            return TransformUtil.fieldInfo2EntityPrimitiveIndexField(fieldInfo);
        }
        if (HRStringUtils.equals((String)"1", (String)fieldInfo.getType())) {
            return TransformUtil.fieldInfo2LatitudeField(fieldInfo);
        }
        return null;
    }

    public static LatitudeField fieldInfo2LatitudeField(FieldInfo fieldInfo) {
        LatitudeField latitudeField = new LatitudeField();
        if (fieldInfo.getRowFieldId() != null) {
            latitudeField.setFieldId(Long.valueOf(Long.parseLong(fieldInfo.getRowFieldId())));
        }
        latitudeField.setFieldAlias(fieldInfo.getNumber());
        latitudeField.setFieldType(fieldInfo.getValueType());
        latitudeField.setPropFullPath(fieldInfo.getFieldPath());
        latitudeField.setUniqueKey(fieldInfo.getNumberAlias());
        latitudeField.setPropName(fieldInfo.getName().getLocaleValue());
        latitudeField.setFieldComplexType(FieldComplexType.getEnum((String)fieldInfo.getComplexType()));
        latitudeField.setFieldControlType(FieldControlType.getFieldControlTypeByValue((String)fieldInfo.getControlType()));
        latitudeField.setShowAllColValue(fieldInfo.getShowEmptyCol());
        latitudeField.setBaseDataNumber(fieldInfo.getBaseDataNum());
        latitudeField.setSortord(fieldInfo.getSort());
        latitudeField.setCustomSort(fieldInfo.getCustomSort());
        latitudeField.setFieldSort(fieldInfo.getFieldSortInfo());
        return latitudeField;
    }

    public static EntityPrimitiveIndexField fieldInfo2EntityPrimitiveIndexField(FieldInfo fieldInfo) {
        EntityPrimitiveIndexField entityPrimitiveIndexField = new EntityPrimitiveIndexField();
        entityPrimitiveIndexField.setFieldAlias(fieldInfo.getNumber());
        entityPrimitiveIndexField.setFieldType(fieldInfo.getValueType());
        entityPrimitiveIndexField.setPropFullPath(fieldInfo.getFieldPath());
        entityPrimitiveIndexField.setPropName(fieldInfo.getName().getLocaleValue());
        entityPrimitiveIndexField.setCalcFunction(fieldInfo.getAlgorithm());
        entityPrimitiveIndexField.setUniqueKey(fieldInfo.getNumberAlias());
        entityPrimitiveIndexField.setFieldSort(fieldInfo.getFieldSortInfo());
        entityPrimitiveIndexField.setSortord(fieldInfo.getSort());
        return entityPrimitiveIndexField;
    }

    public static PresetIndexField fieldInfo2PresetIndexField(FieldInfo fieldInfo) {
        PresetIndexServiceHelper helper = new PresetIndexServiceHelper();
        String preIndexFrom = helper.getGetWayById((Object)Long.valueOf(fieldInfo.getFieldId()));
        if ("10".equals(preIndexFrom)) {
            BizServicePresetIndexField bizServicePresetIndexField = new BizServicePresetIndexField();
            bizServicePresetIndexField.setFieldAlias(fieldInfo.getNumber());
            bizServicePresetIndexField.setFieldType(fieldInfo.getValueType());
            bizServicePresetIndexField.setUniqueKey(fieldInfo.getNumberAlias());
            bizServicePresetIndexField.setPresetIndexInfo(fieldInfo.getNumber());
            return bizServicePresetIndexField;
        }
        AnalysisObjectPresetIndexField analysisObjectPresetIndexField = new AnalysisObjectPresetIndexField();
        analysisObjectPresetIndexField.setFieldAlias(fieldInfo.getNumber());
        analysisObjectPresetIndexField.setFieldType(fieldInfo.getValueType());
        analysisObjectPresetIndexField.setUniqueKey(fieldInfo.getNumberAlias());
        analysisObjectPresetIndexField.setPresetIndexInfo(fieldInfo.getNumber());
        return analysisObjectPresetIndexField;
    }

    public static ReportField fieldInfo2ReportField(FieldInfo fieldInfo, CalculateFieldBo calculateFieldBo) {
        return TransformUtil.fieldInfo2ReportField(fieldInfo, calculateFieldBo, null);
    }

    public static ReportField fieldInfo2ReportField(FieldInfo fieldInfo, CalculateFieldBo calculateFieldBo, DimMapBo dimMap) {
        if ("1".equals(fieldInfo.getType())) {
            if ("0".equals(fieldInfo.getFieldSrc())) {
                return TransformUtil.fieldInfo2LatitudeField(fieldInfo);
            }
            if ("1".equals(fieldInfo.getFieldSrc())) {
                return TransformUtil.calculateFieldBo2ReportField(fieldInfo, calculateFieldBo);
            }
        } else if ("2".equals(fieldInfo.getType())) {
            if ("0".equals(fieldInfo.getFieldSrc())) {
                return TransformUtil.fieldInfo2EntityPrimitiveIndexField(fieldInfo);
            }
            if ("1".equals(fieldInfo.getFieldSrc())) {
                return TransformUtil.calculateFieldBo2ReportField(fieldInfo, calculateFieldBo);
            }
            if ("2".equals(fieldInfo.getFieldSrc())) {
                PresetIndexField presetIndexField = TransformUtil.fieldInfo2PresetIndexField(fieldInfo);
                presetIndexField.setDimMap(dimMap);
                return presetIndexField;
            }
        }
        return null;
    }

    public static ReportField calculateFieldBo2ReportField(FieldInfo fieldInfo, CalculateFieldBo calculateFieldBo) {
        if (CollectionUtils.isNotEmpty((Collection)calculateFieldBo.getRefPreIndexes()) || "summary".equals(calculateFieldBo.getCalMethod())) {
            return TransformUtil.calculateFieldBo2NonAggregateIndexField(fieldInfo, calculateFieldBo);
        }
        return TransformUtil.calculateFieldBo2AggregateIndexField(fieldInfo, calculateFieldBo);
    }

    public static NonAggregateIndexField calculateFieldBo2NonAggregateIndexField(FieldInfo fieldInfo, CalculateFieldBo calculateFieldBo) {
        NonAggregateIndexField nonAggregateIndexField = new NonAggregateIndexField();
        nonAggregateIndexField.setFieldAlias(calculateFieldBo.getFieldNumber());
        nonAggregateIndexField.setFieldType(calculateFieldBo.getValueType());
        nonAggregateIndexField.setCalcFormulaInfo(calculateFieldBo.getExpr());
        if (null != fieldInfo) {
            nonAggregateIndexField.setUniqueKey(fieldInfo.getNumberAlias());
        }
        HashSet dependentFieldSet = new HashSet(calculateFieldBo.getRefEntityFields());
        dependentFieldSet.addAll(calculateFieldBo.getRefCalculateFields().stream().map(CalculateFieldBo::getFieldNumber).collect(Collectors.toList()));
        dependentFieldSet.addAll(calculateFieldBo.getRefPreIndexes().stream().map(PreIndexBo::getFieldNumber).collect(Collectors.toList()));
        nonAggregateIndexField.setDependentFieldSet(dependentFieldSet);
        return nonAggregateIndexField;
    }

    public static AggregateIndexField calculateFieldBo2AggregateIndexField(FieldInfo fieldInfo, CalculateFieldBo calculateFieldBo) {
        AggregateIndexField aggregateIndexField = new AggregateIndexField();
        aggregateIndexField.setFieldAlias(calculateFieldBo.getFieldNumber());
        aggregateIndexField.setFieldType(calculateFieldBo.getValueType());
        aggregateIndexField.setCalcFormulaInfo(calculateFieldBo.getExpr());
        if (null != fieldInfo) {
            aggregateIndexField.setCalcFunction(fieldInfo.getAlgorithm());
            aggregateIndexField.setUniqueKey(fieldInfo.getNumberAlias());
        }
        HashSet dependentFieldSet = new HashSet(calculateFieldBo.getRefEntityFields());
        dependentFieldSet.addAll(calculateFieldBo.getRefCalculateFields().stream().map(CalculateFieldBo::getFieldNumber).collect(Collectors.toList()));
        dependentFieldSet.addAll(calculateFieldBo.getRefPreIndexes().stream().map(PreIndexBo::getFieldNumber).collect(Collectors.toList()));
        aggregateIndexField.setDependentFieldSet(dependentFieldSet);
        return aggregateIndexField;
    }

    public static List<ReportField> getDependFields(AnObjDetailInfo anObjDetailInfo, List<FieldInfo> calcFields, ReportQueryParamInfo reportQueryParamInfo) {
        List queryFields;
        HashSet<PreIndexBo> refPreIndexFields = new HashSet<PreIndexBo>();
        HashSet<String> refQueryFieldNumbers = new HashSet<String>();
        List<Object> refAnObjCalFields = new ArrayList<CalculateFieldBo>();
        List<Object> refReportCalFields = new ArrayList<CalculateFieldBo>();
        HashMap aggregationMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty((Collection)anObjDetailInfo.getAnObjCalFields())) {
            List<CalculateFieldBo> anObjCalFields = anObjDetailInfo.getAnObjCalFields().stream().filter(anObjCalField -> calcFields.stream().anyMatch(calcField -> calcField.getNumber().equals(anObjCalField.getFieldNumber()))).collect(Collectors.toList());
            anObjCalFields.forEach(field -> aggregationMap.putAll(field.getAggregationMap()));
            TransformUtil.handleRefField(anObjCalFields, refPreIndexFields, refAnObjCalFields, refQueryFieldNumbers);
        }
        if (!CollectionUtils.isEmpty((Collection)anObjDetailInfo.getReportCalFields())) {
            List<CalculateFieldBo> reportCalFields = anObjDetailInfo.getReportCalFields().stream().filter(anObjCalField -> calcFields.stream().anyMatch(calcField -> calcField.getNumber().equals(anObjCalField.getFieldNumber()))).collect(Collectors.toList());
            reportCalFields.forEach(field -> aggregationMap.putAll(field.getAggregationMap()));
            TransformUtil.handleRefField(reportCalFields, refPreIndexFields, refReportCalFields, refQueryFieldNumbers);
        }
        if ((queryFields = anObjDetailInfo.getQueryFields()) == null) {
            queryFields = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(Long.valueOf(Long.parseLong(anObjDetailInfo.getAnObj().getId())));
        }
        if (anObjDetailInfo.getAnObj() != null && !HRStringUtils.isEmpty((String)anObjDetailInfo.getAnObj().getId())) {
            List analysePivotIndexes = AnalyseObjectService.getInstance().getAnalysePivotIndexes(Long.valueOf(anObjDetailInfo.getAnObj().getId()), queryFields, anObjDetailInfo.getAnObjCalFields(), false);
            for (PivotIndexFieldBo analysePivotIndex : analysePivotIndexes) {
                if (queryFields.stream().anyMatch(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)analysePivotIndex.getFieldAlias()))) continue;
                QueryFieldBo pivotIndexFieldBo = new QueryFieldBo();
                pivotIndexFieldBo.setFieldName(analysePivotIndex.getFieldName());
                pivotIndexFieldBo.setFieldAlias(analysePivotIndex.getFieldAlias());
                pivotIndexFieldBo.setFieldPath(analysePivotIndex.getFieldAlias());
                pivotIndexFieldBo.setEntityNumber(((QueryFieldBo)queryFields.get(0)).getEntityNumber());
                pivotIndexFieldBo.setValueType(analysePivotIndex.getValueType());
                queryFields.add(pivotIndexFieldBo);
            }
        }
        Set<QueryFieldBo> refQueryFields = queryFields.stream().filter(queryFieldBo -> refQueryFieldNumbers.contains(queryFieldBo.getFieldAlias())).collect(Collectors.toSet());
        ArrayList<ReportField> rowFieldList = new ArrayList<ReportField>(16);
        rowFieldList.addAll(TransformUtil.preIndexBos2PreIdxFields(refPreIndexFields));
        rowFieldList.addAll(TransformUtil.queryFieldBos2EntityPropFields(refQueryFields, aggregationMap));
        refAnObjCalFields = refAnObjCalFields.stream().sorted(Comparator.comparingInt(CalculateFieldBo::getOrder)).collect(Collectors.toList());
        rowFieldList.addAll(TransformUtil.calculateFieldBos2ReportFields(TransformUtil.distinctList(refAnObjCalFields), aggregationMap));
        refReportCalFields = refReportCalFields.stream().sorted(Comparator.comparingInt(CalculateFieldBo::getOrder)).collect(Collectors.toList());
        rowFieldList.addAll(TransformUtil.calculateFieldBos2ReportFields(TransformUtil.distinctList(refReportCalFields), aggregationMap));
        boolean dataStore = reportQueryParamInfo.isDataStore();
        if (dataStore) {
            rowFieldList.forEach(reportField -> reportField.setDependField(false));
        } else {
            rowFieldList.forEach(reportField -> reportField.setDependField(true));
        }
        return rowFieldList;
    }

    private static List<CalculateFieldBo> distinctList(List<CalculateFieldBo> calFields) {
        ArrayList<String> filterCalFields = new ArrayList<String>();
        ArrayList<CalculateFieldBo> distinctCalFields = new ArrayList<CalculateFieldBo>();
        for (CalculateFieldBo calculateFieldBo : calFields) {
            if (filterCalFields.contains(calculateFieldBo.getFieldNumber())) continue;
            filterCalFields.add(calculateFieldBo.getFieldNumber());
            distinctCalFields.add(calculateFieldBo);
        }
        return distinctCalFields;
    }

    private static void handleRefField(List<CalculateFieldBo> calculateFields, Set<PreIndexBo> refPreIndexBos, List<CalculateFieldBo> refCalFields, Set<String> refQueryFields) {
        for (CalculateFieldBo calculateFieldBo : calculateFields) {
            refQueryFields.addAll(calculateFieldBo.getRefEntityFields());
            refPreIndexBos.addAll(calculateFieldBo.getRefPreIndexes());
            refCalFields.addAll(calculateFieldBo.getRefCalculateFields());
            if (CollectionUtils.isEmpty((Collection)calculateFieldBo.getRefCalculateFields())) continue;
            TransformUtil.handleRefField(calculateFieldBo.getRefCalculateFields(), refPreIndexBos, refCalFields, refQueryFields);
        }
    }

    private static List<EntityPropField> queryFieldBos2EntityPropFields(Collection<QueryFieldBo> refQueryFields, Map<String, String> aggregationMap) {
        ArrayList<EntityPropField> entityPropFields = new ArrayList<EntityPropField>(refQueryFields.size());
        for (QueryFieldBo queryFieldBo : refQueryFields) {
            if (TransformUtil.isIndex(queryFieldBo.getValueType()) && !queryFieldBo.getFieldAlias().endsWith(".id")) {
                EntityPrimitiveIndexField entityPrimitiveIndexField = TransformUtil.queryFieldBo2EntityPrimitiveIndexField(queryFieldBo);
                String aggregation = aggregationMap.get(queryFieldBo.getFieldAlias());
                if (HRStringUtils.isNotEmpty((String)aggregation)) {
                    entityPrimitiveIndexField.setCalcFunction(aggregation);
                }
                entityPropFields.add((EntityPropField)entityPrimitiveIndexField);
                continue;
            }
            entityPropFields.add((EntityPropField)TransformUtil.queryFieldBo2LatitudeField(queryFieldBo));
        }
        return entityPropFields;
    }

    public static EntityPropField queryFieldBo2EntityPropField(QueryFieldBo queryFieldBo) {
        if (TransformUtil.isIndex(queryFieldBo.getValueType())) {
            return TransformUtil.queryFieldBo2EntityPrimitiveIndexField(queryFieldBo);
        }
        return TransformUtil.queryFieldBo2LatitudeField(queryFieldBo);
    }

    private static EntityPrimitiveIndexField queryFieldBo2EntityPrimitiveIndexField(QueryFieldBo queryFieldBo) {
        EntityPrimitiveIndexField entityPrimitiveIndexField = new EntityPrimitiveIndexField();
        entityPrimitiveIndexField.setFieldAlias(queryFieldBo.getFieldAlias());
        entityPrimitiveIndexField.setFieldType(queryFieldBo.getValueType());
        entityPrimitiveIndexField.setPropFullPath(queryFieldBo.getFieldPath());
        entityPrimitiveIndexField.setPropName(queryFieldBo.getFieldName().getLocaleValue());
        return entityPrimitiveIndexField;
    }

    private static LatitudeField queryFieldBo2LatitudeField(QueryFieldBo queryFieldBo) {
        LatitudeField latitudeField = new LatitudeField();
        latitudeField.setFieldAlias(queryFieldBo.getFieldAlias());
        latitudeField.setFieldType(queryFieldBo.getValueType());
        latitudeField.setPropFullPath(queryFieldBo.getFieldPath());
        latitudeField.setPropName(queryFieldBo.getFieldName().getLocaleValue());
        return latitudeField;
    }

    private static List<PresetIndexField> preIndexBos2PreIdxFields(Collection<PreIndexBo> preIndexBos) {
        ArrayList<PresetIndexField> entityPropFields = new ArrayList<PresetIndexField>(preIndexBos.size());
        for (PreIndexBo preIndexBo : preIndexBos) {
        }
        return entityPropFields;
    }

    private static BizServicePresetIndexField queryFieldBo2BizServicePreIdxField(PreIndexBo preIndexBo) {
        BizServicePresetIndexField field = new BizServicePresetIndexField();
        return field;
    }

    private static AnalysisObjectPresetIndexField queryFieldBo2AnObjPreIdxField(PreIndexBo preIndexBo) {
        AnalysisObjectPresetIndexField field = new AnalysisObjectPresetIndexField();
        return field;
    }

    private static List<ReportField> calculateFieldBos2ReportFields(Collection<CalculateFieldBo> refCalFields, Map<String, String> aggregationMap) {
        ArrayList<ReportField> reportFields = new ArrayList<ReportField>(refCalFields.size());
        for (CalculateFieldBo calculateFieldBo : refCalFields) {
            if (CollectionUtils.isNotEmpty((Collection)calculateFieldBo.getRefPreIndexes()) || HRStringUtils.equals((String)calculateFieldBo.getCalMethod(), (String)"summary")) {
                reportFields.add((ReportField)TransformUtil.calculateFieldBo2NonAggregateIndexField(null, calculateFieldBo));
                continue;
            }
            AggregateIndexField aggregateIndexField = TransformUtil.calculateFieldBo2AggregateIndexField(null, calculateFieldBo);
            String aggregation = aggregationMap.get(calculateFieldBo.getFieldNumber());
            if (HRStringUtils.isNotEmpty((String)aggregation)) {
                aggregateIndexField.setCalcFunction(aggregation);
            }
            reportFields.add((ReportField)aggregateIndexField);
        }
        return reportFields;
    }

    public static List<PreIndexBo> indexFieldInfos2PreIdxBos(List<IndexFieldInfo> preIdxs) {
        ArrayList<PreIndexBo> preIndexBos = new ArrayList<PreIndexBo>(preIdxs.size());
        for (IndexFieldInfo indexFieldInfo : preIdxs) {
            PreIndexBo preIndexBo = new PreIndexBo();
            preIndexBo.setId(indexFieldInfo.getFieldId());
            preIndexBo.setFieldName(indexFieldInfo.getFieldName().getLocaleValue());
            preIndexBo.setFieldNumber(indexFieldInfo.getFieldAlias());
            preIndexBos.add(preIndexBo);
        }
        return preIndexBos;
    }
}

