/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.formplugin.web.repdesign.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.ReportManageConfigInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.business.repdesign.info.WorkRptInfo;
import kd.hr.hrptmc.common.constant.repdesign.ReportManageConstants;
import kd.hr.hrptmc.formplugin.web.preindex.util.PreIndexPageUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.FieldInfoUtil;
import kd.hr.hrptmc.formplugin.web.repdesign.util.ReportManageUtil;

public class WorkRptUtil
implements ReportManageConstants {
    public static List<WorkRptInfo> getWorkRpt(Long reportManageId, AnObjDetailInfo anObjDetail) {
        DynamicObject[] dys = ReportManageService.getWorkRpt((Long)reportManageId);
        ArrayList<WorkRptInfo> workRptInfoList = new ArrayList<WorkRptInfo>(dys.length);
        if (0 == dys.length) {
            WorkRptInfo workRptInfo = WorkRptUtil.genWorkRptInfo();
            workRptInfoList.add(workRptInfo);
            return workRptInfoList;
        }
        for (int i = 0; i < dys.length; ++i) {
            String columnStr;
            DynamicObject dy = dys[i];
            WorkRptInfo workRptInfo = new WorkRptInfo();
            long workRptId = dy.getLong("id");
            workRptInfo.setWorkRptId(String.valueOf(workRptId));
            workRptInfo.setShow(i == 0);
            workRptInfo.setKey(dy.getInt("key"));
            String rowStr = dy.getString("row");
            if (StringUtils.isNotEmpty((CharSequence)rowStr)) {
                List rows = SerializationUtils.fromJsonStringToList((String)rowStr, RowFieldInfo.class);
                FieldInfoUtil.handleRowFieldName(workRptId, rows, anObjDetail);
                FieldInfoUtil.handleRowFieldAlign(rows);
                workRptInfo.setRows(rows);
            }
            if (StringUtils.isNotEmpty((CharSequence)(columnStr = dy.getString("column")))) {
                List columns = SerializationUtils.fromJsonStringToList((String)columnStr, FieldInfo.class);
                FieldInfoUtil.handleColFieldName(workRptId, columns, anObjDetail);
                workRptInfo.setColumns(columns);
            }
            workRptInfo.setReportConfig(ReportManageUtil.getReportConfig(workRptId));
            workRptInfo.setDimMaps(PreIndexPageUtil.getDimMapsByReportId(workRptId));
            workRptInfoList.add(workRptInfo);
        }
        return workRptInfoList;
    }

    public static int genKey(List<WorkRptInfo> workRptInfoList) {
        int i;
        List keys = workRptInfoList.stream().map(WorkRptInfo::getKey).sorted().collect(Collectors.toList());
        for (i = 0; i < keys.size(); ++i) {
            if (i + 1 == (Integer)keys.get(i)) continue;
            return i + 1;
        }
        return i + 1;
    }

    public static WorkRptInfo getCurWorkRptInfo(List<WorkRptInfo> workRptInfoList) {
        return workRptInfoList.stream().filter(WorkRptInfo::getShow).findAny().orElse(null);
    }

    public static WorkRptInfo genWorkRptInfo() {
        WorkRptInfo workRptInfo = new WorkRptInfo();
        workRptInfo.setShow(true);
        workRptInfo.setWorkRptId(String.valueOf(ORM.create().genLongId("hrptmc_workreport")));
        return workRptInfo;
    }

    public static void switchWorkRpt(ReportManageConfigInfo rptMngCfgInfo, int num) {
        List workRptInfoList = rptMngCfgInfo.getWorkRpt();
        for (int i = 0; i < workRptInfoList.size(); ++i) {
            ((WorkRptInfo)workRptInfoList.get(i)).setShow(i == num);
        }
    }

    public static void switchWorkRpt(ReportManageConfigInfo rptMngCfgInfo, String id) {
        List workRptInfoList = rptMngCfgInfo.getWorkRpt();
        for (int i = 0; i < workRptInfoList.size(); ++i) {
            WorkRptInfo workRptInfo = (WorkRptInfo)workRptInfoList.get(i);
            workRptInfo.setShow(HRStringUtils.equals((String)workRptInfo.getWorkRptId(), (String)id));
        }
    }

    public static boolean isMulWorkRpt(ReportManageConfigInfo rptMngCfgInfo) {
        return !CollectionUtils.isEmpty((Collection)rptMngCfgInfo.getWorkRpt()) && rptMngCfgInfo.getWorkRpt().size() > 1;
    }
}

