/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.model.ofd;

import java.io.IOException;
import java.util.List;
import kd.imc.bdm.file.fpy.model.ofd.OFDDocument;
import kd.imc.bdm.file.fpy.model.ofd.OFDObject;
import kd.imc.bdm.file.fpy.model.ofd.OFDSize;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class OFDTemplate
extends OFDObject {
    private Document templateDoc;
    private final int index;
    private final String id;
    private final OFDDocument doc;
    private Element layerInfo;
    private OFDSize ofdSize;

    public OFDTemplate(OFDDocument doc, String ID, int index, List<Element> eleList, OFDSize ofdSize) {
        this.doc = doc;
        this.id = ID;
        this.index = index;
        try {
            this.templateDoc = XmlHelperUtils.createDocument("ofd:Page");
            Element rootElement = this.templateDoc.getRootElement();
            Element areaTemplate = rootElement.addElement("ofd:Area");
            Element physicalBoxEle = areaTemplate.addElement("ofd:PhysicalBox");
            physicalBoxEle.setText(ofdSize.toString());
            this.ofdSize = ofdSize;
            Element contentEle = rootElement.addElement("ofd:Content");
            this.layerInfo = contentEle.addElement("ofd:Layer");
            this.layerInfo.addAttribute("ID", "6");
            if (eleList != null && !eleList.isEmpty()) {
                for (Element item : eleList) {
                    Element copy = item.createCopy();
                    this.layerInfo.add(copy);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getID() {
        return this.id;
    }

    public OFDSize getOfdSize() {
        return this.ofdSize;
    }

    public void addElementList(List<Element> eleList) {
        if (eleList != null && !eleList.isEmpty()) {
            for (Element item : eleList) {
                Element copy = item.createCopy();
                copy.addAttribute("ID", this.doc.getNewID());
                this.layerInfo.add(copy);
            }
        }
    }

    @Override
    public String getPath() {
        String strPath = this.doc.getPath();
        return strPath + "Tpls" + "/" + "Tpl_" + this.index + "/";
    }

    @Override
    public void flush() throws IOException {
        String strPath = this.getPath();
        byte[] bytes = XmlHelperUtils.toByteArray(this.templateDoc);
        this.doc.getOfdFile().p_AddFile(strPath + "Content.xml", bytes);
    }
}

