/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.ofd.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.file.fpy.service.ofd.util.StandaloneWriter;
import kd.imc.bdm.file.util.ErrorType;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlHelperUtils {
    private static Log log = LogFactory.getLog(XmlHelperUtils.class);

    public static Document loadXML(String xml) {
        Document document;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0420.errcode, ResManager.loadKDString((String)"\u6a21\u7248\u89e3\u6790\u51fa\u73b0\u9519\u8bef!", (String)"XmlHelperUtils_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        return document;
    }

    public static Document createDocument(String rootName) {
        Element root = DocumentHelper.createElement((String)rootName);
        root.addNamespace("ofd", "http://www.ofdspec.org/2016");
        return DocumentHelper.createDocument((Element)root);
    }

    public static Element addNode(Element parentNode, String nodeName, String nodeText) {
        Element element = parentNode.addElement(nodeName);
        if (StringUtils.isNotEmpty((CharSequence)nodeText)) {
            element.setText(nodeText);
        }
        return element;
    }

    public static void addNotEmptyNode(Element parentNode, String nodeName, String nodeText) {
        if (StringUtils.isNotEmpty((CharSequence)nodeText)) {
            Element element = parentNode.addElement(nodeName);
            element.setText(nodeText);
        }
    }

    public static void addLabel(Element parentNode, String labelType, String labelCode, String labelName) {
        XmlHelperUtils.addLabelByKey(parentNode, "Label", labelType, labelCode, labelName);
    }

    public static void addLabelByKey(Element parentNode, String key, String labelType, String labelCode, String labelName) {
        Element labelElement = parentNode.addElement(key);
        XmlHelperUtils.addNotEmptyNode(labelElement, "LabelType", labelType);
        XmlHelperUtils.addNotEmptyNode(labelElement, "LabelCode", labelCode);
        XmlHelperUtils.addNotEmptyNode(labelElement, "LabelName", labelName);
    }

    public static Element addNode(Element parentNode, String nodeName, String attributeName, String nodeText) {
        Element element = parentNode.addElement(nodeName);
        if (nodeText != null) {
            element.setText(nodeText);
        }
        if (attributeName != null) {
            element.addAttribute("Name", attributeName);
        }
        return element;
    }

    public static void addRefNode(Element parentNode, String nodeName, String nodeText, String pageId) {
        if (nodeText == null) {
            return;
        }
        Element nodeElement = parentNode.addElement(nodeName);
        Element refElement = XmlHelperUtils.addNode(nodeElement, "ofd:ObjectRef", nodeText);
        refElement.addAttribute("PageRef", pageId);
    }

    public static byte[] toByteArray(Document document) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setTrimText(false);
        XMLWriter xmlWriter = new XMLWriter((OutputStream)bos, format);
        xmlWriter.write(document);
        xmlWriter.close();
        byte[] bts = bos.toByteArray();
        bos.close();
        return bts;
    }

    public static byte[] toStandaloneByteArray(Document document) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setTrimText(false);
        StandaloneWriter xmlWriter = new StandaloneWriter(bos, format);
        xmlWriter.write(document);
        xmlWriter.close();
        byte[] bts = bos.toByteArray();
        bos.close();
        return bts;
    }

    public static int getAttributeValue(Element element, String key, int defaultValue) {
        try {
            String attributeValue;
            if (element != null && (attributeValue = element.attributeValue(key)) != null) {
                return Integer.parseInt(attributeValue);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5c5e\u6027\u503c{}\u51fa\u9519", (Object)key, (Object)e);
        }
        return defaultValue;
    }
}

