/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LoadFontUtils {
    private static Log LOGGER = LogFactory.getLog(LoadFontUtils.class);
    private static String flag = null;

    public static synchronized void init() {
        if (flag == null) {
            String baseDir = LoadFontUtils.getFontDir();
            LOGGER.info("\u52a0\u8f7d\u5b57\u4f53\u76ee\u5f55-" + baseDir);
            if (baseDir != null) {
                Set<String> list = LoadFontUtils.getFontList();
                for (String file : list) {
                    LoadFontUtils.loadFont(baseDir, file);
                }
            }
        }
        flag = "load";
    }

    private static String getFontDir() {
        String osName = System.getProperty("os.name");
        String deaultDir = StringUtils.cleanPath((String)(System.getProperty("user.home") + File.separator + ".fonts" + File.separator));
        if (osName.startsWith("Windows")) {
            return deaultDir;
        }
        if (osName.startsWith("Mac")) {
            return StringUtils.cleanPath((String)(System.getProperty("user.home") + File.separator + "Library" + File.separator));
        }
        return deaultDir;
    }

    private static Set<String> getFontListConfig() {
        LinkedHashSet<String> list = new LinkedHashSet<String>(32);
        try (InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/font_list.xml");){
            SAXReader sax = new SAXReader();
            Document document = sax.read(inStream);
            Element root = document.getRootElement();
            List listMeta = root.elements("font");
            for (Element elem : listMeta) {
                list.add(elem.getText());
            }
            LOGGER.info("\u52a0\u8f7d\u5b57\u4f53\u914d\u7f6e\u6210\u529f{}", (Object)list.size());
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u5b57\u4f53\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        return list;
    }

    private static Set<String> getFontList() {
        Set<String> list = LoadFontUtils.getFontListConfig();
        list.add(".uuid");
        list.add("arialuni.ttf");
        list.add("cour.ttf");
        list.add("dejavu/.uuid");
        list.add("dejavu/DejaVuSans-Bold.ttf");
        list.add("dejavu/DejaVuSans-BoldOblique.ttf");
        list.add("dejavu/DejaVuSans-ExtraLight.ttf");
        list.add("dejavu/DejaVuSans-Oblique.ttf");
        list.add("dejavu/DejaVuSans.ttf");
        list.add("dejavu/DejaVuSansCondensed-Bold.ttf");
        list.add("dejavu/DejaVuSansCondensed-BoldOblique.ttf");
        list.add("dejavu/DejaVuSansCondensed-Oblique.ttf");
        list.add("dejavu/DejaVuSansCondensed.ttf");
        list.add("fonts.dir");
        list.add("fonts.scale");
        list.add("lyx/cmex10.ttf");
        list.add("lyx/cmmi10.ttf");
        list.add("lyx/cmr10.ttf");
        list.add("lyx/cmsy10.ttf");
        list.add("lyx/esint10.ttf");
        list.add("lyx/eufm10.ttf");
        list.add("lyx/msam10.ttf");
        list.add("lyx/msbm10.ttf");
        list.add("lyx/rsfs10.ttf");
        list.add("lyx/stmary10.ttf");
        list.add("lyx/wasy10.ttf");
        list.add("normal/arial.ttf");
        list.add("normal/arialbd.ttf");
        list.add("normal/arialbi.ttf");
        list.add("normal/ariali.ttf");
        list.add("normal/ARIALN.TTF");
        list.add("normal/ARIALNB.TTF");
        list.add("normal/ARIALNBI.TTF");
        list.add("normal/ARIALNI.TTF");
        list.add("normal/ARIALUNI.TTF");
        list.add("normal/fonts.dir");
        list.add("normal/fonts.scale");
        list.add("simkai.ttf");
        list.add("simsun.ttc");
        list.add("stix/STIX-Bold.otf");
        list.add("stix/STIX-BoldItalic.otf");
        list.add("stix/STIX-Italic.otf");
        list.add("stix/STIX-Regular.otf");
        return list;
    }

    public static void loadFont(String basePath, String template) {
        String templatePath = FilenameUtils.getPath((String)template) + FilenameUtils.getName((String)template);
        String fileName = StringUtils.cleanPath((String)(basePath + templatePath));
        File file = new File(basePath, FilenameUtils.getName((String)template));
        boolean flag = file.getParentFile().mkdirs();
        LOGGER.info("\u52a0\u8f7d\u5b57\u4f53\u521b\u5efa\u76ee\u5f55{}-{}", (Object)fileName, (Object)flag);
        try (InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("fonts/" + templatePath);
             FileOutputStream fos = new FileOutputStream(fileName);){
            int length;
            if (inStream == null) {
                return;
            }
            byte[] b = new byte[1024];
            while ((length = inStream.read(b)) > 0) {
                fos.write(b, 0, length);
            }
            LOGGER.info("\u52a0\u8f7d\u5b57\u4f53\u521b\u5efa\u76ee\u5f55{}\u6210\u529f", (Object)fileName);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u5b57\u4f53-" + template + "\u5931\u8d25", (Throwable)e);
        }
    }
}

