/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.constant.table;

import com.google.common.collect.Lists;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;
import kd.imc.bdm.common.util.PropertieUtil;

public class GoodsInfoConstant {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_GOODSNAME = "name";
    public static final String FIELD_GOODSCODE = "number";
    public static final String FIELD_TAXCODE = "taxcode";
    public static final String FIELD_SPECIFICATIONS = "specifications";
    public static final String FIELD_UNIT = "unit";
    public static final String FIELD_TAXRATE = "taxrate";
    public static final String FIELD_ORG = "org";
    public static final String FIELD_CTRLSTRATEGY = "ctrlstrategy";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_USE_ORG = "useorg";
    public static final String FIELD_PRIVILEGEFLAG = "privilegeflag";
    public static final String FIELD_PRICE = "price";
    public static final String FIELD_PRICES = "prices";
    public static final String FIELD_PRIVILEGETYPE = "privilegetype";
    public static final String FIELD_CREATEDATE = "createtime";
    public static final String FIELD_MODIFYDATE = "modifytime";
    public static final String FIELD_CREATER = "creator";
    public static final String FIELD_MODIFIER = "modifier";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_CREATED = "createorg";
    public static final String FIELD_SHARE = "share";
    public static final String FIELD_PRIORITY = "priority";
    public static final String FIELD_FILTER = "filter_tag";
    public static final String FIELD_SHAREORGS = "shareorgstext_tag";
    public static final String ZZSTSGL = "zzstsgl";
    public static final String NUMBER = "number";
    public static final String HZX = "hzx";
    public static final String FIELD_TEXTYPECODE = "number";
    public static final String FIELD_TEXTYPEJC = "simplecodename";
    public static final String FIELD_TEXBMBBBH = "bmbbbh";
    public static final String FIELD_DISABLE_ENABLE = "enable";
    public static final String FIELD_GOODSINFOGROUPID = "group";
    public static final String FIELD_ISTAXINCLUSIVE = "isinclusive";
    public static final String AUTONO = "autono";
    public static final Integer TAX_CODE_LENGTH = 19;
    private static final String[] PRODUCT_OIL_TAX_CODE = new String[]{"1070101010100000000", "1070101010200000000", "1070101010300000000", "1070101010400000000", "1070101010500000000", "1070101020100000000", "1070101020200000000", "1070101030100000000", "1070101030200000000", "1070101030300000000", "1070101030400000000", "1070101040100000000", "1070101040200000000", "1070101040300000000", "1070101050100000000", "1070101050200000000", "1070101050300000000", "1070101060100000000", "1070101070100000000", "1070101070200000000", "1070101070300000000"};
    private static final String[] OIL_UNIT = new String[]{"\u5428", "\u5347"};
    public static final String RPEAT_CALL_BACK_ID = "repeat_call_back";
    private static final String[] VEHICLE_UNIT = new String[]{"\u8f86"};
    private static final String VEHICLE_GOODS_CODE_START = "1090";
    public static final String SELECT_PROPERTIES = PropertieUtil.getAllPropertiesSplitByComma("bdm_goods_info", true);

    public static String getID() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
        long id = cache.inc("agsBdmGoodInfoID");
        String totalSeconds = System.currentTimeMillis() / 1000L + "";
        String sid = id + "";
        if (sid.length() <= 6) {
            sid = String.format("%06d", id);
        }
        return totalSeconds.substring(totalSeconds.length() - 6) + sid;
    }

    public static String[] getProductOilTaxCode() {
        return PRODUCT_OIL_TAX_CODE;
    }

    public static String[] getOilUnit() {
        return OIL_UNIT;
    }

    public static String[] getVehicleUnit() {
        return VEHICLE_UNIT;
    }

    public static String getVehicleGoodsCodeStart() {
        return VEHICLE_GOODS_CODE_START;
    }

    public static enum PushMatchRulesEnum {
        DEFAULT_MATERIAL("0", new MultiLangEnumBridge("\u7269\u6599\u5339\u914d", "GoodsInfoConstant_7", "imc-bdm-common"), "0"),
        MATERIAL_TYPE("1", new MultiLangEnumBridge("\u7269\u6599\u5206\u7c7b\u5339\u914d", "GoodsInfoConstant_8", "imc-bdm-common"), "1"),
        GOODS_NAME("2", new MultiLangEnumBridge("\u5546\u54c1\u5339\u914d", "GoodsInfoConstant_9", "imc-bdm-common"), "2"),
        GOODS_INFO("3", new MultiLangEnumBridge("\u5f00\u7968\u9879\u5339\u914d", "GoodsInfoConstant_10", "imc-bdm-common"), "3"),
        SOURCE_MATERIAL_NAME("4", new MultiLangEnumBridge("\u4e0d\u5339\u914d", "GoodsInfoConstant_11", "imc-bdm-common"), "4"),
        EXPENSE_ITEM("5", new MultiLangEnumBridge("\u8d39\u7528\u9879\u76ee", "GoodsInfoConstant_6", "imc-bdm-common"), "5");

        String code;
        MultiLangEnumBridge bridge;
        String sourceType;

        private PushMatchRulesEnum(String code, MultiLangEnumBridge bridge, String sourceType) {
            this.code = code;
            this.bridge = bridge;
            this.sourceType = sourceType;
        }

        public String getCode() {
            return this.code;
        }

        public String getValue() {
            return this.bridge.loadKDString();
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public static PushMatchRulesEnum getValueByCode(String code) {
            return Lists.newArrayList((Object[])PushMatchRulesEnum.values()).stream().filter(e -> e.getCode().equals(code)).findFirst().orElse(DEFAULT_MATERIAL);
        }
    }

    public static enum SourceTypeEnum {
        MATERIAL("0", new MultiLangEnumBridge("\u7269\u6599", "GoodsInfoConstant_3", "imc-bdm-common")),
        MATERIAL_TYPE("1", new MultiLangEnumBridge("\u7269\u6599\u5206\u7c7b", "GoodsInfoConstant_4", "imc-bdm-common")),
        GOODS_NAME("2", new MultiLangEnumBridge("\u5546\u54c1", "GoodsInfoConstant_5", "imc-bdm-common")),
        EXPENSE_ITEM("5", new MultiLangEnumBridge("\u8d39\u7528\u9879\u76ee", "GoodsInfoConstant_6", "imc-bdm-common"));

        String code;
        MultiLangEnumBridge bridge;

        private SourceTypeEnum(String code, MultiLangEnumBridge bridge) {
            this.code = code;
            this.bridge = bridge;
        }

        public String getCode() {
            return this.code;
        }

        public String getValue() {
            return this.bridge.loadKDString();
        }

        public static SourceTypeEnum getValueByCode(String code) {
            return Lists.newArrayList((Object[])SourceTypeEnum.values()).stream().filter(e -> e.getCode().equals(code)).findFirst().orElse(MATERIAL);
        }
    }

    public static class Item {
        public static final String GOODS_INFO_ITEM = "bdm_goods_info_item";
        public static final String MATERIAL_NO = "material_no";
        public static final String MATERIAL_NAME = "material_name";
        public static final String MATERIAL_MODELNUM = "material_modelnum";
        public static final String MODELNUM_CODE = "modelnum_code";
        public static final String MODELNUM_UNIT = "modelnum_unit";
        public static final String BASEUNIT = "baseunit";
        public static final String BASISUINT = "basisuint";
        public static final String MODELNUM_RATE = "modelnum_rate";
        public static final String MATERIAL_TYPE = "materialtype";
        public static final String SOURCETYPE = "sourcetype";
        public static final String EXPENSE_ITEM = "expenseitem";

        public static class SourceTypeEnum {
            public static final String MATERIAL = "0";
            public static final String MATERIAL_TYPE = "1";
            public static final String GOODS_NAME = "2";
            public static final String EXPENSE_ITEM = "5";
        }
    }

    public static class IsInclusiveEnum {
        public static final String YES = "1";
        public static final String NO = "0";
    }

    public static class DisableEnableEnum {
        public static final String ENABLE = "1";
        public static final String DISABLE = "0";
    }

    public static class Dialog {
        public static final String dialogImport = "bdm_goods_info_import";
        public static final String dialogAdd = "bdm_goods_info_mgr";
        public static final String dialogBatchEdit = "bdm_goods_edit";
    }

    public static class ShareFlagEnum {
        public static final String SHARE = "1";
        public static final String NO_SHARE = "0";
    }

    public static class PrivilegeFlagEnum {
        public static final String USE = "1";
        public static final String NO_USE = "0";
    }
}

