/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.untrans.BdmConstellationUntrans;
import kd.imc.bdm.common.util.ImcConfigUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AddressSplitHelper {
    private static final Log log = LogFactory.getLog(AddressSplitHelper.class);
    private static final Pattern phoneCompile = Pattern.compile("((\\d{2,4}[-_\uff0d\u2014]{0,5})?\\d{3,8}([-_\uff0d\u2014]{0,5}\\d{3,8})?([-_\uff0d\u2014]{0,5}\\d{1,7})?$)|(^0?1[35]\\d{9})");
    private static final Pattern areaCodeCompile = Pattern.compile("[0][1-9][0-9]{1,2}$");
    private static final String[] redundantCharArr = BdmConstellationUntrans.AddressSplitHelper_0;
    private static final Pattern bankNameCompile = Pattern.compile("(\u5f00\u6237\u94f6\u884c|\u94f6\u884c|\u94f6 \u884c|\u5f00\u6237\u884c|\u5f00 \u6237 \u884c)?([:\uff1a ])?[\\u4E00-\\u9FA5()\uff08\uff09A-Za-z ]+");
    private static final Pattern bankAccountCompile = Pattern.compile("[0-9\\- ]+");

    public static Pair<String, String> splitAddressAndTel(String addressAndTel) {
        try {
            if (addressAndTel.contains("&&")) {
                String[] split = addressAndTel.split("&&");
                return Pair.of((Object)split[0].trim(), (Object)split[1].trim());
            }
            String addTrim = addressAndTel.trim();
            Matcher matcher = phoneCompile.matcher(addTrim);
            if (!matcher.find()) {
                return Pair.of((Object)addressAndTel, (Object)"");
            }
            String phone = matcher.group();
            String address = addTrim.substring(0, matcher.toMatchResult().start()).trim();
            for (String redundantChar : redundantCharArr) {
                address = address.replaceAll(redundantChar + '$', "");
            }
            Pair<String, String> tailPhone = AddressSplitHelper.fixPhone(phone);
            return Pair.of((Object)(address.trim() + ((String)tailPhone.getKey()).trim()), (Object)((String)tailPhone.getValue()).trim());
        }
        catch (Exception e) {
            log.error(String.format("\u62c6\u5206\u5730\u5740\u51fa\u9519\uff0c\u5730\u5740\u662f[%s]", addressAndTel));
            return Pair.of((Object)addressAndTel, (Object)"");
        }
    }

    private static Pair<String, String> fixPhone(String phone) {
        String[] split = AddressSplitHelper.splitAtLastDot(phone);
        if (split.length == 1) {
            return Pair.of((Object)"", (Object)phone);
        }
        Matcher matcher = areaCodeCompile.matcher(split[0]);
        if (!matcher.find()) {
            return Pair.of((Object)"", (Object)phone);
        }
        int first = matcher.toMatchResult().start();
        return Pair.of((Object)phone.substring(0, first), (Object)phone.substring(first));
    }

    private static String[] splitAtLastDot(String phone) {
        int index = phone.lastIndexOf(45);
        if (index == -1) {
            return new String[]{phone};
        }
        return new String[]{phone.substring(0, index), phone.substring(index + 1)};
    }

    public static Pair<String, String> splitBankAndName(String bankAndName) {
        try {
            if (bankAndName.contains("&&")) {
                String[] split = bankAndName.split("&&");
                return Pair.of((Object)split[0].trim(), (Object)split[1].trim());
            }
            String value = ImcConfigUtil.getValue("split_bank", "split_type");
            String bankAndNameTrim = bankAndName.trim();
            if ("old".equals(value)) {
                return AddressSplitHelper.oldBankNameSpltit(bankAndNameTrim);
            }
            return AddressSplitHelper.newBankNameSplit(bankAndNameTrim);
        }
        catch (Exception e) {
            log.error(String.format("\u62c6\u5206\u94f6\u884c\uff0c\u94f6\u884c\u8d26\u53f7\u51fa\u9519\uff0c\u5b57\u7b26\u4e32\u662f[%s]", bankAndName));
            return Pair.of((Object)bankAndName, (Object)"");
        }
    }

    private static Pair<String, String> oldBankNameSpltit(String bankAndNameTrim) {
        Matcher matcher = bankNameCompile.matcher(bankAndNameTrim);
        if (!matcher.find()) {
            return Pair.of((Object)bankAndNameTrim, (Object)"");
        }
        int index = matcher.toMatchResult().start();
        String bankNumber = index == 0 ? bankAndNameTrim.substring(matcher.end()).trim() : bankAndNameTrim.substring(0, index).trim();
        bankNumber = bankNumber.replaceAll("[,;\uff0c\uff1b]", "");
        return Pair.of((Object)matcher.group().trim(), (Object)bankNumber.trim());
    }

    private static Pair<String, String> newBankNameSplit(String bankAndNameTrim) {
        Matcher matcher = bankAccountCompile.matcher(bankAndNameTrim);
        int start = -1;
        int end = -1;
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            start = matchResult.start();
            end = matchResult.end();
        }
        if (start == -1) {
            return Pair.of((Object)bankAndNameTrim, (Object)"");
        }
        String bankNumber = bankAndNameTrim.substring(start, end);
        String bankName = bankAndNameTrim.replaceAll(bankNumber, "");
        return Pair.of((Object)bankName.trim().replaceAll("\n", ""), (Object)bankNumber.trim().replaceAll("\n", ""));
    }
}

