/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.DrawerStrategyEnum;
import kd.imc.bdm.common.enums.PayeeStrategyEnum;
import kd.imc.bdm.common.enums.ReviewerStrategyEnum;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.DrawerStrategyDTO;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;

public class DrawerStrategyHelper {
    private static final Log LOGGER = LogFactory.getLog(DrawerStrategyHelper.class);
    public static final String CURRENT_USER = "0";
    public static final String BUSINESS_USER = "1";
    public static final String DEVICE_USER = "2";
    public static final String SPECIAL_USER = "3";
    public static final String PERSON_EDIT = "4";

    public static DrawerStrategyDTO getSpecialStrategy(DynamicObject strategyObj) {
        DrawerStrategyDTO dto = new DrawerStrategyDTO();
        String strategy = strategyObj.getString("drawerstrategy");
        if (String.valueOf(strategy).length() != 5) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u53d1\u7968\u4e91\u914d\u7f6e\u5f00\u7968\u4eba\u7b56\u7565\uff0c\u6216\u5219\u5220\u9664\u4e0d\u5b8c\u6574\u7684\u5f00\u7968\u4eba\u7b56\u7565", (String)"DrawerStrategyHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String drawerStrategyCode = String.valueOf(strategy.charAt(0));
        dto.setDrawerStrategy(drawerStrategyCode);
        if (DrawerStrategyEnum.APPOINT_DRAWER.getCode().equals(drawerStrategyCode) || DrawerStrategyEnum.PERSON_EDIT.getCode().equals(drawerStrategyCode)) {
            dto.setDrawerName(strategyObj.getString("drawer"));
        }
        String payeeStrategyCode = String.valueOf(strategy.charAt(2));
        dto.setPayeeStrategy(payeeStrategyCode);
        if (PayeeStrategyEnum.APPOINT_PAYEE.getCode().equals(payeeStrategyCode) || PayeeStrategyEnum.PERSON_EDIT.getCode().equals(payeeStrategyCode)) {
            dto.setPayeeName(strategyObj.getString("payee"));
        }
        String reviewerStrategyCode = String.valueOf(strategy.charAt(4));
        dto.setReviewerStrategy(reviewerStrategyCode);
        if (ReviewerStrategyEnum.APPOINT_REVIEWER.getCode().equals(reviewerStrategyCode) || ReviewerStrategyEnum.PERSON_EDIT.getCode().equals(reviewerStrategyCode)) {
            dto.setReviewerName(strategyObj.getString("reviewer"));
        }
        return dto;
    }

    public static DrawerStrategyDTO getDefaultStrategy() {
        DrawerStrategyDTO dto = new DrawerStrategyDTO();
        dto.setDrawerStrategy(BUSINESS_USER);
        dto.setReviewerStrategy(BUSINESS_USER);
        dto.setPayeeStrategy(BUSINESS_USER);
        return dto;
    }

    public static void setOtherObjDrawers(DynamicObject otherObj) {
        DrawerInfo drawerInfo = new DrawerInfo();
        Long orgId = DrawerStrategyHelper.getOrgId(otherObj);
        Object jqbh = otherObj.get("jqbh");
        DrawerStrategyDTO strategy = DrawerStrategyHelper.getDrawerStrategyFromCache(orgId);
        LOGGER.info(String.format("getDrawerNonOriginalBill\u83b7\u53d6\u5f00\u7968\u4eba\u53c2\u6570\uff1aorgId:%s,jqbh:%s,originalBillDrawer:%s,Strategy:%s,originalBillPk:%s", orgId, jqbh, otherObj.getString("drawer"), JSONObject.toJSONString((Object)strategy), otherObj.getPkValue()));
        DynamicObject devDynamicObject = DrawerStrategyHelper.dealDrawer(orgId, jqbh, otherObj.getString("drawer"), drawerInfo, strategy);
        devDynamicObject = DrawerStrategyHelper.dealPayee(orgId, jqbh, otherObj.getString("payee"), drawerInfo, devDynamicObject, strategy);
        DrawerStrategyHelper.dealReviewer(orgId, jqbh, otherObj.getString("reviewer"), drawerInfo, devDynamicObject, strategy);
        otherObj.set("drawer", (Object)drawerInfo.getDrawer());
        otherObj.set("payee", (Object)drawerInfo.getPayee());
        otherObj.set("reviewer", (Object)drawerInfo.getReviewer());
    }

    public static DrawerInfo getDrawerInfoNonOriginalBill(String drawer, String payee, String reviewer, Long orgId, Object jqbh) {
        LOGGER.info("getDrawerInfoNonOriginalBill");
        DynamicObject[] array = DrawerStrategyHelper.queryDrawerStrategyByOrg(orgId);
        DrawerStrategyDTO strategy = array.length == 0 ? DrawerStrategyHelper.getDefaultStrategy() : DrawerStrategyHelper.getSpecialStrategy(array[0]);
        DrawerInfo drawerInfo = new DrawerInfo();
        DynamicObject devObj = DrawerStrategyHelper.dealDrawer(orgId, jqbh, drawer, drawerInfo, strategy);
        devObj = DrawerStrategyHelper.dealPayee(orgId, jqbh, payee, drawerInfo, devObj, strategy);
        DrawerStrategyHelper.dealReviewer(orgId, jqbh, reviewer, drawerInfo, devObj, strategy);
        return drawerInfo;
    }

    public static DrawerInfo getOriginalBillDrawerStrategy(Object jqbh, DynamicObject originalBill) {
        if (null == originalBill.getPkValue() || CURRENT_USER.equals(originalBill.getPkValue())) {
            throw new MsgException(ResManager.loadKDString((String)"\u539f\u59cb\u5355\u636e\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u83b7\u53d6\u83b7\u53d6\u5f00\u7968\u4eba\u7b56\u7565", (String)"DrawerStrategyHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        Long orgId = DrawerStrategyHelper.getOrgId(originalBill);
        jqbh = DrawerStrategyHelper.getJqbh(jqbh, originalBill);
        DrawerInfo drawerInfo = new DrawerInfo();
        DrawerStrategyDTO strategy = DrawerStrategyHelper.getDrawerStrategyFromCache(orgId);
        LOGGER.info(String.format("getOriginalBillDrawerStrategy\u83b7\u53d6\u5f00\u7968\u4eba\u53c2\u6570\uff1aorgId:%s,jqbh:%s,originalBillDrawer:%s,Strategy:%s,originalBillPk:%s", orgId, jqbh, originalBill.getString("drawer"), JSONObject.toJSONString((Object)strategy), originalBill.getPkValue()));
        DynamicObject devDynamicObject = DrawerStrategyHelper.dealDrawer(orgId, jqbh, originalBill.getString("drawer"), drawerInfo, strategy);
        devDynamicObject = DrawerStrategyHelper.dealPayee(orgId, jqbh, originalBill.getString("payee"), drawerInfo, devDynamicObject, strategy);
        DrawerStrategyHelper.dealReviewer(orgId, jqbh, originalBill.getString("reviewer"), drawerInfo, devDynamicObject, strategy);
        return drawerInfo;
    }

    public static Object getJqbh(Object jqbh, DynamicObject originalBill) {
        if (StringUtils.isBlank((Object)jqbh)) {
            jqbh = originalBill.getString("jqbh");
        }
        return jqbh;
    }

    public static Long getOrgId(DynamicObject obj) {
        long orgId;
        String billName = obj.getDynamicObjectType().getName();
        String orgField = "orgid";
        if ("sim_red_info".equals(billName)) {
            orgField = "org";
        }
        if (0L == (orgId = DynamicObjectUtil.getDynamicObjectLongValue(obj.get(orgField)))) {
            orgId = RequestContext.get().getOrgId();
        }
        return orgId;
    }

    public static void dealReviewer(Long orgId, Object jqbh, String businessReviewer, DrawerInfo drawerInfo, DynamicObject devDynamicObject, DrawerStrategyDTO dto) {
        if (ReviewerStrategyEnum.BUSINESS_SYSTEM.getCode().equals(dto.getReviewerStrategy())) {
            drawerInfo.setReviewer(businessReviewer);
        }
        if (ReviewerStrategyEnum.DEVICE_DEFAULT.getCode().equals(dto.getReviewerStrategy())) {
            if (StringUtils.isNotBlank((Object)jqbh)) {
                if (devDynamicObject == null) {
                    devDynamicObject = EquipmentUtil.getEquipmentDynamicObject(orgId, jqbh);
                }
                drawerInfo.setReviewer(devDynamicObject.getString("reviewer"));
            } else {
                drawerInfo.setReviewer(businessReviewer);
            }
        }
        if (ReviewerStrategyEnum.APPOINT_REVIEWER.getCode().equals(dto.getReviewerStrategy()) || ReviewerStrategyEnum.PERSON_EDIT.getCode().equals(dto.getReviewerStrategy())) {
            drawerInfo.setReviewer(dto.getReviewerName());
        }
    }

    public static DynamicObject dealPayee(Long orgId, Object jqbh, String businessPayee, DrawerInfo drawerInfo, DynamicObject devDynamicObject, DrawerStrategyDTO dto) {
        if (PayeeStrategyEnum.BUSINESS_SYSTEM.getCode().equals(dto.getPayeeStrategy())) {
            drawerInfo.setPayee(businessPayee);
        }
        if (PayeeStrategyEnum.DEVICE_DEFAULT.getCode().equals(dto.getPayeeStrategy())) {
            if (StringUtils.isNotBlank((Object)jqbh)) {
                if (devDynamicObject == null) {
                    devDynamicObject = EquipmentUtil.getEquipmentDynamicObject(orgId, jqbh);
                }
                drawerInfo.setPayee(devDynamicObject.getString("payee"));
                return devDynamicObject;
            }
            drawerInfo.setPayee(businessPayee);
        }
        if (PayeeStrategyEnum.APPOINT_PAYEE.getCode().equals(dto.getPayeeStrategy()) || PayeeStrategyEnum.PERSON_EDIT.getCode().equals(dto.getPayeeStrategy())) {
            drawerInfo.setPayee(dto.getPayeeName());
        }
        return null;
    }

    public static DynamicObject dealDrawer(Long orgId, Object jqbh, String businessDrawer, DrawerInfo drawerInfo, DrawerStrategyDTO strategy) {
        if (DrawerStrategyEnum.CURRENT_USER.getCode().equals(strategy.getDrawerStrategy())) {
            drawerInfo.setDrawer(RequestContext.get().getUserName());
        }
        if (DrawerStrategyEnum.BUSINESS_SYSTEM.getCode().equals(strategy.getDrawerStrategy())) {
            String drawer = StringUtils.isBlank((CharSequence)businessDrawer) ? RequestContext.get().getUserName() : businessDrawer;
            drawerInfo.setDrawer(drawer);
        }
        if (DrawerStrategyEnum.DEVICE_DEFAULT.getCode().equals(strategy.getDrawerStrategy())) {
            if (StringUtils.isNotBlank((Object)jqbh)) {
                DynamicObject devDynamicObject = EquipmentUtil.getEquipmentDynamicObject(orgId, jqbh);
                String devDrawer = devDynamicObject.getString("drawer");
                drawerInfo.setDrawer(devDrawer);
                return devDynamicObject;
            }
            if (StringUtils.isNotBlank((CharSequence)businessDrawer)) {
                drawerInfo.setDrawer(businessDrawer);
            } else {
                drawerInfo.setDrawer(RequestContext.get().getUserName());
            }
        }
        if (DrawerStrategyEnum.APPOINT_DRAWER.getCode().equals(strategy.getDrawerStrategy()) || DrawerStrategyEnum.PERSON_EDIT.getCode().equals(strategy.getDrawerStrategy())) {
            drawerInfo.setDrawer(strategy.getDrawerName());
        }
        return null;
    }

    public static DrawerStrategyDTO getDrawerStrategyFromCache(Long orgId) {
        DynamicObject[] array = DrawerStrategyHelper.queryDrawerStrategyByOrg(orgId);
        if (array.length == 0) {
            return DrawerStrategyHelper.getDefaultStrategy();
        }
        return DrawerStrategyHelper.getSpecialStrategy(array[0]);
    }

    public static DynamicObject[] queryDrawerStrategyByOrg(Long orgId) {
        QFilter filter = new QFilter("item.useorg", "=", (Object)orgId);
        return BusinessDataServiceHelper.load((String)"bdm_drawer_strategy", (String)"drawerstrategy,filter_tag,drawer,payee,reviewer,priority", (QFilter[])filter.toArray(), (String)"priority asc");
    }

    public static DrawerInfo getLeQiRedDrawerInfo(Long orgId) {
        DrawerStrategyDTO strategy;
        LOGGER.info("getLeQiRedDrawerInfo");
        DynamicObject[] array = DrawerStrategyHelper.queryDrawerStrategyByOrg(orgId);
        if (array.length == 0) {
            strategy = new DrawerStrategyDTO();
            strategy.setDrawerStrategy(CURRENT_USER);
        } else {
            strategy = DrawerStrategyHelper.getSpecialStrategy(array[0]);
            if (DrawerStrategyEnum.DEVICE_DEFAULT.getCode().equals(strategy.getDrawerStrategy())) {
                strategy = new DrawerStrategyDTO();
                strategy.setDrawerStrategy(CURRENT_USER);
            }
        }
        DrawerInfo drawerInfo = new DrawerInfo();
        DrawerStrategyHelper.dealDrawer(orgId, null, null, drawerInfo, strategy);
        return drawerInfo;
    }
}

