/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.util.Base64Util;
import kd.imc.bdm.common.util.InvoiceUtils;

public class EasBusinessHelper {
    private static final Log log = LogFactory.getLog(EasBusinessHelper.class);

    public static boolean billCanCancel(DynamicObject invoice) {
        DynamicObject[] bills;
        String issueType = invoice.getString("issuetype");
        if (!IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            return true;
        }
        if ("4".equals(invoice.getString("buyertype"))) {
            return true;
        }
        String oriInvoiceCode = invoice.getString("originalinvoicecode");
        String oriInvoiceNo = invoice.getString("originalinvoiceno");
        String sellerTaxNo = invoice.getString("salertaxno");
        DynamicObject[] blueInvoices = InvoiceUtils.getInvoice(sellerTaxNo, oriInvoiceCode, oriInvoiceNo);
        if (blueInvoices.length == 0) {
            return true;
        }
        for (DynamicObject bill : bills = RelationHelper.getOriBillByInvoice(blueInvoices[0])) {
            if (!"1".equals(bill.getString("closestatus"))) continue;
            return false;
        }
        return true;
    }

    public static String getEasRequestData(String data, String interfaceCode) {
        JSONObject param = new JSONObject();
        param.put("api", (Object)"IMWebServiceFacade-messageReceived");
        JSONArray jsonArray = new JSONArray();
        param.put("data", (Object)jsonArray);
        jsonArray.add((Object)"003");
        JSONObject jsonItem = new JSONObject();
        jsonArray.add((Object)jsonItem);
        jsonItem.put("code", (Object)"0");
        jsonItem.put("message", (Object)ResManager.loadKDString((String)"\u56de\u8c03EAS", (String)"EasBusinessHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        jsonItem.put("interfaceCode", (Object)interfaceCode);
        jsonItem.put("data", (Object)Base64Util.encode(data, "UTF-8"));
        String requestStr = param.toJSONString();
        if (log.isInfoEnabled()) {
            log.info(String.format("\u56de\u8c03EAS\u53c2\u6570 [%s]", requestStr));
        }
        return requestStr;
    }

    public static void handleEasResponse(JSONObject jsonObject) {
        JSONObject resultJson = jsonObject.getJSONObject("data").getJSONObject("result");
        String errorCode = resultJson.getString("errorCode");
        jsonObject.put("errorCode", (Object)errorCode);
        if ("2".equals(errorCode)) {
            jsonObject.put("errorCode", (Object)errorCode);
            JSONArray billErrors = resultJson.getJSONArray("billErrors");
            ArrayList<String> errorMsgList = new ArrayList<String>(billErrors.size());
            for (int i = 0; i < billErrors.size(); ++i) {
                JSONObject billError = billErrors.getJSONObject(i);
                errorMsgList.add(billError.getJSONArray("errorMsgs").getString(0));
            }
            jsonObject.put("message", (Object)String.join((CharSequence)",", errorMsgList));
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("eas\u8fd4\u56de\u53c2\u6570\u5904\u7406\u7ed3\u679c : [%s]", jsonObject.toJSONString()));
        }
    }
}

