/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.ek.EkServiceFactory;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.AES128;
import kd.imc.bdm.common.util.AesUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MD5;

public class ImcLicenseServiceHelper {
    private static final Log LOG = LogFactory.getLog(ImcLicenseServiceHelper.class);

    public static int getLicenseTotalNumber(String permissionType) {
        String authType = ImcLicenseServiceHelper.getAuthType();
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(permissionType) || PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo().equals(permissionType)) {
            return ImcLicenseServiceHelper.getInputLicenseNumber(authType, permissionType);
        }
        switch (authType) {
            case "private": {
                return ImcLicenseServiceHelper.getPrivateNumber();
            }
            case "basic": {
                int count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
                if (count == 0) {
                    count = ImcLicenseServiceHelper.getOutPutLicenseNumer();
                }
                return count;
            }
        }
        int count = ImcLicenseServiceHelper.getOutPutLicenseNumer();
        if (count == 0) {
            count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
        }
        return count;
    }

    private static int getInputLicenseNumber(String authType, String permissionType) {
        String licenseGroupId;
        String string = licenseGroupId = PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(permissionType) ? CacheKeyEnum.RIM_INVOICE_PERMISSION_AUTH_GROUP_ID.getDefaultValue() : CacheKeyEnum.IREW_INVOICE_PERMISSION_AUTH_GROUP_ID.getDefaultValue();
        if ("cosmic".equals(authType)) {
            int count = ImcLicenseServiceHelper.getCosmicLicenseNumber(licenseGroupId);
            if (count == 0) {
                count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
            }
            return count;
        }
        int count = ImcLicenseServiceHelper.getLicenseNumberFromAws(permissionType);
        if (count == 0) {
            count = ImcLicenseServiceHelper.getCosmicLicenseNumber(licenseGroupId);
        }
        return count;
    }

    private static int getOutPutLicenseNumer() {
        BigDecimal productVersion = new BigDecimal("5.0");
        try {
            productVersion = new BigDecimal(LicenseServiceHelper.getProductVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (productVersion.compareTo(new BigDecimal("5.0")) >= 0) {
            return ImcLicenseServiceHelper.getCosmicLicenseNumber(ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_IMC_SBI_GROUP_ID));
        }
        return ImcLicenseServiceHelper.getCosmicLicenseNumber(ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_IMC_DJ_GROUP_ID)) + ImcLicenseServiceHelper.getCosmicLicenseNumber(ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_IMC_TG_GROUP_ID));
    }

    private static int getCosmicLicenseNumber(String groupId) {
        try {
            return LicenseServiceHelper.getTotalNumber((Object)groupId);
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u82cd\u7a79\u8bb8\u53ef\u6570\u91cf\u62a5\u9519", (Throwable)e);
            return 0;
        }
    }

    public static int getInvoiceMsgAuth() {
        String authType;
        if (EkServiceFactory.getSmsService() != null) {
            return 1;
        }
        switch (authType = ImcLicenseServiceHelper.getAuthType()) {
            case "basic": {
                return 1;
            }
            case "private": {
                return 1;
            }
        }
        int msgTotalNum = LicenseServiceHelper.getTotalNumber((Object)ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_MSG_AUTH_GROUP_ID));
        LOG.info(String.format("LicenseServiceHelper\u77ed\u4fe1\u5728\u8bb8\u53ef\u6388\u6743\u6570\u91cf%s", msgTotalNum));
        return msgTotalNum;
    }

    private static String getAuthType() {
        String authType = "cosmic";
        try {
            String authTypeStr = ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_AUTH_TYPE);
            if (StringUtils.isNotBlank((CharSequence)authTypeStr)) {
                authType = AesUtil.decrypt(authTypeStr, RequestContext.get().getTenantId() + "_license");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return authType;
    }

    private static int getPrivateNumber() {
        int privateNumer = 0;
        try {
            String privateNumberStr = ImcConfigUtil.getValue(CacheKeyEnum.BDM_INVOICE_PERMISSION_PRIVATE_NUMBER);
            if (StringUtils.isNotBlank((CharSequence)privateNumberStr)) {
                privateNumer = Integer.parseInt(AesUtil.decrypt(privateNumberStr, RequestContext.get().getTenantId() + "_license"));
            }
        }
        catch (Exception e) {
            LOG.error(String.format("\u79c1\u6709\u5316\u6570\u91cf\u89e3\u5bc6\u51fa\u9519,\u79df\u6237\u662f[%s]", RequestContext.get().getTenantId()), (Throwable)e);
        }
        return privateNumer;
    }

    private static int getLicenseNumberFromAws(String permissionType) {
        String CACHE_KEY = "awsLicenseNumber" + permissionType;
        String cache = CacheHelper.get(CACHE_KEY);
        if (!StringUtils.isEmpty((CharSequence)cache)) {
            LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cfkey{},value{}", (Object)CACHE_KEY, (Object)cache);
            return Integer.parseInt(cache);
        }
        Map<String, String> map = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String url = ImcConfigUtil.getValue(map, "url", "dim_imc_config_fpy_url");
        String proxy = ImcConfigUtil.getValue(map, "proxy", "dim_imc_config_fpy_proxy");
        String clientId = ImcConfigUtil.getValue(map, "clientid", "dim_imc_config_fpy_clientid");
        String clientsecret = ImcConfigUtil.getValue(map, "clientsecret", "dim_imc_config_fpy_clientsecret");
        String encryptkey = ImcConfigUtil.getValue(map, "encryptkey", "dim_imc_config_fpy_encryptkey");
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)clientId) || StringUtils.isEmpty((CharSequence)clientsecret)) {
            LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u672a\u914d\u7f6e\u8fde\u63a5\u4fe1\u606f" + map);
            return 0;
        }
        String token = ImcLicenseServiceHelper.getAccessToken(url, proxy, clientId, clientsecret);
        if (!StringUtils.isEmpty((CharSequence)token)) {
            RequestContext request = RequestContext.get();
            JSONObject json = new JSONObject();
            json.put("tenantId", (Object)request.getTenantId());
            json.put("permissionType", (Object)permissionType);
            if (encryptkey == null || "".equals(encryptkey)) {
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8bef");
                return 0;
            }
            try {
                String content = AES128.ecbEncrypt(json.toJSONString(), encryptkey);
                if (StringUtils.isEmpty((CharSequence)content)) {
                    LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8bef");
                    return 0;
                }
                String countUrl = url + "/m3/bill/firmament/auth/count?access_token=" + token;
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf{},{},{}", new Object[]{countUrl, json.toJSONString(), content});
                String result = HttpUtil.doPostJson(countUrl, proxy, null, content);
                LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf{}", (Object)result);
                JSONObject countResult = JSONObject.parseObject((String)result);
                if (countResult != null && "0000".equals(countResult.getString("errcode"))) {
                    String countStr = countResult.getString("data");
                    CacheHelper.put(CACHE_KEY, countStr, 600);
                    return Integer.parseInt(countStr);
                }
            }
            catch (Exception e1) {
                LOG.error("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25", (Throwable)e1);
            }
        } else {
            LOG.info("\u83b7\u53d6aws\u8bb8\u53ef\u6570\u91cf\u5931\u8d25\u52a0\u5bc6\u9519\u8beftoken\u4e3a\u7a7a");
        }
        return 0;
    }

    public static String getAccessToken(String baseurl, String proxy, String clientId, String clientSecret) {
        String CACHE_KEY = "aws_token_cache";
        String token = CacheHelper.get(CACHE_KEY);
        if (!StringUtils.isEmpty((CharSequence)token)) {
            return token;
        }
        JSONObject param = new JSONObject();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5Hex(clientId + clientSecret + timestamp);
        String url = baseurl + "/base/oauth/token";
        param.put("client_id", (Object)clientId);
        param.put("sign", (Object)sign);
        param.put("timestamp", (Object)timestamp);
        try {
            String result = HttpUtil.doPostJson(url, proxy, null, param.toJSONString());
            JSONObject json = JSONObject.parseObject((String)result);
            if (json != null && "0000".equals(json.getString("errcode"))) {
                token = json.getString("access_token");
                CacheHelper.put(CACHE_KEY, token, 300);
            }
        }
        catch (IOException e1) {
            LOG.error("\u83b7\u53d6aws token\u5931\u8d25", (Throwable)e1);
        }
        return token;
    }

    public static Map<String, Date> getDateRange(Long groupId) {
        try {
            Map dateRange = LicenseServiceHelper.getGroupTimeRange((Long)groupId);
            return dateRange;
        }
        catch (RuntimeException e) {
            LOG.info("\u83b7\u53d6\u6388\u6743\u7684\u8d77\u59cb\u65f6\u95f4\u5931\u8d25{},{}", (Object)groupId, (Object)e.getMessage());
            return null;
        }
    }
}

